/*  syntax-highlight.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SYNTAX_HIGHLIGHT_H
#define SYNTAX_HIGHLIGHT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "widgets/gdsfile.h"

typedef struct colorfontflags HighlightInfo;

GtkWidget *build_highlight_menu(void);
void highlight_table_change_cb(GtkWidget *widget, gint num);
GList *build_file_listing(gchar *directory, GList *filenames);

gint reparse_highlight_table(GdsFileHighlightTable *table);
void apply_color_changes(void);

void attach_highlight_tables(GdsFile *file_ptr, gchar *path_to_file);
gboolean detach_highlight_tables(GdsFile *file_ptr);
gboolean delete_highlight_tables(GdsFileHighlightTable *table);
GdsFileHighlightTable *find_highlight_tables(gchar *extension, gchar *cur_dir);
GdsFileHighlightTable *make_highlight_tables(gchar *fname);
GList * get_exts_list(gchar *filename);
gboolean check_exts_list(gchar *ext, GList *exts);
void g_list_delete_all(GList *list);
gboolean get_str(gchar *source, gchar *dest, const gchar search[], gchar end, gint max_chars);
HighlightInfo *get_highlight_info(gchar *color, gchar *cclass);
GdkFont *get_font(gint type);
void highlight_tables_font_change(GdkFont *nfont, gint type);

typedef enum
{
   STRING,
   CHAR,
   CHAR_STRING,
   KEYWORD,
   COMMENT,
   PREPROCESSOR,
   DATA_TYPE,
   FUNCTION,
   MACRO,
   VARIABLE,
   SYMBOL,
   OPERATOR,
   PUNCTUATION,
   DECIMAL,
   HEXIDECIMAL,
   OCTAL,
   WHITE,
   BLACK,
   GRAY,
   BLUE,
   DARK_BLUE,
   RED,
   DARK_RED,
   GREEN,
   DARK_GREEN,
   CYAN,
   MAGENTA,
   YELLOW,
   ORANGE, 
   DEFAULT
}ColorClass;

#define EDITOR_COLORS 30

struct colorfontflags
{
   GdkColor *color;
   GdkFont *font;
   gint type;
   guint16 flags;
};

struct highlight_cache
{
   GdkColor colors[EDITOR_COLORS];
   GdkFont *fonts[EDITOR_COLORS];
   gint types[EDITOR_COLORS];
   guint16 flags[EDITOR_COLORS];
};

extern GSList *highlight_options;
extern GList *highlight_tables;
extern GdsFileHighlightTable *parse_table;
extern gboolean parsing_language;

extern GList *syntax_list;
extern GList *pattern_list;
extern GList *embedded_list;

extern struct highlight_cache HighlightCache;

#ifdef __cplusplus
}
#endif

#endif
