#include "declarations.h"
#include "widgets/gnomefilelist.h"

gchar *session_file = NULL;

guint get_last_session(void)
{
   guint files;
   gchar buffer[256];
   if(!general_preferences.open_session) return(0);
   g_snprintf(buffer, sizeof(buffer), "%s/." PACKAGE "/session.last", getenv("HOME"));
   files = open_session_from_file(session_file ? session_file : buffer);
   return(files);
}

void save_session_cb(GtkWidget *widget, gpointer data)
{
   gint success;
   gchar buffer[256];
   g_snprintf(buffer, sizeof(buffer), "%s/." PACKAGE "/session.last", getenv("HOME"));
   success = save_session_to_file(session_file ? session_file : buffer);
   if(!success) generic_dialog_with_text(_("Session file could not be written.\nMake sure that you have write access to $HOME."));
   else display_message("Session Saved.", FLASH);
}

void open_session_cb(GtkWidget *widget, gpointer data)
{
   gchar *path;
   path =  get_path_from_filename(session_file);
   widget = gnome_filelist_new_with_path(path);
   g_free(path);
   gnome_filelist_set_title(GNOME_FILELIST(widget), _("Open Session..."));
   gtk_signal_connect(GTK_OBJECT(GNOME_FILELIST(widget)->ok_button), "clicked", GTK_SIGNAL_FUNC(open_session_continue), (gpointer)widget);
   gtk_signal_connect_object(GTK_OBJECT(GNOME_FILELIST(widget)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
   gtk_window_set_transient_for(GTK_WINDOW(widget), GTK_WINDOW(window));
   gtk_widget_show(widget);
   gtk_widget_grab_focus(GNOME_FILELIST(widget)->selection_entry);
}

void open_session_continue(GtkWidget *widget, GnomeFileList *file_list)
{
   gchar *string;   
   guint files;
   string = gnome_filelist_get_filename(GNOME_FILELIST(file_list));
   if(check_if_file_exists(string))
   {
      gtk_widget_hide(GTK_WIDGET(file_list));
      if(general_preferences.close_all) close_all_files_cb(NULL, NULL);
      files = open_session_from_file(string);
      if(!files)
      {
         generic_dialog_with_text(_("File contained no session data."));
         gtk_widget_show(GTK_WIDGET(file_list));
      }
      else
      {
         gtk_widget_destroy(GTK_WIDGET(file_list));
         g_free(session_file);
         session_file = g_strdup(string);
         set_window_title();
      }
   }
   else
   {
      gtk_widget_hide(GTK_WIDGET(file_list));
      read_error(string);
      gtk_widget_show(GTK_WIDGET(file_list));
   }
   g_free(string);
}

void save_session_as_cb(GtkWidget *widget, gpointer data)
{
   gchar *path;
   gchar *file;
   if(!session_file)
      path = g_strconcat(getenv("HOME"), "/." PACKAGE, NULL);
   else
      path = get_path_from_filename(session_file);
   widget = gnome_filelist_new_with_path(path);
   gnome_filelist_set_title(GNOME_FILELIST(widget), _("Save session file..."));
   gtk_signal_connect(GTK_OBJECT(GNOME_FILELIST(widget)->ok_button), "clicked", GTK_SIGNAL_FUNC(save_session_as_continue), widget);
   gtk_signal_connect_object(GTK_OBJECT(GNOME_FILELIST(widget)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
   gtk_window_set_transient_for(GTK_WINDOW(widget), GTK_WINDOW(window));
   gtk_window_set_modal(GTK_WINDOW(widget), TRUE);
   gtk_signal_connect_object(GTK_OBJECT(widget), "destroy", GTK_SIGNAL_FUNC(gtk_grab_remove), GTK_OBJECT(widget));
   gtk_widget_show(widget);
   if(session_file)
   {
      file = get_file_from_filename(session_file);
      gtk_entry_set_text(GTK_ENTRY(GNOME_FILELIST(widget)->selection_entry), file);
      g_free(file);
   }
   gtk_widget_grab_focus(GNOME_FILELIST(widget)->selection_entry);
   g_free(path);
}

void save_session_as_continue(GtkWidget *widget, GnomeFileList *file_list)
{
   gchar *string;   
   gint result;
   string = gnome_filelist_get_filename(GNOME_FILELIST(file_list));
   if(check_if_file_exists(string))
   {
      gtk_widget_hide(GTK_WIDGET(file_list));
      result = file_exists_error(string, GTK_SIGNAL_FUNC(save_session_as_error_continue));
      if(result == 0)
         gtk_widget_destroy(GTK_WIDGET(file_list));
      else
         gtk_widget_show(GTK_WIDGET(file_list));
   }
   else
   {
      if(save_session_to_file(string))
      {
         gtk_widget_destroy(GTK_WIDGET(file_list));
         g_free(session_file);
         session_file = g_new(char, strlen(string)+1);
         strcpy(session_file, string);
         set_window_title();
      }
      else
      {
         save_error(string);
         gtk_widget_show(GTK_WIDGET(file_list));
      }
   }
   g_free(string);
}

void save_session_as_error_continue(GtkWidget *widget, gchar *filename)
{
   gboolean success;   
   success = save_session_to_file(filename);
   if(!success) generic_dialog_with_text(_("Session save failed."));
   else
   {
      g_free(session_file);
      session_file = g_new(char, strlen(filename)+1);
      strcpy(session_file, filename);
      set_window_title();
   }
}

gboolean save_session_to_file(gchar *filename)
{
   FILE *file;   
   GList *temp = NULL;
   GdsFile *current;
   
   if((file = fopen(filename, "w")))
   {
      temp = g_list_first(files_list);
      while(temp)
      {
         current = (GdsFile *)temp->data;
         fprintf(file, "<file>\n");
         fprintf(file, "filename=%s\n", current->filename);
         fprintf(file, "over_ride=%d\n", current->props.over_ride);
         fprintf(file, "bracketmatch=%d\n", current->props.bracketmatch);
         fprintf(file, "highlight=%d\n", current->props.syntax);
         fprintf(file, "use_spaces=%d\n", current->props.use_spaces);
         fprintf(file, "tab_stop=%d\n", current->props.spaces);
         fprintf(file, "line=%d\n", gtk_extext_get_line(GTK_EXTEXT(current->text)));
         if(current->props.dir)
            fprintf(file, "directory=%s\n", current->props.dir);
         if(current->props.compiler)
            fprintf(file, "compiler=%s\n", current->props.compiler);
         if(current->props.debugger)
            fprintf(file, "debugger=%s\n", current->props.debugger);
         if(current->props.execution)
            fprintf(file, "execution=%s\n", current->props.execution);	 
         fprintf(file, "</file>\n");	 
         temp = temp->next;
      }
      fclose(file);
   }
   else
   {
      return(FALSE);
   }
   return(TRUE);
}


guint open_session_from_file(gchar *filename)
{
   FILE *file;
   gint success = 0;
   gchar *text;
   gchar buffer[1024];
   gchar file_string[] = "filename=";
   gchar directory_string[] = "directory=";
   gchar compiler_string[] = "compiler=";
   gchar debugger_string[] = "debugger=";
   gchar execution_string[] = "execution=";
   gchar *newfile = NULL;
   GdsFileProperties props;
   gint line;

   props.bracketmatch = general_preferences.bracketmatch;
   props.dir = NULL;
   props.compiler = NULL;
   props.debugger = NULL;
   props.execution = NULL;
   
   if(!(file = fopen(filename, "r"))) return(0);

   if(app->window != NULL)
      gdk_window_set_cursor(app->window, gdk_cursor_new(GDK_WATCH));

   while(fgets(buffer, sizeof(buffer), file))
   {
      while(gtk_events_pending()) gtk_main_iteration();
      if(strstr(buffer, "<file>")) 
      {
         props.bracketmatch = general_preferences.bracketmatch;
         while(fgets(buffer, sizeof(buffer), file) != NULL)
         {
            if(strstr(buffer, "</file>")) break;
            if((text = strrchr(buffer, '\n'))) *text = '\0';
            if((text = strstr(buffer, file_string)))
            {
               g_free(newfile);
               newfile = g_strdup(text + strlen(file_string));
               continue;
            }
            else if(sscanf(buffer, "over_ride=%d", &props.over_ride))
            {
               continue;
            }
            else if(sscanf(buffer, "bracketmatch=%d", &props.bracketmatch))
            {
               continue;
            }
            else if(sscanf(buffer, "highlight=%d", &props.syntax))
            {
               continue;
            }
            else if(sscanf(buffer, "auto_indent=%d", &props.auto_indent))
            {
               continue;
            }
            else if(sscanf(buffer, "use_spaces=%d", &props.use_spaces))
            {
               continue;
            }
            else if(sscanf(buffer, "tab_stop=%d", &props.spaces))
            {
               continue;
            }
            else if(sscanf(buffer, "line=%d", &line))
            {
               continue;
            }
            else if((text = strstr(buffer, directory_string)))
            {
               g_free(props.dir);
               props.dir = g_strdup(text + strlen(directory_string));
               continue;
            }
            else if((text = strstr(buffer, compiler_string)))
            {
               g_free(props.compiler);
               props.compiler = g_strdup(text + strlen(compiler_string));
               continue;
            }
            else if((text = strstr(buffer, debugger_string)))
            {
               g_free(props.debugger);
               props.debugger = g_strdup(text + strlen(debugger_string));
               continue;
            }
            else if((text = strstr(buffer, execution_string)))
            {
               g_free(props.execution);
               props.execution = g_strdup(text + strlen(execution_string));
               continue;
            }
         }
         if(newfile && check_if_file_exists(newfile))
         {
            open_file_real(newfile);
            success++;
            while(gtk_events_pending()) gtk_main_iteration();
            if(GTK_EXTEXT(cur_file->text)->scroll_line_count < 1)
               GTK_EXTEXT(cur_file->text)->scroll_line_count=10;
            gtk_extext_set_line(GTK_EXTEXT(cur_file->text), line);
            cur_file->props.over_ride = props.over_ride;
            cur_file->props.bracketmatch = props.bracketmatch;
            cur_file->props.syntax = props.syntax;
            cur_file->props.auto_indent = props.auto_indent;
            cur_file->props.use_spaces = props.use_spaces;
            cur_file->props.spaces = props.spaces;
            if(props.over_ride)
            {
               gds_editor_set_highlight(GDS_EDITOR(cur_file->text), props.syntax);
               GTK_EXTEXT(cur_file->text)->default_tab_width = props.spaces;
            }
            if(props.dir)
            {
               g_free(cur_file->props.dir);
               cur_file->props.dir = g_strdup(props.dir);
            }
            if(props.compiler)
            {
               g_free(cur_file->props.compiler);
               cur_file->props.compiler = g_strdup(props.compiler);
            }
            if(props.debugger)
            {
               g_free(cur_file->props.debugger);
               cur_file->props.debugger = g_strdup(props.debugger);
            }
            if(props.execution)
            {
               g_free(cur_file->props.execution);
               cur_file->props.execution = g_strdup(props.execution);
            }
         }
      }
   }
   fclose(file);
   g_free(newfile);
   g_free(props.dir);
   g_free(props.compiler);
   g_free(props.debugger);
   g_free(props.execution);
   if(app->window) gdk_window_set_cursor(app->window, gdk_cursor_new(GDK_LEFT_PTR));
   return(success);
}
