#include "declarations.h"
#include "macro-language.h"
#include "bindings.h"

#ifdef HAVE_PYGTK
#include "pygtk.h"
#endif

static gint build_menu_from_scripts_dir(gchar *path, GtkWidget *parent);

static GList *static_scripts = NULL; //Scripts files
static GList *dynamic_scripts = NULL; //Scripts entries
static GList *static_entries = NULL; // Normal entries, but only the ones added whilst we were not parsing a syntax highlighting definition.
GList *dynamic_build = NULL;         // Build Entries (All, including whilst parsing a syntsx highlight definition)
GList *edit_entries = NULL;          // Popup menu entries

void initialize_macro_language(int argc, char *argv[])
{
   Py_Initialize();
   PySys_SetArgv(argc,argv);
   PyImport_AddModule("glimmer");
   init_scripting();
   PyRun_SimpleString("import glimmer");
   PyRun_SimpleString("from glimmer import *");
#ifdef HAVE_PYGTK
   init_pygtk();
#endif
   main_finish(NULL, argc, argv);
}

void execute_macro_string(char* string)
{
   PyRun_SimpleString(string);
}

void autoexec_script(void)
{
   gchar filename[256];
   FILE* autoexec_file;
   g_snprintf(filename, sizeof(filename), "%s/." PACKAGE "/autoexec.py", getenv("HOME"));
   if((autoexec_file = fopen(filename,"r")))
   {
      PyRun_SimpleFile(autoexec_file, "autoexec.py");
      fclose(autoexec_file);
   }
}

static gint build_menu_from_scripts_dir(gchar *path, GtkWidget *parent)
{
   DIR *dir_list;
   struct dirent *dir;
   struct stat st;
   gchar *label;
   gchar *text;
   GtkWidget *menu;
   GtkWidget *menu_item;
   gint items = 0;
   
   dir_list = opendir(path);
   if(!dir_list) return(0);
   while((dir = readdir(dir_list)))
   {
      text = g_strconcat(path, "/", dir->d_name, NULL);
	   stat(text, &st);
      g_free(text);
      if(!S_ISDIR(st.st_mode))
      {
         if(strstr(dir->d_name, ".py"))
         {
            label = get_file_wo_extension(dir->d_name);
            menu_item = gtk_menu_item_new_with_label(label);
            gtk_menu_append(GTK_MENU(parent), menu_item);
            text = g_strconcat(path, "/", dir->d_name, NULL);
            gtk_object_set_data(GTK_OBJECT(menu_item), "path", text);
            gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(script_run_cb), (gpointer)text);
            gtk_widget_show(menu_item);
            static_scripts = g_list_append(static_scripts, (gpointer)menu_item);
            g_free(label);
            items++;
         }
      }
      else if(strcmp(dir->d_name, ".") && strcmp(dir->d_name, ".."))
      {
         menu_item = gtk_menu_item_new_with_label(dir->d_name);
         gtk_menu_append(GTK_MENU(parent), menu_item);
         static_scripts = g_list_append(static_scripts, (gpointer)menu_item);
         gtk_widget_show(menu_item);
         menu = gtk_menu_new();
         gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
         static_scripts = g_list_append(static_scripts, (gpointer)menu);
         gtk_widget_show(menu);
         text = g_strconcat(path, "/", dir->d_name, NULL);
         items += build_menu_from_scripts_dir(text, menu);
         g_free(text);
      }
   }
   closedir(dir_list);
   return(items);
}

void build_scripts_menu(void)
{
   gchar path[384];
   g_snprintf(path, sizeof(path), PREFIX "/share/" PACKAGE "/scripts");
   build_menu_from_scripts_dir(path, scriptsmenu);
   g_snprintf(path, sizeof(path), "%s/." PACKAGE "/scripts", getenv("HOME"));
   build_menu_from_scripts_dir(path, scriptsmenu);
   return;
}

void script_run_cb(GtkWidget *widget, gchar *filename)
{
   FILE *file;
   g_print("Executing Python script: %s\n", filename);
   file = fopen(filename, "r");
   if(!file) return;
   PyRun_SimpleFile(file, filename);
   fclose(file);
   return;
}

void regenerate_scripts_cb(GtkWidget *widget, gpointer data)
{
   GList *current;
   gpointer text;
   current = static_scripts = g_list_reverse(static_scripts);
   while(current)
   {
      text = gtk_object_get_data(GTK_OBJECT(current->data), "path");
      if(text) g_free(text);
      if(GTK_IS_WIDGET(current->data))
         gtk_widget_destroy(GTK_WIDGET(current->data));
      current = current->next;
      //g_print("killing item\n");
   }
   g_list_free(static_scripts);
   static_scripts = NULL;
   build_scripts_menu();
}

void adjust_popup_menu(void)
{
   GList *list;
   GtkWidget *widget;
   if(!cur_file) return;
   for(list = g_list_first(edit_entries); list; list = list->next)
   {
      widget = (GtkWidget *)list->data;
      if(widget) gtk_widget_hide(widget);
   }
   if(!cur_file->tables) return;
   if(!cur_file->tables->menu_entries) return;
   for(list = g_list_first(edit_entries); list; list = list->next)
   {
      widget = (GtkWidget *)list->data;
      if(widget && g_list_nth_data(cur_file->tables->menu_entries, g_list_index(cur_file->tables->menu_entries, list->data)))
         gtk_widget_show(widget);
   }
   adjust_build_menu();
}

void adjust_build_menu(void)
{
   GList *list;
   GtkWidget *widget;
   if(!cur_file) return;
   for(list = g_list_first(dynamic_build); list; list = list->next)
   {
      widget = (GtkWidget *)list->data;
      if(widget) gtk_widget_hide(widget);
   }
   if(!cur_file->tables) return;
   if(!cur_file->tables->menu_entries) return;
   for(list = g_list_first(dynamic_build); list; list = list->next)
   {
      widget = (GtkWidget *)list->data;
      if(widget && g_list_nth_data(cur_file->tables->menu_entries, g_list_index(cur_file->tables->menu_entries, list->data)))
      {
         gtk_widget_show(widget);
      }
   }
}

void remove_pyref(GtkWidget *widget, PyObject *object)
{
   Py_DECREF(object);
}

void call_python_function_cb(GtkWidget *widget, gpointer *function)
{
   PyObject* result;
   g_assert(PyCallable_Check((PyObject*)function));
   result = PyObject_CallObject((PyObject*)function,NULL);
   Py_XDECREF(result);
}

#include "bindings-python.c"
