#include "declarations.h"
#include "linebar.h"

static void check_line_button_cb(GtkWidget* widget, GtkWidget *target);

GtkWidget *linebar = NULL;
GtkWidget *line_combo;
GtkWidget *line_entry;
static GList *line_history = NULL;

void make_line_toolbar(void)
{
   GtkWidget *line_button;
   GtkWidget *pixmapwid;

   linebar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_container_set_border_width(GTK_CONTAINER(linebar), 2);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(linebar), GTK_RELIEF_NONE);
   gtk_widget_show(linebar);

   line_combo = gtk_combo_new();
   gtk_widget_set_usize(line_combo, 100, 23);
   gtk_combo_disable_activate(GTK_COMBO(line_combo));
   gtk_combo_set_case_sensitive(GTK_COMBO(line_combo), TRUE);
   gtk_toolbar_append_widget(GTK_TOOLBAR(linebar), line_combo, _("Line Number"), NULL);
   line_entry = GTK_COMBO(line_combo)->entry;
   gtk_signal_connect(GTK_OBJECT(line_entry), "activate", GTK_SIGNAL_FUNC(execute_line_cb), NULL);
   line_combo_set_history(build_glist_from_file("line.hist", general_preferences.history));
   gtk_widget_show(line_combo);
   gtk_toolbar_append_space(GTK_TOOLBAR(linebar));
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_JUMP_TO, 21, 21);
   line_button = gtk_toolbar_append_item(GTK_TOOLBAR(linebar), 0, _("Jump to a line."), 0, pixmapwid, GTK_SIGNAL_FUNC(execute_line_cb), 0);
   gtk_widget_set_sensitive(line_button, FALSE);
   gtk_signal_connect(GTK_OBJECT(line_entry), "changed", GTK_SIGNAL_FUNC(check_line_button_cb), line_button);
   gnome_app_add_docked(GNOME_APP(app), linebar, "LineBar", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 2, 7, 0);
}

void execute_line_cb(GtkWidget* widget, gpointer data)
{
   GtkExText *extext;
   GtkEditable *editable;
   gchar *text;
   gint line_num;
   extext = GTK_EXTEXT(cur_file->text);
   editable = GTK_EDITABLE(cur_file->text);

   text = gtk_entry_get_text(GTK_ENTRY(line_entry));
   if(strlen(text)>0)
   {
      if(sscanf(text, "%d", &line_num) && line_num >= 1 && line_num <= extext->line_count)
      {
         add_string_to_file("line.hist", text);
         line_combo_add_string(text);
         gtk_extext_set_line(extext, line_num-1);
         gtk_widget_grab_focus(GTK_WIDGET(extext));
      }
      else display_message("Line not found.", FLASH);
   }
}

static void check_line_button_cb(GtkWidget* widget, GtkWidget *target)
{
   gchar *text;
   gint line_num;
   text = gtk_entry_get_text(GTK_ENTRY(line_entry));
   if(text && strlen(text) > 0 && sscanf(text, "%d", &line_num) && line_num >= 1)
      gtk_widget_set_sensitive(target, TRUE);
   else
      gtk_widget_set_sensitive(target, FALSE);
}

void line_combo_set_history(GList *history)
{
   if(history == NULL) return;
   line_history = history;
   gtk_combo_set_popdown_strings(GTK_COMBO(line_combo), line_history);
   gtk_entry_set_text(GTK_ENTRY(line_entry), "");
}

gboolean line_combo_add_string(gchar *string)
{
   gint pos;
   gpointer temp;
   GList *ptr;
   gboolean success = FALSE;
   pos = check_list_for_string(line_history, string);
   if(pos)
   {
      temp = g_list_nth_data(line_history, pos-1);
      line_history = g_list_remove(line_history, temp);
   }
   else
   {
      temp = g_new(char, strlen(string)+1);
      strcpy((gchar *)temp, string);
   }

   line_history = g_list_prepend(line_history, temp);

   while(g_list_length(line_history) > general_preferences.history)
   {
      ptr = g_list_nth(line_history, g_list_length(line_history)-1);
      if(ptr)
      {
         temp = ptr->data;
         line_history = g_list_remove(line_history, ptr->data);
         g_free(ptr->data);
      }
   }
   gtk_combo_set_popdown_strings(GTK_COMBO(line_combo), line_history);
   return(success);
}
