/*  insert.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INSERT_H
#define INSERT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "widgets/gnomefilelist.h"
#include "widgets/gnomeasciilist.h"
#include "widgets/gnomeruncmd.h"
void insert_date_time(GtkWidget *widget, gpointer data);
void insert_username(GtkWidget *widget, gpointer data);
void insert_name(GtkWidget *widget, gpointer data);
void insert_email(GtkWidget *widget, gpointer data);

void insert_gpl_notice(GtkWidget *widget, gpointer data);
void insert_gpl_noticepp(GtkWidget *widget, gpointer data);
void insert_gpl_noticepython(GtkWidget *widget, gpointer data);
void insert_changelog_string(GtkWidget *widget, gpointer data);
void insert_comment(GtkWidget *widget, gpointer data);
void insert_commentpp(GtkWidget *widget, gpointer data);

void insert_ascii_char_cb(GtkWidget *widget, gpointer data);
void insert_ascii_char(GtkWidget *widget, GnomeAsciiList *ascii);

void insert_file_cb(GtkWidget *widget, gpointer data);
void insert_file_cb_continue(GtkWidget *widget, GnomeFileList *file_list);
void insert_file_real(gchar *filename);

void runcmd_cb(GtkWidget *widget, gpointer data);
void exec_command_cb(GtkWidget *widget, GnomeRunCmd *grc);
void exec_command_callback(GdsFile *current);

void indent_cb(GtkWidget *widget, gpointer data);
void exec_indent_command_cb(GtkWidget *widget, GnomeRunCmd *grc);

#ifdef __cplusplus
}
#endif

#endif
