#include "declarations.h"
#include "highlightbar.h"

GtkWidget *highlightbar;
GtkWidget *rehighlight_button;
GtkWidget *reparse_button;
GtkWidget *highlightbar_option;

void make_highlight_bar(GtkWidget *menu)
{
   GtkWidget *pixmapwid;

   highlightbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_container_set_border_width(GTK_CONTAINER(highlightbar), 2);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(highlightbar), GTK_RELIEF_NONE);
   gtk_widget_show(highlightbar);

   highlightbar_option = gtk_option_menu_new();
   gtk_option_menu_set_menu(GTK_OPTION_MENU(highlightbar_option), menu);
   gtk_option_menu_set_history(GTK_OPTION_MENU(highlightbar_option), 0);
   gtk_toolbar_append_widget(GTK_TOOLBAR(highlightbar), highlightbar_option, _("Highlight style."), NULL);
   gtk_widget_show(highlightbar_option);

   gtk_toolbar_append_space(GTK_TOOLBAR(highlightbar));
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_JUMP_TO, 21, 21);
   rehighlight_button = gtk_toolbar_append_item(GTK_TOOLBAR(highlightbar), 0, _("Re-Highlight the current buffer."), 0, pixmapwid, GTK_SIGNAL_FUNC(highlight_syntax_cb), 0);
   gnome_app_add_docked(GNOME_APP(app), highlightbar, "HighlightBar", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 2, 5, 0);
}
