/*  edit.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef EDIT_H
#define EDIT_H

#ifdef __cplusplus
extern "C" {
#endif

void reverse_bookmark_cb(GtkWidget *widget, gpointer data);

void undo_last_cb(GtkWidget *widget, gpointer data);
void undo_last_real(GdsFile *file);
void redo_last_cb(GtkWidget *widget, gpointer data);
void redo_last_real(GdsFile *file);
void cut_text_cb(GtkWidget *widget, gpointer data);
void cut_text_real(GdsFile *file);
void copy_text_cb(GtkWidget *widget, gpointer data);
void copy_text_real(GdsFile *file);
void paste_text_cb(GtkWidget *widget, gpointer data);
void paste_text_real(GdsFile *file);
void clear_text_cb(GtkWidget *widget, gpointer data);
void clear_text_real(GdsFile *file);
void clear_line_cb(GtkWidget *widget, gpointer data);
void clear_end_cb(GtkWidget *widget, gpointer data);
void clear_start_cb(GtkWidget *widget, gpointer data);
void clear_entry_real(void);
void select_line_cb(GtkWidget *widget, gpointer data);
void select_all_text_cb(GtkWidget *widget, gpointer data);
void select_all_text_real(GdsFile *file);
void select_current_cb(GtkWidget *widget, gpointer data);
void select_current_real(GdsFile *file);
void highlight_syntax_cb(GtkWidget *widget, gpointer data);
void highlight_syntax_real(GdsFile *file);
void reparse_highlight_table_cb(GtkWidget *widget, gpointer data);

#ifdef __cplusplus
}
#endif

#endif
