/*  declarations.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef DECLARATIONS_H
#define DECLARATIONS_H

#ifdef __cplusplus
extern "C" {
#endif

#include <unistd.h>
#include <gtk/gtk.h>
#include <gnome.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <gdk/gdkkeysyms.h>

// This is the package name and version... hopefully will be there :o)
#include "../config.h"

#ifndef PACKAGE
#warning "Package name not defined!"
#endif

#ifndef VERSION
#warning "Package version not defined!"
#endif

#ifndef PREFIX
#warning "Prefix not defined!"
#endif

#define MAX_FILES 30

#define PIXMAP_DIR (PREFIX "/share/pixmaps")
#define LANG_DIR (PREFIX "/share/" PACKAGE "/languages")

#define URL "http://glimmer.sourceforge.net"

#define LINE_LENGTH 1024

#define FLASH 0
#define ERROR 1
#define WARNING 2

#include "Python.h"

#include "properties.h"
#include "widgets/custom_widgets.h"
#include "gtkextext/gtkextext.h"
#include "main.h"
#include "misc.h"
#include "menus.h"
#include "toolbar.h"
#include "settings.h"
#include "getprefs.h"
#include "syntax-highlight.h"
#include "mdi-routines.h"
#include "file-io.h"
#include "edit.h"
#include "dialogs.h"
#include "searches.h"
#include "build.h"
#include "session.h"
#include "color-settings.h"

#ifdef __cplusplus
}
#endif

#endif
