/*  bindings.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _BINDINGS_H__
#define _BINDINGS_H__

#ifdef __cplusplus
extern "C" {
#endif

int get_file_number(void);
int change(int file_no);
int get_files(void);
char *get_default_term_command(void);
char *get_default_make_command(void);
int get_tab_stops(void);
int get_file_length(int file_no);
int get_file_changed(int file_no);
int get_file_tab_width(int file_no);
int get_file_use_spaces(int file_no);
char *get_full_filename(int file_no);
char *get_filename(int file_no);
char *get_path(int file_no);
char *get_file(int file_no);
char *get_file_compile_string(int file_no);
char *get_file_debug_string(int file_no);
char *get_file_execute_string(int file_no);
void set_file_done_compiling(int file_no);
void set_file_done_debugging(int file_no);
void set_file_done_executing(int file_no);
int has_selection(void);
int selection_start(void);
int selection_end(void);
void move(int relative_movement);
void move_to(int index);
int current_position(void);
int  buffer_size(void);
void insert_in(int file_no, int pos, char* text);
void insert(char* text);
void move_to_line (int index);
void move_lines (int relative_movement);
int current_line(void);
int line_start(void);
int line_end(void);
int freeze(void);
int thaw(void);
int line_by_pos(int pos);
void move_to_col(int index);
char* get_text(int begin,int end);
char get_current_char(void);
char get_next_char(void);
void delete_text(int start, int end);
void delete_text_in(int file_no, int start, int end);
void forward_delete (int n);
void backward_delete (int index);
void undo(void);
void undo_last(int file_no);
void redo(void);
void redo_last(int file_no);
void cut(void);
void cut_text(int file_no);
void copy(void);
void copy_text(int file_no);
void paste(void);
void paste_text(int file_no);
void clear(void);
void clear_text(int file_no);
void clear_entry(void);
void select_area(int from, int to);
void select_text(int file_no, int from, int to);
void select_current(void);
void select_all(void);
void select_all_text(int file_no);
void highlight_syntax(int file_no);
void new_window(void);
void new_file(char *filename);
void open_file(char *filename);
void close_file(int file_no);
void save_all_files(void);
void close_all_files(void);
int find(char *text);
int find_in(int file_no, char *text);
int find_regex(char *text);
int find_regex_in(int file_no, char *text);
int replace(char *search_text, char *replacer);
int replace_in(int file_no, char *search_text, char *replacer);
int replace_all(char *search_text, char *replacer);
int replace_all_in(int file_no, char *search_text, char *replacer);

void add_syntax_entry(char *name, char *start, char *end, char *color, char *cclass);
void add_pattern_entry(char *name, char *words, char *color, char *cclass);
void add_embedded_entry(char *name, char *start, char *words, char *end, char *color, char *cclass);

#ifdef __cplusplus
}
#endif

#endif
