# Sample autoexec.py script

import glimmer
import string
import sys
sys.argv=[]
sys.argv.append("null")
from gtk import *
import _gtk

def populate_dir_listing(path):
   import dircache
   import string
   filelist.set_column_title(0, path)
   filelist.clear()
   dirlisting = dircache.listdir(path)
   dirlisting = dirlisting[:]
   dircache.annotate(path, dirlisting)
   dotfiles = []
   dotfiles = [".", ""]
   filelist.append(dotfiles)
   dotfiles = ["..", ""]
   filelist.append(dotfiles)
   num = 0
   dlen = len(dirlisting)
   filelist.freeze()
   while num < dlen:
      if string.count(dirlisting[num], "/") > 0:
         dname = []
         dname.append(dirlisting[num])
         dname.append("")
         filelist.append(dname)
      num = num + 1
   num = 0
   while num < dlen:
      if string.count(dirlisting[num], "/") <= 0:
         dname = []
         dname.append(dirlisting[num])
         dname.append("")
         filelist.append(dname)
      num = num + 1
   del dircache
   del string
   filelist.thaw()

def select_row_callback(clist, row, col, event, data):
   import glimmer
   import string
   dir = filelist.get_column_title(0)
   text = filelist.get_text(row, 0)
   if string.count(text, "/") > 0:
      dir = dir + text
      populate_dir_listing(dir)
   elif text == ".":
      dir = dir
      populate_dir_listing(dir)
   elif text == "..":
      i = string.rfind(dir, "/")
      if i > 1:
         dir = dir[0:i]
         i = string.rfind(dir, "/")
         if i > 1:
            dir = dir[0:i+1]
         else:
            dir = "/"
      else:
         dir = "/"
      populate_dir_listing(dir)
   else:
      filename = dir + text
      glimmer.open_file(filename)
   del glimmer
   del string

filewindow = GtkScrolledWindow()
filewindow.set_usize(130, 500)
filewindow.show()
filelist = GtkCList(1)
filewindow.add(filelist)
filelist.show()
filelist.column_titles_show(1)
filelist.set_column_title(0, "/")
glimmer.add_dock_item(filewindow._o, "FileSelector", 3, 0, 0, 0)
populate_dir_listing("/")
args = (None,)
_gtk.gtk_signal_connect(filelist._o, "select_row", select_row_callback, args)

def show_file_selector():
   filewindow.show()

def hide_file_selector():
   filewindow.hide()

glimmer.add_item_to_scripts_menu("Show File Selector", -1, show_file_selector)
glimmer.add_item_to_scripts_menu("Hide File Selector", -1, hide_file_selector)
