#include <gtk/gtk.h>
#include <champlain/champlain.h>
#include <champlain-gtk/champlain-gtk.h>
#include <clutter-gtk/clutter-gtk.h>
#include <glib/gstdio.h>
#include <string.h>

static ChamplainView *champlain_view;
GApplication *app;
GtkWidget *search_selector;
GtkWidget *window;

static void
new_station(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("New Internet Radio Station\n");
  return;
}

static void
search_station(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("Search Internet Radio Station\n");
  return;
}

static void
listen_station(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("Listen to Internet Radio Station\n");
  return;
}

static void
pause_station(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("Pause Internet Radio Station\n");
  return;
}

static void
prev_station(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("Previous Internet Radio Station\n");
  return;
}

static void
stations_all(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("79 Internet Radio Stations\n");
  return;
}

static void
next_station(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("Next Internet Radio Station\n");
  return;
}

static void
about_station(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("About Internet Radio Station\n");
  return;
}

static void
about_program(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_print("About Internet Radio Program\n");
  return;
}

static void
quit_program(GSimpleAction *simple, GVariant *parameter, gpointer user_data) {
  g_application_quit(app);
  return;
}

static void
girl_window_cb (GApplication *app,
	     gpointer user_data)
{
  GtkWidget *widget, *grid, *toolbar, *new, *search, *listen, *pause, *prev, *stations, *next, *station, *program, *quit;
	
	window = gtk_application_window_new (app);
	widget = gtk_champlain_embed_new();
	toolbar = gtk_toolbar_new();

	new = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "New");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(new), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(new), 0);
	gtk_widget_show (GTK_WIDGET(new));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(new), "New Station");
	g_signal_connect(new, "clicked", G_CALLBACK (new_station), GTK_WINDOW (window));

	search = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "Search");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(search), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(search), 1);
	gtk_widget_show (GTK_WIDGET(search));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(search), "Search Internet Radio Station");
	g_signal_connect(search, "clicked", G_CALLBACK (search_station), GTK_WINDOW (window));
	
	listen = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "Listen");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(listen), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(listen), 2);
	gtk_widget_show (GTK_WIDGET(listen));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(listen), "Listen Internet Radio Station");
	g_signal_connect(listen, "clicked", G_CALLBACK (listen_station), GTK_WINDOW (window));

	pause = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "Pause");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(pause), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(pause), 3);
	gtk_widget_show (GTK_WIDGET(pause));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(pause), "Pause Internet Radio Station");
	g_signal_connect(pause, "clicked", G_CALLBACK (pause_station), GTK_WINDOW (window));

	prev = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "Prev");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(prev), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(prev), 4);
	gtk_widget_show (GTK_WIDGET(prev));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(prev), "Prev Internet Radio Station");
	g_signal_connect(prev, "clicked", G_CALLBACK (prev_station), GTK_WINDOW (window));

	stations = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "Stations");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(stations), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(stations), 5);
	gtk_widget_show (GTK_WIDGET(stations));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(stations), "Stations");
	g_signal_connect(stations, "clicked", G_CALLBACK (stations_all), GTK_WINDOW (window));

	next = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "Next");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(next), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(next), 6);
	gtk_widget_show (GTK_WIDGET(next));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(next), "Next Internet Radio Station");
	g_signal_connect(next, "clicked", G_CALLBACK (next_station), GTK_WINDOW (window));
	
	station = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "About Station");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(station), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(station), 7);
	gtk_widget_show (GTK_WIDGET(station));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(station), "About Station");
	g_signal_connect(station, "clicked", G_CALLBACK (about_station), GTK_WINDOW (window));

	program = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "About Program");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(program), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(program), 8);
	gtk_widget_show (GTK_WIDGET(program));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(program), "About Program");
	g_signal_connect(program, "clicked", G_CALLBACK (about_program), GTK_WINDOW (window));

	quit = gtk_tool_button_new(gtk_image_new_from_icon_name(NULL, GTK_ICON_SIZE_BUTTON), "Exit");
	gtk_tool_item_set_is_important(GTK_TOOL_ITEM(quit), TRUE);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(quit), 9);
	gtk_widget_show (GTK_WIDGET(quit));
	gtk_tool_item_set_tooltip_text (GTK_TOOL_ITEM(quit), "Exit Program");
	g_signal_connect(quit, "clicked", G_CALLBACK (quit_program), GTK_WINDOW (window));

	grid = gtk_grid_new();
	gtk_grid_attach (GTK_GRID(grid), GTK_WIDGET(toolbar), 0, 0, 1, 1);
	gtk_grid_attach (GTK_GRID(grid), GTK_WIDGET(widget), 0, 1, 1, 1);
        champlain_view = gtk_champlain_embed_get_view (GTK_CHAMPLAIN_EMBED(widget));
        gtk_widget_set_size_request(GTK_WIDGET(widget), 1440, 720);
	gtk_container_add (GTK_CONTAINER(window), GTK_WIDGET(grid));
	g_signal_connect (window, "destroy", G_CALLBACK(gtk_main_quit), NULL);
	gtk_window_set_title (GTK_WINDOW(window), "GNOME Internet Radio Locator");
	gtk_window_set_default_size (GTK_WINDOW(window), 1440, 720);
	gtk_widget_show_all (window);
	
}

int
main (int argc,
      char **argv)
{
	int status;

	if (gtk_clutter_init (&argc, &argv) != CLUTTER_INIT_SUCCESS)
		return 1;
	
	app = gtk_application_new ("software.girl.gtk", G_APPLICATION_FLAGS_NONE);
	g_signal_connect (app, "activate", G_CALLBACK (girl_window_cb), NULL);
	
	status = g_application_run (G_APPLICATION (app), argc, argv);
	g_object_unref (app);

	return status;
}

