/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * main.c: the ggv shell
 *
 * Copyright (C) 2002 the Free Software Foundation
 *
 * Author: Jaka Mocnik  <jaka@gnu.org>
 */

#include <config.h>

#include <gnome.h>
#include <bonobo-activation/bonobo-activation.h>
#include <libgnomeui/gnome-window-icon.h>
#include <gconf/gconf-client.h>
#include <bonobo.h>
#include <bonobo/bonobo-ui-main.h>

#include <math.h>
#include <ctype.h>

#include "ggv-window.h"
#include "ggv-prefs.h"

static GgvWindow *
create_window(const gchar *filename)
{
        GgvWindow *win = GGV_WINDOW(ggv_window_new());

        if(filename)
                ggv_window_load(win, filename);

        gtk_widget_show(GTK_WIDGET(win));

        return win;
}

static gboolean
create_windows_from_cmdline(gpointer data)
{
        const gchar **files = NULL;
        poptContext *ctx;
        int i;

        ctx = (poptContext *)data;
        if(*ctx)
                files = poptGetArgs(*ctx);

        if(!files)
                create_window(NULL);
        else
                for(i = 0; files[i]; i++)
                        create_window(files[i]);

        return FALSE;
}

int
main(int argc, char **argv)
{
	CORBA_Environment ev;
	CORBA_ORB orb;
	GError *error;
	poptContext *ctx;

	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);

	ctx = g_new0(poptContext, 1);
	gnome_init_with_popt_table("Gnome Ghostview", VERSION,
                                   argc, argv, NULL, 0, ctx);

	CORBA_exception_init(&ev);

	error = NULL;
	if (gconf_init(argc, argv, &error) == FALSE) {
		g_assert(error != NULL);
		g_message("GConf init failed: %s", error->message);
		g_error_free (error);
		exit (EXIT_FAILURE);
	}

	if (bonobo_ui_init ("Gnome Ghostview", VERSION, &argc, argv) == FALSE)
		g_error (_("Could not initialize Bonobo!\n"));

        gtk_idle_add (create_windows_from_cmdline, ctx);

        ggv_prefs_add_callback((GgvPrefsCb)ggv_window_apply_prefs, NULL);

	gnome_window_icon_set_default_from_file (GNOMEICONDIR "/gnome-ghostview.png");

        ggv_prefs_load();

	bonobo_main ();

        g_warning("GGV exiting...");

        ggv_prefs_save();

	CORBA_exception_free (&ev);
	
        return 0;
}
