/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * ggv-prefs.h: GGV preferences & preferences ui
 *
 * Copyright (C) 2002 the Free Software Foundation
 *
 * Author: Jaka Mocnik  <jaka@gnu.org>
 */

#ifndef __GGV_PREFS_H__

#include <config.h>

#include <glib.h>
#include <gconf/gconf-client.h>

G_BEGIN_DECLS 

#define DEFAULT_WINDOW_WIDTH  640
#define DEFAULT_WINDOW_HEIGHT 480

#define DEFAULT_FILE_SEL_WIDTH   320
#define DEFAULT_FILE_SEL_HEIGHT  256

#define GGV_TYPE_PREFS_DIALOG            (ggv_prefs_dialog_get_type ())
#define GGV_PREFS_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GGV_TYPE_PREFS_DIALOG, GgvPrefsDialog))
#define GGV_PREFS_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GGV_TYPE_PREFS_DIALOG, GgvPrefsDialogClass))
#define GGV_IS_PREFS_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GGV_TYPE_PREFS_DIALOG))
#define GGV_IS_PREFS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GGV_TYPE_PREFS_DIALOG))
#define GGV_PREFS_DIALOG_GET_CLASS(o)    (G_TYPE_INSTANCE_GET_CLASS ((o), GGV_TYPE_PREFS_DIALOG, GgvPrefsDialogClass))

typedef struct _GgvPrefsDialog      GgvPrefsDialog;
typedef struct _GgvPrefsDialogClass GgvPrefsDialogClass;

struct _GgvPrefsDialog
{
        GtkWindow dlg;

        GtkWidget *notebook;

        GtkWidget *gs, *alpha_params, *scan_pdf, *unzip, *unbzip2, *print;   /* entries */
        GtkWidget *size, *zoom, *orientation, *units;      /* option menus */
        GtkWidget *watch, *aa, *override_size, *respect_eof, *show_scroll_rect; /* checkbuttons */
        GtkWidget *override_orientation;
        GtkWidget *sidebar, *mbar, *sbar, *toolbar, *tblabels, *savegeo,*auto_jump;/* checkbuttons */
        GtkWidget **size_choice;               /* paper items */
        GtkWidget **zoom_choice;               /* zoom items */
        GtkWidget **orientation_choice;        /* orientation items */
        GtkWidget **unit_choice;               /* unit items */

        GtkWidget *ok, *cancel, *apply;
};

struct _GgvPrefsDialogClass
{
        GtkWindowClass klass;
};

GType ggv_prefs_dialog_get_type(void);
GtkWidget *ggv_prefs_dialog_new(void);
void ggv_prefs_dialog_show(GgvPrefsDialog *dlg);

extern gchar    *ggv_print_cmd;       /* print command: must print its stdin */
extern gboolean  ggv_panel;           /* panel visible */
extern gboolean  ggv_toolbar;         /* toolbar visible */
extern gboolean  ggv_toolbar_labels;  /* toolbar has labels */
extern gboolean  ggv_menubar;         /* menubar visible */
extern gboolean  ggv_statusbar;       /* statusbar visible */
extern gboolean  ggv_save_geometry;   /* Save the current geometry for next session */
extern gint      ggv_unit_index;      /* the unit we want to use for coordinates */
extern gboolean  ggv_autojump;        /* auto jump to beginning of the page */

/* default window dimensions */
extern gint ggv_default_width, file_sel_width;
extern gint ggv_default_height, file_sel_height;

void         ggv_prefs_load (void);
void         ggv_prefs_save (void);
GConfClient *ggv_prefs_gconf_client (void);

G_END_DECLS

#endif /* __GGV_PREFS_H__ */
