/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * GGV Bonobo stuff server
 *
 * Authors:
 *   Jaka Mocnik  <jaka@gnu.org>
 *
 * Inspired by Martin Baulig's EOG image viewer
 */

#include <config.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include <gnome.h>

#include <bonobo/bonobo-ui-main.h> 

#include <bonobo/bonobo-generic-factory.h>

#include <ggv-control.h>
#if 0
#include <ggv-embeddable.h>
#endif

static BonoboObject *
ggv_postscript_viewer_factory (BonoboGenericFactory *this, const char *oaf_iid,
			       void *data)
{
	GtkWidget *gs;
	GgvPostscriptView *ps_view;
	GtkAdjustment *hadj, *vadj;
	BonoboObject *retval;

	g_return_val_if_fail (this != NULL, NULL);
	g_return_val_if_fail (oaf_iid != NULL, NULL);

	hadj = GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 1.0, 0.01, 0.1, 0.09));
	vadj = GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 1.0, 0.01, 0.1, 0.09));
	gs = gtk_gs_new(hadj, vadj);

	ps_view = ggv_postscript_view_new(GTK_GS(gs), FALSE);

	if (!strcmp (oaf_iid, "OAFIID:GNOME_GGV_Control"))
		retval = BONOBO_OBJECT (ggv_control_new (ps_view));
#if 0
	else if (!strcmp (oaf_iid, "OAFIID:GNOME_GGV_Embeddable"))
		retval = BONOBO_OBJECT (ggv_embeddable_new (ps_view));
#endif
	else if(!strcmp(oaf_iid, "OAFIID:GNOME_GGV_PostscriptView")) {
		retval = BONOBO_OBJECT(ps_view);
		bonobo_object_ref (BONOBO_OBJECT (ps_view));
	}
	else {
		g_warning ("Unknown IID `%s' requested", oaf_iid);
		return NULL;
	}

	bonobo_object_unref (BONOBO_OBJECT (ps_view));

	return retval;
}

BONOBO_ACTIVATION_FACTORY("OAFIID:GNOME_GGV_Factory", "ggv-postscript-viewer", 
			  VERSION, ggv_postscript_viewer_factory, NULL);
