/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

#ifndef __GGV_WINDOW_H__
#define __GGV_WINDOW_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include "crop.h"

#ifdef __cplusplus
extern "C" {
#if 0    /* fool emacs */
}
#endif
#endif /* __cplusplus */

/*  size of the array used to specify data */
#define MENU_DATA_SIZE 40
/* Number of zoom options */
#define MENU_ZOOM_SIZE 9
/* orinetation menu size */
#define MENU_ORIENTATION_SIZE 4
/* number of units */
#define MENU_UNITS_SIZE 4

/* toggle page enums */
enum {
        TOGGLE_CURRENT_PAGE = -1,
        TOGGLE_EVEN_PAGES = -2,
        TOGGLE_ODD_PAGES = -3,
        TOGGLE_ALL_PAGES = -4,
        UNMARK_ALL_PAGES = -5,
};

/* DND enums */
enum {
        TARGET_URI_LIST,
};

/* typedefs */
typedef struct _window_with_data window_with_data;
typedef struct _ggv_window ggv_window;
typedef struct _ggv_prefs ggv_prefs;

/* global variables */
extern GdkCursor *pan_cursor;
extern GList     *window_list;
extern int       active_ggv;
extern ggv_prefs prefs_dialog;
extern GList     *recent_files_list;
extern gint      ZoomMenuMagnificationSteps[];

/* prototypes */
gboolean load_gs(ggv_window *ggv, char *fname);

ggv_window *create_ggv_window(void);

void create_sidebar(ggv_window *retval);
void create_menus(ggv_window *retval, window_with_data *temp);
void create_toolbar(ggv_window *retval);
void create_popup_menus(ggv_window *ggv);

ggv_window *open_window(gchar *filename, gint x, gint y, gint w, gint h);
void close_window(ggv_window *ggv);

void open_prefs_dialog(ggv_prefs *pd);

void ggv_prefs_apply(GList *windows);

void refresh_coordinates(ggv_window *ggv);

void goto_page(ggv_window *ggv, int page);

void flash_message(ggv_window *ggv, gchar *flash);
void error_message(ggv_window *ggv, gchar *errormsg);

void save_marked_pages(ggv_window *ggv, gchar *file);

/* sync UI with current ggv_window and its GtkGS widget state */
void synchronize_user_interface(ggv_window *ggv);
void synchronize_paper_items(ggv_window *ggv);
void synchronize_orientation_items(ggv_window *ggv);
/* sync UI with ggv_window and its GtkGS widget defaults (_wd stands for
   _with_defaults) */
void synchronize_user_interface_wd(ggv_window *ggv);
void synchronize_paper_items_wd(ggv_window *ggv);
void synchronize_orientation_items_wd(ggv_window *ggv);

/* set visibility of components */
void ggv_menus_set_visible(ggv_window *ggv, gboolean v);
void ggv_toolbar_set_visible(ggv_window *ggv, gboolean v);
void ggv_toolbar_set_labels(ggv_window *ggv, gboolean labels);
void ggv_panel_set_visible(ggv_window *ggv, gboolean v);

void set_page_sensitivities(ggv_window *ggv, int page);
gboolean set_corresponding_zoom_menu_option(ggv_window *ggv, gint spec);

void display_current_doc_info(ggv_window *ggv);

/* a pair of (ggv_window, user_data). */
struct _window_with_data {
        ggv_window *ggv;
        gpointer data;
};

/* what's in each of GGV's windows. */
struct _ggv_window {
	GtkWidget *main_window;         /* main window */
	GtkWidget *status, *gs_text;    /* status window */
	GtkWidget *pagelistscroll;
        GtkWidget *pagelist;
        GtkWidget *coordinates;
        GtkWidget *scrollpane;
        GtkWidget *popup_menu;
        GtkWidget *sidebar;
        GtkWidget *file_sel;
        GtkWidget *save_file_sel;
        GtkWidget *appbar;
        GtkObject *hadj, *vadj;
        GtkWidget *gs;
        gboolean show_menus, show_panel, show_toolbar;
        gboolean loaded;
        gboolean pan;
        gboolean pane_auto_jump;	/* ...to top of new page */

        gdouble prev_x, prev_y;
        gchar *startup_file;
        crop_data *cd;
        window_with_data *menudata;

        gfloat xcoord, ycoord;

        /* store some pointers to widgets from GnomeUIInfo trees here
           as we need them for setting sensitivity and stuff like that */
        GtkWidget *firstitem, *firstpu;  /* first-page menu item and popup menu item */
        GtkWidget *lastitem, *lastpu;  /* last-page menu item and popup menu item */
        GtkWidget *nextbutton, *nextitem, *nextpu;  /* next button, menu item and popup menu item */
        GtkWidget *prevbutton, *previtem, *prevpu;  /* prev ... */
        GtkWidget *printitem, *printmarkeditem, *reloaditem;          /* menu items... */
	GtkWidget *printbutton, *reloadbutton, *savebutton;      /* toolbar buttons */
        GtkWidget *saveitem;
        GtkWidget *recenteritem, *recenterpu;
        GtkWidget *zoominbutton, *zoominpu;                    /* zoom buttons */
        GtkWidget *zoomoutbutton, *zoomoutpu;
        GtkWidget *panel_vis, *menus_vis, *toolbar_vis;  /* menu/side panel/toolbar visibility check items in menus */
        GtkWidget *watchdoc_menu;
        GtkWidget *antialiased_menu;
        GtkWidget *override_media_menu;
        GtkWidget *override_orientation_menu;
        GtkWidget *zoom_to_fit_menu, *zoom_to_fit_width_menu;
        GtkWidget *zoom_menu[MENU_ZOOM_SIZE];
        GtkWidget **paper_menu;
        GtkWidget *orientation_menu[MENU_ORIENTATION_SIZE];

        GtkWidget *panel_vis_pu, *menus_vis_pu, *toolbar_vis_pu; /* and in popup menu */
 	GtkWidget *toggleakt, *toggleall,          		 /* (un)mark pages */
                  *toggleeven, *toggleodd, *clearall,
                  *toggleakt_pu, *toggleall_pu,
 	          *toggleeven_pu, *toggleodd_pu, *clearall_pu,
		  *toggleallbutton, *clearallbutton,
		  *toggleevenbutton, *toggleoddbutton;
        guint num_recent; /* Recent menu has been instantiated? so we can
                             remove it before we add new entries */
};

/* what's in our prefs dialog. */
struct _ggv_prefs
{
        GnomePropertyBox *pbox;
        GtkWidget *gs, *scan_pdf, *unzip, *unbzip2, *print;   /* entries */
        GtkWidget *media, *zoom, *orientation, *units;        /* option menus */
        GtkWidget *watch, *aa, *override_media, *respect_eof, *show_scroll_rect; /* checkbuttons */
        GtkWidget *override_orientation;
        GtkWidget *sidebar, *mbar, *toolbar, *tblabels, *savegeo,*auto_jump;/* checkbuttons */
        GtkWidget **media_choice;                             /* paper items */
        GtkWidget *zoom_choice[MENU_ZOOM_SIZE];               /* zoom items */
        GtkWidget *orientation_choice[MENU_ORIENTATION_SIZE]; /* orientation items */
        GtkWidget *unit_choice[MENU_UNITS_SIZE];              /* unit items */
};


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
