/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/* Author: Jaka Mocnik  <jaka.mocnik@kiss.uni-lj.si>
 */

#ifndef __PREFS_H__
#define __PREFS_H__

#include <gtk/gtkwidget.h>

#include "gtkgs.h"
#include "ggvwindow.h"

extern gchar *ggv_print_cmd;         /* print command: printf format, char* argument */

extern gboolean ggv_panel;           /* panel visible */
extern gboolean ggv_toolbar;         /* toolbar visible */
extern gboolean ggv_menubar;         /* menubar visible */
extern gboolean ggv_auto_jump;       /* to top of page when moving with keyboard */

extern gboolean ggv_save_geometry;     /* Save the current geometry for next session */

/* main window and file selection dialog dimensions. */
extern gint ggv_default_width, file_sel_width;
extern gint ggv_default_height, file_sel_height;

/* which unit do we want to use */
extern gint ggv_unit_index;

void ggv_prefs_load (void);
void ggv_prefs_save (void);
GConfClient *ggv_prefs_gconf_client (void);

#define MAX_RECENT 6

#define DEFAULT_WINDOW_WIDTH  640
#define DEFAULT_WINDOW_HEIGHT 480

#define DEFAULT_FILE_SEL_WIDTH   320
#define DEFAULT_FILE_SEL_HEIGHT  256

#endif
