/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/* Authors: Jaka Mocnik  <jaka.mocnik@kiss.uni-lj.si>
 */

#ifndef __PREFS_H__
#define __PREFS_H__

#include <gtk/gtkwidget.h>

#include "gtkgs.h"
#include "ggvwindow.h"

/* command lines of the external programmes: */
extern gchar *gs_print_cmd;     /* print command: printf format, char* argument */

extern gboolean gs_panel;       /* panel visible */
extern gboolean gs_toolbar;     /* toolbar visible */
extern gboolean gs_menubar;     /* menubar visible */
extern gboolean gs_auto_jump;   /* to top of page */
extern gint gs_default_magnification; /* Default magnification for ggv */

extern gboolean gs_save_geometry; /* Save the current geometry for next session */
extern gint ggv_default_width, file_sel_width;
extern gint ggv_default_height, file_sel_height;

extern gint ggv_unit_index;
extern gfloat ggv_unit_factors[];

void load_prefs (gchar *);
void save_prefs (gchar *);
void set_prefs  (ggv_window *);
gint get_index_from_string(gchar *string, gchar **strings);

#define MAX_RECENT 6

#define DEFAULT_WINDOW_WIDTH  640
#define DEFAULT_WINDOW_HEIGHT 480

#define DEFAULT_FILE_SEL_WIDTH   320
#define DEFAULT_FILE_SEL_HEIGHT  256

#endif
