/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/* Authors: Jaka Mocnik  <jaka@gnu.org>
 */

#include <config.h>
#include <gnome.h>

#include "ps.h"
#include "prefs.h"
#include "gtkgs.h"
#include "ggvwindow.h"
#include "callbacks.h"

gchar *gs_print_cmd = NULL;

gboolean gs_save_geometry;
gint ggv_default_width, file_sel_width;
gint ggv_default_height, file_sel_height;

gboolean gs_panel, gs_menubar, gs_toolbar;
gboolean gs_auto_jump;
gint gs_default_magnification; /* Default magnification for ggv */

gint ggv_unit_index;

gfloat ggv_unit_factors[] = {
        1.0,
        25.4,
        2.54,
        72.0
};

char *ggv_orientation_labels[] = {
        N_("Portrait"),
        N_("Landscape"),
        N_("Upside Down"),
        N_("Seascape"),
        NULL,
};

char *ggv_unit_labels[] = {
        N_("inch"),
        N_("mm"),
        N_("cm"),
        N_("point"),
        NULL
};

static gint
get_index_for_string(gchar *string, gchar **strings)
{
        guint idx = 0;

        while(strings[idx] != NULL) {
                if(strcmp(strings[idx], string) == 0)
                        return idx;
                idx++;
        }

        return -1;
}



void
load_prefs(gchar *prefix)
{
        gchar *s;
        gint i;

        gnome_config_push_prefix(prefix);
        if((s = gnome_config_get_string("GhostScript/Interpreter=" GS_PATH))) {
                gtk_gs_defaults_set_interpreter_cmd(s);
        }
        if((s = gnome_config_get_string("GhostScript/ScanPDF=" GS_PATH " -dNODISPLAY -dQUIET -sPDFname=\"%s\" -sDSCname=\"%s\" pdf2dsc.ps -c quit"))) {
                gtk_gs_defaults_set_scan_pdf_cmd(s);
        }
        if((s = gnome_config_get_string("GhostScript/Ungzip=gzip -cd"))) {
                gtk_gs_defaults_set_ungzip_cmd(s);
        }
        if((s = gnome_config_get_string("GhostScript/Unbzip2=bzip2 -cd"))) {
                gtk_gs_defaults_set_unbzip2_cmd(s);
        }
        if((s = gnome_config_get_string("Printing/Command=" LPR_PATH " %s"))) {
                if(gs_print_cmd != NULL)
                        g_free(gs_print_cmd);
                gs_print_cmd = s;
        }
        /* Read gtkgs widget defaults */

        gs_default_magnification = gnome_config_get_int("Document/Magnification");
        gtk_gs_defaults_set_zoom_factor(compute_zoom(gs_default_magnification));

        gtk_gs_defaults_set_override_media(gnome_config_get_bool("Document/OverrideDocumentMedia=false"));
        gtk_gs_defaults_set_antialiased(gnome_config_get_bool("Document/Antialiasing=false"));
        gtk_gs_defaults_set_watch_doc(gnome_config_get_bool("Document/Watch=false"));
        gtk_gs_defaults_set_respect_eof(gnome_config_get_bool("Document/RespectEOF=false"));
        gtk_gs_defaults_set_override_orientation(gnome_config_get_bool("Document/OverrideOrientation=false"));
        gtk_gs_defaults_set_override_orientation(gnome_config_get_bool("Document/OverrideOrientation=false"));
        
        if((s = gnome_config_get_string("Document/Orientation=Portrait"))) {
                i = get_index_for_string(s, ggv_orientation_labels);
                g_free(s);
                if (i == -1) 
                        i = get_index_for_string("Portrait", ggv_orientation_labels);
                gtk_gs_defaults_set_orientation(i);

        }

        if((s = gnome_config_get_string("Document/Media=A4"))) {
                i = gtk_gs_get_media_index(s, gtk_gs_defaults_get_paper_sizes());
                g_free(s);
                if(i == -1)
                        i = 0;
                gtk_gs_defaults_set_media(i);
        }

        if((s = gnome_config_get_string("Coordinates/Units=mm"))) {
                ggv_unit_index = get_index_for_string(s, ggv_unit_labels);
                g_free(s);
                if(ggv_unit_index == -1)
                        ggv_unit_index = 0;
        }

        /* read ggv widget defaults */
        gs_panel = gnome_config_get_bool("Layout/ShowPanel=true");
	gs_toolbar = gnome_config_get_bool("Layout/ShowToolbar=true");
        gs_menubar = gnome_config_get_bool("Layout/ShowMenubar=true");
        gs_auto_jump = gnome_config_get_bool("Layout/AutoJump=true");

        /* Get geometry */
        gs_save_geometry = gnome_config_get_bool("Layout/SaveGeometry=false");
        if((ggv_default_width = gnome_config_get_int("Layout/SaveGeometryX")) == 0)
                ggv_default_width = DEFAULT_WINDOW_WIDTH;
        if((ggv_default_height = gnome_config_get_int("Layout/SaveGeometryY")) == 0)
                ggv_default_height = DEFAULT_WINDOW_HEIGHT;
        if((file_sel_width = gnome_config_get_int("Layout/FileSelWidth")) == 0)
                file_sel_width = DEFAULT_FILE_SEL_WIDTH;
        if((file_sel_height = gnome_config_get_int("Layout/FileSelHeight")) == 0)
                file_sel_height = DEFAULT_FILE_SEL_WIDTH;

        gnome_config_pop_prefix();
}

void
save_prefs(gchar *prefix)
{
        GtkGSPaperSize *papersizes = gtk_gs_defaults_get_paper_sizes();

        gnome_config_push_prefix(prefix);

        gnome_config_set_string("GhostScript/Interpreter", gtk_gs_defaults_get_interpreter_cmd());
        gnome_config_set_string("GhostScript/ScanPDF", gtk_gs_defaults_get_scan_pdf_cmd());
        gnome_config_set_string("GhostScript/Ungzip", gtk_gs_defaults_get_ungzip_cmd());
        gnome_config_set_string("GhostScript/Unbzip2", gtk_gs_defaults_get_unbzip2_cmd());

        gnome_config_set_string("Printing/Command", gs_print_cmd);

        gnome_config_set_int("Document/Magnification",
                             gs_default_magnification);
        gnome_config_set_string("Document/Media",
                                papersizes[gtk_gs_defaults_get_media()].name);
        gnome_config_set_bool("Document/OverrideDocumentMedia",
                              gtk_gs_defaults_get_override_media());
        gnome_config_set_bool("Document/Antialiasing",
                              gtk_gs_defaults_get_antialiased());
        gnome_config_set_bool("Document/OverrideOrientation", 
                              gtk_gs_defaults_get_override_orientation());
        gnome_config_set_string("Document/Orientation", 
                                ggv_orientation_labels[gtk_gs_defaults_get_orientation()]);
        gnome_config_set_bool("Document/Watch", gtk_gs_defaults_get_watch_doc());
        gnome_config_set_bool("Document/RespectEOF", gtk_gs_defaults_get_respect_eof());

        gnome_config_set_string("Coordinates/Units",
                                ggv_unit_labels[ggv_unit_index]);

        gnome_config_set_bool("Layout/ShowPanel", gs_panel);
	gnome_config_set_bool("Layout/ShowToolbar", gs_toolbar);
        gnome_config_set_bool("Layout/ShowMenubar", gs_menubar);
        gnome_config_set_bool("Layout/AutoJump", gs_auto_jump);
        gnome_config_set_bool("Layout/SaveGeometry", gs_save_geometry);
        if(gs_save_geometry) {
                gnome_config_set_int("Layout/SaveGeometryX", ggv_default_width);
                gnome_config_set_int("Layout/SaveGeometryY", ggv_default_height);
                gnome_config_set_int("Layout/FileSelWidth", file_sel_width);
                gnome_config_set_int("Layout/FileSelHeight", file_sel_height);
        }

        gnome_config_pop_prefix();

	gnome_config_sync();
}

void
set_prefs(ggv_window *ggv)
{
        GtkGS *gs = GTK_GS(ggv->gs);
        
        gs->override_media = gtk_gs_defaults_get_override_media();
        gs->default_media = gtk_gs_defaults_get_media();
        gs->antialiased = gtk_gs_defaults_get_antialiased();
        gs->watch_doc = gtk_gs_defaults_get_watch_doc();
        gs->fallback_orientation = gtk_gs_defaults_get_orientation();
        gs->respect_eof = gtk_gs_defaults_get_respect_eof();
        gtk_gs_set_override_orientation (gs, gtk_gs_defaults_get_override_orientation());
        ggv->pane_auto_jump = gs_auto_jump;
}

