/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * ggv-postscript-view.h.
 *
 * Authors:  Jaka Mocnik  <jaka@gnu.org>
 *
 * Copyright (c) 2001 Free Software Foundation
 */

#ifndef _GGV_POSTSCRIPT_VIEW_H_
#define _GGV_POSTSCRIPT_VIEW_H_

#include <gtkgs.h>

#include <gnome.h>

#include <bonobo.h>

#include <Ggv.h>

BEGIN_GNOME_DECLS
 
#define GGV_POSTSCRIPT_VIEW_TYPE          (ggv_postscript_view_get_type ())
#define GGV_POSTSCRIPT_VIEW(o)            (GTK_CHECK_CAST ((o), GGV_POSTSCRIPT_VIEW_TYPE, GgvPostscriptView))
#define GGV_POSTSCRIPT_VIEW_CLASS(k)      (GTK_CHECK_CLASS_CAST((k), GGV_POSTSCRIPT_VIEW_TYPE, GgvPostscriptViewClass))

#define GGV_IS_POSTSCRIPT_VIEW(o)         (GTK_CHECK_TYPE ((o), GGV_POSTSCRIPT_VIEW_TYPE))
#define GGV_IS_POSTSCRIPT_VIEW_CLASS(k)   (GTK_CHECK_CLASS_TYPE ((k), GGV_POSTSCRIPT_VIEW_TYPE))

typedef struct _GgvPostscriptView             GgvPostscriptView;
typedef struct _GgvPostscriptViewClass        GgvPostscriptViewClass;
typedef struct _GgvPostscriptViewPrivate      GgvPostscriptViewPrivate;
typedef struct _GgvPostscriptViewClassPrivate GgvPostscriptViewClassPrivate;

struct _GgvPostscriptView {
	BonoboXObject base;

	GgvPostscriptViewPrivate *priv;
};

struct _GgvPostscriptViewClass {
	BonoboXObjectClass parent_class;

	POA_GNOME_GGV_PostscriptView__epv epv;

	GgvPostscriptViewClassPrivate *priv;
};

GtkType               ggv_postscript_view_get_type              (void);
GgvPostscriptView     *ggv_postscript_view_new                  (GtkGS *gs,
								 gboolean zoom_fit);
GgvPostscriptView     *ggv_postscript_view_construct            (GgvPostscriptView *ps_view,
								 GtkGS *gs,
								 gboolean zoom_fit);
BonoboPropertyBag     *ggv_postscript_view_get_property_bag     (GgvPostscriptView *image_view);
BonoboPropertyControl *ggv_postscript_view_get_property_control (GgvPostscriptView *image_view);
void                  ggv_postscript_view_set_ui_container      (GgvPostscriptView *image_view,
								 Bonobo_UIContainer ui_container);
void                  ggv_postscript_view_unset_ui_container    (GgvPostscriptView *image_view);
GtkWidget             *ggv_postscript_view_get_widget           (GgvPostscriptView *image_view);
void	              ggv_postscript_view_print                 (GgvPostscriptView *image_view,
								 gboolean preview);


/* Zooming */
float ggv_postscript_view_get_zoom_factor (GgvPostscriptView *image_view);
void  ggv_postscript_view_set_zoom_factor (GgvPostscriptView *image_view,
					   float zoom_factor);
void  ggv_postscript_view_zoom_to_fit     (GgvPostscriptView *image_view,
					   gboolean keep_aspect_ratio);
void  ggv_postscript_view_set_zoom        (GgvPostscriptView *image_view,
					   double zoomx,
					   double zoomy);

BonoboObject *ggv_postscript_view_add_interfaces (GgvPostscriptView *ps_view,
						  BonoboObject *to_aggregate);

/* Properties */
void
ggv_postscript_view_set_orientation (GgvPostscriptView *image_view,
				     GNOME_GGV_Orientation interpolation);
GNOME_GGV_Orientation
ggv_postscript_view_get_orientation (GgvPostscriptView *image_view);
void
ggv_postscript_view_set_media        (GgvPostscriptView *image_view,
				      GNOME_GGV_Media media);
GNOME_GGV_Media
ggv_postscript_view_get_media        (GgvPostscriptView *image_view);

END_GNOME_DECLS

#endif _GGV_POSTSCRIPT_VIEW_H_
