/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/* Authors: Jaka Mocnik  <jaka.mocnik@kiss.uni-lj.si>
 */

#include <config.h>
#include <gnome.h>

#include "ps.h"
#include "prefs.h"
#include "ggvwindow.h"

gchar *gs_cmd = NULL;
gchar *gs_scan_pdf_cmd = NULL;
gchar *gs_ungzip_cmd = NULL;
gchar *gs_unbzip2_cmd = NULL;
gchar *gs_print_cmd = NULL;

gint gs_def_media;
gboolean gs_override_media;

gboolean gs_antialiased;
gboolean gs_watch_doc;

gboolean gs_panel, gs_menubar;
gboolean gs_auto_jump;


static gint
get_media_index (gchar *string, struct documentmedia *media)
{
        guint idx = 0;

        while(media[idx].name != NULL) {
                if(strcmp(media[idx].name, string) == 0)
                        return idx;
                idx++;
        }

        return -1;
}

void
load_prefs (gchar *prefix)
{
        gchar *s;
        gint i;

        gnome_config_push_prefix(prefix);
        if((s = gnome_config_get_string("GhostScript/Interpreter=" GS_PATH))) {
                g_free(gs_cmd);
                gs_cmd = s;
        }
        if((s = gnome_config_get_string("GhostScript/ScanPDF=" GS_PATH " -dNODISPLAY -dQUIET -sPDFname=\"%s\" -sDSCname=\"%s\" pdf2dsc.ps -c quit"))) {
                g_free(gs_scan_pdf_cmd);
                gs_scan_pdf_cmd = s;
        }
        if((s = gnome_config_get_string("GhostScript/Ungzip=gzip -cd"))) {
                g_free(gs_ungzip_cmd);
                gs_ungzip_cmd = s;
        }
        if((s = gnome_config_get_string("GhostScript/Unbzip2=bzip2 -cd"))) {
                g_free(gs_unbzip2_cmd);
                gs_unbzip2_cmd = s;
        }
        if((s = gnome_config_get_string("Printing/Command=" LPR_PATH " %s"))) {
                g_free(gs_print_cmd);
                gs_print_cmd = s;
        }
        if((s = gnome_config_get_string("Document/Media=A4"))) {
                i = get_media_index(s, papersizes);
                g_free(s);
                if (i == -1)
                        i = get_media_index("A4", papersizes);

                /*
                g_print("default media = %d\n", i);
                */
                gs_def_media = i;
        }
        gs_override_media = gnome_config_get_bool("Document/OverrideDocumentMedia=false");
        gs_antialiased = gnome_config_get_bool("Document/Antialiasing=false");
        gs_watch_doc = gnome_config_get_bool("Document/Watch=false");
        gs_panel = gnome_config_get_bool("Layout/ShowToolbar=true");
        gs_menubar = gnome_config_get_bool("Layout/ShowMenubar=true");
        gs_auto_jump = gnome_config_get_bool("Layout/AutoJump=true");
        gnome_config_pop_prefix();
}

void
save_prefs (gchar *prefix)
{
        gnome_config_push_prefix(prefix);
        gnome_config_set_string("GhostScript/Interpreter", gs_cmd);
        gnome_config_set_string("GhostScript/ScanPDF", gs_scan_pdf_cmd);
        gnome_config_set_string("GhostScript/Ungzip", gs_ungzip_cmd);
        gnome_config_set_string("GhostScript/Unbzip2", gs_unbzip2_cmd);
        gnome_config_set_string("Printing/Command", gs_print_cmd);
        gnome_config_set_string("Document/Media", papersizes[gs_def_media].name);
        gnome_config_set_bool("Document/OverrideDocumentMedia", gs_override_media);
        gnome_config_set_bool("Document/Antialiasing", gs_antialiased);
        gnome_config_set_bool("Document/Watch", gs_watch_doc);
        gnome_config_set_bool("Layout/ShowToolbar", gs_panel);
        gnome_config_set_bool("Layout/ShowMenubar", gs_menubar);
        gnome_config_set_bool("Layout/AutoJump", gs_auto_jump);
        gnome_config_pop_prefix();

	gnome_config_sync();
}

void
set_prefs (ggv_window *ggv)
{
        GTK_GS(ggv->gs)->override_media = gs_override_media;
        GTK_GS(ggv->gs)->default_page_media = gs_def_media;
        GTK_GS(ggv->gs)->antialiased = gs_antialiased;
        GTK_GS(ggv->gs)->watch_doc = gs_watch_doc;
        ggv->pane_auto_jump =  gs_auto_jump;
}
