/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

#include <config.h>
#include <gnome.h>
#include <gdk/gdkkeysyms.h>
#include <sys/stat.h>

#include "gtkscrollpane.h"
#include "gtkgs.h"
#include "prefs.h"
#include "ggvwindow.h"
#include "callbacks.h"

void recent_callback(GtkWidget *w, gpointer *data)
{
        char *error_msg;
        window_with_data *wwd = (window_with_data *) data;
        struct stat stat_rec;

        if (stat((char*)wwd->data, &stat_rec) == 0) {
                if (S_ISREG(stat_rec.st_mode)) {
                        wwd->ggv->loaded = load_gs(wwd->ggv, (char*)wwd->data);
                        return;
                }
                error_msg = g_strdup_printf(_("%s is not a regular file."), (char*)wwd->data);

        }
        else {
                error_msg = g_strdup_printf(_("%s does not exist."), (char*)wwd->data);
        }

        error_message(wwd->ggv,error_msg);
}

void unmark_all_pages_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;
        g_return_if_fail (ggv!=NULL);

        toggle_pages(ggv, UNMARK_ALL_PAGES, GTK_GS(ggv->gs)->current_page);
}

void toggle_current_page_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;
        g_return_if_fail (ggv!=NULL);

        toggle_pages(ggv, TOGGLE_CURRENT_PAGE, GTK_GS(ggv->gs)->current_page);
}

void toggle_even_pages_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;
        g_return_if_fail (ggv!=NULL);

        toggle_pages(ggv, TOGGLE_EVEN_PAGES, 0);
}

void toggle_odd_pages_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;
        g_return_if_fail (ggv!=NULL);

        toggle_pages(ggv, TOGGLE_ODD_PAGES, 0);
}

void toggle_all_pages_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;
        g_return_if_fail (ggv!=NULL);

        toggle_pages(ggv, TOGGLE_ALL_PAGES, 0);
}

void about_callback(GtkWidget *widget, gpointer data) 
{
	GtkWidget *about = NULL;

	gchar *authors[] = {
                "GGV was originally based on gv 3.5.8,",
                "written by Johannes Plass <plass@thep.physik.uni-mainz.de>,",
                "which in turn was based on GhostView 1.5,",
                "written by Tim Theisen <tim@cs.wisc.edu>.",
		"Szekeres Istvan <szekeres@cyberspace.mht.bme.hu> and",
                "Jonathan Blandford <jrb@redhat.com>",
                "started the GNOME port with further contributions by",
                "(in alphabetical order)",
                "Daniel M. German <dmg@csg.uwaterloo.ca> (current maintainer),",
                "Tuomas J. Lukka <lukka@iki.fi>",
                "Jaka Mocnik <jaka.mocnik@kiss.uni-lj.si>",
                "and the whole GNOME developers team.",
                "",
                "GGV would be a carcass without Ghostscript, written by Peter Deutsch.",
		NULL
	};

        gtk_widget_push_visual (gdk_imlib_get_visual ());
        gtk_widget_push_colormap (gdk_imlib_get_colormap ());
        
	about = gnome_about_new(_("GNOME Ghostview"), VERSION,
				"Copyright (C) 1998, 1999 the Free Software Foundation",
				(const gchar **) authors,
				_("PostScript(TM) document viewer.\n"
                                  "Based on Tim Theisen's excellent Ghostview application."),
				"ggv-splash.png");
        gtk_widget_show(about);
        gtk_widget_pop_colormap ();
        gtk_widget_pop_visual ();
}

void new_callback(GtkWidget *widget, gpointer data)
{
        open_window(NULL);
}

void button_press_callback(GtkWidget *widget, GdkEventButton *event,
				  gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;
        gint button = event->button;
        gint x = 0;
        gint y = 0;

        if (event->window == GTK_GS (ggv->gs)->pstarget) {
                gdk_window_get_position (event->window, &x, &y);
        }
        x += event->x;
        y += event->y;
        switch(button) {
        case 1:
                if(!ggv->pan) {
                        gint wx = 0, wy = 0;

                        gdk_window_get_pointer(widget->window, &wx, &wy, NULL);

                        ggv->pan = TRUE;
                        if(pan_cursor == NULL)
                                pan_cursor = gdk_cursor_new(GDK_FLEUR);

                        gtk_grab_add(widget);
                        gdk_pointer_grab(widget->window, FALSE,
                                         GDK_POINTER_MOTION_MASK |
                                         GDK_BUTTON_RELEASE_MASK, NULL,
                                         pan_cursor, GDK_CURRENT_TIME);
                        ggv->prev_x = wx;
                        ggv->prev_y = wy;
                }
                break;
        case 2:
                /* uncomment this to mark a section to crop.
                 * it has been removed until it clears correctly */        
#if 0     
                clear_crop (ggv->cd, ggv->gs->window);
                crop_button_clicked (ggv->cd, x, y);
                draw_crop (ggv->cd, ggv->gs->window);
#endif
              
                break;
        case 3:
                gnome_popup_menu_do_popup(ggv->popup_menu, NULL, NULL, event, ggv);
                if(ggv->menus_vis_pu)
                        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(ggv->menus_vis_pu),
                                                       ggv->show_menus);
                if(ggv->panel_vis_pu)
                        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(ggv->panel_vis_pu),
                                                       ggv->show_panel);
                break;
        default:
                break;
        }
        gtk_clist_select_row (GTK_CLIST (ggv->pagelist),  GTK_GS(ggv->gs)->current_page,1);

}

void button_release_callback(GtkWidget *widget, GdkEventButton *event,
				    gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;

        switch(event->button) {
        case 1:
                if(ggv->pan) {
                        ggv->pan = FALSE;
                        gdk_pointer_ungrab(GDK_CURRENT_TIME);
                        gtk_grab_remove(widget);
                }
                break;
        case 2:
                ggv->cd->incrop = 0;
                break;
        default:
                break;
        }
}

void close_callback (GtkWidget *widget, ggv_window *ggv)
{
        close_window(ggv);
}

gint exit_callback(GtkWidget *widget, gpointer data) 
{

        ggv_window *ggv;
        GList *node;

        /* do we want to save anything before we exit??? */        
        while (window_list) {
                node = window_list;
                window_list = window_list->next;
                if(window_list)
                        window_list->prev = NULL;
                node->next = NULL;
                ggv = (ggv_window *)node->data;
                g_list_free(node);
                gtk_widget_destroy (GTK_WIDGET (ggv->main_window));
                g_free(ggv);
        }

	gtk_main_quit();

	return 0;
}

gint delete_callback(GtkWidget *widget, GdkEventAny *event,
			    gpointer data)
{
        close_window((ggv_window *)data);

        return 0;
}

void file_open_cancel_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;

        gtk_widget_destroy(ggv->file_sel);
        ggv->file_sel = NULL;
}

void file_open_delete_callback(GtkWidget *widget, GdkEventAny *e,
				      gpointer data)
{
        file_open_cancel_callback(widget, data);
}

void file_open_ok_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;
        gchar *file;
        gchar *base_filename;
        char *error_msg;
        struct stat stat_rec;

	file = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(ggv->file_sel)));

        /* We have to verify that this file exists */
        if (stat(file,&stat_rec) == 0) {
                if (S_ISDIR(stat_rec.st_mode)) {
                        /* This is a directory, reset window and
                           try again */
                        if (strlen(file) > 0 && file[strlen(file)-1] != '/')
                                strcat(file,"/");
                        gtk_file_selection_set_filename(GTK_FILE_SELECTION(ggv->file_sel),
                                                        file);
                        return;
                }
        }
        else {
                /* We have to check if there is a wildcard in the directory name
                 */
                base_filename = g_basename(file);
                if (strchr(base_filename, '?' ) != NULL ||
                    strchr(base_filename, '*' ) != NULL) {
                        gtk_file_selection_complete(GTK_FILE_SELECTION(ggv->file_sel),
                                                    file);
                }
                           
                /* FIXME:  currently , if the file does not exist,
                   the window does not close, but it does not send a message.
                   If we send a message, the focus does not return to the
                   File window after the user clicks on it

                  error_msg = g_strdup_printf(_("File does not exist %s."), file);
                  error_message(ggv,error_msg);
                */
                return;
        }
        gtk_widget_destroy(ggv->file_sel);
        ggv->file_sel = NULL;

        if ((ggv->loaded = load_gs(ggv, file))) {
                recent_add (file);
                recent_update (ggv);
        }
        g_free(file);
}

void show_menubar_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        ggv->show_menus = GTK_CHECK_MENU_ITEM(widget)->active;

        if (ggv->show_menus) {
                if((GNOME_APP(ggv->main_window))->menubar == NULL) {
                        create_menus(ggv, ggv->menudata);
                        gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(ggv->menus_vis),
                                                        ggv->show_menus);
                        gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(ggv->panel_vis),
                                                        ggv->show_panel);
                }
                gtk_widget_show ((GNOME_APP(ggv->main_window))->menubar->parent);
        } else {
                gtk_widget_hide ((GNOME_APP(ggv->main_window))->menubar->parent);
		gtk_widget_queue_resize (ggv->main_window);
        }
        if(ggv->menus_vis &&
           GTK_CHECK_MENU_ITEM(ggv->menus_vis)->active != ggv->show_menus)
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(ggv->menus_vis),
                                               ggv->show_menus);
}

void hide_panel_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        ggv->show_panel = GTK_CHECK_MENU_ITEM(widget)->active;

        if (ggv->show_panel) {
                if(ggv->scrollpane == NULL)
                        create_sidebar(ggv);
                gtk_widget_show (ggv->sidebar);
        } else {
                gtk_widget_hide (ggv->sidebar);
		gtk_widget_queue_resize (ggv->main_window);
        }
        if(ggv->panel_vis &&
           GTK_CHECK_MENU_ITEM(ggv->panel_vis)->active != ggv->show_panel)
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(ggv->panel_vis),
                                               ggv->show_panel);
}

void motion_callback(GtkWidget *widget, GdkEventMotion *event,
                     gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if(ggv->pan) {
                gtk_gs_scroll(GTK_GS(ggv->gs), -event->x + ggv->prev_x, -event->y + ggv->prev_y);;
                ggv->prev_x = event->x;
                ggv->prev_y = event->y;
        }
        else {
#if 0
                mouse_moved (ggv->cd, ggv->gs->window, 
                             event->x, event->y,
                             ggv->main_window->allocation.width,
                             ggv->main_window->allocation.height);
#endif
        }
}

void interpreter_message_callback(GtkGS *gs, gchar *msg, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;

        gnome_app_error(GNOME_APP(ggv->main_window), msg);
}

void key_pressed_event_callback(GtkWidget *widget, GdkEventKey *event,
                                gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;
        gint key = event->keyval;
        gint orientation = gtk_gs_get_orientation (GTK_GS (ggv->gs));

        if (!ggv->loaded)
                return;
        /*ugh. the possibilities! */
        switch (key) {
        case GDK_space:
                switch (orientation) {
                case GTK_GS_ORIENTATION_PORTRAIT:
                        if (!gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane), 
                                                 GTK_SCROLLPANE_SCROLL_DOWN, TRUE)) {
                                /* Since we are doing wrapping, go to top of the page */
                                gtk_scrollpane_goto_edge(GTK_SCROLLPANE (ggv->scrollpane),
                                                         GTK_SCROLLPANE_GOTOEDGE_LOWER, 
                                                         GTK_SCROLLPANE_GOTOEDGE_LOWER);
                                g_print("Scroll Return false\n");
				goto_page( ggv, GTK_GS(ggv->gs)->current_page + 1);
                        }
                        break;
                case GTK_GS_ORIENTATION_LANDSCAPE:
                        if (!gtk_scrollpane_step (GTK_SCROLLPANE (ggv->scrollpane),
                                                       GTK_SCROLLPANE_SCROLL_LEFT,TRUE)) {
				goto_page( ggv, GTK_GS(ggv->gs)->current_page + 1);
                        }
                        break;
                case GTK_GS_ORIENTATION_SEASCAPE:
                        if (!gtk_scrollpane_step (GTK_SCROLLPANE (ggv->scrollpane),
                                                  GTK_SCROLLPANE_SCROLL_RIGHT,TRUE)) {
				goto_page( ggv, GTK_GS(ggv->gs)->current_page + 1);
                        }
                        break;
                case GTK_GS_ORIENTATION_UPSIDEDOWN:
                        if (!gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),
                                                     GTK_SCROLLPANE_SCROLL_UP,TRUE)) {
				goto_page( ggv, GTK_GS(ggv->gs)->current_page + 1);
                        }
                        break;
                }
                break;
        case GDK_BackSpace:
        case GDK_Delete:
                switch (orientation) {
                case GTK_GS_ORIENTATION_PORTRAIT:
                        if (!gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),
                                                 GTK_SCROLLPANE_SCROLL_UP,TRUE)) {
				goto_page( ggv, GTK_GS(ggv->gs)->current_page - 1);
                        }
                        break;
                case GTK_GS_ORIENTATION_LANDSCAPE:
                        if (!gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),GTK_SCROLLPANE_SCROLL_RIGHT,TRUE)) {
				goto_page( ggv, GTK_GS(ggv->gs)->current_page - 1);
                        }
                        break;
                case GTK_GS_ORIENTATION_SEASCAPE:
                        if (!gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),GTK_SCROLLPANE_SCROLL_LEFT,TRUE)) {
				goto_page( ggv, GTK_GS(ggv->gs)->current_page - 1);
                        }
                        break;
                case GTK_GS_ORIENTATION_UPSIDEDOWN:
                        if (!gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),GTK_SCROLLPANE_SCROLL_DOWN,TRUE)) {
				goto_page( ggv, GTK_GS(ggv->gs)->current_page - 1);
                        }
                        break;
                }
                break;
        case GDK_Left:
                gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),GTK_SCROLLPANE_SCROLL_LEFT,FALSE);
                break;
        case GDK_Right:
                gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),GTK_SCROLLPANE_SCROLL_RIGHT,FALSE);
                break;
        case GDK_Up:
                gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),GTK_SCROLLPANE_SCROLL_UP,FALSE);
                break;
        case GDK_Down:
                gtk_scrollpane_step(GTK_SCROLLPANE (ggv->scrollpane),GTK_SCROLLPANE_SCROLL_DOWN,FALSE);
                break;
        case GDK_Page_Up:
		goto_page( ggv, GTK_GS(ggv->gs)->current_page - 1);
                if (ggv->pane_auto_jump)
                        gtk_scrollpane_goto_edge(GTK_SCROLLPANE(ggv->scrollpane), GTK_SCROLLPANE_GOTOEDGE_LOWER, GTK_SCROLLPANE_GOTOEDGE_LOWER);
                break;
        case GDK_Page_Down:
		goto_page( ggv, GTK_GS(ggv->gs)->current_page + 1);
                if (ggv->pane_auto_jump)
                        gtk_scrollpane_goto_edge(GTK_SCROLLPANE(ggv->scrollpane), GTK_SCROLLPANE_GOTOEDGE_LOWER, GTK_SCROLLPANE_GOTOEDGE_LOWER);
                break;
	case GDK_plus:
		zoomin_callback(ggv->gs, (gpointer *)ggv);
		break;
	case GDK_minus:
		zoomout_callback(ggv->gs, (gpointer *)ggv);
		break;
	default:
		goto DONT_STOP_SIGNAL;
        }
	gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
 DONT_STOP_SIGNAL:
	;
}

void next_page_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;
        if (ggv->loaded)
	        goto_page(ggv, GTK_GS(ggv->gs)->current_page + 1);
}

void previous_page_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded)
		goto_page(ggv, GTK_GS(ggv->gs)->current_page - 1);
}

void open_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;
        gchar *dirname;

        if(ggv->file_sel)
                return;

	ggv->file_sel = gtk_file_selection_new(_("ggv: Open File"));
	gtk_signal_connect(GTK_OBJECT(ggv->file_sel), "delete_event",
			   GTK_SIGNAL_FUNC(file_open_delete_callback), data);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ggv->file_sel)->cancel_button),
			   "clicked",
			   GTK_SIGNAL_FUNC(file_open_cancel_callback), data);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ggv->file_sel)->ok_button),
			   "clicked",
			   GTK_SIGNAL_FUNC(file_open_ok_callback), data);

        gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ggv->file_sel));

        /* Switch to the directory where the current 
           file came from */

        if (GTK_GS (ggv->gs)->gs_filename != NULL &&
            (dirname=g_dirname(GTK_GS (ggv->gs)->gs_filename)) != NULL)
                gtk_file_selection_complete(GTK_FILE_SELECTION(ggv->file_sel),
                                                    dirname);

        gtk_widget_show(ggv->file_sel);
}

void orientation_callback(GtkWidget *widget, gpointer data)
{
        window_with_data *wwd = (window_with_data *) data;
        ggv_window *ggv = wwd->ggv;

        if (!ggv->loaded)
                return;
        if (gtk_gs_set_orientation (GTK_GS(ggv->gs), GPOINTER_TO_INT(wwd->data)))
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page);
}

void preferences_callback(GtkWidget *widget, gpointer data) {
        open_prefs_dialog(&prefs_dialog);
}

void print_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;
        gchar *print_command;

        if(ggv->loaded) {
                print_command = g_strdup_printf(gs_print_cmd,
                                                GTK_GS(ggv->gs)->gs_filename);
                if(print_command) {
                        gnome_execute_shell(NULL, print_command);
                        g_free(print_command);
                }
        }
}

void print_marked_pages_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;
        gchar *tmp_name, *print_command;

        if(ggv->loaded) {
                tmp_name = g_malloc(256);
                tmpnam(tmp_name);

                save_marked_pages(ggv, tmp_name);

                print_command = g_strdup_printf(gs_print_cmd, tmp_name);
                if(print_command) {
                        gnome_execute_shell(NULL, print_command);
                        // FIXME: file tmp_name should be unlinked after
                        // printing...
                        g_free(print_command);
                }

                g_free(tmp_name);
        }
}

void recenter_page_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded)
                gtk_gs_center_page (GTK_GS (ggv->gs));
}

void reload_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded) {
                gchar *fname = g_strdup (GTK_GS (ggv->gs)->gs_filename);
                ggv->loaded = load_gs (ggv, fname);
                g_free (fname);
        }
}

void file_save_cancel_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;

        gtk_widget_destroy(ggv->save_file_sel);
        ggv->save_file_sel = NULL;
}

void file_save_delete_callback(GtkWidget *widget, GdkEventAny *e,
                               gpointer data)
{
        file_save_cancel_callback(widget, data);
}

void file_save_ok_callback(GtkWidget *widget, gpointer data)
{
        gchar *base_filename, *flash;
        char *error_msg;
        struct stat stat_rec;
        ggv_window *ggv = (ggv_window *)data;
        gchar *file;

	file = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(ggv->save_file_sel)));

        if(stat(file,&stat_rec) == 0) {
                if(S_ISDIR(stat_rec.st_mode)) {
                        /* This is a directory, reset window and
                           try again */
                        if (strlen(file) > 0 && file[strlen(file)-1] != '/')
                                strcat(file,"/");
                        gtk_file_selection_set_filename(GTK_FILE_SELECTION(ggv->save_file_sel),
                                                        file);
                        g_free(file);
                        return;
                }
                
        }
        else {
                /* We have to check if there is a wildcard in the directory name
                 */
                base_filename = g_basename(file);
                if (strchr(base_filename, '?' ) != NULL ||
                    strchr(base_filename, '*' ) != NULL) {
                        gtk_file_selection_complete(GTK_FILE_SELECTION(ggv->save_file_sel),
                                                    file);
                        g_free(file);
                        return;
                }
                /* At this point, we know the file does not exist */
        }

        gtk_widget_destroy(ggv->save_file_sel);
        ggv->save_file_sel = NULL;

        save_marked_pages(ggv, file);

        g_free(file);
}

void save_callback(GtkWidget *widget, gpointer data) {
        ggv_window *ggv = (ggv_window *) data;
        char *error_msg;
        gchar *dirname;

        if (ggv->loaded) {
                if(ggv->save_file_sel)
                        return;
                
                ggv->save_file_sel = gtk_file_selection_new(_("ggv: Save marked pages"));
                gtk_signal_connect(GTK_OBJECT(ggv->save_file_sel), "delete_event",
                                   GTK_SIGNAL_FUNC(file_save_delete_callback), data);
                gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ggv->save_file_sel)->cancel_button),
                                   "clicked",
                                   GTK_SIGNAL_FUNC(file_save_cancel_callback), data);
                gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ggv->save_file_sel)->ok_button),
                                   "clicked",
                                   GTK_SIGNAL_FUNC(file_save_ok_callback), data);
                
                gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ggv->save_file_sel));
                
                /* Switch to the directory where the current file came from */
                if (GTK_GS (ggv->gs)->gs_filename != NULL &&
                    (dirname=g_dirname(GTK_GS (ggv->gs)->gs_filename)) != NULL)
                        gtk_file_selection_complete(GTK_FILE_SELECTION(ggv->save_file_sel),
                                                    dirname);

                gtk_widget_show(ggv->save_file_sel);
        }
}

void save_as_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;
        if (ggv->loaded) {
        }
}


void scrollpane_middle_click_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded) {
		goto_page( ggv, GTK_GS(ggv->gs)->current_page - 1);
        }
}

void scrollpane_right_click_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded) {
		goto_page( ggv, GTK_GS(ggv->gs)->current_page + 1);
        }
}

void select_page_button_press_callback(GtkWidget *widget,
				       GdkEventButton *event,
				       gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;
        gint row = 0;
        gint col = 0;

        if (GTK_CLIST(ggv->pagelist)->clist_window == event->window) {
                gtk_clist_get_selection_info (GTK_CLIST(widget), event->x, event->y, &row, &col);
                if (event->button == 3 & row >= 0) {
                        toggle_pages(ggv, TOGGLE_CURRENT_PAGE, row);
                }
        }

}


void select_page_callback(GtkWidget *widget, gint row, gint column,
				 GdkEventButton *event, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;

        g_return_if_fail(widget != NULL);


        /* If event is null then it is not from the user */
        if (event == NULL || event->button == 1) {
                if(GTK_GS(ggv->gs)->current_page != row) {
                        gtk_gs_goto_page(GTK_GS(ggv->gs), row);
                        row = GTK_GS(ggv->gs)->current_page; /* make sure */
                        set_page_sensitivities(ggv, row);
                }
        }
}

void drop_callback(GtkWidget *widget, GdkDragContext *context,
                          gint x, gint y, GtkSelectionData *selection_data,
                          guint info, guint time, gpointer data) {
	GList *names, *list;
        ggv_window *ggv = (ggv_window *)data;

	switch (info) {
	case TARGET_URI_LIST:
		list = names = gnome_uri_list_extract_filenames (selection_data->data);
		while (names) {
                        if(ggv->loaded)
                                open_window(names->data);
                        else if (load_gs (ggv, names->data))
                                ggv->loaded = TRUE;

			names = names->next;
		}
		gnome_uri_list_free_strings (list);
		break;
	default:
                break;
	}
}

void zoom_callback(GtkWidget *widget, gpointer data)
{
        window_with_data *wwd = (window_with_data *) data;
        ggv_window *ggv = wwd->ggv;

        if (ggv->zoom_magstep == GPOINTER_TO_INT(wwd->data)) 
                return;
	zoom_to(ggv, GPOINTER_TO_INT(wwd->data));
}

void zoomin_callback(GtkWidget *widget, gpointer *data)
{
        ggv_window *ggv = (ggv_window *)data;
	zoom_to(ggv, ggv->zoom_magstep+1);
}

void zoomout_callback(GtkWidget *widget, gpointer *data)
{
        ggv_window *ggv = (ggv_window *)data;
	zoom_to(ggv, ggv->zoom_magstep-1);
}

void prefs_destroy_callback(GtkWidget *w, ggv_prefs *p)
{
        p->pbox = NULL;
}

void prefs_apply_callback(GtkWidget *w, gint page, ggv_prefs *p)
{
        GtkWidget *active;
        gint i;

        if( page != -1 ) return;

        if(gs_cmd)
                g_free(gs_cmd);
        gs_cmd = g_strdup(gtk_entry_get_text(GTK_ENTRY(p->gs)));
        if(gs_scan_pdf_cmd)
                g_free(gs_scan_pdf_cmd);
        gs_scan_pdf_cmd = g_strdup(gtk_entry_get_text(GTK_ENTRY(p->scan_pdf)));
        if(gs_uncompress_cmd)
                g_free(gs_uncompress_cmd);
        gs_uncompress_cmd = g_strdup(gtk_entry_get_text(GTK_ENTRY(p->uncompress)));  
        if(gs_print_cmd)
                g_free(gs_print_cmd);
        gs_print_cmd = g_strdup(gtk_entry_get_text(GTK_ENTRY(p->print)));

        active = gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(p->media))));
        for(i = 0; i < PAPER_SIZE_COUNT; i++)
                if(active == p->media_choice[i]) {
                        gs_def_media = i;
                        break;
                }
        
        gs_antialiased = GTK_TOGGLE_BUTTON(p->aa)->active;
        gs_override_media = GTK_TOGGLE_BUTTON(p->override_media)->active;
        gs_panel = GTK_TOGGLE_BUTTON(p->tbar)->active;
        gs_menubar = GTK_TOGGLE_BUTTON(p->mbar)->active;
        gs_auto_jump = GTK_TOGGLE_BUTTON(p->auto_jump)->active;

        apply_gs_prefs(window_list);
}

void prefs_changed_callback(GtkWidget *w, ggv_prefs *p)
{
	gnome_property_box_changed(p->pbox);
}
