#include <config.h>
#include <gnome.h>
#include <libgnorba/gnorba.h>
#include <gdk/gdkprivate.h>
#include <gdk/gdkx.h>
#include <bonobo/gnome-bonobo.h>
#include <math.h>

CORBA_Environment ev;
CORBA_ORB orb;

GList *object_list = NULL;

char *server_goadid = "Test_server_bonobo_object";

typedef struct {
	GtkWidget *app;
	GnomeContainer *container;
	GtkWidget *box;
	GNOME_View view;
} Application;

static void server_destroy(GnomeObjectClient *client, GList *verb_list) {
  if(verb_list)
    gnome_bonobo_object_free_verbs(verb_list);
}

static GnomeObjectClient *
launch_server (GnomeClientSite *client_site, GnomeContainer *container, char *goadid)
{
	GnomeObjectClient *object_server;
	
	gnome_container_add (container, GNOME_OBJECT (client_site));

	printf ("Launching...\n");
	object_server = gnome_object_activate_with_goad_id (NULL, goadid, 0, NULL);
	printf ("Return: %p\n", object_server);
	if (!object_server){
		g_warning (_("Can not activate object_server\n"));
		return NULL;
	}

	if (!gnome_client_site_bind_bonobo_object (client_site, object_server)){
		g_warning (_("Can not bind object server to client_site\n"));
		return NULL;
	}

	return object_server;
}

static void
verb_cb (GtkWidget *item, char *verb_name) {
	GnomeObjectClient *server;

	server = gtk_object_get_data(GTK_OBJECT(item), "test-container-server");
	if(server)
		gnome_bonobo_object_do_verb(server, verb_name);
}

static void
add_verb (Application *app, GnomeObjectClient *server, char *verb_name) {
	GtkWidget *shell, *item;
	gchar *path;
	gint pos;

	path = g_strconcat(_("Verbs"), "/", NULL);

	shell = gnome_app_find_menu_pos (GNOME_APP(app->app)->menubar, path, &pos);  
	if(shell) {
		item = gtk_menu_item_new_with_label(verb_name);
		gtk_object_set_data(GTK_OBJECT(item), "test-container-server",
                        server);
		gtk_signal_connect(GTK_OBJECT(item), "activate",
                       GTK_SIGNAL_FUNC(verb_cb), verb_name);
		gtk_widget_show(item);
		gtk_menu_shell_insert(GTK_MENU_SHELL(shell), item, pos);
	}

	g_free(path);
} /* add_verb */

static GnomeObjectClient *
add_cmd (GtkWidget *widget, Application *app, char *server_goadid)
{
	GtkWidget *frame;
	GtkWidget *wrapper;
	GnomeViewFrame *view_frame;
	GnomeObjectClient *server;
	GNOME_View view;
	GNOME_View_windowid id;
	GList *verbs, *v;
	GnomeClientSite *client_site;
	int i;

	client_site = gnome_client_site_new (app->container);

	server = launch_server (client_site, app->container, server_goadid);
	if (server == NULL)
		return NULL;

	verbs = gnome_bonobo_object_get_verbs(server);
	for(v = verbs; v; v = v->next)
		add_verb(app, server, (char *)v->data);

  gtk_signal_connect(GTK_OBJECT(server), "destroy",
                     GTK_SIGNAL_FUNC(server_destroy), verbs);

	view_frame = gnome_bonobo_object_new_view (server, client_site);
	wrapper = gnome_view_frame_get_wrapper (view_frame);

	frame = gtk_frame_new ("BonoboObject");
	gtk_widget_show (frame);
	gtk_box_pack_start (GTK_BOX (app->box), frame, TRUE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (frame), wrapper);

	gtk_widget_show_all (frame);

	gnome_bonobo_object_client_activate (server);

	return server;
}

static void
add_demo_cmd (GtkWidget *widget, Application *app)
{
	add_cmd (widget, app, server_goadid);
}

static void
add_ps_cmd (GtkWidget *widget, Application *app)
{
	GnomeObjectClient *object;
	GnomeStream *stream;
	GNOME_PersistStream persist;

	object = add_cmd (widget, app, "bonobo-object:application-ps");
	if (object == NULL)
	{
		gnome_warning_dialog (_("Could not launch bonobo object."));
		return;
	}

	object_list = g_list_prepend(object_list, object);

	persist = GNOME_obj_query_interface (
		GNOME_OBJECT (object)->object,
		"IDL:GNOME/PersistStream:1.0", &ev);

        if (ev._major != CORBA_NO_EXCEPTION)
                return;

        if (persist == CORBA_OBJECT_NIL)
                return;

	printf ("Good: BonoboObject supports PersistStream\n");
	
	stream = gnome_stream_fs_open (NULL, "/tmp/a.ps", GNOME_Storage_READ);

	if (stream == NULL){
		printf ("I could not open /tmp/a.ps!\n");
		return;
	}
	
	GNOME_PersistStream_load (persist, (GNOME_Stream) GNOME_OBJECT (stream)->object, &ev);
}


static void
exit_cmd (void)
{
	g_list_foreach(object_list, (GFunc)gtk_object_destroy, NULL);
	g_list_free(object_list);

	gtk_main_quit ();
}

static GnomeUIInfo container_file_menu [] = {
	GNOMEUIINFO_ITEM_NONE(N_("_Add a new object"), NULL, add_demo_cmd),
	GNOMEUIINFO_ITEM_NONE(N_("_Add a new application/ps handler"), NULL, add_ps_cmd),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM (exit_cmd, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo container_verbs_menu [] = {
	GNOMEUIINFO_END
};

static GnomeUIInfo container_main_menu [] = {
	GNOMEUIINFO_MENU_FILE_TREE (container_file_menu),
	GNOMEUIINFO_SUBTREE (N_("_Verbs"), container_verbs_menu),
	GNOMEUIINFO_END
};

static Application *
application_new (void)
{
	Application *app;

	app = g_new0 (Application, 1);
	app->app = gnome_app_new ("test-container", "Sample Container Application");
	gtk_widget_set_usize(app->app, 640, 480);
	app->container = GNOME_CONTAINER (gnome_container_new ());

	app->box = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (app->box);
	gnome_app_set_contents (GNOME_APP (app->app), app->box);
	gnome_app_create_menus_with_data (GNOME_APP (app->app), container_main_menu, app);
	gtk_widget_show (app->app);

	return app;
}

int
main (int argc, char *argv [])
{
	Application *app;

	if (argc != 1){
		server_goadid = argv [1];
	}
	
	CORBA_exception_init (&ev);
	
	gnome_CORBA_init ("MyShell", "1.0", &argc, argv, 0, &ev);
	orb = gnome_CORBA_ORB ();
	
	if (bonobo_init (orb, NULL, NULL) == FALSE)
		g_error (_("Can not bonobo_init\n"));

	app = application_new ();
	
	gtk_main ();

	CORBA_exception_free (&ev);

	return 0;
}


