import pygtk
pygtk.require('2.0')
import gtk.glade
import os

import config

import gettext
gettext.textdomain(config.PACKAGE)
gtk.glade.textdomain(config.PACKAGE)
from gettext import gettext as _

class GeviceFind:
    def __init__ (self):
    	self.window_find = None
    	self.button_find_cancel = None
    	self.button_find_find = None
    	self.entry_find = None
    	self.radiobutton_namedevice = None
    	self.radiobutton_ip = None
    	self.radiobutton_serial = None
    	
    	self.list_names = {}
        self.list_ips =  {}
        self.list_serials = {}
        self.token = []
    
    def load_interface (self,gevice):
		glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_find",None)
		self.window_find = glade_file.get_widget ("window_find")
		self.button_find_cancel = glade_file.get_widget ("button_find_cancel")
		self.button_find_find = glade_file.get_widget ("button_find_find")
		self.entry_find = glade_file.get_widget ("entry_find")
		self.radiobutton_namedevice = glade_file.get_widget ("radiobutton_namedevice")
		self.radiobutton_ip = glade_file.get_widget ("radiobutton_ip")
		self.radiobutton_serial = glade_file.get_widget ("radiobutton_serial")
		
		self.entry_find.grab_focus()
		
		self.window_find.connect ("delete-event",self.on_window_find_delete_event)
		self.button_find_cancel.connect ("clicked",self.on_button_cancel_find_clicked)
		self.button_find_find.connect ("clicked",self.on_button_find_find_clicked,gevice)
		self.entry_find.connect ("key-press-event", self.on_entry_find_key_press,gevice)
		self.radiobutton_namedevice.connect ("toggled", self.on_radiobutton_toggled)
		self.radiobutton_ip.connect ("toggled", self.on_radiobutton_toggled)
		self.radiobutton_serial.connect ("toggled", self.on_radiobutton_toggled)
		
		self.clear_lists()
		gevice.gmodel.treestore.foreach(self.copy_models_to_lists)
    
    def show_interface (self):
    	self.window_find.show_all()
    
    def clear_lists (self):
        self.list_names = {}
        self.list_ips =  {}
        self.list_serials = {}        
    
    def on_radiobutton_toggled(self,radiobutton):
        self.entry_find.grab_focus()
    
    def copy_models_to_lists(self,model,path,iter):
        data = model.get(iter,config.COLUMN_NAME_DEV,config.COLUMN_IP_DEV,config.COLUMN_SERIAL_DEV)
        
        self.list_names[data[0]] = iter
        self.list_ips[data[1]] = iter
        self.list_serials[data[2]] = iter
    
    def close_window (self,window):
	    window.destroy()
    
    def on_button_cancel_find_clicked (self,button):
	    self.close_window (self.window_find)
    
    def on_window_find_delete_event (self,window,event):
	    self.close_window (window)
    
    def on_button_find_find_clicked(self,button,gevice):
        if (self.radiobutton_namedevice.get_active() == True):
	        list = self.list_names
        elif (self.radiobutton_ip.get_active() == True):
            list = self.list_ips
        elif (self.radiobutton_serial.get_active() == True):
            list = self.list_serials
        
        sname = self.entry_find.get_text().strip()
        
        for n in list.items():
            key = n[0]
            iter = n[1]
            
            res = key.find(sname)
            if res >= 0:
                try:
                    self.token.index(key)
                except:
                    self.token.append(key)
                    selection = gevice.gmodel.treeview.get_selection()
                    selection.select_iter(iter)
                    path = gevice.gmodel.treestore.get_path(iter)
                    gevice.gmodel.treeview.set_cursor(path,None,False)
                    break
    
    def on_entry_find_key_press (self,widget,event,gevice):
        if gtk.gdk.keyval_name(event.keyval) == "Return":
            self.on_button_find_find_clicked(None,gevice)
