// Generated by gtkmmproc -- DO NOT MODIFY!


#include <geglmm/node.h>
#include <geglmm/private/node_p.h>

/* libgeglmm - a C++ wrapper for libgegl
 *
 * (c) 2008 Hubert Figuiere
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.
 */

#include <gegl.h>

#include <glibmm/object.h>
#include <geglmm/node.h>
#include <geglmm/rectangle.h>
#include <geglmm/processor.h>


namespace  Gegl {

    Glib::RefPtr<Node> Node::new_child(const Glib::ustring & first_property_name, const Glib::ustring & first_value)
	{
		Glib::RefPtr<Node> node(Glib::wrap(
									gegl_node_new_child(gobj(),
														first_property_name.c_str(),
														first_value.c_str(), NULL)));
        // the node is refcounted owned by the node. Make sure the pointer won't free it too early.
        node->reference();
		return node;
	}

	Glib::RefPtr<Node> Node::get_producer(const Glib::ustring & input_pad_name, Glib::ustring * output_pad_name) const
	{
		gchar *s = NULL;
		Glib::RefPtr<Node> node(Glib::wrap(gegl_node_get_producer(const_cast<GeglNode*>(gobj()), 
																  (gchar*)input_pad_name.c_str(), 
																  output_pad_name?&s:NULL)));
		if(output_pad_name) {
			*output_pad_name = s;
		}
		return node;
	}


  Glib::RefPtr<Node> Node::link(const Glib::RefPtr<Node> & sink)
  {
    gegl_node_link(gobj(), sink->gobj());
    return sink;
  }


}


namespace
{


static void Node_signal_invalidated_callback(GeglNode* self, GeglRectangle* p0,void* data)
{
  using namespace Gegl;
  typedef sigc::slot< void,const Rectangle & > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Node_signal_invalidated_info =
{
  "invalidated",
  (GCallback) &Node_signal_invalidated_callback,
  (GCallback) &Node_signal_invalidated_callback
};


static void Node_signal_computed_callback(GeglNode* self, GeglRectangle* p0,void* data)
{
  using namespace Gegl;
  typedef sigc::slot< void,const Rectangle & > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Node_signal_computed_info =
{
  "computed",
  (GCallback) &Node_signal_computed_callback,
  (GCallback) &Node_signal_computed_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gegl::Node> wrap(GeglNode* object, bool take_copy)
{
  return Glib::RefPtr<Gegl::Node>( dynamic_cast<Gegl::Node*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gegl
{


/* The *_Class implementation: */

const Glib::Class& Node_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Node_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gegl_node_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Node_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Node_Class::wrap_new(GObject* object)
{
  return new Node((GeglNode*)object);
}


/* The implementation: */

GeglNode* Node::gobj_copy()
{
  reference();
  return gobj();
}

Node::Node(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Node::Node(GeglNode* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Node::~Node()
{}


Node::CppClassType Node::node_class_; // initialize static member

GType Node::get_type()
{
  return node_class_.init().get_type();
}

GType Node::get_base_type()
{
  return gegl_node_get_type();
}


Node::Node()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(node_class_.init()))
{
  

}

Glib::RefPtr<Node> Node::create()
{
  return Glib::RefPtr<Node>( new Node() );
}
bool Node::connect_from(const Glib::ustring & input_pad_name, const Glib::RefPtr<Node> & source, const Glib::ustring & output_pad_name)
{
  return gegl_node_connect_from(gobj(), input_pad_name.c_str(), Glib::unwrap(source), output_pad_name.c_str());
}

bool Node::connect_to(const Glib::ustring & output_pad_name, const Glib::RefPtr<Node> & sink, const Glib::ustring & input_pad_name)
{
  return gegl_node_connect_to(gobj(), output_pad_name.c_str(), Glib::unwrap(sink), input_pad_name.c_str());
}

bool Node::disconnect(const Glib::ustring & input_pad)
{
  return gegl_node_disconnect(gobj(), input_pad.c_str());
}

void Node::blit(double scale, const Rectangle & roi, const Babl * format, void * destination_buf, int rowstride, BlitFlags flags)
{
gegl_node_blit(gobj(), scale, const_cast<const GeglRectangle*>(roi.gobj()), format, destination_buf, rowstride, ((GeglBlitFlags)(flags))); 
}

void Node::process()
{
gegl_node_process(gobj()); 
}

Glib::RefPtr<Node> Node::adopt_child(const Glib::RefPtr<Node> & child)
{
  return Glib::wrap(gegl_node_adopt_child(gobj(), Glib::unwrap(child)));
}

Glib::RefPtr<Node> Node::add_child(const Glib::RefPtr<Node> & child)
{
  return Glib::wrap(gegl_node_add_child(gobj(), Glib::unwrap(child)));
}

Glib::RefPtr<Node> Node::remove_child(const Glib::RefPtr<Node> & child)
{
  return Glib::wrap(gegl_node_remove_child(gobj(), Glib::unwrap(child)));
}

Glib::RefPtr<Node> Node::get_parent()
{

  Glib::RefPtr<Node> retvalue = Glib::wrap(gegl_node_get_parent(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Node> Node::get_parent() const
{
  return const_cast<Node*>(this)->get_parent();
}

Glib::RefPtr<Node> Node::detect(int x, int y)
{

  Glib::RefPtr<Node> retvalue = Glib::wrap(gegl_node_detect(gobj(), x, y));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Node> Node::detect(int x, int y) const
{
  return const_cast<Node*>(this)->detect(x, y);
}

GParamSpec* Node::find_property(const Glib::ustring & property_name)
{
  return gegl_node_find_property(gobj(), property_name.c_str());
}

Rectangle Node::get_bounding_box() const
{
  return Rectangle(gegl_node_get_bounding_box(const_cast<GeglNode*>(gobj())));
}

Glib::SListHandle< Glib::RefPtr<Node> > Node::get_children()
{
  return Glib::SListHandle< Glib::RefPtr<Node> >(gegl_node_get_children(gobj()), Glib::OWNERSHIP_SHALLOW);
}

int Node::get_consumers(const Glib::ustring & output_pad, GeglNode *** nodes, const gchar *** pads) const
{
  return gegl_node_get_consumers(const_cast<GeglNode*>(gobj()), output_pad.c_str(), nodes, pads);
}

Glib::RefPtr<Node> Node::get_input_proxy(const Glib::ustring & pad_name)
{

  Glib::RefPtr<Node> retvalue = Glib::wrap(gegl_node_get_input_proxy(gobj(), pad_name.c_str()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Node> Node::get_input_proxy(const Glib::ustring & pad_name) const
{
  return const_cast<Node*>(this)->get_input_proxy(pad_name);
}

Glib::RefPtr<Node> Node::get_output_proxy(const Glib::ustring & pad_name)
{

  Glib::RefPtr<Node> retvalue = Glib::wrap(gegl_node_get_output_proxy(gobj(), pad_name.c_str()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Node> Node::get_output_proxy(const Glib::ustring & pad_name) const
{
  return const_cast<Node*>(this)->get_output_proxy(pad_name);
}

Glib::ustring Node::get_operation() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gegl_node_get_operation(const_cast<GeglNode*>(gobj())));
}

Glib::RefPtr<Node> Node::create_child(const Glib::ustring & operation)
{
  return Glib::wrap(gegl_node_create_child(gobj(), operation.c_str()));
}

Glib::RefPtr<Node> Node::new_from_xml(const Glib::ustring & xmldata, const Glib::ustring & path_root)
{
  return Glib::wrap(gegl_node_new_from_xml(xmldata.c_str(), path_root.c_str()));
}


Glib::RefPtr<Node> Node::new_from_file(const Glib::ustring & path)
{
  return Glib::wrap(gegl_node_new_from_file(path.c_str()));
}


Glib::ustring Node::to_xml(const Glib::ustring & path_root) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gegl_node_to_xml(const_cast<GeglNode*>(gobj()), path_root.c_str()));
}

Glib::RefPtr<Processor> Node::new_processor(const Rectangle & rectangle)
{
  return Glib::wrap(gegl_node_new_processor(gobj(), const_cast<const GeglRectangle*>(rectangle.gobj())));
}


Glib::SignalProxy1< void,const Rectangle & > Node::signal_invalidated()
{
  return Glib::SignalProxy1< void,const Rectangle & >(this, &Node_signal_invalidated_info);
}


Glib::SignalProxy1< void,const Rectangle & > Node::signal_computed()
{
  return Glib::SignalProxy1< void,const Rectangle & >(this, &Node_signal_computed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Operation> > Node::property_gegl_operation() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Operation> >(this, "gegl-operation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Operation> > Node::property_gegl_operation() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Operation> >(this, "gegl-operation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Node::property_operation() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "operation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Node::property_operation() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "operation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Node::property_name() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Node::property_name() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gegl


