// Generated by gtkmmproc -- DO NOT MODIFY!


#include <geglmm/buffer.h>
#include <geglmm/private/buffer_p.h>

/* libgeglmm - a C++ wrapper for libgegl
 *
 * (c) 2008 Hubert Figuiere
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.
 */


namespace Gegl {

Buffer::Buffer(const Rectangle & extent, const Babl * format)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(buffer_class_.init(),
                                     "x", const_cast<const GeglRectangle*>(extent.gobj())->x,
                                     "y", const_cast<const GeglRectangle*>(extent.gobj())->y,
                                     "width", const_cast<const GeglRectangle*>(extent.gobj())->width,
                                     "height", const_cast<const GeglRectangle*>(extent.gobj())->height,
                                     "format", format, static_cast<char*>(0)))
{

}

void Buffer::save(const Glib::ustring &p1) const
{
  gegl_buffer_save(const_cast<GeglBuffer*>(gobj()), p1.c_str(), NULL);
}

}

namespace
{


static void Buffer_signal_changed_callback(GeglBuffer* self, GeglRectangle* p0,void* data)
{
  using namespace Gegl;
  typedef sigc::slot< void,const Rectangle & > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Buffer_signal_changed_info =
{
  "changed",
  (GCallback) &Buffer_signal_changed_callback,
  (GCallback) &Buffer_signal_changed_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gegl::Buffer> wrap(GeglBuffer* object, bool take_copy)
{
  return Glib::RefPtr<Gegl::Buffer>( dynamic_cast<Gegl::Buffer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gegl
{


/* The *_Class implementation: */

const Glib::Class& Buffer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Buffer_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gegl_buffer_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Buffer_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Buffer_Class::wrap_new(GObject* object)
{
  return new Buffer((GeglBuffer*)object);
}


/* The implementation: */

GeglBuffer* Buffer::gobj_copy()
{
  reference();
  return gobj();
}

Buffer::Buffer(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Buffer::Buffer(GeglBuffer* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Buffer::~Buffer()
{}


Buffer::CppClassType Buffer::buffer_class_; // initialize static member

GType Buffer::get_type()
{
  return buffer_class_.init().get_type();
}

GType Buffer::get_base_type()
{
  return gegl_buffer_get_type();
}


Glib::RefPtr<Buffer> Buffer::create(const Rectangle & extent, const Babl * format)
{
  return Glib::RefPtr<Buffer>( new Buffer(extent, format) );
}
Glib::RefPtr<Buffer> Buffer::create_from_file(const Glib::ustring& p1)
{
  return Glib::wrap(gegl_buffer_open(p1.c_str()));
}


Glib::RefPtr<Buffer> Buffer::create_sub_buffer(const Rectangle & extent)
{
  return Glib::wrap(gegl_buffer_create_sub_buffer(gobj(), const_cast<const GeglRectangle*>(extent.gobj())));
}

Rectangle Buffer::get_extent() const
{
  return Glib::wrap(gegl_buffer_get_extent(const_cast<GeglBuffer*>(gobj())));
}

void Buffer::set_extent(const Rectangle & p1)
{
gegl_buffer_set_extent(gobj(), const_cast<const GeglRectangle*>(p1.gobj())); 
}

void Buffer::save(const Glib::ustring & p1, const Rectangle & p2) const
{
gegl_buffer_save(const_cast<GeglBuffer*>(gobj()), p1.c_str(), const_cast<const GeglRectangle*>(p2.gobj())); 
}

void Buffer::flush()
{
gegl_buffer_flush(gobj()); 
}

void Buffer::clear(const Rectangle & p1)
{
gegl_buffer_clear(gobj(), const_cast<const GeglRectangle*>(p1.gobj())); 
}

const Babl* Buffer::get_format()
{
  return gegl_buffer_get_format(gobj());
}

void Buffer::get(double scale, const Rectangle & rect, const Babl * format, void * dest, int rowstride) const
{
gegl_buffer_get(const_cast<GeglBuffer*>(gobj()), scale, const_cast<const GeglRectangle*>(rect.gobj()), format, dest, rowstride); 
}

void Buffer::set(const Rectangle & rect, const Babl * format, void * src, int rowstride)
{
gegl_buffer_set(gobj(), const_cast<const GeglRectangle*>(rect.gobj()), format, src, rowstride); 
}

void Buffer::copy(const Rectangle & src_rect, const Glib::RefPtr<Buffer> & dest, const Rectangle & dest_rect)
{
gegl_buffer_copy(gobj(), const_cast<const GeglRectangle*>(src_rect.gobj()), Glib::unwrap(dest), const_cast<const GeglRectangle*>(dest_rect.gobj())); 
}

Glib::RefPtr<Buffer> Buffer::dup() const
{
  return Glib::wrap(gegl_buffer_dup(const_cast<GeglBuffer*>(gobj())));
}

void Buffer::sample(double x, double y, double scale, void * dest, const Babl* format, Interpolation interpolation)
{
gegl_buffer_sample(gobj(), x, y, scale, dest, format, ((GeglInterpolation)(interpolation))); 
}

void Buffer::sample_cleanup()
{
gegl_buffer_sample_cleanup(gobj()); 
}

Interpolation Buffer::interpolation_from_string(const Glib::ustring & string)
{
  return ((Interpolation)(gegl_buffer_interpolation_from_string(string.c_str())));
}


Glib::SignalProxy1< void,const Rectangle & > Buffer::signal_changed()
{
  return Glib::SignalProxy1< void,const Rectangle & >(this, &Buffer_signal_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_px_size() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "px-size");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_pixels() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "pixels");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Buffer::property_width() 
{
  return Glib::PropertyProxy<int>(this, "width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_width() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Buffer::property_height() 
{
  return Glib::PropertyProxy<int>(this, "height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_height() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Buffer::property_x() 
{
  return Glib::PropertyProxy<int>(this, "x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_x() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Buffer::property_y() 
{
  return Glib::PropertyProxy<int>(this, "y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_y() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_abyss_width() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "abyss-width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_abyss_height() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "abyss-height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_abyss_x() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "abyss-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_abyss_y() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "abyss-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_shift_x() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "shift-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Buffer::property_shift_y() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "shift-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Babl*> Buffer::property_format() 
{
  return Glib::PropertyProxy<Babl*>(this, "format");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Babl*> Buffer::property_format() const
{
  return Glib::PropertyProxy_ReadOnly<Babl*>(this, "format");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gegl


