from gazpacho.unittest import common

import gtk

class GtkButtonTest(common.GazpachoTest):

    def setUp(self):
        common.GazpachoTest.setUp(self)

        # add a window
        self.window = self.create_gwidget('GtkWindow')
        self.window.get_glade_property('visible').set(False)
        self.project.add_widget(self.window.gtk_widget)
        
    def testCreation(self):
        button = self.add_child(self.window, 'GtkButton',
                                self.window.gtk_widget.get_child())
        
        self.assertEqual(gtk.Button, type(button.gtk_widget))

    def testProperty(self):
        button = self.add_child(self.window, 'GtkButton',
                                self.window.gtk_widget.get_child())

        prop = button.get_glade_property('label')
        prop.set('Click me!')
        self.assertEqual(button.gtk_widget.get_label(), 'Click me!')

    def testSavingLoading(self):
        button = self.add_child(self.window, 'GtkButton',
                                self.window.gtk_widget.get_child())
        self.project.add_widget(button.gtk_widget)
        self.project.save(__file__+'.glade')

        self.app.open_project(__file__+'.glade')
