/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* e-contact-editor-categories.h
 * Copyright (C) 2000  Helix Code, Inc.
 * Author: Chris Lahey <clahey@helixcode.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __E_CATEGORIES_H__
#define __E_CATEGORIES_H__

#include <gnome.h>
#include <glade/glade.h>
#include <gal/e-table/e-table-model.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

/* ECategories - A dialog displaying information about a contact.
 *
 * The following arguments are available:
 *
 * name		type		read/write	description
 * --------------------------------------------------------------------------------
 */

#define E_CATEGORIES_TYPE			(e_categories_get_type ())
#define E_CATEGORIES(obj)			(GTK_CHECK_CAST ((obj), E_CATEGORIES_TYPE, ECategories))
#define E_CATEGORIES_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), E_CATEGORIES_TYPE, ECategoriesClass))
#define E_IS_CATEGORIES(obj)		        (GTK_CHECK_TYPE ((obj), E_CATEGORIES_TYPE))
#define E_IS_CATEGORIES_CLASS(klass)	        (GTK_CHECK_CLASS_TYPE ((obj), E_CATEGORIES_TYPE))


typedef struct _ECategories       ECategories;
typedef struct _ECategoriesClass  ECategoriesClass;

struct _ECategories
{
	GnomeDialog parent;
	
	/* item specific fields */
	char *categories;
	GtkWidget *entry;
	ETableModel *model;

	int list_length;
	char **category_list;
	gboolean *selected_list;

	GladeXML *gui;
};

struct _ECategoriesClass
{
	GnomeDialogClass parent_class;
};


GtkType    e_categories_get_type   (void);
GtkWidget *e_categories_new        (const char  *categories);
void       e_categories_construct  (ECategories *categories,
				    const char  *initial_category_list);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __E_CATEGORIES_H__ */
