#ifndef GNOME_APP_LIB__COLOR_GROUP_H
#define GNOME_APP_LIB__COLOR_GROUP_H

#include <gnome.h>
#include <libgnomeui/gnome-canvas.h>
#include <libgnome/gnome-defs.h>
#include <gtk/gtkobject.h>

BEGIN_GNOME_DECLS

typedef struct _ColorGroup {
	GtkObject  parent;

        gchar     *name;
        GdkColor **color_history; /* custom color history */
	GdkColor  *current_color ;
	gint       history_size;  /* length of color_history */
	gint       history_iterator; /* used to cycle through the colors */
} ColorGroup;

typedef struct {
	GtkObjectClass parent_class;

	/* Signals emited by this object */
	void (*color_change) (ColorGroup *color_group, GdkColor *color, gboolean custom);
} ColorGroupClass;

#define COLOR_GROUP_TYPE     (color_group_get_type ())
#define COLOR_GROUP(obj)     (GTK_CHECK_CAST((obj), COLOR_GROUP_TYPE, ColorGroup))
#define COLOR_GROUP_CLASS(k) (GTK_CHECK_CLASS_CAST(k), COLOR_GROUP_TYPE)
#define IS_COLOR_GROUP(obj)  (GTK_CHECK_TYPE((obj), COLOR_GROUP_TYPE))

GtkType         color_group_get_type  (void);
GtkObject      *color_group_new_named (const gchar *name);
GtkObject      *color_group_from_name (const gchar * name);

void            color_group_set_history_size (ColorGroup *cg, gint size);
gint            color_group_get_history_size (ColorGroup *cg);

GdkColor       *color_group_get_current_color (ColorGroup *cg);
void            color_group_set_current_color (ColorGroup *cg, GdkColor *color);
GdkColor       *color_group_most_recent_color (ColorGroup *cg);
GdkColor       *color_group_oldest_color      (ColorGroup *cg);
GdkColor       *color_group_next_color	      (ColorGroup *cg);
GdkColor       *color_group_previous_color    (ColorGroup *cg);
void            color_group_add_color	      (ColorGroup *cg, GdkColor *color,
					       gboolean custom_color);

END_GNOME_DECLS

#endif GNOME_APP_LIB__COLOR_GROUP_H
