#
# Library for common functionality.
#

# convert
#   bytes_to_gmkb
#   gmkb_to_bytes
#   secs_to_dhms
#   dmhs_to_secs
#   centigrade_to_fahrenheit
#   fahrenheit_to_centigrade
#   centigrade_to_kelvin
#   kelvin_to_centigrade
#
# cpu
#   get_speed(): float
#   get_model(): str
#   get_cache_size(): str
#   get_load(): (total:int, load:int)
#
# disk
#   get_partitions(): [(device:str, mpoint:str),...]
#   get_size(partition:str): (total:int, used:int)
#
# memory
#   get_ram(): (total:int, used:int)
#   get_swap(): (total:int, used:int)
#
# network
#   get_devices(): [device:str,...]
#   get_ipaddr(): str
#   get_bytes_in_out(dev:str): (int, int)
#   get_pack_in_out(dev:str): (int, int)
#   get_speed_in_out(dev:str): (int, int)
#
# system
#   get_arch(): str
#   get_uptime(): int
#   get_idletime(): int
#   get_sysstart(): int
#   get_load_avg_1m(): float
#   get_load_avg_5m(): float
#   get_load_avg_15m(): float
#   get_tasks(): (total:int, running:int)


from Convert import Convert
from CPU import CPU
from Disk import Disk
from Memory import Memory
from Network import Network
from Sys import Sys


convert = Convert()
cpu = CPU()
disk = Disk()
memory = Memory()
net = Network()
sys = Sys()
print "INIT libdesklets (should happen only once)"
