from utils.Observable import Observable
from utils.TypeConverter import TypeConverter
from utils.datatypes import *


#
# Abstract class for data targets.
#
class DataTarget(Observable):

    def __init__(self, parent, display):

        # the actions and their associated calls
        self.__actions = {}

        # the parent of this target
        self.__parent = parent

        # the display of this target
        self.__display = display

        # converter for data types
        self.__type_converter = TypeConverter()


        self._set_property_type("watch", TYPE_LIST)
        


    #
    # Returns the parent of this target.
    #
    def _get_parent(self): return self.__parent



    #
    # Returns the display of this target.
    #
    def _get_display(self): return self.__display



    #
    # Configures this target.
    #
    def set_config(self, key, value):

        if (key == "watch"):
            entries = value
            for e in entries:
                property, sensorplug = e.split("=")
                self._get_display().add_mapping(sensorplug.strip(),
                                                self, property.strip())
            #end for



    #
    # Associates the given action woth the given sensor call.
    #
    def set_action_call(self, action, call):

        if (not self.__actions.has_key(action)): self.__actions[action] = []
        self.__actions[action] += call



    #
    # Emits the given action if the pointer is over this target.
    #
    def get_action_call(self, action):

        call = self.__actions.get(action)
        return call



    def has_actions(self): return self.__actions



    #
    # Returns whether this target supports the given action.
    #
    def has_action(self, action): return self.__actions.has_key(action)



    #
    # Returns the target and its array indexes (if any) at the given
    # coordinates.
    #
    def get_target_at(self, px, py):

        return None



    #
    # Sets the data type for the given property.
    #
    def _set_property_type(self, key, dtype):

        self.__type_converter.add_type(key, dtype)



    #
    # Converts a value to the data type of the given property. This function
    # is idem-potent.
    #
    def _convert_type(self, key, v):

        return self.__type_converter.str2type(key, v)
