from DisplayTarget import DisplayTarget


#
# Abstract class for targets that can contain others.
#
class ContainerTarget(DisplayTarget):


    def __init__(self, parent, display):

        # the list is necessary for preserving order
        self.__children = []

        # mapping: id -> child
        self.__children_id = {}

        # mapping: child -> id
        self.__ids = {}
        
        self.__settings = []
        

        DisplayTarget.__init__(self, parent, display)



    def _register_child(self, child, cid):

        self.__children_id[cid] = child
        self.__ids[child] = cid
        self.__children.append(child)



    def _unregister_child(self, child):

        cid = self.__ids[child]
        del self.__children_id[cid]
        del self.__ids[child]
        self.__children.remove(child)



    def add_children(self, childrendata):

        for childname, childclass, childsettings, children in childrendata:
            self.add_child(childname, childclass, childsettings, children)



    def add_child(self, cid, clss, settings, children):

        display = self._get_display()
        child = clss(self, display)
        if (children): child.add_children(children)

        self._register_child(child, cid)

        if (settings):
            for key, value in settings.get_entries():
                self.__settings.append((child, key, value))



    def _init_children(self):

        for child, key, value in self.__settings:
            child.set_config(key, value)
        

        

    def _get_children(self): return self.__children[:]

    def _get_child(self): return self._get_children()[0]

    def get_child_by_id(self, id): return self.__children_id.get(id)

    def get_id_by_child(self, child): return self.__ids.get(child)
