/*
 * ActiveSync client library for email access
 *
 * Copyright © 2011 Intel Corporation.
 *
 * Authors: Mobica Ltd. <www.mobica.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 */

#ifndef EAS_ERRORS_H
#define EAS_ERRORS_H

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

GQuark eas_connection_error_quark (void);

#define EAS_CONNECTION_ERROR (eas_connection_error_quark ())

/* NB: the error values in this enum do not match anything
   in MSFT docs; the values are our own */
enum _EasConnectionError {
	EAS_CONNECTION_ERROR_FAILED, // 0
	EAS_CONNECTION_ERROR_FILEERROR,
	EAS_CONNECTION_ERROR_NOTENOUGHMEMORY,
	EAS_CONNECTION_ERROR_BADARG,
	EAS_CONNECTION_ERROR_WBXMLERROR,
	EAS_CONNECTION_ERROR_SOUPERROR,
	EAS_CONNECTION_ERROR_XMLELEMENTNOTFOUND,	// generic error for use by response parsers
	EAS_CONNECTION_ERROR_STATUSUNRECOGNIZED,
	EAS_CONNECTION_ERROR_ACCOUNTNOTFOUND,
	EAS_CONNECTION_ERROR_BADREQUESTSTATE,
	EAS_CONNECTION_ERROR_XMLTOOLARGETODOM,
	EAS_CONNECTION_ERROR_NOTSUPPORTED,
	EAS_CONNECTION_ERROR_CANCELLED,
	EAS_CONNECTION_ERROR_REPROVISION,

	/*  Provision status errors  */
	EAS_CONNECTION_PROVISION_ERROR_PROTOCOLERROR,
	EAS_CONNECTION_PROVISION_ERROR_GENERALSERVERERROR,
	EAS_CONNECTION_PROVISION_ERROR_DEVICE_EXTERNALLY_MANAGED,
	EAS_CONNECTION_PROVISION_ERROR_NOCLIENTPOLICYEXISTS,
	EAS_CONNECTION_PROVISION_ERROR_UNKNOWNPOLICYTYPE,
	EAS_CONNECTION_PROVISION_ERROR_CORRUPTSERVERPOLICYDATA,
	EAS_CONNECTION_PROVISION_ERROR_ACKINGWRONGPOLICYKEY,
	EAS_CONNECTION_PROVISION_ERROR_STATUSUNRECOGNIZED,

	/* Sync status errors  */
	EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCKEY,
	EAS_CONNECTION_SYNC_ERROR_PROTOCOLERROR,
	EAS_CONNECTION_SYNC_ERROR_SERVERERROR,
	EAS_CONNECTION_SYNC_ERROR_CONVERSIONERROR,
	EAS_CONNECTION_SYNC_ERROR_CONFLICTERROR,
	EAS_CONNECTION_SYNC_ERROR_OBJECTNOTFOUND,
	EAS_CONNECTION_SYNC_ERROR_MAILBOXFULL,
	EAS_CONNECTION_SYNC_ERROR_FOLDERHIERARCHYCHANGED,
	EAS_CONNECTION_SYNC_ERROR_REQUESTINCOMPLETE,
	EAS_CONNECTION_SYNC_ERROR_INVALIDWAITORHEARTBEAT,
	EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCCOMMAND,
	EAS_CONNECTION_SYNC_ERROR_RETRY,
	EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED,
	EAS_CONNECTION_SYNC_ERROR_INVALIDSTATE,
	EAS_CONNECTION_SYNC_ERROR_INVALIDTYPE,

	/* FolderSync status errors */
	EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED,
	EAS_CONNECTION_FOLDER_SYNC_ERROR_SERVERERROR,
	EAS_CONNECTION_FOLDER_SYNC_ERROR_TIMEOUT,
	EAS_CONNECTION_FOLDER_SYNC_ERROR_INVALIDSYNCKEY,
	EAS_CONNECTION_FOLDER_SYNC_ERROR_BADLYFORMATTEDREQUEST,
	EAS_CONNECTION_FOLDER_SYNC_ERROR_UNKNOWNERROR,
	EAS_CONNECTION_FOLDER_SYNC_ERROR_CODEUNKNOWN,

	/* ItemOperations status errors */
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_PROTOCOLERROR,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_SERVERERROR,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_BADURI,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_DOCLIBACCESSDENIED,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_OBJECTNOTFOUND,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_FAILEDTOCONNECT,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDBYTERANGE,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_UNKNOWNSTORE,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_FILEEMPTY,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_TOOLARGE,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_IOFAILURE,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_CONVERSIONFAILED,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDATTACHMENT,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_RESOURCEACCESSDENIED,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_PARTIALCOMPLETE,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_CREDENTIALSREQUIRED,
	EAS_CONNECTION_ITEMOPERATIONS_ERROR_STATUSUNRECOGNIZED,

	/* Ping status errors */
	EAS_CONNECTION_PING_ERROR_STATUSUNRECOGNIZED,
	EAS_CONNECTION_PING_ERROR_FOLDERS_UPDATED,
	EAS_CONNECTION_PING_ERROR_PARAMETER,
	EAS_CONNECTION_PING_ERROR_PROTOCOL,
	EAS_CONNECTION_PING_ERROR_HEARTBEAT_INTERVAL,
	EAS_CONNECTION_PING_ERROR_FOLDER,
	EAS_CONNECTION_PING_ERROR_FOLDER_SYNC,

	/* MoveItems status errors */
	EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_SRC_ID,
	EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_DST_ID,
	EAS_CONNECTION_MOVEITEMS_ERROR_SRC_AND_DST_SAME,
	EAS_CONNECTION_MOVEITEMS_ERROR_MULTIPLE_DST,
	EAS_CONNECTION_MOVEITEMS_ERROR_SRC_OR_DST_LOCKED,
	EAS_CONNECTION_MOVEITEMS_ERROR_STATUSUNRECOGNIZED,

	/* GetItemEstimate status errors */
	EAS_CONNECTION_GETITEMESTIMATE_ERROR_STATUSUNRECOGNIZED,
	EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_COLLECTION,
	EAS_CONNECTION_GETITEMESTIMATE_ERROR_BAD_SYNC_STATE,
	EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_SYNC_KEY,

	/* Common status errors */
	EAS_CONNECTION_COMMON_ERROR_STATUSUNRECOGNIZED,
	EAS_CONNECTION_COMMON_ERROR_INVALIDCONTENT,
	EAS_CONNECTION_COMMON_ERROR_INVALIDWBXML,
	EAS_CONNECTION_COMMON_ERROR_INVALIDXML,
	EAS_CONNECTION_COMMON_ERROR_INVALIDDATETIME,
	EAS_CONNECTION_COMMON_ERROR_INVALIDCOMBINATIONOFIDS,
	EAS_CONNECTION_COMMON_ERROR_INVALIDIDS,
	EAS_CONNECTION_COMMON_ERROR_INVALIDMIME,
	EAS_CONNECTION_COMMON_ERROR_DEVICEIDMISSINGORINVALID,
	EAS_CONNECTION_COMMON_ERROR_DEVICETYPEMISSINGORINVALID,
	EAS_CONNECTION_COMMON_ERROR_SERVERERROR,
	EAS_CONNECTION_COMMON_ERROR_SERVERERRORRETRYLATER,
	EAS_CONNECTION_COMMON_ERROR_ACTIVEDIRECTORYACCESSDENIED,
	EAS_CONNECTION_COMMON_ERROR_MAILBOXQUOTAEXCEEDED,
	EAS_CONNECTION_COMMON_ERROR_MAILBOXSERVEROFFLINE,
	EAS_CONNECTION_COMMON_ERROR_SENDQUOTAEXCEEDED,
	EAS_CONNECTION_COMMON_ERROR_MESSAGERECIPIENTUNRESOLVED,
	EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYNOTALLOWED,
	EAS_CONNECTION_COMMON_ERROR_MESSAGEPREVIOUSLYSENT,
	EAS_CONNECTION_COMMON_ERROR_MESSAGEHASNORECIPIENT,
	EAS_CONNECTION_COMMON_ERROR_MAILSUBMISSIONFAILED,
	EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYFAILED,
	EAS_CONNECTION_COMMON_ERROR_ATTACHMENTISTOOLARGE,
	EAS_CONNECTION_COMMON_ERROR_USERHASNOMAILBOX,
	EAS_CONNECTION_COMMON_ERROR_USERCANNOTBEANONYMOUS,
	EAS_CONNECTION_COMMON_ERROR_USERPRINCIPALCOULDNOTBEFOUND,
	EAS_CONNECTION_COMMON_ERROR_USERDISABLEDFORSYNC,
	EAS_CONNECTION_COMMON_ERROR_USERONNEWMAILBOXCANNOTSYNC,
	EAS_CONNECTION_COMMON_ERROR_USERONLEGACYMAILBOXCANNOTSYNC,
	EAS_CONNECTION_COMMON_ERROR_DEVICEISBLOCKEDFORTHISUSER,
	EAS_CONNECTION_COMMON_ERROR_ACCESSDENIED,
	EAS_CONNECTION_COMMON_ERROR_ACCOUNTDISABLED,
	EAS_CONNECTION_COMMON_ERROR_SYNCSTATENOTFOUND,
	EAS_CONNECTION_COMMON_ERROR_SYNCSTATELOCKED,
	EAS_CONNECTION_COMMON_ERROR_SYNCSTATECORRUPT,
	EAS_CONNECTION_COMMON_ERROR_SYNCSTATEALREADYEXISTS,
	EAS_CONNECTION_COMMON_ERROR_SYNCSTATEVERSIONINVALID,
	EAS_CONNECTION_COMMON_ERROR_COMMANDNOTSUPPORTED,
	EAS_CONNECTION_COMMON_ERROR_VERSIONNOTSUPPORTED,
	EAS_CONNECTION_COMMON_ERROR_DEVICENOTFULLYPROVISIONABLE,
	EAS_CONNECTION_COMMON_ERROR_REMOTEWIPEREQUESTED,
	EAS_CONNECTION_COMMON_ERROR_LEGACYDEVICEONSTRICTPOLICY,
	EAS_CONNECTION_COMMON_ERROR_DEVICENOTPROVISIONED,
	EAS_CONNECTION_COMMON_ERROR_POLICYREFRESH,
	EAS_CONNECTION_COMMON_ERROR_INVALIDPOLICYKEY,
	EAS_CONNECTION_COMMON_ERROR_EXTERNALLYMANAGEDDEVICESNOTALLOWED,
	EAS_CONNECTION_COMMON_ERROR_NORECURRENCEINCALENDAR,
	EAS_CONNECTION_COMMON_ERROR_UNEXPECTEDITEMCLASS,
	EAS_CONNECTION_COMMON_ERROR_REMOTESERVERHASNOSSL,
	EAS_CONNECTION_COMMON_ERROR_INVALIDSTOREDREQUEST,
	EAS_CONNECTION_COMMON_ERROR_ITEMNOTFOUND,
	EAS_CONNECTION_COMMON_ERROR_TOOMANYFOLDERS,
	EAS_CONNECTION_COMMON_ERROR_NOFOLDERSFOUND,
	EAS_CONNECTION_COMMON_ERROR_ITEMSLOSTAFTERMOVE,
	EAS_CONNECTION_COMMON_ERROR_FAILUREINMOVEOPERATION,
	EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDDISALLOWEDFORNONPERSISTENTMOVEACTION,
	EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDINVALIDDESTINATIONFOLDER,
	EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTOOMANYRECIPIENTS,
	EAS_CONNECTION_COMMON_ERROR_AVAILABILITYDLLIMITREACHED,
	EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTRANSIENTFAILURE,
	EAS_CONNECTION_COMMON_ERROR_AVAILABILITYFAILURE,
	EAS_CONNECTION_COMMON_ERROR_BODYPARTPREFERENCETYPENOTSUPPORTED,
	EAS_CONNECTION_COMMON_ERROR_DEVICEINFORMATIONREQUIRED,
	EAS_CONNECTION_COMMON_ERROR_INVALIDACCOUNTID,
	EAS_CONNECTION_COMMON_ERROR_ACCOUNTSENDDISABLED,
	EAS_CONNECTION_COMMON_ERROR_IRM_FEATUREDISABLED,
	EAS_CONNECTION_COMMON_ERROR_IRM_TRANSIENTERROR,
	EAS_CONNECTION_COMMON_ERROR_IRM_PERMANENTERROR,
	EAS_CONNECTION_COMMON_ERROR_IRM_INVALIDTEMPLATEID,
	EAS_CONNECTION_COMMON_ERROR_IRM_OPERATIONNOTPERMITTED,
	EAS_CONNECTION_COMMON_ERROR_NOPICTURE,
	EAS_CONNECTION_COMMON_ERROR_PICTURETOOLARGE,
	EAS_CONNECTION_COMMON_ERROR_PICTURELIMITREACHED,
	EAS_CONNECTION_COMMON_ERROR_BODYPART_CONVERSATIONTOOLARGE,
	EAS_CONNECTION_COMMON_ERROR_MAXIMUMDEVICESREACHED,
	EAS_CONNECTION_COMMON_ERROR_EXCEEDSSTATUSLIMIT,

	/* */

	EAS_CONNECTION_ERROR_LAST
} ;

typedef enum _EasConnectionError EasConnectionError;

G_END_DECLS

#endif /* EAS_ERRORS_H */
