using System;
using System.IO.Ports;

public class ChronopicTest
{
	static SerialPort sp;

	public static void Main(string[] args)
	{ 
		bool ok;
		//-- Crear puerto serie.
		//-- El nombre de dispositivo es diferente segun
		//-- si se trata de Linux o Windows
		sp = new SerialPort("/dev/ttyUSB0", 9600);

		//-- Abrir puerto serie
		sp.Open();

		//-- Configurar Timeout
		sp.ReadTimeout = 400;

		for (;;) {
			ok=Leer_Chronopic();
			if (ok) Console.WriteLine("TRAMA OK");
			else Console.WriteLine("Timeout!");
		}
	}

	public static bool Leer_Chronopic()
	{
		//-- Trama de respuesta
		byte[] respuesta = new byte[4];

		//-- Esperar hasta recibir una trama completa
		int count=0;
		int n;
		do {
			n = sp.Read(respuesta,count,4-count);
			count+=n;
		} while (count<4 && n!=-1);

		//-- Si hay error o timeout devolver false
		if (n==-1) return false;

		//-- La trama debe comenzar con 'X', sino
		//-- no es correcta
		if (respuesta[0]!=(byte)'X') return false;

		return true;
	}

}

