/***********************************************************/
/* test-saltos.mono    Juan Gonzalez Gomez. Febrero 2005   */
/*---------------------------------------------------------*/
/* Medir el tiempo de vuelo de los saltos                  */
/* Licencia GPL                                            */
/***********************************************************/

using System;
using System.IO.Ports;

class Test {
  
  //-- Estado del automata
  enum Automata {
    ON,
    OFF
  }
  
  /**********************/
  /* PROGRAMA PRINCIPAL */
  /**********************/
  public static void Main()
  {
    Chronopic.Plataforma estado_plataforma;
    Automata estado_automata;  
    SerialPort sp;
    double timestamp;
    double toff;
    bool ok;
    
		
    //-- Crear puerto serie		
		sp = new SerialPort("/dev/ttyUSB0");
    
    //-- Abrir puerto serie. Si ocurre algun error
    //-- Se lanzara una excepcion
    try {
      sp.Open();
    } catch (Exception e){
       Console.WriteLine("Error al abrir puerto serie");
       Console.WriteLine(e);
       Environment.Exit(1);
    }
    
    //-- Crear objeto chronopic, para acceder al chronopic
    Chronopic cp = new Chronopic(sp);
    
    //-- Obtener el estado inicial de la plataforma
    ok=cp.Read_platform(out estado_plataforma);
    if (!ok) {
      //-- Si hay error terminar
      Console.WriteLine("Error: {0}",cp.Error);
      System.Environment.Exit(-1);
    }
    Console.WriteLine("Plataforma: {0}",estado_plataforma);
    
    //-- Establecer el estado inicial del automata
    if (estado_plataforma==Chronopic.Plataforma.ON) 
      estado_automata=Automata.ON;
    else {
      Console.WriteLine("Suba a la plataforma para realizar el salto");
      
      //-- Esperar a que llegue una trama con el estado de la plataforma
      //-- igual a ON. Esto indica que el usuario se ha subido
      do {
        ok = cp.Read_event(out timestamp, out estado_plataforma);
      } while (!ok);
      
      //-- Se han subido a la plataforma
      estado_automata = Automata.ON;
    }
    
    Console.WriteLine("");
    Console.WriteLine("Puede saltar cuando quiera");
    Console.WriteLine("Pulse control-c para finalizar la sesion");
    Console.WriteLine("-----------------------------------------"); 
    
    while(true) {
      //-- Esperar a que llegue una trama
      do {
        ok = cp.Read_event(out timestamp, out estado_plataforma);
      } while (ok==false);
       
      //-- Segun el estado del automata
      switch(estado_automata) {
      
        case Automata.OFF: //-- Usuario estaba en el aire
        
          //-- Si ha aterrizado
          if (estado_plataforma==Chronopic.Plataforma.ON) {
          
            //-- Pasar al estado ON
            estado_automata=Automata.ON;
            
            //-- Registrar tiempo de vuelo
            toff = timestamp;
            
            //-- Imprimir informacion
            Console.WriteLine("Tiempo de vuelo: {0:f1} ms",toff);
          }
          break;
          
        case Automata.ON: //-- Usuario estaba en la plataforma
        
          //-- Si ahora esta en el aire...
          if (estado_plataforma==Chronopic.Plataforma.OFF) {
            
            //-- Pasar al estado OFF
            estado_automata=Automata.OFF;
          }
          break;
      } 
    } 
  }
}
