/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * This file is part of capuchin-glib. 
 *
 * Copyright (C) Sebastian Pölsterl 2008 <marduk@k-d-w.org>
 * 
 * capuchin-glib is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * 
 * capuchin-glib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with capuchin-glib.
 * If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CAPUCHIN_G_PLUGIN_AUTHOR_H_
#define _CAPUCHIN_G_PLUGIN_AUTHOR_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define CAPUCHIN_TYPE_G_PLUGIN_AUTHOR             (capuchin_g_plugin_author_get_type ())
#define CAPUCHIN_G_PLUGIN_AUTHOR(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPUCHIN_TYPE_G_PLUGIN_AUTHOR, CapuchinGPluginAuthor))
#define CAPUCHIN_G_PLUGIN_AUTHOR_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CAPUCHIN_TYPE_G_PLUGIN_AUTHOR, CapuchinGPluginAuthorClass))
#define CAPUCHIN_IS_G_PLUGIN_AUTHOR(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPUCHIN_TYPE_G_PLUGIN_AUTHOR))
#define CAPUCHIN_IS_G_PLUGIN_AUTHOR_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CAPUCHIN_TYPE_G_PLUGIN_AUTHOR))
#define CAPUCHIN_G_PLUGIN_AUTHOR_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CAPUCHIN_TYPE_G_PLUGIN_AUTHOR, CapuchinGPluginAuthorClass))

typedef struct _CapuchinGPluginAuthorClass CapuchinGPluginAuthorClass;
typedef struct _CapuchinGPluginAuthor CapuchinGPluginAuthor;
typedef struct _CapuchinGPluginAuthorPrivate CapuchinGPluginAuthorPrivate;

struct _CapuchinGPluginAuthorClass
{
	GObjectClass parent_class;
};

struct _CapuchinGPluginAuthor
{
	GObject parent_instance;
	CapuchinGPluginAuthorPrivate *priv;
};

GType capuchin_g_plugin_author_get_type (void) G_GNUC_CONST;
CapuchinGPluginAuthor* capuchin_g_plugin_author_new (const gchar *name, const gchar *email);

G_END_DECLS

#endif /* _CAPUCHIN_G_PLUGIN_AUTHOR_H_ */
