/* util-string.c generated by valac 0.26.1, the Vala compiler
 * generated from util-string.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))


extern gchar california_string_NUL;
gchar california_string_NUL = '\0';

gboolean california_string_is_empty (const gchar* str);
gint california_string_stricmp (const gchar* a, const gchar* b);
guint california_string_ci_hash (const gchar* str);
gboolean california_string_ci_equal (const gchar* a, const gchar* b);
gboolean california_string_ascii_ci_equal (const gchar* a, const gchar* b);
gchar* california_string_reduce_whitespace (const gchar* str);
gboolean california_string_is_numeric (const gchar* str);
gchar* california_string_remove_leading_chars (const gchar* str, gunichar ch, const gchar* delims);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 47 "util-string.c"
}


inline gboolean california_string_is_empty (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = str;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_ == NULL) {
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp0_ = TRUE;
#line 61 "util-string.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gchar _tmp3_ = '\0';
		gchar _tmp4_ = '\0';
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp2_ = str;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp3_ = string_get (_tmp2_, (glong) 0);
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp4_ = california_string_NUL;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 74 "util-string.c"
	}
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp0_;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 80 "util-string.c"
}


gint california_string_stricmp (const gchar* a, const gchar* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 15 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 15 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = g_strcmp0;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = a;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) (-1));
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp3_ = _tmp2_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp4_ = b;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) (-1));
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp6_ = _tmp5_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp7_ = _tmp0_ (_tmp3_, _tmp6_);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp8_ = _tmp7_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_g_free0 (_tmp6_);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_g_free0 (_tmp3_);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp8_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 125 "util-string.c"
}


guint california_string_ci_hash (const gchar* str) {
	guint result = 0U;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 19 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (str != NULL, 0U);
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = g_utf8_casefold (_tmp0_, (gssize) (-1));
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = _tmp1_;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp3_ = g_str_hash (_tmp2_);
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp4_ = _tmp3_;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_g_free0 (_tmp2_);
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp4_;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 154 "util-string.c"
}


gboolean california_string_ci_equal (const gchar* a, const gchar* b) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 23 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 23 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = a;
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = b;
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = california_string_stricmp (_tmp0_, _tmp1_);
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp2_ == 0;
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 177 "util-string.c"
}


gboolean california_string_ascii_ci_equal (const gchar* a, const gchar* b) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 27 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 27 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 28 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = a;
#line 28 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = b;
#line 28 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = g_ascii_strcasecmp (_tmp0_, _tmp1_);
#line 28 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp2_ == 0;
#line 28 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 200 "util-string.c"
}


/**
 * Removes redundant whitespace (including tabs and newlines) and strips whitespace from beginning
 * and end of string.
 */
static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1015 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1016 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1016 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1016 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1017 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1017 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 226 "util-string.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1018 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1018 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1018 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		if (c) {
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 241 "util-string.c"
		}
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 245 "util-string.c"
	} else {
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		if (c) {
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 253 "util-string.c"
		}
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 257 "util-string.c"
	}
#line 1015 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (c) {
#line 1015 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 263 "util-string.c"
	}
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1099 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1100 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1100 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1101 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1101 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_strchomp (_tmp1_);
#line 1102 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _result_;
#line 1102 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 287 "util-string.c"
}


gchar* california_string_reduce_whitespace (const gchar* str) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gchar _tmp2_ = '\0';
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	gunichar ch = 0U;
	gunichar last_ch = 0U;
	gchar _tmp6_ = '\0';
	gint index = 0;
	GString* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
#line 35 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 36 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 36 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 36 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = california_string_NUL;
#line 36 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_ == _tmp2_) {
#line 315 "util-string.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 37 "/home/jim/git/california/src/util/util-string.vala"
		_tmp3_ = str;
#line 37 "/home/jim/git/california/src/util/util-string.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 37 "/home/jim/git/california/src/util/util-string.vala"
		result = _tmp4_;
#line 37 "/home/jim/git/california/src/util/util-string.vala"
		return result;
#line 326 "util-string.c"
	}
#line 39 "/home/jim/git/california/src/util/util-string.vala"
	_tmp5_ = g_string_new ("");
#line 39 "/home/jim/git/california/src/util/util-string.vala"
	builder = _tmp5_;
#line 41 "/home/jim/git/california/src/util/util-string.vala"
	_tmp6_ = california_string_NUL;
#line 41 "/home/jim/git/california/src/util/util-string.vala"
	last_ch = (gunichar) _tmp6_;
#line 42 "/home/jim/git/california/src/util/util-string.vala"
	index = 0;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
	while (TRUE) {
#line 340 "util-string.c"
		const gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		gunichar _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		gunichar _tmp21_ = 0U;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
		_tmp7_ = str;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
		_tmp9_ = string_get_next_char (_tmp7_, &index, &_tmp8_);
#line 43 "/home/jim/git/california/src/util/util-string.vala"
		ch = _tmp8_;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp9_) {
#line 43 "/home/jim/git/california/src/util/util-string.vala"
			break;
#line 357 "util-string.c"
		}
#line 46 "/home/jim/git/california/src/util/util-string.vala"
		_tmp10_ = ch;
#line 46 "/home/jim/git/california/src/util/util-string.vala"
		_tmp11_ = g_unichar_isspace (_tmp10_);
#line 46 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp11_) {
#line 365 "util-string.c"
			gboolean _tmp12_ = FALSE;
			gunichar _tmp13_ = 0U;
			gchar _tmp14_ = '\0';
#line 47 "/home/jim/git/california/src/util/util-string.vala"
			_tmp13_ = last_ch;
#line 47 "/home/jim/git/california/src/util/util-string.vala"
			_tmp14_ = california_string_NUL;
#line 47 "/home/jim/git/california/src/util/util-string.vala"
			if (_tmp13_ != ((gunichar) _tmp14_)) {
#line 375 "util-string.c"
				gunichar _tmp15_ = 0U;
				gboolean _tmp16_ = FALSE;
#line 47 "/home/jim/git/california/src/util/util-string.vala"
				_tmp15_ = last_ch;
#line 47 "/home/jim/git/california/src/util/util-string.vala"
				_tmp16_ = g_unichar_isspace (_tmp15_);
#line 47 "/home/jim/git/california/src/util/util-string.vala"
				_tmp12_ = !_tmp16_;
#line 384 "util-string.c"
			} else {
#line 47 "/home/jim/git/california/src/util/util-string.vala"
				_tmp12_ = FALSE;
#line 388 "util-string.c"
			}
#line 47 "/home/jim/git/california/src/util/util-string.vala"
			if (_tmp12_) {
#line 392 "util-string.c"
				GString* _tmp17_ = NULL;
				gunichar _tmp18_ = 0U;
#line 48 "/home/jim/git/california/src/util/util-string.vala"
				_tmp17_ = builder;
#line 48 "/home/jim/git/california/src/util/util-string.vala"
				_tmp18_ = ch;
#line 48 "/home/jim/git/california/src/util/util-string.vala"
				g_string_append_unichar (_tmp17_, _tmp18_);
#line 401 "util-string.c"
			}
		} else {
			GString* _tmp19_ = NULL;
			gunichar _tmp20_ = 0U;
#line 50 "/home/jim/git/california/src/util/util-string.vala"
			_tmp19_ = builder;
#line 50 "/home/jim/git/california/src/util/util-string.vala"
			_tmp20_ = ch;
#line 50 "/home/jim/git/california/src/util/util-string.vala"
			g_string_append_unichar (_tmp19_, _tmp20_);
#line 412 "util-string.c"
		}
#line 53 "/home/jim/git/california/src/util/util-string.vala"
		_tmp21_ = ch;
#line 53 "/home/jim/git/california/src/util/util-string.vala"
		last_ch = _tmp21_;
#line 418 "util-string.c"
	}
#line 58 "/home/jim/git/california/src/util/util-string.vala"
	_tmp22_ = builder;
#line 58 "/home/jim/git/california/src/util/util-string.vala"
	_tmp23_ = _tmp22_->str;
#line 58 "/home/jim/git/california/src/util/util-string.vala"
	_tmp24_ = string_chomp (_tmp23_);
#line 58 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp24_;
#line 58 "/home/jim/git/california/src/util/util-string.vala"
	_g_string_free0 (builder);
#line 58 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 432 "util-string.c"
}


/**
 * Returns true if every character in the string is a numeric digit.
 */
gboolean california_string_is_numeric (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gunichar ch = 0U;
	gint index = 0;
#line 65 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 65 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 65 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_) {
#line 66 "/home/jim/git/california/src/util/util-string.vala"
		result = FALSE;
#line 66 "/home/jim/git/california/src/util/util-string.vala"
		return result;
#line 455 "util-string.c"
	}
#line 69 "/home/jim/git/california/src/util/util-string.vala"
	index = 0;
#line 70 "/home/jim/git/california/src/util/util-string.vala"
	while (TRUE) {
#line 461 "util-string.c"
		const gchar* _tmp2_ = NULL;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
#line 70 "/home/jim/git/california/src/util/util-string.vala"
		_tmp2_ = str;
#line 70 "/home/jim/git/california/src/util/util-string.vala"
		_tmp4_ = string_get_next_char (_tmp2_, &index, &_tmp3_);
#line 70 "/home/jim/git/california/src/util/util-string.vala"
		ch = _tmp3_;
#line 70 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp4_) {
#line 70 "/home/jim/git/california/src/util/util-string.vala"
			break;
#line 477 "util-string.c"
		}
#line 71 "/home/jim/git/california/src/util/util-string.vala"
		_tmp5_ = ch;
#line 71 "/home/jim/git/california/src/util/util-string.vala"
		_tmp6_ = g_unichar_isdigit (_tmp5_);
#line 71 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp6_) {
#line 72 "/home/jim/git/california/src/util/util-string.vala"
			result = FALSE;
#line 72 "/home/jim/git/california/src/util/util-string.vala"
			return result;
#line 489 "util-string.c"
		}
	}
#line 75 "/home/jim/git/california/src/util/util-string.vala"
	result = TRUE;
#line 75 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 496 "util-string.c"
}


/**
 * Removes leading characters from throughout the string.
 *
 * Both the leading character and what constitutes tokens can be specified.
 *
 * Results are undefined if the leading character is also found in the delimiter string.
 */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 528 "util-string.c"
		gchar* _tmp4_ = NULL;
#line 924 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 536 "util-string.c"
	} else {
#line 926 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 542 "util-string.c"
	}
}


gchar* california_string_remove_leading_chars (const gchar* str, gunichar ch, const gchar* delims) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GString* builder = NULL;
	GString* _tmp4_ = NULL;
	gunichar current_ch = 0U;
	gint index = 0;
	gboolean leading = FALSE;
	GString* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
#line 85 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (delims != NULL, NULL);
#line 86 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 86 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 86 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_) {
#line 567 "util-string.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 87 "/home/jim/git/california/src/util/util-string.vala"
		_tmp2_ = str;
#line 87 "/home/jim/git/california/src/util/util-string.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 87 "/home/jim/git/california/src/util/util-string.vala"
		result = _tmp3_;
#line 87 "/home/jim/git/california/src/util/util-string.vala"
		return result;
#line 578 "util-string.c"
	}
#line 89 "/home/jim/git/california/src/util/util-string.vala"
	_tmp4_ = g_string_new ("");
#line 89 "/home/jim/git/california/src/util/util-string.vala"
	builder = _tmp4_;
#line 91 "/home/jim/git/california/src/util/util-string.vala"
	index = 0;
#line 92 "/home/jim/git/california/src/util/util-string.vala"
	leading = TRUE;
#line 93 "/home/jim/git/california/src/util/util-string.vala"
	while (TRUE) {
#line 590 "util-string.c"
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gint _tmp10_ = 0;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		GString* _tmp17_ = NULL;
		gunichar _tmp18_ = 0U;
#line 93 "/home/jim/git/california/src/util/util-string.vala"
		_tmp5_ = str;
#line 93 "/home/jim/git/california/src/util/util-string.vala"
		_tmp7_ = string_get_next_char (_tmp5_, &index, &_tmp6_);
#line 93 "/home/jim/git/california/src/util/util-string.vala"
		current_ch = _tmp6_;
#line 93 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp7_) {
#line 93 "/home/jim/git/california/src/util/util-string.vala"
			break;
#line 611 "util-string.c"
		}
#line 95 "/home/jim/git/california/src/util/util-string.vala"
		_tmp8_ = delims;
#line 95 "/home/jim/git/california/src/util/util-string.vala"
		_tmp9_ = current_ch;
#line 95 "/home/jim/git/california/src/util/util-string.vala"
		_tmp10_ = string_index_of_char (_tmp8_, _tmp9_, 0);
#line 95 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp10_ >= 0) {
#line 621 "util-string.c"
			GString* _tmp11_ = NULL;
			gunichar _tmp12_ = 0U;
#line 96 "/home/jim/git/california/src/util/util-string.vala"
			leading = TRUE;
#line 97 "/home/jim/git/california/src/util/util-string.vala"
			_tmp11_ = builder;
#line 97 "/home/jim/git/california/src/util/util-string.vala"
			_tmp12_ = current_ch;
#line 97 "/home/jim/git/california/src/util/util-string.vala"
			g_string_append_unichar (_tmp11_, _tmp12_);
#line 99 "/home/jim/git/california/src/util/util-string.vala"
			continue;
#line 634 "util-string.c"
		}
#line 103 "/home/jim/git/california/src/util/util-string.vala"
		_tmp14_ = leading;
#line 103 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp14_) {
#line 640 "util-string.c"
			gunichar _tmp15_ = 0U;
			gunichar _tmp16_ = 0U;
#line 103 "/home/jim/git/california/src/util/util-string.vala"
			_tmp15_ = current_ch;
#line 103 "/home/jim/git/california/src/util/util-string.vala"
			_tmp16_ = ch;
#line 103 "/home/jim/git/california/src/util/util-string.vala"
			_tmp13_ = _tmp15_ == _tmp16_;
#line 649 "util-string.c"
		} else {
#line 103 "/home/jim/git/california/src/util/util-string.vala"
			_tmp13_ = FALSE;
#line 653 "util-string.c"
		}
#line 103 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp13_) {
#line 104 "/home/jim/git/california/src/util/util-string.vala"
			continue;
#line 659 "util-string.c"
		}
#line 107 "/home/jim/git/california/src/util/util-string.vala"
		leading = FALSE;
#line 108 "/home/jim/git/california/src/util/util-string.vala"
		_tmp17_ = builder;
#line 108 "/home/jim/git/california/src/util/util-string.vala"
		_tmp18_ = current_ch;
#line 108 "/home/jim/git/california/src/util/util-string.vala"
		g_string_append_unichar (_tmp17_, _tmp18_);
#line 669 "util-string.c"
	}
#line 111 "/home/jim/git/california/src/util/util-string.vala"
	_tmp19_ = builder;
#line 111 "/home/jim/git/california/src/util/util-string.vala"
	_tmp20_ = _tmp19_->str;
#line 111 "/home/jim/git/california/src/util/util-string.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 111 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp21_;
#line 111 "/home/jim/git/california/src/util/util-string.vala"
	_g_string_free0 (builder);
#line 111 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 683 "util-string.c"
}



