/* util-email.c generated by valac 0.26.1, the Vala compiler
 * generated from util-email.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))


extern GRegex* california_email_email_regex;
GRegex* california_email_email_regex = NULL;

void california_email_init (GError** error);
void california_email_terminate (void);
gboolean california_email_is_valid_mailbox (const gchar* str);
gchar* california_email_generate_mailto_text (const gchar* mailbox);
SoupURI* california_email_generate_mailto_uri (const gchar* mailbox, GError** error);
SoupURI* california_uri_parse (const gchar* uri, GError** error);
static void _vala_SoupURI_free (SoupURI* self);


void california_email_init (GError** error) {
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_ = NULL;
	GRegex* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 14 "/home/jim/git/california/src/util/util-email.vala"
	_tmp1_ = g_regex_new ("[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\\.)+[A-Z]{2,5}", G_REGEX_CASELESS, 0, &_inner_error_);
#line 14 "/home/jim/git/california/src/util/util-email.vala"
	_tmp0_ = _tmp1_;
#line 14 "/home/jim/git/california/src/util/util-email.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14 "/home/jim/git/california/src/util/util-email.vala"
		g_propagate_error (error, _inner_error_);
#line 14 "/home/jim/git/california/src/util/util-email.vala"
		return;
#line 49 "util-email.c"
	}
#line 14 "/home/jim/git/california/src/util/util-email.vala"
	_tmp2_ = _tmp0_;
#line 14 "/home/jim/git/california/src/util/util-email.vala"
	_tmp0_ = NULL;
#line 14 "/home/jim/git/california/src/util/util-email.vala"
	_g_regex_unref0 (california_email_email_regex);
#line 14 "/home/jim/git/california/src/util/util-email.vala"
	california_email_email_regex = _tmp2_;
#line 11 "/home/jim/git/california/src/util/util-email.vala"
	_g_regex_unref0 (_tmp0_);
#line 61 "util-email.c"
}


void california_email_terminate (void) {
#line 18 "/home/jim/git/california/src/util/util-email.vala"
	_g_regex_unref0 (california_email_email_regex);
#line 18 "/home/jim/git/california/src/util/util-email.vala"
	california_email_email_regex = NULL;
#line 70 "util-email.c"
}


/**
 * Validates a string as a valid RFC822 mailbox (i.e. email) address.
 */
gboolean california_email_is_valid_mailbox (const gchar* str) {
	gboolean result = FALSE;
	GRegex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 24 "/home/jim/git/california/src/util/util-email.vala"
	g_return_val_if_fail (str != NULL, FALSE);
#line 25 "/home/jim/git/california/src/util/util-email.vala"
	_tmp0_ = california_email_email_regex;
#line 25 "/home/jim/git/california/src/util/util-email.vala"
	_tmp1_ = str;
#line 25 "/home/jim/git/california/src/util/util-email.vala"
	_tmp2_ = g_regex_match (_tmp0_, _tmp1_, 0, NULL);
#line 25 "/home/jim/git/california/src/util/util-email.vala"
	result = _tmp2_;
#line 25 "/home/jim/git/california/src/util/util-email.vala"
	return result;
#line 94 "util-email.c"
}


/**
 * Generates a valid mailto: as a text string.
 *
 * No validity checking is done here on the mailbox; use {@link is_valid_mailbox}.
 */
gchar* california_email_generate_mailto_text (const gchar* mailbox) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 33 "/home/jim/git/california/src/util/util-email.vala"
	g_return_val_if_fail (mailbox != NULL, NULL);
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	_tmp0_ = mailbox;
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	_tmp1_ = g_uri_escape_string (_tmp0_, "@", TRUE);
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	_tmp2_ = _tmp1_;
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	_tmp3_ = g_strdup_printf ("mailto:%s", _tmp2_);
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	_tmp4_ = _tmp3_;
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	_g_free0 (_tmp2_);
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	result = _tmp4_;
#line 34 "/home/jim/git/california/src/util/util-email.vala"
	return result;
#line 128 "util-email.c"
}


/**
 * Generates a valid mailto: Soup.URI given a mailbox (i.e. email) address.
 *
 * No validity checking is done here on the mailbox; use {@link is_valid_mailbox}.
 */
static void _vala_SoupURI_free (SoupURI* self) {
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 140 "util-email.c"
}


SoupURI* california_email_generate_mailto_uri (const gchar* mailbox, GError** error) {
	SoupURI* result = NULL;
	SoupURI* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SoupURI* _tmp4_ = NULL;
	SoupURI* _tmp5_ = NULL;
	SoupURI* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 42 "/home/jim/git/california/src/util/util-email.vala"
	g_return_val_if_fail (mailbox != NULL, NULL);
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp1_ = mailbox;
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp2_ = california_email_generate_mailto_text (_tmp1_);
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp3_ = _tmp2_;
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp4_ = california_uri_parse (_tmp3_, &_inner_error_);
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp5_ = _tmp4_;
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_g_free0 (_tmp3_);
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp0_ = _tmp5_;
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/jim/git/california/src/util/util-email.vala"
		g_propagate_error (error, _inner_error_);
#line 43 "/home/jim/git/california/src/util/util-email.vala"
		return NULL;
#line 176 "util-email.c"
	}
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp6_ = _tmp0_;
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	_tmp0_ = NULL;
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	result = _tmp6_;
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	__vala_SoupURI_free0 (_tmp0_);
#line 43 "/home/jim/git/california/src/util/util-email.vala"
	return result;
#line 188 "util-email.c"
}



