/* toolkit-card.c generated by valac 0.26.1, the Vala compiler
 * generated from toolkit-card.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define CALIFORNIA_TOOLKIT_TYPE_CARD (california_toolkit_card_get_type ())
#define CALIFORNIA_TOOLKIT_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard))
#define CALIFORNIA_TOOLKIT_IS_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD))
#define CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCardIface))

typedef struct _CaliforniaToolkitCard CaliforniaToolkitCard;
typedef struct _CaliforniaToolkitCardIface CaliforniaToolkitCardIface;

#define CALIFORNIA_TOOLKIT_CARD_TYPE_JUMP (california_toolkit_card_jump_get_type ())

#define CALIFORNIA_TOOLKIT_CARD_TYPE_DISMISS_REASON (california_toolkit_card_dismiss_reason_get_type ())

#define CALIFORNIA_TOOLKIT_TYPE_DECK (california_toolkit_deck_get_type ())
#define CALIFORNIA_TOOLKIT_DECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck))
#define CALIFORNIA_TOOLKIT_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))
#define CALIFORNIA_TOOLKIT_IS_DECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_IS_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_DECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))

typedef struct _CaliforniaToolkitDeck CaliforniaToolkitDeck;
typedef struct _CaliforniaToolkitDeckClass CaliforniaToolkitDeckClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	CALIFORNIA_TOOLKIT_CARD_JUMP_HOME,
	CALIFORNIA_TOOLKIT_CARD_JUMP_BACK,
	CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT
} CaliforniaToolkitCardJump;

struct _CaliforniaToolkitCardIface {
	GTypeInterface parent_iface;
	void (*jumped_to) (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
	const gchar* (*get_card_id) (CaliforniaToolkitCard* self);
	const gchar* (*get_title) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_default_widget) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_initial_focus) (CaliforniaToolkitCard* self);
};

typedef enum  {
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_SUCCESS,
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_FAILED,
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_USER_CLOSED,
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_ABORTED
} CaliforniaToolkitCardDismissReason;



GType california_toolkit_card_jump_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_dismiss_reason_get_type (void) G_GNUC_CONST;
void california_toolkit_card_jumped_to (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
void california_toolkit_card_notify_user_closed (CaliforniaToolkitCard* self);
void california_toolkit_card_notify_aborted (CaliforniaToolkitCard* self);
void california_toolkit_card_notify_success (CaliforniaToolkitCard* self);
void california_toolkit_card_notify_failure (CaliforniaToolkitCard* self, const gchar* user_message);
gboolean california_string_is_empty (const gchar* str);
void california_toolkit_card_report_error (CaliforniaToolkitCard* self, const gchar* user_message);
void california_toolkit_card_jump_home_or_user_closed (CaliforniaToolkitCard* self);
GType california_toolkit_deck_get_type (void) G_GNUC_CONST;
CaliforniaToolkitDeck* california_toolkit_card_get_deck (CaliforniaToolkitCard* self);
CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self);
const gchar* california_toolkit_card_get_card_id (CaliforniaToolkitCard* self);
const gchar* california_toolkit_card_get_title (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_card_get_default_widget (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_card_get_initial_focus (CaliforniaToolkitCard* self);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


/**
     * Enumerates the various reasons a {@link Card} may be jumped to.
     */
GType california_toolkit_card_jump_get_type (void) {
	static volatile gsize california_toolkit_card_jump_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_card_jump_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, "CALIFORNIA_TOOLKIT_CARD_JUMP_HOME", "home"}, {CALIFORNIA_TOOLKIT_CARD_JUMP_BACK, "CALIFORNIA_TOOLKIT_CARD_JUMP_BACK", "back"}, {CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT, "CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT", "direct"}, {0, NULL, NULL}};
		GType california_toolkit_card_jump_type_id;
		california_toolkit_card_jump_type_id = g_enum_register_static ("CaliforniaToolkitCardJump", values);
		g_once_init_leave (&california_toolkit_card_jump_type_id__volatile, california_toolkit_card_jump_type_id);
	}
	return california_toolkit_card_jump_type_id__volatile;
}


/**
     * Reason for dismissing the {@link Deck}.
     */
GType california_toolkit_card_dismiss_reason_get_type (void) {
	static volatile gsize california_toolkit_card_dismiss_reason_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_card_dismiss_reason_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_SUCCESS, "CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_SUCCESS", "success"}, {CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_FAILED, "CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_FAILED", "failed"}, {CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_USER_CLOSED, "CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_USER_CLOSED", "user-closed"}, {CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_ABORTED, "CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_ABORTED", "aborted"}, {0, NULL, NULL}};
		GType california_toolkit_card_dismiss_reason_type_id;
		california_toolkit_card_dismiss_reason_type_id = g_enum_register_static ("CaliforniaToolkitCardDismissReason", values);
		g_once_init_leave (&california_toolkit_card_dismiss_reason_type_id__volatile, california_toolkit_card_dismiss_reason_type_id);
	}
	return california_toolkit_card_dismiss_reason_type_id__volatile;
}


/**
     * Called by {@link Deck} when the {@link Card} has been activated, i.e. put to the "top" of
     * the Deck.
     *
     * message may be null even if the Card expects one; generally this means {@link jump_back}
     * or {@link jump_home} was invoked, resulting in this Card being activated.  The supplied
     * {@link Jump} reason is useful for context.  There are code paths where {@link Jump.HOME}
     * accepts a message; {@link Jump.BACK} will never supply a message.
     *
     * Due to some mechanism inside of GSignal or Vala, it's possible for a caller to pass null
     * that gets translated into a Value object holding a null pointer.  Deck will watch for this
     * situation and convert those Values into a null reference.  This means passing Value(null)
     * as a message is impossible.
     *
     * In order for this null-checking to work, the message must be holding a pointer, Object, or
     * a string.  Other types (including Vala-generated fundamental types!) are not safe-guarded.
     *
     * This is called before dealing with {@link default_widget} and {@link initial_focus}, so
     * changes to those properties in this call, if need be.
     */
void california_toolkit_card_jumped_to (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message) {
#line 159 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self));
#line 159 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->jumped_to (self, from, reason, message);
#line 141 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} due to the user requesting it be closed or cancelled.
     */
void california_toolkit_card_notify_user_closed (CaliforniaToolkitCard* self) {
#line 165 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_USER_CLOSED);
#line 151 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} due to programmatic reasons.
     */
void california_toolkit_card_notify_aborted (CaliforniaToolkitCard* self) {
#line 172 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_ABORTED);
#line 161 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} and notify that the user has successfully completed the task.
     */
void california_toolkit_card_notify_success (CaliforniaToolkitCard* self) {
#line 179 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_SUCCESS);
#line 171 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} and notify that the operation has failed.
     */
void california_toolkit_card_notify_failure (CaliforniaToolkitCard* self, const gchar* user_message) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 186 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp0_ = user_message;
#line 186 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 186 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (!_tmp1_) {
#line 187 "toolkit-card.c"
		const gchar* _tmp2_ = NULL;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		_tmp2_ = user_message;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_emit_by_name (self, "error-message", _tmp2_);
#line 193 "toolkit-card.c"
	}
#line 189 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_FAILED);
#line 197 "toolkit-card.c"
}


/**
     * Report a failure message but do not dismiss the {@link Deck}.
     */
void california_toolkit_card_report_error (CaliforniaToolkitCard* self, const gchar* user_message) {
	const gchar* _tmp0_ = NULL;
#line 195 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_if_fail (user_message != NULL);
#line 196 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp0_ = user_message;
#line 196 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "error-message", _tmp0_);
#line 212 "toolkit-card.c"
}


/**
     * Jump home or, if this {@link Card} is the home card, dismiss {@link Deck}.
     */
void california_toolkit_card_jump_home_or_user_closed (CaliforniaToolkitCard* self) {
	CaliforniaToolkitDeck* _tmp0_ = NULL;
	CaliforniaToolkitDeck* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
	CaliforniaToolkitCard* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp0_ = california_toolkit_card_get_deck (self);
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp1_ = _tmp0_;
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp2_ = california_toolkit_deck_get_home (_tmp1_);
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp3_ = _tmp2_;
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp4_ = _tmp3_;
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp5_ = _tmp4_ == self;
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_g_object_unref0 (_tmp4_);
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (_tmp5_) {
#line 204 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		california_toolkit_card_notify_user_closed (self);
#line 244 "toolkit-card.c"
	} else {
#line 206 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_emit_by_name (self, "jump-home");
#line 248 "toolkit-card.c"
	}
}


const gchar* california_toolkit_card_get_card_id (CaliforniaToolkitCard* self) {
#line 68 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 68 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_card_id (self);
#line 258 "toolkit-card.c"
}


const gchar* california_toolkit_card_get_title (CaliforniaToolkitCard* self) {
#line 75 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 75 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_title (self);
#line 267 "toolkit-card.c"
}


GtkWidget* california_toolkit_card_get_default_widget (CaliforniaToolkitCard* self) {
#line 82 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 82 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_default_widget (self);
#line 276 "toolkit-card.c"
}


GtkWidget* california_toolkit_card_get_initial_focus (CaliforniaToolkitCard* self) {
#line 92 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 92 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_initial_focus (self);
#line 285 "toolkit-card.c"
}


CaliforniaToolkitDeck* california_toolkit_card_get_deck (CaliforniaToolkitCard* self) {
	CaliforniaToolkitDeck* result;
	GtkContainer* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
#line 97 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 97 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp0_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 97 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp1_ = _tmp0_;
#line 97 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, CALIFORNIA_TOOLKIT_TYPE_DECK) ? ((CaliforniaToolkitDeck*) _tmp1_) : NULL;
#line 97 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return result;
#line 303 "toolkit-card.c"
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_if_fail (n_param_values == 3);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = closure->data;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = param_values->data[0].v_pointer;
#line 322 "toolkit-card.c"
	} else {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = param_values->data[0].v_pointer;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = closure->data;
#line 328 "toolkit-card.c"
	}
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
#line 334 "toolkit-card.c"
}


static void california_toolkit_card_base_init (CaliforniaToolkitCardIface * iface) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	static gboolean initialized = FALSE;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (!initialized) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		initialized = TRUE;
#line 345 "toolkit-card.c"
		/**
		     * Each {@link Card} has its own identifier that should be unique within the {@link Deck}.
		     *
		     * In the Gtk.Stack, this is its name.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("card-id", "card-id", "card-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 353 "toolkit-card.c"
		/**
		     * A user-visible string that may be used elsewhere in the application.
		     *
		     * Gtk.StackSwitcher uses this title.  {@link Deck} does not use the title in any way.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 361 "toolkit-card.c"
		/** 
		     * The widget the {@link Card} wants to be default when navigated to.
		     *
		     * The widget must have can-default set to true.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("default-widget", "default-widget", "default-widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 369 "toolkit-card.c"
		/**
		     * The widget the {@link Card} wants to have initial focus when navigated to.
		     *
		     * Focus is set after {@link default_widget} is handled, so if this widget has receives-default
		     * set to true, it will get the default as well.
		     *
		     * The widget must have can-focus set to true.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("initial-focus", "initial-focus", "initial-focus", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 380 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} wishes to jump to another Card by its name.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("jump_to_card_by_id", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VALUE);
#line 386 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} wishes to jump to the previous Card in the {@link Deck}.
		     *
		     * Note that this Card's position in the navigation stack is lost; there is no "jump forward".
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("jump_back", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 394 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} wishes to jump to the first Card in the {@link Deck}.
		     *
		     * This clears the Deck's navigation stack, meaning {@link jump_back} will not return to
		     * this Card.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("jump_home", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 403 "toolkit-card.c"
		/**
		     * Fired when the {@link Deck}'s work is cancelled, closed, failure, or a success, whether due
		     * to programmatic reasons or by user request.
		     *
		     * Implementing classes should use one of the notify_ methods to ensure that proper signal
		     * order and values are issued.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("dismiss", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, CALIFORNIA_TOOLKIT_CARD_TYPE_DISMISS_REASON);
#line 413 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} needs to report an important error message to the user.
		     *
		     * Signal subscribers should not use this signal to close the deck, but merely report the
		     * message.
		     *
		     * Implementing classes should use one of the notify_ methods to ensure that proper signal
		     * order is maintained.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("error_message", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 425 "toolkit-card.c"
	}
}


/**
 * A Card is a single pane of widget(s) in a {@link Deck}.
 *
 * The navigation of Cards is tracked within their Deck, and Cards can request navigation via their
 * various signals.  They're also notified when nevigation which affects them is made.
 */
GType california_toolkit_card_get_type (void) {
	static volatile gsize california_toolkit_card_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_card_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaToolkitCardIface), (GBaseInitFunc) california_toolkit_card_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType california_toolkit_card_type_id;
		california_toolkit_card_type_id = g_type_register_static (G_TYPE_INTERFACE, "CaliforniaToolkitCard", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (california_toolkit_card_type_id, gtk_widget_get_type ());
		g_once_init_leave (&california_toolkit_card_type_id__volatile, california_toolkit_card_type_id);
	}
	return california_toolkit_card_type_id__volatile;
}



