/* toolkit-button-event.c generated by valac 0.26.1, the Vala compiler
 * generated from toolkit-button-event.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#define CALIFORNIA_TOOLKIT_TYPE_BUTTON (california_toolkit_button_get_type ())

#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT (california_toolkit_button_event_get_type ())
#define CALIFORNIA_TOOLKIT_BUTTON_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEvent))
#define CALIFORNIA_TOOLKIT_BUTTON_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEventClass))
#define CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT))
#define CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT))
#define CALIFORNIA_TOOLKIT_BUTTON_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEventClass))

typedef struct _CaliforniaToolkitButtonEvent CaliforniaToolkitButtonEvent;
typedef struct _CaliforniaToolkitButtonEventClass CaliforniaToolkitButtonEventClass;
typedef struct _CaliforniaToolkitButtonEventPrivate CaliforniaToolkitButtonEventPrivate;

#define CALIFORNIA_TYPE_SCHEDULED (california_scheduled_get_type ())
#define CALIFORNIA_SCHEDULED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduled))
#define CALIFORNIA_SCHEDULED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduledClass))
#define CALIFORNIA_IS_SCHEDULED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_SCHEDULED))
#define CALIFORNIA_IS_SCHEDULED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_SCHEDULED))
#define CALIFORNIA_SCHEDULED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduledClass))

typedef struct _CaliforniaScheduled CaliforniaScheduled;
typedef struct _CaliforniaScheduledClass CaliforniaScheduledClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	CALIFORNIA_TOOLKIT_BUTTON_PRIMARY,
	CALIFORNIA_TOOLKIT_BUTTON_SECONDARY,
	CALIFORNIA_TOOLKIT_BUTTON_TERTIARY,
	CALIFORNIA_TOOLKIT_BUTTON_OTHER
} CaliforniaToolkitButton;

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaToolkitButtonEvent {
	CaliforniaBaseObject parent_instance;
	CaliforniaToolkitButtonEventPrivate * priv;
};

struct _CaliforniaToolkitButtonEventClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaToolkitButtonEventPrivate {
	GtkWidget* _widget;
	CaliforniaToolkitButton _button;
	GdkEventType _press_type;
	GdkPoint _press_point;
	GdkPoint _release_point;
	CaliforniaScheduled* scheduled_click;
};

typedef void (*CaliforniaScheduledScheduleOnce) (void* user_data);

static gpointer california_toolkit_button_event_parent_class = NULL;

GType california_toolkit_button_get_type (void) G_GNUC_CONST;
CaliforniaToolkitButton california_toolkit_button_from_button_event (GdkEventButton* event);
GdkModifierType california_toolkit_button_get_modifier_mask (CaliforniaToolkitButton self);
GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_toolkit_button_event_get_type (void) G_GNUC_CONST;
GType california_scheduled_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_TOOLKIT_BUTTON_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEventPrivate))
enum  {
	CALIFORNIA_TOOLKIT_BUTTON_EVENT_DUMMY_PROPERTY,
	CALIFORNIA_TOOLKIT_BUTTON_EVENT_WIDGET,
	CALIFORNIA_TOOLKIT_BUTTON_EVENT_BUTTON,
	CALIFORNIA_TOOLKIT_BUTTON_EVENT_PRESS_TYPE
};
static void california_toolkit_button_event_cancel_click (CaliforniaToolkitButtonEvent* self);
#define CALIFORNIA_TOOLKIT_BUTTON_EVENT_SYNTHESIZED_CLICK_MSEC 125
CaliforniaToolkitButtonEvent* california_toolkit_button_event_new (GtkWidget* widget, GdkEventButton* press_event);
CaliforniaToolkitButtonEvent* california_toolkit_button_event_construct (GType object_type, GtkWidget* widget, GdkEventButton* press_event);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
static void california_toolkit_button_event_set_widget (CaliforniaToolkitButtonEvent* self, GtkWidget* value);
static void california_toolkit_button_event_set_button (CaliforniaToolkitButtonEvent* self, CaliforniaToolkitButton value);
static void california_toolkit_button_event_set_press_type (CaliforniaToolkitButtonEvent* self, GdkEventType value);
void california_scheduled_cancel (CaliforniaScheduled* self);
void california_toolkit_button_event_update_press (CaliforniaToolkitButtonEvent* self, GtkWidget* widget, GdkEventButton* press_event);
GtkWidget* california_toolkit_button_event_get_widget (CaliforniaToolkitButtonEvent* self);
CaliforniaToolkitButton california_toolkit_button_event_get_button (CaliforniaToolkitButtonEvent* self);
void california_toolkit_button_event_update_release (CaliforniaToolkitButtonEvent* self, GtkWidget* widget, GdkEventButton* release_event);
GdkEventType california_toolkit_button_event_get_press_type (CaliforniaToolkitButtonEvent* self);
static void ___lambda30_ (CaliforniaToolkitButtonEvent* self);
static void ____lambda30__california_scheduled_schedule_once (gpointer self);
CaliforniaScheduled* california_scheduled_new_once_after_msec (guint msec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_once_after_msec (GType object_type, guint msec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
static gchar* california_toolkit_button_event_real_to_string (CaliforniaBaseObject* base);
const gchar* california_toolkit_button_to_string (CaliforniaToolkitButton self);
const gchar* gdk_event_type_to_string (GdkEventType self);
void california_toolkit_button_event_get_press_point (CaliforniaToolkitButtonEvent* self, GdkPoint* result);
void california_toolkit_button_event_get_release_point (CaliforniaToolkitButtonEvent* self, GdkPoint* result);
static void california_toolkit_button_event_finalize (GObject* obj);
static void _vala_california_toolkit_button_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_toolkit_button_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Converts the button field of a Gdk.EventButton to a {@link Button} enumeration.
     */
CaliforniaToolkitButton california_toolkit_button_from_button_event (GdkEventButton* event) {
	CaliforniaToolkitButton result = 0;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 23 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_val_if_fail (event != NULL, 0);
#line 24 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = event;
#line 24 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp1_ = _tmp0_->button;
#line 24 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	switch (_tmp1_) {
#line 24 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case 1:
#line 152 "toolkit-button-event.c"
		{
#line 26 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = CALIFORNIA_TOOLKIT_BUTTON_PRIMARY;
#line 26 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 158 "toolkit-button-event.c"
		}
#line 24 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case 3:
#line 162 "toolkit-button-event.c"
		{
#line 29 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = CALIFORNIA_TOOLKIT_BUTTON_SECONDARY;
#line 29 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 168 "toolkit-button-event.c"
		}
#line 24 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case 2:
#line 172 "toolkit-button-event.c"
		{
#line 32 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = CALIFORNIA_TOOLKIT_BUTTON_TERTIARY;
#line 32 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 178 "toolkit-button-event.c"
		}
		default:
		{
#line 35 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = CALIFORNIA_TOOLKIT_BUTTON_OTHER;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 186 "toolkit-button-event.c"
		}
	}
}


/**
     * Returns the Gdk.ModifierType corresponding to this {@link Button}.
     *
     * {@link OTHER} merely means any button not {@link PRIMARY}, {@link SECONDARY}, or
     * {@link TERTIARY}.
     */
GdkModifierType california_toolkit_button_get_modifier_mask (CaliforniaToolkitButton self) {
	GdkModifierType result = 0;
#line 46 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	switch (self) {
#line 46 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_PRIMARY:
#line 204 "toolkit-button-event.c"
		{
#line 48 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = GDK_BUTTON1_MASK;
#line 48 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 210 "toolkit-button-event.c"
		}
#line 46 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_SECONDARY:
#line 214 "toolkit-button-event.c"
		{
#line 51 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = GDK_BUTTON2_MASK;
#line 51 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 220 "toolkit-button-event.c"
		}
#line 46 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_TERTIARY:
#line 224 "toolkit-button-event.c"
		{
#line 54 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = GDK_BUTTON3_MASK;
#line 54 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 230 "toolkit-button-event.c"
		}
#line 46 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_OTHER:
#line 234 "toolkit-button-event.c"
		{
#line 57 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			result = GDK_BUTTON4_MASK | GDK_BUTTON5_MASK;
#line 57 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			return result;
#line 240 "toolkit-button-event.c"
		}
		default:
		{
#line 60 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
			g_assert_not_reached ();
#line 246 "toolkit-button-event.c"
		}
	}
}


/**
 * Enumeration for (mouse) buttons.
 *
 * @see ButtonConnector
 */
GType california_toolkit_button_get_type (void) {
	static volatile gsize california_toolkit_button_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_button_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_TOOLKIT_BUTTON_PRIMARY, "CALIFORNIA_TOOLKIT_BUTTON_PRIMARY", "primary"}, {CALIFORNIA_TOOLKIT_BUTTON_SECONDARY, "CALIFORNIA_TOOLKIT_BUTTON_SECONDARY", "secondary"}, {CALIFORNIA_TOOLKIT_BUTTON_TERTIARY, "CALIFORNIA_TOOLKIT_BUTTON_TERTIARY", "tertiary"}, {CALIFORNIA_TOOLKIT_BUTTON_OTHER, "CALIFORNIA_TOOLKIT_BUTTON_OTHER", "other"}, {0, NULL, NULL}};
		GType california_toolkit_button_type_id;
		california_toolkit_button_type_id = g_enum_register_static ("CaliforniaToolkitButton", values);
		g_once_init_leave (&california_toolkit_button_type_id__volatile, california_toolkit_button_type_id);
	}
	return california_toolkit_button_type_id__volatile;
}


CaliforniaToolkitButtonEvent* california_toolkit_button_event_construct (GType object_type, GtkWidget* widget, GdkEventButton* press_event) {
	CaliforniaToolkitButtonEvent * self = NULL;
	GtkWidget* _tmp0_ = NULL;
	GdkEventButton* _tmp1_ = NULL;
	CaliforniaToolkitButton _tmp2_ = 0;
	GdkEventButton* _tmp3_ = NULL;
	GdkEventType _tmp4_ = 0;
	GdkEventButton* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	GdkEventButton* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
#line 108 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_val_if_fail (GTK_IS_WIDGET (widget), NULL);
#line 108 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_val_if_fail (press_event != NULL, NULL);
#line 108 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self = (CaliforniaToolkitButtonEvent*) california_base_object_construct (object_type);
#line 109 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = widget;
#line 109 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_set_widget (self, _tmp0_);
#line 110 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp1_ = press_event;
#line 110 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp2_ = california_toolkit_button_from_button_event (_tmp1_);
#line 110 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_set_button (self, _tmp2_);
#line 111 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp3_ = press_event;
#line 111 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp4_ = _tmp3_->type;
#line 111 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_set_press_type (self, _tmp4_);
#line 112 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp5_ = press_event;
#line 112 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp6_ = _tmp5_->x;
#line 112 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_press_point.x = (gint) _tmp6_;
#line 113 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp7_ = press_event;
#line 113 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp8_ = _tmp7_->y;
#line 113 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_press_point.y = (gint) _tmp8_;
#line 108 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return self;
#line 316 "toolkit-button-event.c"
}


CaliforniaToolkitButtonEvent* california_toolkit_button_event_new (GtkWidget* widget, GdkEventButton* press_event) {
#line 108 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return california_toolkit_button_event_construct (CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, widget, press_event);
#line 323 "toolkit-button-event.c"
}


static void california_toolkit_button_event_cancel_click (CaliforniaToolkitButtonEvent* self) {
	CaliforniaScheduled* _tmp0_ = NULL;
	CaliforniaScheduled* _tmp1_ = NULL;
#line 120 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 121 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->scheduled_click;
#line 121 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	if (_tmp0_ == NULL) {
#line 122 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		return;
#line 338 "toolkit-button-event.c"
	}
#line 124 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp1_ = self->priv->scheduled_click;
#line 124 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_scheduled_cancel (_tmp1_);
#line 125 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_g_object_unref0 (self->priv->scheduled_click);
#line 125 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->scheduled_click = NULL;
#line 348 "toolkit-button-event.c"
}


void california_toolkit_button_event_update_press (CaliforniaToolkitButtonEvent* self, GtkWidget* widget, GdkEventButton* press_event) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GdkEventButton* _tmp2_ = NULL;
	CaliforniaToolkitButton _tmp3_ = 0;
	CaliforniaToolkitButton _tmp4_ = 0;
	GdkEventButton* _tmp5_ = NULL;
	GdkEventType _tmp6_ = 0;
	GdkEventButton* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GdkEventButton* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
#line 129 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 129 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 129 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (press_event != NULL);
#line 130 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_widget;
#line 130 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp1_ = widget;
#line 130 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_vala_assert (_tmp0_ == _tmp1_, "this.widget == widget");
#line 131 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp2_ = press_event;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp3_ = california_toolkit_button_from_button_event (_tmp2_);
#line 131 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp4_ = self->priv->_button;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_vala_assert (_tmp3_ == _tmp4_, "Button.from_button_event(press_event) == button");
#line 133 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp5_ = press_event;
#line 133 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp6_ = _tmp5_->type;
#line 133 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_set_press_type (self, _tmp6_);
#line 134 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp7_ = press_event;
#line 134 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp8_ = _tmp7_->x;
#line 134 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_press_point.x = (gint) _tmp8_;
#line 135 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp9_ = press_event;
#line 135 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp10_ = _tmp9_->y;
#line 135 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_press_point.y = (gint) _tmp10_;
#line 137 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_cancel_click (self);
#line 404 "toolkit-button-event.c"
}


static void ___lambda30_ (CaliforniaToolkitButtonEvent* self) {
#line 153 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_signal_emit_by_name (self, "clicked");
#line 411 "toolkit-button-event.c"
}


static void ____lambda30__california_scheduled_schedule_once (gpointer self) {
#line 153 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	___lambda30_ ((CaliforniaToolkitButtonEvent*) self);
#line 418 "toolkit-button-event.c"
}


void california_toolkit_button_event_update_release (CaliforniaToolkitButtonEvent* self, GtkWidget* widget, GdkEventButton* release_event) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GdkEventButton* _tmp2_ = NULL;
	CaliforniaToolkitButton _tmp3_ = 0;
	CaliforniaToolkitButton _tmp4_ = 0;
	GdkEventButton* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	GdkEventButton* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GdkEventType _tmp9_ = 0;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 141 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 141 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (release_event != NULL);
#line 142 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_widget;
#line 142 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp1_ = widget;
#line 142 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_vala_assert (_tmp0_ == _tmp1_, "this.widget == widget");
#line 143 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp2_ = release_event;
#line 143 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp3_ = california_toolkit_button_from_button_event (_tmp2_);
#line 143 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp4_ = self->priv->_button;
#line 143 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_vala_assert (_tmp3_ == _tmp4_, "Button.from_button_event(release_event) == button");
#line 145 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp5_ = release_event;
#line 145 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp6_ = _tmp5_->x;
#line 145 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_release_point.x = (gint) _tmp6_;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp7_ = release_event;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp8_ = _tmp7_->y;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_release_point.y = (gint) _tmp8_;
#line 148 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_cancel_click (self);
#line 150 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp9_ = self->priv->_press_type;
#line 150 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	if (_tmp9_ == GDK_3BUTTON_PRESS) {
#line 151 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		g_signal_emit_by_name (self, "clicked");
#line 473 "toolkit-button-event.c"
	} else {
		CaliforniaScheduled* _tmp10_ = NULL;
#line 153 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		_tmp10_ = california_scheduled_new_once_after_msec ((guint) CALIFORNIA_TOOLKIT_BUTTON_EVENT_SYNTHESIZED_CLICK_MSEC, ____lambda30__california_scheduled_schedule_once, self, G_PRIORITY_DEFAULT);
#line 153 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		_g_object_unref0 (self->priv->scheduled_click);
#line 153 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		self->priv->scheduled_click = _tmp10_;
#line 482 "toolkit-button-event.c"
	}
}


static gchar* california_toolkit_button_event_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaToolkitButtonEvent * self;
	gchar* result = NULL;
	CaliforniaToolkitButton _tmp0_ = 0;
	GEnumValue* _tmp1_;
	GdkEventType _tmp2_ = 0;
	GEnumValue* _tmp3_;
	gchar* _tmp4_ = NULL;
#line 156 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEvent);
#line 157 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_button;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp1_ = g_enum_get_value (g_type_class_ref (CALIFORNIA_TOOLKIT_TYPE_BUTTON), _tmp0_);
#line 157 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp2_ = self->priv->_press_type;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp3_ = g_enum_get_value (g_type_class_ref (gdk_event_type_get_type ()), _tmp2_);
#line 157 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp4_ = g_strdup_printf ("EventDetails: button=%s press_type=%s", (_tmp1_ != NULL) ? _tmp1_->value_name : NULL, (_tmp3_ != NULL) ? _tmp3_->value_name : NULL);
#line 157 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	result = _tmp4_;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return result;
#line 511 "toolkit-button-event.c"
}


GtkWidget* california_toolkit_button_event_get_widget (CaliforniaToolkitButtonEvent* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_ = NULL;
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self), NULL);
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_widget;
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	result = _tmp0_;
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return result;
#line 526 "toolkit-button-event.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return self ? g_object_ref (self) : NULL;
#line 533 "toolkit-button-event.c"
}


static void california_toolkit_button_event_set_widget (CaliforniaToolkitButtonEvent* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = value;
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_g_object_unref0 (self->priv->_widget);
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_widget = _tmp1_;
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_object_notify ((GObject *) self, "widget");
#line 552 "toolkit-button-event.c"
}


CaliforniaToolkitButton california_toolkit_button_event_get_button (CaliforniaToolkitButtonEvent* self) {
	CaliforniaToolkitButton result;
	CaliforniaToolkitButton _tmp0_ = 0;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self), 0);
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_button;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	result = _tmp0_;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return result;
#line 567 "toolkit-button-event.c"
}


static void california_toolkit_button_event_set_button (CaliforniaToolkitButtonEvent* self, CaliforniaToolkitButton value) {
	CaliforniaToolkitButton _tmp0_ = 0;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = value;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_button = _tmp0_;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_object_notify ((GObject *) self, "button");
#line 581 "toolkit-button-event.c"
}


GdkEventType california_toolkit_button_event_get_press_type (CaliforniaToolkitButtonEvent* self) {
	GdkEventType result;
	GdkEventType _tmp0_ = 0;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self), 0);
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_press_type;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	result = _tmp0_;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return result;
#line 596 "toolkit-button-event.c"
}


static void california_toolkit_button_event_set_press_type (CaliforniaToolkitButtonEvent* self, GdkEventType value) {
	GdkEventType _tmp0_ = 0;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = value;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->_press_type = _tmp0_;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_object_notify ((GObject *) self, "press-type");
#line 610 "toolkit-button-event.c"
}


void california_toolkit_button_event_get_press_point (CaliforniaToolkitButtonEvent* self, GdkPoint* result) {
	GdkPoint _tmp0_ = {0};
#line 94 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 94 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_press_point;
#line 94 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	*result = _tmp0_;
#line 94 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return;
#line 624 "toolkit-button-event.c"
}


void california_toolkit_button_event_get_release_point (CaliforniaToolkitButtonEvent* self, GdkPoint* result) {
	GdkPoint _tmp0_ = {0};
#line 100 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_BUTTON_EVENT (self));
#line 100 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_tmp0_ = self->priv->_release_point;
#line 100 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	*result = _tmp0_;
#line 100 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	return;
#line 638 "toolkit-button-event.c"
}


static void california_toolkit_button_event_class_init (CaliforniaToolkitButtonEventClass * klass) {
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_parent_class = g_type_class_peek_parent (klass);
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaToolkitButtonEventPrivate));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_toolkit_button_event_real_to_string;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_toolkit_button_event_get_property;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_toolkit_button_event_set_property;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	G_OBJECT_CLASS (klass)->finalize = california_toolkit_button_event_finalize;
#line 655 "toolkit-button-event.c"
	/**
	     * The Gtk.Widget the button press occurred on.
	     *
	     * Even if the button is released over a different widget, this widget is always reported
	     * by GTK and all coordinates are relative to it.
	     */
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_BUTTON_EVENT_WIDGET, g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 664 "toolkit-button-event.c"
	/**
	     * The {@link Button} the event originated from.
	     */
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_BUTTON_EVENT_BUTTON, g_param_spec_enum ("button", "button", "button", CALIFORNIA_TOOLKIT_TYPE_BUTTON, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 670 "toolkit-button-event.c"
	/**
	     * The last-seen button press type.
	     */
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_BUTTON_EVENT_PRESS_TYPE, g_param_spec_enum ("press-type", "press-type", "press-type", gdk_event_type_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	g_signal_new ("clicked", CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 678 "toolkit-button-event.c"
}


static void california_toolkit_button_event_instance_init (CaliforniaToolkitButtonEvent * self) {
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv = CALIFORNIA_TOOLKIT_BUTTON_EVENT_GET_PRIVATE (self);
#line 93 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	memset (&self->priv->_press_point, 0, sizeof (GdkPoint));
#line 99 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	memset (&self->priv->_release_point, 0, sizeof (GdkPoint));
#line 106 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self->priv->scheduled_click = NULL;
#line 691 "toolkit-button-event.c"
}


static void california_toolkit_button_event_finalize (GObject* obj) {
	CaliforniaToolkitButtonEvent * self;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEvent);
#line 117 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	california_toolkit_button_event_cancel_click (self);
#line 78 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_g_object_unref0 (self->priv->_widget);
#line 106 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	_g_object_unref0 (self->priv->scheduled_click);
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	G_OBJECT_CLASS (california_toolkit_button_event_parent_class)->finalize (obj);
#line 707 "toolkit-button-event.c"
}


/**
 * Details of a (mouse) button event as reported by {@link ButtonConnector}.
 */
GType california_toolkit_button_event_get_type (void) {
	static volatile gsize california_toolkit_button_event_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_button_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaToolkitButtonEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_toolkit_button_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaToolkitButtonEvent), 0, (GInstanceInitFunc) california_toolkit_button_event_instance_init, NULL };
		GType california_toolkit_button_event_type_id;
		california_toolkit_button_event_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaToolkitButtonEvent", &g_define_type_info, 0);
		g_once_init_leave (&california_toolkit_button_event_type_id__volatile, california_toolkit_button_event_type_id);
	}
	return california_toolkit_button_event_type_id__volatile;
}


static void _vala_california_toolkit_button_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitButtonEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEvent);
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	switch (property_id) {
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_EVENT_WIDGET:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		g_value_set_object (value, california_toolkit_button_event_get_widget (self));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_EVENT_BUTTON:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		g_value_set_enum (value, california_toolkit_button_event_get_button (self));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_EVENT_PRESS_TYPE:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		g_value_set_enum (value, california_toolkit_button_event_get_press_type (self));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 749 "toolkit-button-event.c"
		default:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 755 "toolkit-button-event.c"
	}
}


static void _vala_california_toolkit_button_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitButtonEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_BUTTON_EVENT, CaliforniaToolkitButtonEvent);
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
	switch (property_id) {
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_EVENT_WIDGET:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		california_toolkit_button_event_set_widget (self, g_value_get_object (value));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_EVENT_BUTTON:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		california_toolkit_button_event_set_button (self, g_value_get_enum (value));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		case CALIFORNIA_TOOLKIT_BUTTON_EVENT_PRESS_TYPE:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		california_toolkit_button_event_set_press_type (self, g_value_get_enum (value));
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 783 "toolkit-button-event.c"
		default:
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 69 "/home/jim/git/california/src/toolkit/toolkit-button-event.vala"
		break;
#line 789 "toolkit-button-event.c"
	}
}



