/* component-event.c generated by valac 0.26.1, the Vala compiler
 * generated from component-event.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libical/ical.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COMPONENT_TYPE_INSTANCE (california_component_instance_get_type ())
#define CALIFORNIA_COMPONENT_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance))
#define CALIFORNIA_COMPONENT_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))
#define CALIFORNIA_COMPONENT_IS_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_IS_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))

typedef struct _CaliforniaComponentInstance CaliforniaComponentInstance;
typedef struct _CaliforniaComponentInstanceClass CaliforniaComponentInstanceClass;
typedef struct _CaliforniaComponentInstancePrivate CaliforniaComponentInstancePrivate;

#define CALIFORNIA_COMPONENT_TYPE_UID (california_component_uid_get_type ())
#define CALIFORNIA_COMPONENT_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUID))
#define CALIFORNIA_COMPONENT_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))
#define CALIFORNIA_COMPONENT_IS_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_IS_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_UID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))

typedef struct _CaliforniaComponentUID CaliforniaComponentUID;
typedef struct _CaliforniaComponentUIDClass CaliforniaComponentUIDClass;

#define CALIFORNIA_COMPONENT_TYPE_EVENT (california_component_event_get_type ())
#define CALIFORNIA_COMPONENT_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent))
#define CALIFORNIA_COMPONENT_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))
#define CALIFORNIA_COMPONENT_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))

typedef struct _CaliforniaComponentEvent CaliforniaComponentEvent;
typedef struct _CaliforniaComponentEventClass CaliforniaComponentEventClass;
typedef struct _CaliforniaComponentEventPrivate CaliforniaComponentEventPrivate;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN (california_calendar_exact_time_span_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpan))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))

typedef struct _CaliforniaCalendarExactTimeSpan CaliforniaCalendarExactTimeSpan;
typedef struct _CaliforniaCalendarExactTimeSpanClass CaliforniaCalendarExactTimeSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN (california_calendar_unit_span_get_type ())
#define CALIFORNIA_CALENDAR_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))

typedef struct _CaliforniaCalendarUnitSpan CaliforniaCalendarUnitSpan;
typedef struct _CaliforniaCalendarUnitSpanClass CaliforniaCalendarUnitSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;

#define CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS (california_component_event_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_BACKING_TYPE_SOURCE (california_backing_source_get_type ())
#define CALIFORNIA_BACKING_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource))
#define CALIFORNIA_BACKING_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))
#define CALIFORNIA_BACKING_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))

typedef struct _CaliforniaBackingSource CaliforniaBackingSource;
typedef struct _CaliforniaBackingSourceClass CaliforniaBackingSourceClass;

#define CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE (california_backing_calendar_source_get_type ())
#define CALIFORNIA_BACKING_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSource))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))

typedef struct _CaliforniaBackingCalendarSource CaliforniaBackingCalendarSource;
typedef struct _CaliforniaBackingCalendarSourceClass CaliforniaBackingCalendarSourceClass;

#define CALIFORNIA_COMPONENT_TYPE_DATE_TIME (california_component_date_time_get_type ())
#define CALIFORNIA_COMPONENT_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTime))
#define CALIFORNIA_COMPONENT_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))

typedef struct _CaliforniaComponentDateTime CaliforniaComponentDateTime;
typedef struct _CaliforniaComponentDateTimeClass CaliforniaComponentDateTimeClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;

#define CALIFORNIA_CALENDAR_DATE_TYPE_PRETTY_FLAG (california_calendar_date_pretty_flag_get_type ())

#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_TYPE_PRETTY_FLAG (california_calendar_exact_time_span_pretty_flag_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;

#define CALIFORNIA_CALENDAR_TYPE_DURATION (california_calendar_duration_get_type ())
#define CALIFORNIA_CALENDAR_DURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration))
#define CALIFORNIA_CALENDAR_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))
#define CALIFORNIA_CALENDAR_IS_DURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_IS_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_DURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))

typedef struct _CaliforniaCalendarDuration CaliforniaCalendarDuration;
typedef struct _CaliforniaCalendarDurationClass CaliforniaCalendarDurationClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaComponentInstance {
	CaliforniaBaseObject parent_instance;
	CaliforniaComponentInstancePrivate * priv;
};

struct _CaliforniaComponentInstanceClass {
	CaliforniaBaseObjectClass parent_class;
	void (*notify_altered) (CaliforniaComponentInstance* self, gboolean from_full_update);
	void (*update_from_component) (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
	CaliforniaComponentInstance* (*clone) (CaliforniaComponentInstance* self, GError** error);
	gboolean (*is_valid) (CaliforniaComponentInstance* self, gboolean and_useful);
	gboolean (*equal_to) (CaliforniaComponentInstance* self, CaliforniaComponentInstance* other);
	guint (*hash) (CaliforniaComponentInstance* self);
};

struct _CaliforniaComponentEvent {
	CaliforniaComponentInstance parent_instance;
	CaliforniaComponentEventPrivate * priv;
};

struct _CaliforniaComponentEventClass {
	CaliforniaComponentInstanceClass parent_class;
};

typedef enum  {
	CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED
} CaliforniaComponentEventStatus;

struct _CaliforniaComponentEventPrivate {
	gchar* _summary;
	gchar* _description;
	CaliforniaCalendarExactTimeSpan* _exact_time_span;
	CaliforniaCalendarDateSpan* _date_span;
	gchar* _location;
	CaliforniaComponentEventStatus _status;
};

typedef enum  {
	CALIFORNIA_COMPONENT_ERROR_INVALID,
	CALIFORNIA_COMPONENT_ERROR_MISMATCH,
	CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE
} CaliforniaComponentError;
#define CALIFORNIA_COMPONENT_ERROR california_component_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV = 1 << 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT = 1 << 1,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR = 1 << 2,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR = 1 << 3,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY = 1 << 4,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK = 1 << 5
} CaliforniaCalendarDatePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_PRETTY_FLAG_ALLOW_MULTILINE = 1 << 0,
	CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_PRETTY_FLAG_INCLUDE_TIMEZONE = 1 << 1
} CaliforniaCalendarExactTimeSpanPrettyFlag;


static gpointer california_component_event_parent_class = NULL;
static GeeComparableIface* california_component_event_gee_comparable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_component_instance_get_type (void) G_GNUC_CONST;
GType california_component_uid_get_type (void) G_GNUC_CONST;
GType california_component_event_get_type (void) G_GNUC_CONST;
GType california_calendar_exact_time_span_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
GType california_component_event_status_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventPrivate))
enum  {
	CALIFORNIA_COMPONENT_EVENT_DUMMY_PROPERTY,
	CALIFORNIA_COMPONENT_EVENT_SUMMARY,
	CALIFORNIA_COMPONENT_EVENT_DESCRIPTION,
	CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN,
	CALIFORNIA_COMPONENT_EVENT_DATE_SPAN,
	CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY,
	CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING,
	CALIFORNIA_COMPONENT_EVENT_LOCATION,
	CALIFORNIA_COMPONENT_EVENT_STATUS
};
#define CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY "summary"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION "description"
#define CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN "exact-time-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN "date-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_IS_ALL_DAY "is-all-day"
#define CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION "location"
#define CALIFORNIA_COMPONENT_EVENT_PROP_STATUS "status"
GType california_backing_source_get_type (void) G_GNUC_CONST;
GType california_backing_calendar_source_get_type (void) G_GNUC_CONST;
CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentInstance* california_component_instance_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, icalcomponent_kind kind, GError** error);
static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec);
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
CaliforniaComponentEvent* california_component_event_new_blank (CaliforniaBackingCalendarSource* calendar_source);
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type, CaliforniaBackingCalendarSource* calendar_source);
CaliforniaComponentInstance* california_component_instance_construct_blank (GType object_type, icalcomponent_kind kind, CaliforniaBackingCalendarSource* calendar_source);
static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_instance_update_from_component (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value);
GType california_component_date_time_get_type (void) G_GNUC_CONST;
GQuark california_component_error_quark (void);
CaliforniaComponentDateTime* california_component_date_time_new (icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
CaliforniaComponentDateTime* california_component_date_time_construct (GType object_type, icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
CaliforniaComponentDateTime* california_component_date_time_adjust_duration (CaliforniaComponentDateTime* self, icalcomponent* ical_component, icalproperty_kind new_kind, GError** error);
GQuark california_calendar_error_quark (void);
void california_component_date_time_to_span (CaliforniaComponentDateTime* dt_start, CaliforniaComponentDateTime* dt_end, gboolean dtend_inclusive, CaliforniaCalendarDateSpan** date_span, CaliforniaCalendarExactTimeSpan** exact_time_span, GError** error);
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span);
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span);
void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value);
gboolean california_component_instance_get_in_full_update (CaliforniaComponentInstance* self);
gint california_component_instance_remove_all_properties (CaliforniaComponentInstance* self, icalproperty_kind kind);
icalcomponent* california_component_instance_get_ical_component (CaliforniaComponentInstance* self);
const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self);
const gchar* california_component_event_get_description (CaliforniaComponentEvent* self);
CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self);
CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self);
void california_component_instance_exact_time_span_to_ical (CaliforniaCalendarExactTimeSpan* exact_time_span, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
void california_component_instance_date_span_to_ical (CaliforniaCalendarDateSpan* date_span, gboolean dtend_inclusive, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
const gchar* california_component_event_get_location (CaliforniaComponentEvent* self);
CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self);
void california_component_instance_notify_altered (CaliforniaComponentInstance* self, gboolean from_full_update);
static CaliforniaComponentInstance* california_component_event_real_clone (CaliforniaComponentInstance* base, GError** error);
CaliforniaBackingCalendarSource* california_component_instance_get_calendar_source (CaliforniaComponentInstance* self);
CaliforniaComponentInstance* california_component_instance_get_master (CaliforniaComponentInstance* self);
void california_component_instance_set_master (CaliforniaComponentInstance* self, CaliforniaComponentInstance* value);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_to_timezone (CaliforniaCalendarExactTimeSpan* self, CaliforniaCalendarTimezone* new_tz);
CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span);
static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value);
static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value);
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
void california_component_event_adjust_start_date (CaliforniaComponentEvent* self, CaliforniaCalendarDate* new_start_date);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
gint california_calendar_unit_difference (CaliforniaCalendarUnit* self, gconstpointer other);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity);
gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self);
CaliforniaCalendarDateSpan* california_calendar_date_span_new (CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_start_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarTimezone* california_calendar_exact_time_get_tz (CaliforniaCalendarExactTime* self);
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_exact_time_to_wall_time (CaliforniaCalendarExactTime* self);
CaliforniaCalendarExactTime* california_calendar_exact_time_new (CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct (GType object_type, CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_end_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_new (CaliforniaCalendarExactTime* start_exact_time, CaliforniaCalendarExactTime* end_exact_time);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_construct (GType object_type, CaliforniaCalendarExactTime* start_exact_time, CaliforniaCalendarExactTime* end_exact_time);
void california_component_event_all_day_to_timed_event (CaliforniaComponentEvent* self, CaliforniaCalendarWallTime* start_time, CaliforniaCalendarWallTime* end_time, CaliforniaCalendarTimezone* timezone);
void california_component_event_timed_to_all_day_event (CaliforniaComponentEvent* self);
GType california_calendar_date_pretty_flag_get_type (void) G_GNUC_CONST;
GType california_calendar_exact_time_span_pretty_flag_get_type (void) G_GNUC_CONST;
gchar* california_component_event_get_event_time_pretty_string (CaliforniaComponentEvent* self, CaliforniaCalendarDatePrettyFlag date_flags, CaliforniaCalendarExactTimeSpanPrettyFlag time_flags, CaliforniaCalendarTimezone* timezone);
GType california_calendar_year_get_type (void) G_GNUC_CONST;
CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self);
CaliforniaCalendarDate* california_calendar_system_get_today (void);
gchar* california_calendar_date_span_to_pretty_string (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDatePrettyFlag date_flags);
gchar* california_calendar_exact_time_span_to_pretty_string (CaliforniaCalendarExactTimeSpan* self, CaliforniaCalendarDatePrettyFlag date_flags, CaliforniaCalendarExactTimeSpanPrettyFlag time_flags);
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base, gboolean and_useful);
gboolean california_string_is_empty (const gchar* str);
gboolean california_component_instance_is_valid (CaliforniaComponentInstance* self, gboolean and_useful);
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other);
CaliforniaComponentDateTime* california_component_instance_get_rid (CaliforniaComponentInstance* self);
CaliforniaCalendarExactTime* california_component_instance_get_dtstamp (CaliforniaComponentInstance* self);
gint california_component_instance_get_sequence (CaliforniaComponentInstance* self);
gint california_backing_source_compare_to (CaliforniaBackingSource* self, CaliforniaBackingSource* other);
CaliforniaComponentUID* california_component_instance_get_uid (CaliforniaComponentInstance* self);
static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self);
GType california_calendar_duration_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDuration* california_calendar_exact_time_span_get_duration (CaliforniaCalendarExactTimeSpan* self);
guint64 california_calendar_duration_get_days (CaliforniaCalendarDuration* self);
static void california_component_event_finalize (GObject* obj);
static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType california_component_event_status_get_type (void) {
	static volatile gsize california_component_event_status_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_status_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE, "CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE", "tentative"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED", "confirmed"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED", "cancelled"}, {0, NULL, NULL}};
		GType california_component_event_status_type_id;
		california_component_event_status_type_id = g_enum_register_static ("CaliforniaComponentEventStatus", values);
		g_once_init_leave (&california_component_event_status_type_id__volatile, california_component_event_status_type_id);
	}
	return california_component_event_status_type_id__volatile;
}


/**
     * Create an {@link Event} {@link Component} from an EDS CalComponent object.
     *
     * Throws a BackingError if the E.CalComponent's VTYPE is not VEVENT.
     */
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 99 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_on_notify ((CaliforniaComponentEvent*) self, pspec);
#line 437 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
	CaliforniaComponentEvent * self = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
	icalcomponent* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((calendar_source == NULL) || CALIFORNIA_BACKING_IS_CALENDAR_SOURCE (calendar_source), NULL);
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (ical_component != NULL, NULL);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = calendar_source;
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = ical_component;
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct (object_type, _tmp0_, _tmp1_, ICAL_VEVENT_COMPONENT, &_inner_error_);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (self);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		return NULL;
#line 464 "component-event.c"
	}
#line 99 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 470 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct (CALIFORNIA_COMPONENT_TYPE_EVENT, calendar_source, ical_component, error);
#line 477 "component-event.c"
}


/**
     * Creates a "blank" {@link Event} with a generated {@link uid}.
     *
     * A {@link Calendar.DateSpan} or a {@link Calendar.ExactTimeSpan} must be specified in order
     * to generate a minimally-valid Event.
     */
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type, CaliforniaBackingCalendarSource* calendar_source) {
	CaliforniaComponentEvent * self = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((calendar_source == NULL) || CALIFORNIA_BACKING_IS_CALENDAR_SOURCE (calendar_source), NULL);
#line 109 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = calendar_source;
#line 109 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct_blank (object_type, ICAL_VEVENT_COMPONENT, _tmp0_);
#line 111 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 500 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new_blank (CaliforniaBackingCalendarSource* calendar_source) {
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct_blank (CALIFORNIA_COMPONENT_TYPE_EVENT, calendar_source);
#line 507 "component-event.c"
}


/**
     * @inheritDoc
     */
static gpointer _g_error_copy0 (gpointer self) {
#line 135 "/home/jim/git/california/src/component/component-event.vala"
	return self ? g_error_copy (self) : NULL;
#line 517 "component-event.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 152 "/home/jim/git/california/src/component/component-event.vala"
	return self ? g_object_ref (self) : NULL;
#line 524 "component-event.c"
}


static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error) {
	CaliforniaComponentEvent * self;
	icalcomponent* _tmp0_ = NULL;
	CaliforniaComponentUID* _tmp1_ = NULL;
	icalcomponent* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	icalcomponent* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	CaliforniaComponentDateTime* dt_start = NULL;
	icalcomponent* _tmp6_ = NULL;
	CaliforniaComponentDateTime* _tmp7_ = NULL;
	CaliforniaComponentDateTime* dt_end = NULL;
	CaliforniaComponentDateTime* _tmp15_ = NULL;
	gboolean dtend_inclusive = FALSE;
	CaliforniaComponentDateTime* _tmp21_ = NULL;
	CaliforniaCalendarDateSpan* date_span = NULL;
	CaliforniaCalendarExactTimeSpan* exact_time_span = NULL;
	CaliforniaComponentDateTime* _tmp24_ = NULL;
	CaliforniaComponentDateTime* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp27_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp28_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp29_ = NULL;
	icalcomponent* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	icalcomponent* _tmp35_ = NULL;
	icalproperty_status _tmp36_ = 0;
	GError * _inner_error_ = NULL;
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (ical_component != NULL);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail ((supplied_uid == NULL) || CALIFORNIA_COMPONENT_IS_UID (supplied_uid));
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = ical_component;
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = supplied_uid;
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->update_from_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp0_, _tmp1_, &_inner_error_);
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 119 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 119 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 574 "component-event.c"
	}
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = ical_component;
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = icalcomponent_get_summary (_tmp2_);
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_summary (self, _tmp3_);
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = ical_component;
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = icalcomponent_get_description (_tmp4_);
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_description (self, _tmp5_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = ical_component;
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_component_date_time_new (_tmp6_, ICAL_DTSTART_PROPERTY, &_inner_error_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	dt_start = _tmp7_;
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 124 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 600 "component-event.c"
	}
#line 129 "/home/jim/git/california/src/component/component-event.vala"
	dt_end = NULL;
#line 604 "component-event.c"
	{
		CaliforniaComponentDateTime* _tmp8_ = NULL;
		icalcomponent* _tmp9_ = NULL;
		CaliforniaComponentDateTime* _tmp10_ = NULL;
		CaliforniaComponentDateTime* _tmp11_ = NULL;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = ical_component;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_component_date_time_new (_tmp9_, ICAL_DTEND_PROPERTY, &_inner_error_);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = _tmp10_;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			if (_inner_error_->domain == CALIFORNIA_COMPONENT_ERROR) {
#line 620 "component-event.c"
				goto __catch42_california_component_error;
			}
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_end);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_start);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			g_clear_error (&_inner_error_);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			return;
#line 633 "component-event.c"
		}
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = _tmp8_;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = NULL;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		dt_end = _tmp11_;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp8_);
#line 645 "component-event.c"
	}
	goto __finally42;
	__catch42_california_component_error:
	{
		GError* comperr = NULL;
		GError* _tmp12_ = NULL;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		comperr = _inner_error_;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_inner_error_ = NULL;
#line 134 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = comperr;
#line 134 "/home/jim/git/california/src/component/component-event.vala"
		if (!g_error_matches (_tmp12_, CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE)) {
#line 660 "component-event.c"
			GError* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_tmp13_ = comperr;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_tmp14_ = _g_error_copy0 (_tmp13_);
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_inner_error_ = _tmp14_;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_g_error_free0 (comperr);
#line 671 "component-event.c"
			goto __finally42;
		}
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_error_free0 (comperr);
#line 676 "component-event.c"
	}
	__finally42:
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 689 "component-event.c"
	}
#line 139 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = dt_end;
#line 139 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp15_ == NULL) {
#line 695 "component-event.c"
		{
			CaliforniaComponentDateTime* _tmp16_ = NULL;
			CaliforniaComponentDateTime* _tmp17_ = NULL;
			icalcomponent* _tmp18_ = NULL;
			CaliforniaComponentDateTime* _tmp19_ = NULL;
			CaliforniaComponentDateTime* _tmp20_ = NULL;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp17_ = dt_start;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp18_ = ical_component;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp19_ = california_component_date_time_adjust_duration (_tmp17_, _tmp18_, ICAL_DTEND_PROPERTY, &_inner_error_);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp16_ = _tmp19_;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				if (_inner_error_->domain == CALIFORNIA_COMPONENT_ERROR) {
#line 714 "component-event.c"
					goto __catch43_california_component_error;
				}
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (dt_end);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (dt_start);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				g_clear_error (&_inner_error_);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				return;
#line 727 "component-event.c"
			}
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp20_ = _tmp16_;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp16_ = NULL;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_end);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			dt_end = _tmp20_;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (_tmp16_);
#line 739 "component-event.c"
		}
		goto __finally43;
		__catch43_california_component_error:
		{
			GError* comperr = NULL;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			comperr = _inner_error_;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_inner_error_ = NULL;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_error_free0 (comperr);
#line 751 "component-event.c"
		}
		__finally43:
#line 140 "/home/jim/git/california/src/component/component-event.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			g_propagate_error (error, _inner_error_);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_end);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_start);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			return;
#line 764 "component-event.c"
		}
	}
#line 147 "/home/jim/git/california/src/component/component-event.vala"
	dtend_inclusive = FALSE;
#line 148 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = dt_end;
#line 148 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp21_ == NULL) {
#line 773 "component-event.c"
		CaliforniaComponentDateTime* _tmp22_ = NULL;
		CaliforniaComponentDateTime* _tmp23_ = NULL;
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = dt_start;
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		dt_end = _tmp23_;
#line 153 "/home/jim/git/california/src/component/component-event.vala"
		dtend_inclusive = TRUE;
#line 786 "component-event.c"
	}
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_tmp24_ = dt_start;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_tmp25_ = dt_end;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_tmp26_ = dtend_inclusive;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	california_component_date_time_to_span (_tmp24_, _tmp25_, _tmp26_, &_tmp27_, &_tmp28_, &_inner_error_);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	date_span = _tmp27_;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	exact_time_span = _tmp28_;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (exact_time_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (date_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 818 "component-event.c"
	}
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	_tmp29_ = exact_time_span;
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp29_ != NULL) {
#line 824 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp30_ = NULL;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		_tmp30_ = exact_time_span;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_exact_time_span (self, _tmp30_);
#line 830 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp31_ = NULL;
		CaliforniaCalendarDateSpan* _tmp32_ = NULL;
#line 164 "/home/jim/git/california/src/component/component-event.vala"
		_tmp31_ = date_span;
#line 164 "/home/jim/git/california/src/component/component-event.vala"
		_vala_assert (_tmp31_ != NULL, "date_span != null");
#line 165 "/home/jim/git/california/src/component/component-event.vala"
		_tmp32_ = date_span;
#line 165 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp32_);
#line 842 "component-event.c"
	}
#line 168 "/home/jim/git/california/src/component/component-event.vala"
	_tmp33_ = ical_component;
#line 168 "/home/jim/git/california/src/component/component-event.vala"
	_tmp34_ = icalcomponent_get_location (_tmp33_);
#line 168 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_location (self, _tmp34_);
#line 170 "/home/jim/git/california/src/component/component-event.vala"
	_tmp35_ = ical_component;
#line 170 "/home/jim/git/california/src/component/component-event.vala"
	_tmp36_ = icalcomponent_get_status (_tmp35_);
#line 170 "/home/jim/git/california/src/component/component-event.vala"
	switch (_tmp36_) {
#line 170 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_TENTATIVE:
#line 858 "component-event.c"
		{
#line 172 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE);
#line 173 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 864 "component-event.c"
		}
#line 170 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CANCELLED:
#line 868 "component-event.c"
		{
#line 176 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED);
#line 177 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 874 "component-event.c"
		}
		default:
#line 170 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CONFIRMED:
#line 879 "component-event.c"
		{
#line 181 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED);
#line 182 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 885 "component-event.c"
		}
	}
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_end);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_start);
#line 896 "component-event.c"
}


static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean altered = FALSE;
	GParamSpec* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	gboolean _tmp41_ = FALSE;
#line 186 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 186 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (G_IS_PARAM_SPEC (pspec));
#line 188 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_instance_get_in_full_update (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 188 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 188 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 189 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 921 "component-event.c"
	}
#line 191 "/home/jim/git/california/src/component/component-event.vala"
	altered = TRUE;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = pspec;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_->name;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = _tmp3_;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 937 "component-event.c"
			default:
			{
				icalcomponent* _tmp7_ = NULL;
				icalcomponent* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 194 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_SUMMARY_PROPERTY);
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				_tmp7_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				_tmp8_ = _tmp7_;
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				_tmp9_ = self->priv->_summary;
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_summary (_tmp8_, _tmp9_);
#line 196 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 955 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 961 "component-event.c"
			default:
			{
				icalcomponent* _tmp10_ = NULL;
				icalcomponent* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 199 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DESCRIPTION_PROPERTY);
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				_tmp10_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				_tmp11_ = _tmp10_;
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				_tmp12_ = self->priv->_description;
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_description (_tmp11_, _tmp12_);
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 979 "component-event.c"
			}
		}
	} else if ((_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN)) || (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN))) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 985 "component-event.c"
			default:
			{
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				CaliforniaCalendarDateSpan* _tmp15_ = NULL;
				icaltimetype ical_dtstart = {0};
				icaltimetype _tmp20_ = {0};
				icaltimetype ical_dtend = {0};
				icaltimetype _tmp21_ = {0};
				CaliforniaCalendarExactTimeSpan* _tmp22_ = NULL;
				icalcomponent* _tmp25_ = NULL;
				icalcomponent* _tmp26_ = NULL;
				icaltimetype _tmp27_ = {0};
				icalcomponent* _tmp28_ = NULL;
				icalcomponent* _tmp29_ = NULL;
				icaltimetype _tmp30_ = {0};
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				_tmp15_ = self->priv->_date_span;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp15_ == NULL) {
#line 1006 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp16_ = self->priv->_exact_time_span;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = _tmp16_ == NULL;
#line 1012 "component-event.c"
				} else {
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = FALSE;
#line 1016 "component-event.c"
				}
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp14_) {
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = TRUE;
#line 1022 "component-event.c"
				} else {
					gboolean _tmp17_ = FALSE;
					CaliforniaCalendarDateSpan* _tmp18_ = NULL;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
					_tmp18_ = self->priv->_date_span;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
					if (_tmp18_ != NULL) {
#line 1030 "component-event.c"
						CaliforniaCalendarExactTimeSpan* _tmp19_ = NULL;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
						_tmp19_ = self->priv->_exact_time_span;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = _tmp19_ != NULL;
#line 1036 "component-event.c"
					} else {
#line 209 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = FALSE;
#line 1040 "component-event.c"
					}
#line 209 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = _tmp17_;
#line 1044 "component-event.c"
				}
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp13_) {
#line 210 "/home/jim/git/california/src/component/component-event.vala"
					return;
#line 1050 "component-event.c"
				}
#line 215 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtstart = _tmp20_;
#line 216 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtend = _tmp21_;
#line 217 "/home/jim/git/california/src/component/component-event.vala"
				_tmp22_ = self->priv->_exact_time_span;
#line 217 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp22_ != NULL) {
#line 1060 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp23_ = NULL;
#line 218 "/home/jim/git/california/src/component/component-event.vala"
					_tmp23_ = self->priv->_exact_time_span;
#line 218 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_exact_time_span_to_ical (_tmp23_, &ical_dtstart, &ical_dtend);
#line 1066 "component-event.c"
				} else {
					CaliforniaCalendarDateSpan* _tmp24_ = NULL;
#line 220 "/home/jim/git/california/src/component/component-event.vala"
					_tmp24_ = self->priv->_date_span;
#line 220 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_date_span_to_ical (_tmp24_, FALSE, &ical_dtstart, &ical_dtend);
#line 1073 "component-event.c"
				}
#line 222 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DTSTART_PROPERTY);
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				_tmp25_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				_tmp26_ = _tmp25_;
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				_tmp27_ = ical_dtstart;
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtstart (_tmp26_, _tmp27_);
#line 225 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DTEND_PROPERTY);
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				_tmp28_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				_tmp29_ = _tmp28_;
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = ical_dtend;
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtend (_tmp29_, _tmp30_);
#line 227 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1097 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 1103 "component-event.c"
			default:
			{
				icalcomponent* _tmp31_ = NULL;
				icalcomponent* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 230 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_LOCATION_PROPERTY);
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = _tmp31_;
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = self->priv->_location;
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_location (_tmp32_, _tmp33_);
#line 232 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1121 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_STATUS)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 1127 "component-event.c"
			default:
			{
				CaliforniaComponentEventStatus _tmp34_ = 0;
#line 235 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_STATUS_PROPERTY);
#line 236 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = self->priv->_status;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
				switch (_tmp34_) {
#line 236 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE:
#line 1139 "component-event.c"
					{
						icalcomponent* _tmp35_ = NULL;
						icalcomponent* _tmp36_ = NULL;
#line 238 "/home/jim/git/california/src/component/component-event.vala"
						_tmp35_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 238 "/home/jim/git/california/src/component/component-event.vala"
						_tmp36_ = _tmp35_;
#line 238 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp36_, ICAL_STATUS_TENTATIVE);
#line 239 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 1151 "component-event.c"
					}
#line 236 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED:
#line 1155 "component-event.c"
					{
						icalcomponent* _tmp37_ = NULL;
						icalcomponent* _tmp38_ = NULL;
#line 242 "/home/jim/git/california/src/component/component-event.vala"
						_tmp37_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 242 "/home/jim/git/california/src/component/component-event.vala"
						_tmp38_ = _tmp37_;
#line 242 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp38_, ICAL_STATUS_CANCELLED);
#line 243 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 1167 "component-event.c"
					}
					default:
#line 236 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED:
#line 1172 "component-event.c"
					{
						icalcomponent* _tmp39_ = NULL;
						icalcomponent* _tmp40_ = NULL;
#line 247 "/home/jim/git/california/src/component/component-event.vala"
						_tmp39_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 247 "/home/jim/git/california/src/component/component-event.vala"
						_tmp40_ = _tmp39_;
#line 247 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp40_, ICAL_STATUS_CONFIRMED);
#line 248 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 1184 "component-event.c"
					}
				}
#line 250 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1189 "component-event.c"
			}
		}
	} else {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 1195 "component-event.c"
			default:
			{
#line 253 "/home/jim/git/california/src/component/component-event.vala"
				altered = FALSE;
#line 254 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1202 "component-event.c"
			}
		}
	}
#line 257 "/home/jim/git/california/src/component/component-event.vala"
	_tmp41_ = altered;
#line 257 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp41_) {
#line 258 "/home/jim/git/california/src/component/component-event.vala"
		california_component_instance_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), FALSE);
#line 1212 "component-event.c"
	}
}


/**
     * @inheritDoc
     */
static CaliforniaComponentInstance* california_component_event_real_clone (CaliforniaComponentInstance* base, GError** error) {
	CaliforniaComponentEvent * self;
	CaliforniaComponentInstance* result = NULL;
	CaliforniaComponentEvent* cloned_event = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
	CaliforniaBackingCalendarSource* _tmp1_ = NULL;
	icalcomponent* _tmp2_ = NULL;
	icalcomponent* _tmp3_ = NULL;
	CaliforniaComponentEvent* _tmp4_ = NULL;
	CaliforniaComponentInstance* _tmp5_ = NULL;
	CaliforniaComponentInstance* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 264 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_;
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_component_event_new (_tmp1_, _tmp3_, &_inner_error_);
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	cloned_event = _tmp4_;
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 265 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 265 "/home/jim/git/california/src/component/component-event.vala"
		return NULL;
#line 1252 "component-event.c"
	}
#line 266 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 266 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = _tmp5_;
#line 266 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ != NULL) {
#line 1260 "component-event.c"
		CaliforniaComponentEvent* _tmp7_ = NULL;
		CaliforniaComponentInstance* _tmp8_ = NULL;
		CaliforniaComponentInstance* _tmp9_ = NULL;
		CaliforniaBackingCalendarSource* _tmp10_ = NULL;
		CaliforniaBackingCalendarSource* _tmp11_ = NULL;
		CaliforniaComponentInstance* _tmp12_ = NULL;
		CaliforniaComponentInstance* _tmp13_ = NULL;
		icalcomponent* _tmp14_ = NULL;
		icalcomponent* _tmp15_ = NULL;
		CaliforniaComponentEvent* _tmp16_ = NULL;
		CaliforniaComponentEvent* _tmp17_ = NULL;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = _tmp8_;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_component_instance_get_calendar_source (_tmp9_);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = _tmp10_;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = _tmp12_;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp14_ = california_component_instance_get_ical_component (_tmp13_);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = _tmp14_;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = california_component_event_new (_tmp11_, _tmp15_, &_inner_error_);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp16_;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "/home/jim/git/california/src/component/component-event.vala"
			g_propagate_error (error, _inner_error_);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (cloned_event);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
			return NULL;
#line 1300 "component-event.c"
		}
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = cloned_event;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		california_component_instance_set_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 266 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp7_);
#line 1308 "component-event.c"
	}
#line 269 "/home/jim/git/california/src/component/component-event.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (cloned_event, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance);
#line 269 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1314 "component-event.c"
}


/**
     * Returns a {@link Calendar.DateSpan} for the {@link Event}.
     *
     * This will return a DateSpan whether the Event is a DATE or DATE-TIME VEVENT.
     */
CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarDateSpan* result = NULL;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
	CaliforniaCalendarTimezone* _tmp4_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
#line 277 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 277 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((tz == NULL) || CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 278 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 278 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_ != NULL) {
#line 1337 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp1_ = NULL;
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
#line 279 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = self->priv->_date_span;
#line 279 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 279 "/home/jim/git/california/src/component/component-event.vala"
		result = _tmp2_;
#line 279 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1348 "component-event.c"
	}
#line 282 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = tz;
#line 282 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp4_ != NULL) {
#line 1354 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp5_ = NULL;
		CaliforniaCalendarTimezone* _tmp6_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp7_ = NULL;
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = self->priv->_exact_time_span;
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = tz;
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = california_calendar_exact_time_span_to_timezone (_tmp5_, _tmp6_);
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp7_;
#line 1368 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = self->priv->_exact_time_span;
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 282 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp9_;
#line 1380 "component-event.c"
	}
#line 281 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = california_calendar_date_span_new_from_exact_time_span (_tmp3_);
#line 281 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp10_;
#line 281 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp3_);
#line 281 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1390 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE VEVENT.
     *
     * {@link date_span} will be set and {@link exact_time_span} will be unset.
     *
     * @see set_event_exact_time_span
     */
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 292 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 292 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (date_span));
#line 293 "/home/jim/git/california/src/component/component-event.vala"
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 295 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = date_span;
#line 295 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, _tmp0_);
#line 296 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, NULL);
#line 298 "/home/jim/git/california/src/component/component-event.vala"
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 1417 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE-TIME VEVENT.
     *
     * {@link exact_time_span} will be set and {@link date_span} will be unset.
     *
     * @see set_event_date_span
     */
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 308 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 308 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN (exact_time_span));
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 311 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = exact_time_span;
#line 311 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, _tmp0_);
#line 312 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, NULL);
#line 314 "/home/jim/git/california/src/component/component-event.vala"
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 1444 "component-event.c"
}


/**
     * Adjusts the dates of an {@link Event} while preserving {@link WallTime}, if present.
     *
     * This will preserve the DATE/DATE-TIME aspect of an Event while adjusting the start and
     * end {@link Calendar.Date}s.  If a DATE Event, then this is functionally equivalent to
     * {@link set_event_date_span}.  If a DATE-TIME event, then this is like
     * {@link set_event_exact_time_span} but without the hassle of preserving start and end times
     * while changing the dates.
     */
void california_component_event_adjust_start_date (CaliforniaComponentEvent* self, CaliforniaCalendarDate* new_start_date) {
	CaliforniaCalendarDateSpan* orig_dates = NULL;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	gint diff = 0;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	CaliforniaCalendarDate* new_end_date = NULL;
	CaliforniaCalendarDateSpan* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDate* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gpointer _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	CaliforniaCalendarExactTime* new_start_time = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp18_ = NULL;
	CaliforniaCalendarExactTime* _tmp19_ = NULL;
	CaliforniaCalendarExactTime* _tmp20_ = NULL;
	CaliforniaCalendarTimezone* _tmp21_ = NULL;
	CaliforniaCalendarTimezone* _tmp22_ = NULL;
	CaliforniaCalendarDate* _tmp23_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp24_ = NULL;
	CaliforniaCalendarExactTime* _tmp25_ = NULL;
	CaliforniaCalendarExactTime* _tmp26_ = NULL;
	CaliforniaCalendarWallTime* _tmp27_ = NULL;
	CaliforniaCalendarWallTime* _tmp28_ = NULL;
	CaliforniaCalendarExactTime* _tmp29_ = NULL;
	CaliforniaCalendarExactTime* _tmp30_ = NULL;
	CaliforniaCalendarExactTime* new_end_time = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp31_ = NULL;
	CaliforniaCalendarExactTime* _tmp32_ = NULL;
	CaliforniaCalendarExactTime* _tmp33_ = NULL;
	CaliforniaCalendarTimezone* _tmp34_ = NULL;
	CaliforniaCalendarTimezone* _tmp35_ = NULL;
	CaliforniaCalendarDate* _tmp36_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp37_ = NULL;
	CaliforniaCalendarExactTime* _tmp38_ = NULL;
	CaliforniaCalendarExactTime* _tmp39_ = NULL;
	CaliforniaCalendarWallTime* _tmp40_ = NULL;
	CaliforniaCalendarWallTime* _tmp41_ = NULL;
	CaliforniaCalendarExactTime* _tmp42_ = NULL;
	CaliforniaCalendarExactTime* _tmp43_ = NULL;
	CaliforniaCalendarExactTime* _tmp44_ = NULL;
	CaliforniaCalendarExactTime* _tmp45_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp46_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp47_ = NULL;
#line 326 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 326 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (new_start_date));
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_event_date_span (self, NULL);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	orig_dates = _tmp0_;
#line 330 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = orig_dates;
#line 330 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 330 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_;
#line 330 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = new_start_date;
#line 330 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = california_calendar_unit_difference (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp4_);
#line 330 "/home/jim/git/california/src/component/component-event.vala"
	diff = _tmp5_;
#line 331 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = diff;
#line 331 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ == 0) {
#line 332 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (orig_dates);
#line 332 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1535 "component-event.c"
	}
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = orig_dates;
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = _tmp8_;
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = diff;
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp10_);
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	new_end_date = (CaliforniaCalendarDate*) _tmp11_;
#line 336 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = california_component_event_get_is_all_day (self);
#line 336 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = _tmp12_;
#line 336 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp13_) {
#line 1555 "component-event.c"
		CaliforniaCalendarDate* _tmp14_ = NULL;
		CaliforniaCalendarDate* _tmp15_ = NULL;
		CaliforniaCalendarDateSpan* _tmp16_ = NULL;
		CaliforniaCalendarDateSpan* _tmp17_ = NULL;
#line 337 "/home/jim/git/california/src/component/component-event.vala"
		_tmp14_ = new_start_date;
#line 337 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = new_end_date;
#line 337 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = california_calendar_date_span_new (_tmp14_, _tmp15_);
#line 337 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = _tmp16_;
#line 337 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp17_);
#line 337 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp17_);
#line 339 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (new_end_date);
#line 339 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (orig_dates);
#line 339 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1578 "component-event.c"
	}
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = self->priv->_exact_time_span;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = california_calendar_exact_time_span_get_start_exact_time (_tmp18_);
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = _tmp19_;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = california_calendar_exact_time_get_tz (_tmp20_);
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp22_ = _tmp21_;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp23_ = new_start_date;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp24_ = self->priv->_exact_time_span;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp25_ = california_calendar_exact_time_span_get_start_exact_time (_tmp24_);
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp26_ = _tmp25_;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp27_ = california_calendar_exact_time_to_wall_time (_tmp26_);
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp28_ = _tmp27_;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp29_ = california_calendar_exact_time_new (_tmp22_, _tmp23_, _tmp28_);
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_tmp30_ = _tmp29_;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp28_);
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	new_start_time = _tmp30_;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp31_ = self->priv->_exact_time_span;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp32_ = california_calendar_exact_time_span_get_end_exact_time (_tmp31_);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp33_ = _tmp32_;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp34_ = california_calendar_exact_time_get_tz (_tmp33_);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp35_ = _tmp34_;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp36_ = new_end_date;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp37_ = self->priv->_exact_time_span;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp38_ = california_calendar_exact_time_span_get_end_exact_time (_tmp37_);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp39_ = _tmp38_;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp40_ = california_calendar_exact_time_to_wall_time (_tmp39_);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp41_ = _tmp40_;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp42_ = california_calendar_exact_time_new (_tmp35_, _tmp36_, _tmp41_);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_tmp43_ = _tmp42_;
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp41_);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
	new_end_time = _tmp43_;
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	_tmp44_ = new_start_time;
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	_tmp45_ = new_end_time;
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	_tmp46_ = california_calendar_exact_time_span_new (_tmp44_, _tmp45_);
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	_tmp47_ = _tmp46_;
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_event_exact_time_span (self, _tmp47_);
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp47_);
#line 326 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_end_time);
#line 326 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_start_time);
#line 326 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_end_date);
#line 326 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (orig_dates);
#line 1660 "component-event.c"
}


/**
     * Convert an {@link Event} from an all-day to a timed event by only adding the time.
     *
     * Returns with no changes if {@link is_all_day} is false.
     */
void california_component_event_all_day_to_timed_event (CaliforniaComponentEvent* self, CaliforniaCalendarWallTime* start_time, CaliforniaCalendarWallTime* end_time, CaliforniaCalendarTimezone* timezone) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarTimezone* _tmp2_ = NULL;
	CaliforniaCalendarDateSpan* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarExactTime* _tmp7_ = NULL;
	CaliforniaCalendarExactTime* _tmp8_ = NULL;
	CaliforniaCalendarTimezone* _tmp9_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarWallTime* _tmp13_ = NULL;
	CaliforniaCalendarExactTime* _tmp14_ = NULL;
	CaliforniaCalendarExactTime* _tmp15_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp17_ = NULL;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 362 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (start_time));
#line 362 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (end_time));
#line 362 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (timezone));
#line 364 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_is_all_day (self);
#line 364 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 364 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp1_) {
#line 365 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1704 "component-event.c"
	}
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = timezone;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = self->priv->_date_span;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = _tmp4_;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = start_time;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_calendar_exact_time_new (_tmp2_, _tmp5_, _tmp6_);
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = _tmp7_;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = timezone;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = self->priv->_date_span;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = _tmp11_;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = end_time;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = california_calendar_exact_time_new (_tmp9_, _tmp12_, _tmp13_);
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = _tmp14_;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = california_calendar_exact_time_span_new (_tmp8_, _tmp15_);
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = _tmp16_;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_event_exact_time_span (self, _tmp17_);
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp17_);
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp15_);
#line 368 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp8_);
#line 1746 "component-event.c"
}


/**
     * Convert an {@link Event} from a timed event to an all-day event by removing the time.
     *
     * Returns with no changes if {@link is_all_day} is true.
     */
void california_component_event_timed_to_all_day_event (CaliforniaComponentEvent* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 382 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_is_all_day (self);
#line 382 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 382 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp1_) {
#line 1766 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
		CaliforniaCalendarDateSpan* _tmp3_ = NULL;
#line 383 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = california_component_event_get_event_date_span (self, NULL);
#line 383 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp2_;
#line 383 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp3_);
#line 383 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 1777 "component-event.c"
	}
}


/**
     * Returns a prettified string describing the {@link Event}'s time span in as concise and
     * economical manner possible.
     *
     * @return null if no time/date information is specified
     */
gchar* california_component_event_get_event_time_pretty_string (CaliforniaComponentEvent* self, CaliforniaCalendarDatePrettyFlag date_flags, CaliforniaCalendarExactTimeSpanPrettyFlag time_flags, CaliforniaCalendarTimezone* timezone) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
	CaliforniaCalendarDateSpan* date_span = NULL;
	CaliforniaCalendarTimezone* _tmp3_ = NULL;
	CaliforniaCalendarDateSpan* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarYear* _tmp9_ = NULL;
	CaliforniaCalendarYear* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarYear* _tmp13_ = NULL;
	CaliforniaCalendarYear* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	CaliforniaCalendarExactTimeSpan* _tmp32_ = NULL;
	CaliforniaCalendarTimezone* _tmp33_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp34_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp35_ = NULL;
	CaliforniaCalendarDatePrettyFlag _tmp36_ = 0;
	CaliforniaCalendarExactTimeSpanPrettyFlag _tmp37_ = 0;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
#line 392 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 392 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (timezone), NULL);
#line 394 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = self->priv->_date_span;
#line 394 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_ == NULL) {
#line 1824 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp2_ = NULL;
#line 394 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_exact_time_span;
#line 394 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 1830 "component-event.c"
	} else {
#line 394 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 1834 "component-event.c"
	}
#line 394 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_) {
#line 395 "/home/jim/git/california/src/component/component-event.vala"
		result = NULL;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1842 "component-event.c"
	}
#line 398 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = timezone;
#line 398 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_component_event_get_event_date_span (self, _tmp3_);
#line 398 "/home/jim/git/california/src/component/component-event.vala"
	date_span = _tmp4_;
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = date_span;
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = _tmp7_;
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_calendar_date_get_year (_tmp8_);
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = _tmp9_;
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_system_get_today ();
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = _tmp11_;
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = california_calendar_date_get_year (_tmp12_);
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = _tmp13_;
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_HASHABLE, GeeHashable), _tmp14_);
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp15_) {
#line 399 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = TRUE;
#line 1874 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp16_ = NULL;
		CaliforniaCalendarDate* _tmp17_ = NULL;
		CaliforniaCalendarDate* _tmp18_ = NULL;
		CaliforniaCalendarYear* _tmp19_ = NULL;
		CaliforniaCalendarYear* _tmp20_ = NULL;
		CaliforniaCalendarDate* _tmp21_ = NULL;
		CaliforniaCalendarDate* _tmp22_ = NULL;
		CaliforniaCalendarYear* _tmp23_ = NULL;
		CaliforniaCalendarYear* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = date_span;
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = _tmp17_;
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp19_ = california_calendar_date_get_year (_tmp18_);
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp20_ = _tmp19_;
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp21_ = california_calendar_system_get_today ();
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = _tmp21_;
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp23_ = california_calendar_date_get_year (_tmp22_);
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp24_ = _tmp23_;
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp25_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_HASHABLE, GeeHashable), _tmp24_);
#line 400 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = !_tmp25_;
#line 1908 "component-event.c"
	}
#line 399 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp5_) {
#line 1912 "component-event.c"
		CaliforniaCalendarDatePrettyFlag _tmp26_ = 0;
#line 401 "/home/jim/git/california/src/component/component-event.vala"
		_tmp26_ = date_flags;
#line 401 "/home/jim/git/california/src/component/component-event.vala"
		date_flags = _tmp26_ | CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR;
#line 1918 "component-event.c"
	}
#line 405 "/home/jim/git/california/src/component/component-event.vala"
	_tmp27_ = california_component_event_get_is_all_day (self);
#line 405 "/home/jim/git/california/src/component/component-event.vala"
	_tmp28_ = _tmp27_;
#line 405 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp28_) {
#line 1926 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp29_ = NULL;
		CaliforniaCalendarDatePrettyFlag _tmp30_ = 0;
		gchar* _tmp31_ = NULL;
#line 406 "/home/jim/git/california/src/component/component-event.vala"
		_tmp29_ = date_span;
#line 406 "/home/jim/git/california/src/component/component-event.vala"
		_tmp30_ = date_flags;
#line 406 "/home/jim/git/california/src/component/component-event.vala"
		_tmp31_ = california_calendar_date_span_to_pretty_string (_tmp29_, _tmp30_);
#line 406 "/home/jim/git/california/src/component/component-event.vala"
		result = _tmp31_;
#line 406 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (date_span);
#line 406 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1942 "component-event.c"
	}
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp32_ = self->priv->_exact_time_span;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp33_ = timezone;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp34_ = california_calendar_exact_time_span_to_timezone (_tmp32_, _tmp33_);
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp35_ = _tmp34_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp36_ = date_flags;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp37_ = time_flags;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp38_ = california_calendar_exact_time_span_to_pretty_string (_tmp35_, _tmp36_, _tmp37_);
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp39_ = _tmp38_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp35_);
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp39_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1968 "component-event.c"
}


/**
     * @inheritDoc
     */
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base, gboolean and_useful) {
	CaliforniaComponentEvent * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 414 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 415 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = and_useful;
#line 415 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 1989 "component-event.c"
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_summary;
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_string_is_empty (_tmp2_);
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp3_;
#line 1998 "component-event.c"
	} else {
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 2002 "component-event.c"
	}
#line 415 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_) {
#line 416 "/home/jim/git/california/src/component/component-event.vala"
		result = FALSE;
#line 416 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2010 "component-event.c"
	}
#line 418 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = and_useful;
#line 418 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->is_valid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp5_);
#line 418 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_) {
#line 2018 "component-event.c"
		gboolean _tmp7_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp8_ = NULL;
#line 418 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = self->priv->_date_span;
#line 418 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp8_ != NULL) {
#line 418 "/home/jim/git/california/src/component/component-event.vala"
			_tmp7_ = TRUE;
#line 2027 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
#line 418 "/home/jim/git/california/src/component/component-event.vala"
			_tmp9_ = self->priv->_exact_time_span;
#line 418 "/home/jim/git/california/src/component/component-event.vala"
			_tmp7_ = _tmp9_ != NULL;
#line 2034 "component-event.c"
		}
#line 418 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp7_;
#line 2038 "component-event.c"
	} else {
#line 418 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = FALSE;
#line 2042 "component-event.c"
	}
#line 418 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp4_;
#line 418 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2048 "component-event.c"
}


/**
     * Compares an {@link Event} to another and returns which is chronologically first.
     *
     * The method attempts to compare DATE-TIMEs first, then DATEs, coercing a DATE-TIME into a DATE
     * if necessary.
     *
     * If both events have the same chronological time, they're sorted by summary in lexographical
     * order.
     *
     * {@link dtstamp} is the third comparison attempted.  In general, dtstamp is the time the
     * {@link Component} was created.
     *
     * Finally, UIDs are used to stabilize the sort.
     *
     * @inheritDoc
     */
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other) {
	CaliforniaComponentEvent * self;
	gint result = 0;
	CaliforniaComponentEvent* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint compare = 0;
	gboolean _tmp13_ = FALSE;
	CaliforniaCalendarExactTimeSpan* _tmp14_ = NULL;
	gint _tmp42_ = 0;
	gboolean _tmp43_ = FALSE;
	CaliforniaComponentDateTime* _tmp44_ = NULL;
	CaliforniaComponentDateTime* _tmp45_ = NULL;
	GCompareFunc _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	CaliforniaComponentEvent* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	CaliforniaCalendarExactTime* _tmp62_ = NULL;
	CaliforniaCalendarExactTime* _tmp63_ = NULL;
	CaliforniaComponentEvent* _tmp64_ = NULL;
	CaliforniaCalendarExactTime* _tmp65_ = NULL;
	CaliforniaCalendarExactTime* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	CaliforniaComponentEvent* _tmp71_ = NULL;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gboolean _tmp75_ = FALSE;
	CaliforniaBackingCalendarSource* _tmp76_ = NULL;
	CaliforniaBackingCalendarSource* _tmp77_ = NULL;
	CaliforniaComponentUID* _tmp88_ = NULL;
	CaliforniaComponentUID* _tmp89_ = NULL;
	CaliforniaComponentEvent* _tmp90_ = NULL;
	CaliforniaComponentUID* _tmp91_ = NULL;
	CaliforniaComponentUID* _tmp92_ = NULL;
	gint _tmp93_ = 0;
#line 437 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 437 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (other), 0);
#line 438 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = other;
#line 438 "/home/jim/git/california/src/component/component-event.vala"
	if (self == _tmp0_) {
#line 439 "/home/jim/git/california/src/component/component-event.vala"
		result = 0;
#line 439 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2125 "component-event.c"
	}
#line 442 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = california_component_event_get_is_all_day (self);
#line 442 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_;
#line 442 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp3_) {
#line 2133 "component-event.c"
		CaliforniaComponentEvent* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 442 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = other;
#line 442 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_component_event_get_is_all_day (_tmp4_);
#line 442 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = _tmp5_;
#line 442 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = !_tmp6_;
#line 2145 "component-event.c"
	} else {
#line 442 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = FALSE;
#line 2149 "component-event.c"
	}
#line 442 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 443 "/home/jim/git/california/src/component/component-event.vala"
		result = -1;
#line 443 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2157 "component-event.c"
	}
#line 445 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = california_component_event_get_is_all_day (self);
#line 445 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = _tmp8_;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp9_) {
#line 2165 "component-event.c"
		CaliforniaComponentEvent* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = other;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = california_component_event_get_is_all_day (_tmp10_);
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = _tmp11_;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp12_;
#line 2177 "component-event.c"
	} else {
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = FALSE;
#line 2181 "component-event.c"
	}
#line 445 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp7_) {
#line 446 "/home/jim/git/california/src/component/component-event.vala"
		result = 1;
#line 446 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2189 "component-event.c"
	}
#line 450 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = self->priv->_exact_time_span;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp14_ != NULL) {
#line 2195 "component-event.c"
		CaliforniaComponentEvent* _tmp15_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = other;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = _tmp15_->priv->_exact_time_span;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = _tmp16_ != NULL;
#line 2204 "component-event.c"
	} else {
#line 450 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = FALSE;
#line 2208 "component-event.c"
	}
#line 450 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp13_) {
#line 2212 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp17_ = NULL;
		CaliforniaComponentEvent* _tmp18_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp19_ = NULL;
		gint _tmp20_ = 0;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = self->priv->_exact_time_span;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = other;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp19_ = _tmp18_->priv->_exact_time_span;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp20_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp19_);
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp20_;
#line 2227 "component-event.c"
	} else {
		gboolean _tmp21_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp22_ = NULL;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = self->priv->_date_span;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp22_ != NULL) {
#line 2235 "component-event.c"
			CaliforniaComponentEvent* _tmp23_ = NULL;
			CaliforniaCalendarDateSpan* _tmp24_ = NULL;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
			_tmp23_ = other;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
			_tmp24_ = _tmp23_->priv->_date_span;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
			_tmp21_ = _tmp24_ != NULL;
#line 2244 "component-event.c"
		} else {
#line 452 "/home/jim/git/california/src/component/component-event.vala"
			_tmp21_ = FALSE;
#line 2248 "component-event.c"
		}
#line 452 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp21_) {
#line 2252 "component-event.c"
			CaliforniaCalendarDateSpan* _tmp25_ = NULL;
			CaliforniaComponentEvent* _tmp26_ = NULL;
			CaliforniaCalendarDateSpan* _tmp27_ = NULL;
			gint _tmp28_ = 0;
#line 453 "/home/jim/git/california/src/component/component-event.vala"
			_tmp25_ = self->priv->_date_span;
#line 453 "/home/jim/git/california/src/component/component-event.vala"
			_tmp26_ = other;
#line 453 "/home/jim/git/california/src/component/component-event.vala"
			_tmp27_ = _tmp26_->priv->_date_span;
#line 453 "/home/jim/git/california/src/component/component-event.vala"
			_tmp28_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 453 "/home/jim/git/california/src/component/component-event.vala"
			compare = _tmp28_;
#line 2267 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp29_ = NULL;
#line 454 "/home/jim/git/california/src/component/component-event.vala"
			_tmp29_ = self->priv->_exact_time_span;
#line 454 "/home/jim/git/california/src/component/component-event.vala"
			if (_tmp29_ != NULL) {
#line 2274 "component-event.c"
				CaliforniaCalendarExactTimeSpan* _tmp30_ = NULL;
				CaliforniaCalendarDateSpan* _tmp31_ = NULL;
				CaliforniaCalendarDateSpan* _tmp32_ = NULL;
				CaliforniaComponentEvent* _tmp33_ = NULL;
				CaliforniaCalendarDateSpan* _tmp34_ = NULL;
				gint _tmp35_ = 0;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = self->priv->_exact_time_span;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = california_calendar_date_span_new_from_exact_time_span (_tmp30_);
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = _tmp31_;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = other;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = _tmp33_->priv->_date_span;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				_tmp35_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp35_;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp32_);
#line 2297 "component-event.c"
			} else {
				CaliforniaCalendarDateSpan* _tmp36_ = NULL;
				CaliforniaComponentEvent* _tmp37_ = NULL;
				CaliforniaCalendarExactTimeSpan* _tmp38_ = NULL;
				CaliforniaCalendarDateSpan* _tmp39_ = NULL;
				CaliforniaCalendarDateSpan* _tmp40_ = NULL;
				gint _tmp41_ = 0;
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				_tmp36_ = self->priv->_date_span;
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				_tmp37_ = other;
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				_tmp38_ = _tmp37_->priv->_exact_time_span;
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				_tmp39_ = california_calendar_date_span_new_from_exact_time_span (_tmp38_);
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				_tmp40_ = _tmp39_;
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				_tmp41_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp41_;
#line 457 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp40_);
#line 2321 "component-event.c"
			}
		}
	}
#line 459 "/home/jim/git/california/src/component/component-event.vala"
	_tmp42_ = compare;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp42_ != 0) {
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2333 "component-event.c"
	}
#line 463 "/home/jim/git/california/src/component/component-event.vala"
	_tmp44_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 463 "/home/jim/git/california/src/component/component-event.vala"
	_tmp45_ = _tmp44_;
#line 463 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp45_ != NULL) {
#line 2341 "component-event.c"
		CaliforniaComponentEvent* _tmp46_ = NULL;
		CaliforniaComponentDateTime* _tmp47_ = NULL;
		CaliforniaComponentDateTime* _tmp48_ = NULL;
#line 463 "/home/jim/git/california/src/component/component-event.vala"
		_tmp46_ = other;
#line 463 "/home/jim/git/california/src/component/component-event.vala"
		_tmp47_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 463 "/home/jim/git/california/src/component/component-event.vala"
		_tmp48_ = _tmp47_;
#line 463 "/home/jim/git/california/src/component/component-event.vala"
		_tmp43_ = _tmp48_ != NULL;
#line 2353 "component-event.c"
	} else {
#line 463 "/home/jim/git/california/src/component/component-event.vala"
		_tmp43_ = FALSE;
#line 2357 "component-event.c"
	}
#line 463 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp43_) {
#line 2361 "component-event.c"
		CaliforniaComponentDateTime* _tmp49_ = NULL;
		CaliforniaComponentDateTime* _tmp50_ = NULL;
		CaliforniaComponentEvent* _tmp51_ = NULL;
		CaliforniaComponentDateTime* _tmp52_ = NULL;
		CaliforniaComponentDateTime* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
		_tmp49_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 464 "/home/jim/git/california/src/component/component-event.vala"
		_tmp50_ = _tmp49_;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
		_tmp51_ = other;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
		_tmp52_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 464 "/home/jim/git/california/src/component/component-event.vala"
		_tmp53_ = _tmp52_;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
		_tmp54_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp53_);
#line 464 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp54_;
#line 465 "/home/jim/git/california/src/component/component-event.vala"
		_tmp55_ = compare;
#line 465 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp55_ != 0) {
#line 466 "/home/jim/git/california/src/component/component-event.vala"
			result = compare;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
			return result;
#line 2391 "component-event.c"
		}
	}
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp56_ = g_strcmp0;
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp57_ = self->priv->_summary;
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp58_ = other;
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp59_ = _tmp58_->priv->_summary;
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp60_ = _tmp56_ (_tmp57_, _tmp59_);
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp60_;
#line 471 "/home/jim/git/california/src/component/component-event.vala"
	_tmp61_ = compare;
#line 471 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp61_ != 0) {
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2414 "component-event.c"
	}
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp62_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp63_ = _tmp62_;
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp64_ = other;
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp65_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp66_ = _tmp65_;
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp67_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp66_);
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp67_;
#line 476 "/home/jim/git/california/src/component/component-event.vala"
	_tmp68_ = compare;
#line 476 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp68_ != 0) {
#line 477 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 477 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2438 "component-event.c"
	}
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp69_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp70_ = _tmp69_;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp71_ = other;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp72_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp73_ = _tmp72_;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp70_ - _tmp73_;
#line 481 "/home/jim/git/california/src/component/component-event.vala"
	_tmp74_ = compare;
#line 481 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp74_ != 0) {
#line 482 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 482 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2460 "component-event.c"
	}
#line 485 "/home/jim/git/california/src/component/component-event.vala"
	_tmp76_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 485 "/home/jim/git/california/src/component/component-event.vala"
	_tmp77_ = _tmp76_;
#line 485 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp77_ != NULL) {
#line 2468 "component-event.c"
		CaliforniaComponentEvent* _tmp78_ = NULL;
		CaliforniaBackingCalendarSource* _tmp79_ = NULL;
		CaliforniaBackingCalendarSource* _tmp80_ = NULL;
#line 485 "/home/jim/git/california/src/component/component-event.vala"
		_tmp78_ = other;
#line 485 "/home/jim/git/california/src/component/component-event.vala"
		_tmp79_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 485 "/home/jim/git/california/src/component/component-event.vala"
		_tmp80_ = _tmp79_;
#line 485 "/home/jim/git/california/src/component/component-event.vala"
		_tmp75_ = _tmp80_ != NULL;
#line 2480 "component-event.c"
	} else {
#line 485 "/home/jim/git/california/src/component/component-event.vala"
		_tmp75_ = FALSE;
#line 2484 "component-event.c"
	}
#line 485 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp75_) {
#line 2488 "component-event.c"
		CaliforniaBackingCalendarSource* _tmp81_ = NULL;
		CaliforniaBackingCalendarSource* _tmp82_ = NULL;
		CaliforniaComponentEvent* _tmp83_ = NULL;
		CaliforniaBackingCalendarSource* _tmp84_ = NULL;
		CaliforniaBackingCalendarSource* _tmp85_ = NULL;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp81_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp82_ = _tmp81_;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp83_ = other;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp84_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp85_ = _tmp84_;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp86_ = california_backing_source_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource));
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp86_;
#line 487 "/home/jim/git/california/src/component/component-event.vala"
		_tmp87_ = compare;
#line 487 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp87_ != 0) {
#line 488 "/home/jim/git/california/src/component/component-event.vala"
			result = compare;
#line 488 "/home/jim/git/california/src/component/component-event.vala"
			return result;
#line 2518 "component-event.c"
		}
	}
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	_tmp88_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	_tmp89_ = _tmp88_;
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	_tmp90_ = other;
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	_tmp91_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	_tmp92_ = _tmp91_;
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	_tmp93_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp92_);
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp93_;
#line 492 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2537 "component-event.c"
}


static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaComponentEvent * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CaliforniaComponentDateTime* _tmp1_ = NULL;
	CaliforniaComponentDateTime* _tmp2_ = NULL;
	gchar* _tmp7_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
	CaliforniaComponentUID* _tmp13_ = NULL;
	CaliforniaComponentUID* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
#line 495 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 498 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 498 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 498 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_ != NULL) {
#line 2566 "component-event.c"
		CaliforniaComponentDateTime* _tmp3_ = NULL;
		CaliforniaComponentDateTime* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp3_;
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp5_;
#line 2580 "component-event.c"
	} else {
		gchar* _tmp6_ = NULL;
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = g_strdup ("(no-recurring)");
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 498 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp6_;
#line 2589 "component-event.c"
	}
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = self->priv->_exact_time_span;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp8_ != NULL) {
#line 2595 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = self->priv->_exact_time_span;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp10_;
#line 2606 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = self->priv->_date_span;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 501 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp12_;
#line 2618 "component-event.c"
	}
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = _tmp13_;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = _tmp15_;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = _tmp17_;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = self->priv->_summary;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = g_strdup_printf ("Event %s/rid=%s/%d \"%s\" (%s)", _tmp16_, _tmp0_, _tmp18_, _tmp19_, _tmp7_);
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = _tmp20_;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp16_);
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp21_;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp7_);
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp0_);
#line 496 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2648 "component-event.c"
}


const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_summary;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2663 "component-event.c"
}


void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = _tmp1_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "summary");
#line 2682 "component-event.c"
}


const gchar* california_component_event_get_description (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_description;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2697 "component-event.c"
}


void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = _tmp1_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "description");
#line 2716 "component-event.c"
}


CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarExactTimeSpan* result;
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_exact_time_span;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2731 "component-event.c"
}


static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp1_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = _tmp1_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "exact-time-span");
#line 2750 "component-event.c"
}


CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarDateSpan* result;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2765 "component-event.c"
}


static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = _tmp1_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "date-span");
#line 2784 "component-event.c"
}


gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
#line 64 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = self->priv->_date_span;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_ != NULL) {
#line 2798 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp2_ = NULL;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_exact_time_span;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 2804 "component-event.c"
	} else {
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 2808 "component-event.c"
	}
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2814 "component-event.c"
}


gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 73 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_event_get_is_all_day (self);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_) {
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = TRUE;
#line 2833 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
		CaliforniaCalendarDuration* _tmp4_ = NULL;
		CaliforniaCalendarDuration* _tmp5_ = NULL;
		CaliforniaCalendarDuration* _tmp6_ = NULL;
		guint64 _tmp7_ = 0ULL;
		guint64 _tmp8_ = 0ULL;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = self->priv->_exact_time_span;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = california_calendar_exact_time_span_get_duration (_tmp3_);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = _tmp4_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = _tmp5_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = california_calendar_duration_get_days (_tmp6_);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = _tmp7_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp8_ >= ((guint64) 1);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp6_);
#line 2857 "component-event.c"
	}
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2863 "component-event.c"
}


const gchar* california_component_event_get_location (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_location;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2878 "component-event.c"
}


void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = _tmp1_;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "location");
#line 2897 "component-event.c"
}


CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self) {
	CaliforniaComponentEventStatus result;
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), 0);
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_status;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2912 "component-event.c"
}


void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value) {
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = _tmp0_;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "status");
#line 2926 "component-event.c"
}


static void california_component_event_class_init (CaliforniaComponentEventClass * klass) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaComponentEventPrivate));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaComponentInstanceClass *) klass)->update_from_component = california_component_event_real_update_from_component;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaComponentInstanceClass *) klass)->clone = california_component_event_real_clone;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaComponentInstanceClass *) klass)->is_valid = california_component_event_real_is_valid;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_component_event_real_to_string;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_component_event_get_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_component_event_set_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->finalize = california_component_event_finalize;
#line 2949 "component-event.c"
	/**
	     * Summary (title) of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_SUMMARY, g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2955 "component-event.c"
	/**
	     * Description of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2961 "component-event.c"
	/**
	     * {@link Calendar.ExactTimeSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT specifies a DATE-TIME for both properties, otherwise
	     * {@link date_span} will be specified.
	     *
	     * @see set_exact_time_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN, g_param_spec_object ("exact-time-span", "exact-time-span", "exact-time-span", CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2972 "component-event.c"
	/**
	     * {@link Calendar.DateSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT defines a DATE for one or both properties.  Generally
	     * this indicates an "all day" or multi-day event.
	     *
	     * @see set_date_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DATE_SPAN, g_param_spec_object ("date-span", "date-span", "date-span", CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2983 "component-event.c"
	/**
	     * Convenience property for determining if an all-day event or not.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY, g_param_spec_boolean ("is-all-day", "is-all-day", "is-all-day", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2989 "component-event.c"
	/**
	     * Convenience property for determining if {@link Event} spans one or more full days.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING, g_param_spec_boolean ("is-day-spanning", "is-day-spanning", "is-day-spanning", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2995 "component-event.c"
	/**
	     * Location of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_LOCATION, g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3001 "component-event.c"
	/**
	     * Status (confirmation) of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_STATUS, g_param_spec_enum ("status", "status", "status", CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3007 "component-event.c"
}


static void california_component_event_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_component_event_real_compare_to;
#line 3016 "component-event.c"
}


static void california_component_event_instance_init (CaliforniaComponentEvent * self) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self->priv = CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE (self);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = NULL;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED;
#line 3035 "component-event.c"
}


static void california_component_event_finalize (GObject* obj) {
	CaliforniaComponentEvent * self;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (california_component_event_parent_class)->finalize (obj);
#line 3055 "component-event.c"
}


/**
 * A mutable representation of an iCalendar Event.
 *
 * See [[https://tools.ietf.org/html/rfc5545#section-3.6.1]]
 */
GType california_component_event_get_type (void) {
	static volatile gsize california_component_event_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaComponentEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_component_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaComponentEvent), 0, (GInstanceInitFunc) california_component_event_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_component_event_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_component_event_type_id;
		california_component_event_type_id = g_type_register_static (CALIFORNIA_COMPONENT_TYPE_INSTANCE, "CaliforniaComponentEvent", &g_define_type_info, 0);
		g_type_add_interface_static (california_component_event_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_once_init_leave (&california_component_event_type_id__volatile, california_component_event_type_id);
	}
	return california_component_event_type_id__volatile;
}


static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_summary (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_description (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_exact_time_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_date_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_all_day (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_day_spanning (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_location (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_enum (value, california_component_event_get_status (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3131 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3137 "component-event.c"
	}
}


static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_summary (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_description (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_exact_time_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_date_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_location (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_status (self, g_value_get_enum (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3183 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3189 "component-event.c"
	}
}



