/* calendar-date.c generated by valac 0.26.1, the Vala compiler
 * generated from calendar-date.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;
typedef struct _CaliforniaCalendarSpanPrivate CaliforniaCalendarSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;
typedef struct _CaliforniaCalendarUnitPrivate CaliforniaCalendarUnitPrivate;
typedef struct _CaliforniaCalendarDatePrivate CaliforniaCalendarDatePrivate;

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK (california_calendar_day_of_week_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeek))
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeekClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_WEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK))
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeekClass))

typedef struct _CaliforniaCalendarDayOfWeek CaliforniaCalendarDayOfWeek;
typedef struct _CaliforniaCalendarDayOfWeekClass CaliforniaCalendarDayOfWeekClass;

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH (california_calendar_day_of_month_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonth))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))

typedef struct _CaliforniaCalendarDayOfMonth CaliforniaCalendarDayOfMonth;
typedef struct _CaliforniaCalendarDayOfMonthClass CaliforniaCalendarDayOfMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH (california_calendar_month_get_type ())
#define CALIFORNIA_CALENDAR_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonth))
#define CALIFORNIA_CALENDAR_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))
#define CALIFORNIA_CALENDAR_IS_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_IS_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))

typedef struct _CaliforniaCalendarMonth CaliforniaCalendarMonth;
typedef struct _CaliforniaCalendarMonthClass CaliforniaCalendarMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;

#define CALIFORNIA_CALENDAR_DATE_TYPE_PRETTY_FLAG (california_calendar_date_pretty_flag_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK (california_calendar_first_of_week_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_WEEK (california_calendar_week_get_type ())
#define CALIFORNIA_CALENDAR_WEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek))
#define CALIFORNIA_CALENDAR_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))
#define CALIFORNIA_CALENDAR_IS_WEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_IS_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_WEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))

typedef struct _CaliforniaCalendarWeek CaliforniaCalendarWeek;
typedef struct _CaliforniaCalendarWeekClass CaliforniaCalendarWeekClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR (california_calendar_month_of_year_get_type ())
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))

typedef struct _CaliforniaCalendarMonthOfYear CaliforniaCalendarMonthOfYear;
typedef struct _CaliforniaCalendarMonthOfYearClass CaliforniaCalendarMonthOfYearClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSpanPrivate * priv;
};

struct _CaliforniaCalendarSpanClass {
	CaliforniaBaseObjectClass parent_class;
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (CaliforniaCollectionSimpleIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (CaliforniaCollectionSimpleIterable* self);
	GDestroyNotify (*get_g_destroy_func) (CaliforniaCollectionSimpleIterable* self);
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarUnit {
	CaliforniaCalendarSpan parent_instance;
	CaliforniaCalendarUnitPrivate * priv;
};

struct _CaliforniaCalendarUnitClass {
	CaliforniaCalendarSpanClass parent_class;
	gpointer (*adjust) (CaliforniaCalendarUnit* self, gint quantity);
	gint (*difference) (CaliforniaCalendarUnit* self, gconstpointer other);
};

struct _CaliforniaCalendarDate {
	CaliforniaCalendarUnit parent_instance;
	CaliforniaCalendarDatePrivate * priv;
};

struct _CaliforniaCalendarDateClass {
	CaliforniaCalendarUnitClass parent_class;
};

struct _CaliforniaCalendarDatePrivate {
	CaliforniaCalendarDayOfWeek* _day_of_week;
	CaliforniaCalendarDayOfMonth* _day_of_month;
	gint _day_of_year;
	CaliforniaCalendarMonth* _month;
	CaliforniaCalendarYear* _year;
	GDate gdate;
};

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV = 1 << 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT = 1 << 1,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR = 1 << 2,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR = 1 << 3,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY = 1 << 4,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK = 1 << 5
} CaliforniaCalendarDatePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;

typedef enum  {
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_DEFAULT = CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY
} CaliforniaCalendarFirstOfWeek;


static gpointer california_calendar_date_parent_class = NULL;
static CaliforniaCalendarDate* california_calendar_date__earliest;
static CaliforniaCalendarDate* california_calendar_date__earliest = NULL;
static CaliforniaCalendarDate* california_calendar_date__latest;
static CaliforniaCalendarDate* california_calendar_date__latest = NULL;
extern CaliforniaCalendarMonth* california_calendar_month_DEC;
extern const gchar* california_calendar_FMT_FULL_DATE;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_YEAR;
static GeeComparableIface* california_calendar_date_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_date_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_day_of_week_get_type (void) G_GNUC_CONST;
GType california_calendar_day_of_month_get_type (void) G_GNUC_CONST;
GType california_calendar_month_get_type (void) G_GNUC_CONST;
GType california_calendar_year_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDatePrivate))
enum  {
	CALIFORNIA_CALENDAR_DATE_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_DATE_START_DATE,
	CALIFORNIA_CALENDAR_DATE_END_DATE,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR,
	CALIFORNIA_CALENDAR_DATE_MONTH,
	CALIFORNIA_CALENDAR_DATE_YEAR
};
GType california_calendar_date_pretty_flag_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DATE_PROP_DAY_OF_WEEK "day-of-week"
#define CALIFORNIA_CALENDAR_DATE_PROP_DAY_OF_MONTH "day-of-month"
#define CALIFORNIA_CALENDAR_DATE_PROP_MONTH "month"
#define CALIFORNIA_CALENDAR_DATE_PROP_YEAR "year"
GQuark california_calendar_error_quark (void);
CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarUnit* california_calendar_unit_construct_uninitialized (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit);
GDateDay california_calendar_day_of_month_to_date_day (CaliforniaCalendarDayOfMonth* self);
GDateMonth california_calendar_month_to_date_month (CaliforniaCalendarMonth* self);
GDateYear california_calendar_year_to_date_year (CaliforniaCalendarYear* self);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
CaliforniaCalendarDayOfWeek* california_calendar_day_of_week_from_gdate (GDate* date);
static void california_calendar_date_set_day_of_week (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfWeek* value);
static void california_calendar_date_set_day_of_month (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfMonth* value);
static void california_calendar_date_set_day_of_year (CaliforniaCalendarDate* self, gint value);
static void california_calendar_date_set_month (CaliforniaCalendarDate* self, CaliforniaCalendarMonth* value);
static void california_calendar_date_set_year (CaliforniaCalendarDate* self, CaliforniaCalendarYear* value);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDayOfMonth* california_calendar_exact_time_get_day_of_month (CaliforniaCalendarExactTime* self);
CaliforniaCalendarMonth* california_calendar_exact_time_get_month (CaliforniaCalendarExactTime* self);
CaliforniaCalendarYear* california_calendar_exact_time_get_year (CaliforniaCalendarExactTime* self);
CaliforniaCalendarDayOfMonth* california_calendar_date_get_day_of_month (CaliforniaCalendarDate* self);
CaliforniaCalendarMonth* california_calendar_date_get_month (CaliforniaCalendarDate* self);
CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_date_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_exact_time_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_date_new_from_gdate (GDate* gdate);
CaliforniaCalendarDate* california_calendar_date_construct_from_gdate (GType object_type, GDate* gdate);
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_from_gdate (GDate* gdate);
CaliforniaCalendarMonth* california_calendar_month_from_gdate (GDate* gdate);
CaliforniaCalendarYear* california_calendar_year_new_from_gdate (GDate* gdate);
CaliforniaCalendarYear* california_calendar_year_construct_from_gdate (GType object_type, GDate* gdate);
void california_calendar_date_init (GError** error);
CaliforniaCalendarDate* california_calendar_date_get_earliest (void);
static void california_calendar_date_set_earliest (CaliforniaCalendarDate* value);
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_for (gint value, GError** error);
CaliforniaCalendarYear* california_calendar_year_new (gint value);
CaliforniaCalendarYear* california_calendar_year_construct (GType object_type, gint value);
CaliforniaCalendarDate* california_calendar_date_get_latest (void);
static void california_calendar_date_set_latest (CaliforniaCalendarDate* value);
void california_calendar_date_terminate (void);
GType california_calendar_first_of_week_get_type (void) G_GNUC_CONST;
GType california_calendar_week_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWeek* california_calendar_date_week_of (CaliforniaCalendarDate* self, CaliforniaCalendarFirstOfWeek first);
CaliforniaCalendarDayOfWeek* california_calendar_date_get_day_of_week (CaliforniaCalendarDate* self);
gint california_calendar_day_of_week_ordinal (CaliforniaCalendarDayOfWeek* self, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarDayOfWeek* california_calendar_first_of_week_as_day_of_week (CaliforniaCalendarFirstOfWeek self);
CaliforniaCalendarDate* california_calendar_date_adjust_by (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit);
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_MAX 7
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_MIN 1
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT ((CALIFORNIA_CALENDAR_DAY_OF_WEEK_MAX - CALIFORNIA_CALENDAR_DAY_OF_WEEK_MIN) + 1)
GType california_calendar_month_of_year_get_type (void) G_GNUC_CONST;
CaliforniaCalendarMonthOfYear* california_calendar_date_month_of_year (CaliforniaCalendarDate* self);
CaliforniaCalendarWeek* california_calendar_week_new (CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarWeek* california_calendar_week_construct (GType object_type, CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_new (CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_construct (GType object_type, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
static CaliforniaCalendarDate* california_calendar_date_real_adjust (CaliforniaCalendarUnit* base, gint quantity);
CaliforniaCalendarDate* california_calendar_date_upcoming (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target);
static CaliforniaCalendarDate* california_calendar_date_upcoming_prior (CaliforniaCalendarDate* self, gboolean inclusive, gint adjustment, GeePredicate predicate, void* predicate_target);
CaliforniaCalendarDate* california_calendar_date_prior (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target);
gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity);
static gint california_calendar_date_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarDate* other);
CaliforniaCalendarDate* california_calendar_date_clamp (CaliforniaCalendarDate* self, CaliforniaCalendarDate* min, CaliforniaCalendarDate* max);
static gint california_calendar_date_real_compare_to (GeeComparable* base, CaliforniaCalendarDate* other);
static gboolean california_calendar_date_real_equal_to (GeeHashable* base, CaliforniaCalendarDate* other);
static guint california_calendar_date_real_hash (GeeHashable* base);
gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt);
gchar* california_calendar_date_to_standard_string (CaliforniaCalendarDate* self);
gchar* california_calendar_date_to_pretty_string (CaliforniaCalendarDate* self, CaliforniaCalendarDatePrettyFlag flags);
CaliforniaCalendarDate* california_calendar_system_get_today (void);
gchar* california_string_reduce_whitespace (const gchar* str);
gchar* california_string_remove_leading_chars (const gchar* str, gunichar ch, const gchar* delims);
static gchar* california_calendar_date_real_to_string (CaliforniaBaseObject* base);
gint california_calendar_date_get_day_of_year (CaliforniaCalendarDate* self);
static void california_calendar_date_finalize (GObject* obj);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
static void _vala_california_calendar_date_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_date_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Options for {@link to_pretty_string}.
     */
GType california_calendar_date_pretty_flag_get_type (void) {
	static volatile gsize california_calendar_date_pretty_flag_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_pretty_flag_type_id__volatile)) {
		static const GFlagsValue values[] = {{CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE", "none"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV", "abbrev"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT", "compact"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR", "include-year"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR", "include-other-year"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY", "no-today"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK", "no-day-of-week"}, {0, NULL, NULL}};
		GType california_calendar_date_pretty_flag_type_id;
		california_calendar_date_pretty_flag_type_id = g_flags_register_static ("CaliforniaCalendarDatePrettyFlag", values);
		g_once_init_leave (&california_calendar_date_pretty_flag_type_id__volatile, california_calendar_date_pretty_flag_type_id);
	}
	return california_calendar_date_pretty_flag_type_id__volatile;
}


/**
     * Creates a new {@link Date} object for the day, month, and year.
     *
     * @throws CalendarError if an invalid calendar day
     */
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
	GDateDay _tmp1_ = '\0';
	CaliforniaCalendarMonth* _tmp2_ = NULL;
	GDateMonth _tmp3_ = 0;
	CaliforniaCalendarYear* _tmp4_ = NULL;
	GDateYear _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	GDate _tmp18_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp19_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp20_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	CaliforniaCalendarMonth* _tmp23_ = NULL;
	CaliforniaCalendarYear* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH (day_of_month), NULL);
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH (month), NULL);
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (year), NULL);
#line 103 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = day_of_month;
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_day_of_month_to_date_day (_tmp0_);
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = month;
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = california_calendar_month_to_date_month (_tmp2_);
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = year;
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = california_calendar_year_to_date_year (_tmp4_);
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&self->priv->gdate, _tmp1_, (gint) _tmp3_, _tmp5_);
#line 106 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = g_date_valid (&self->priv->gdate);
#line 106 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp6_) {
#line 456 "calendar-date.c"
		CaliforniaCalendarDayOfMonth* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		CaliforniaCalendarMonth* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		CaliforniaCalendarYear* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = day_of_month;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp8_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = _tmp8_;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = month;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = _tmp11_;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = year;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = _tmp14_;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp16_ = g_error_new (CALIFORNIA_CALENDAR_ERROR, CALIFORNIA_CALENDAR_ERROR_INVALID, "Invalid day/month/year %s/%s/%s", _tmp9_, _tmp12_, _tmp15_);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp17_ = _tmp16_;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp15_);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp12_);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp9_);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_inner_error_ = _tmp17_;
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_propagate_error (error, _inner_error_);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_g_object_unref0 (self);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return NULL;
#line 506 "calendar-date.c"
		} else {
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_clear_error (&_inner_error_);
#line 107 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return NULL;
#line 514 "calendar-date.c"
		}
	}
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = self->priv->gdate;
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp19_ = california_calendar_day_of_week_from_gdate (&_tmp18_);
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp20_ = _tmp19_;
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp20_);
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp20_);
#line 112 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = day_of_month;
#line 112 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp21_);
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = g_date_get_day_of_year (&self->priv->gdate);
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp22_);
#line 114 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp23_ = month;
#line 114 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp23_);
#line 115 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = year;
#line 115 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp24_);
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 545 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error) {
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct (CALIFORNIA_CALENDAR_TYPE_DATE, day_of_month, month, year, error);
#line 552 "calendar-date.c"
}


/**
     * Creates a {@link Date} for the {@link ExactTime}.
     */
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarExactTime* _tmp0_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp2_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp3_ = NULL;
	CaliforniaCalendarExactTime* _tmp4_ = NULL;
	CaliforniaCalendarMonth* _tmp5_ = NULL;
	CaliforniaCalendarMonth* _tmp6_ = NULL;
	CaliforniaCalendarMonth* _tmp7_ = NULL;
	CaliforniaCalendarExactTime* _tmp8_ = NULL;
	CaliforniaCalendarYear* _tmp9_ = NULL;
	CaliforniaCalendarYear* _tmp10_ = NULL;
	CaliforniaCalendarYear* _tmp11_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp12_ = NULL;
	GDateDay _tmp13_ = '\0';
	CaliforniaCalendarMonth* _tmp14_ = NULL;
	GDateMonth _tmp15_ = 0;
	CaliforniaCalendarYear* _tmp16_ = NULL;
	GDateYear _tmp17_ = 0U;
	gboolean _tmp18_ = FALSE;
	GDate _tmp19_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp20_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
#line 121 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME (exact_time), NULL);
#line 122 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 125 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = exact_time;
#line 125 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_exact_time_get_day_of_month (_tmp0_);
#line 125 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_;
#line 125 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp3_);
#line 125 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp3_);
#line 126 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = exact_time;
#line 126 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = california_calendar_exact_time_get_month (_tmp4_);
#line 126 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = _tmp5_;
#line 126 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = _tmp6_;
#line 126 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp7_);
#line 126 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp7_);
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = exact_time;
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = california_calendar_exact_time_get_year (_tmp8_);
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = _tmp9_;
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp11_ = _tmp10_;
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp11_);
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp11_);
#line 129 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp12_ = self->priv->_day_of_month;
#line 129 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp13_ = california_calendar_day_of_month_to_date_day (_tmp12_);
#line 129 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = self->priv->_month;
#line 129 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp15_ = california_calendar_month_to_date_month (_tmp14_);
#line 129 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = self->priv->_year;
#line 129 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_year_to_date_year (_tmp16_);
#line 129 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&self->priv->gdate, _tmp13_, (gint) _tmp15_, _tmp17_);
#line 130 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = g_date_valid (&self->priv->gdate);
#line 130 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp18_, "gdate.valid()");
#line 132 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp19_ = self->priv->gdate;
#line 132 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp20_ = california_calendar_day_of_week_from_gdate (&_tmp19_);
#line 132 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = _tmp20_;
#line 132 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp21_);
#line 132 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp21_);
#line 133 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = g_date_get_day_of_year (&self->priv->gdate);
#line 133 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp22_);
#line 121 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 658 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time) {
#line 121 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_from_exact_time (CALIFORNIA_CALENDAR_TYPE_DATE, exact_time);
#line 665 "calendar-date.c"
}


/**
     * Creates a {@link Date} that corresponds to the current time in the specified {@link Timezone}.
     */
CaliforniaCalendarDate* california_calendar_date_construct_now (GType object_type, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
	CaliforniaCalendarExactTime* _tmp1_ = NULL;
	CaliforniaCalendarExactTime* _tmp2_ = NULL;
#line 139 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 140 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = tz;
#line 140 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_exact_time_new_now (_tmp0_);
#line 140 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_;
#line 140 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_date_construct_from_exact_time (object_type, _tmp2_);
#line 140 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp2_);
#line 139 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 691 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_now (CaliforniaCalendarTimezone* tz) {
#line 139 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_now (CALIFORNIA_CALENDAR_TYPE_DATE, tz);
#line 698 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_construct_from_gdate (GType object_type, GDate* gdate) {
	CaliforniaCalendarDate * self = NULL;
	gboolean _tmp0_ = FALSE;
	GDate _tmp1_ = {0};
	GDate _tmp2_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp3_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp4_ = NULL;
	GDate _tmp5_ = {0};
	CaliforniaCalendarDayOfMonth* _tmp6_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	GDate _tmp9_ = {0};
	CaliforniaCalendarMonth* _tmp10_ = NULL;
	CaliforniaCalendarMonth* _tmp11_ = NULL;
	GDate _tmp12_ = {0};
	CaliforniaCalendarYear* _tmp13_ = NULL;
	CaliforniaCalendarYear* _tmp14_ = NULL;
#line 143 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (gdate != NULL, NULL);
#line 144 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_date_valid (gdate);
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp0_, "gdate.valid()");
#line 148 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = *gdate;
#line 148 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->gdate = _tmp1_;
#line 150 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = *gdate;
#line 150 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = california_calendar_day_of_week_from_gdate (&_tmp2_);
#line 150 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = _tmp3_;
#line 150 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp4_);
#line 150 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp4_);
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = *gdate;
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = california_calendar_day_of_month_from_gdate (&_tmp5_);
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = _tmp6_;
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp7_);
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp7_);
#line 152 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = g_date_get_day_of_year (gdate);
#line 152 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp8_);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = *gdate;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = california_calendar_month_from_gdate (&_tmp9_);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp11_ = _tmp10_;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp11_);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp11_);
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp12_ = *gdate;
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp13_ = california_calendar_year_new_from_gdate (&_tmp12_);
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = _tmp13_;
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp14_);
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp14_);
#line 143 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 777 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_from_gdate (GDate* gdate) {
#line 143 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_from_gdate (CALIFORNIA_CALENDAR_TYPE_DATE, gdate);
#line 784 "calendar-date.c"
}


void california_calendar_date_init (GError** error) {
	GDate earliest_gdate = {0};
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	GDate _tmp2_ = {0};
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp5_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarMonth* _tmp8_ = NULL;
	CaliforniaCalendarYear* _tmp9_ = NULL;
	CaliforniaCalendarYear* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarDate* _tmp13_ = NULL;
	CaliforniaCalendarDate* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
#line 158 "/home/jim/git/california/src/calendar/calendar-date.vala"
	memset (&earliest_gdate, 0, sizeof (GDate));
#line 159 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_julian (&earliest_gdate, (guint) 1);
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_date_get_earliest ();
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _tmp0_;
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = earliest_gdate;
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = california_calendar_date_new_from_gdate (&_tmp2_);
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = _tmp3_;
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_earliest (_tmp4_);
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp4_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = california_calendar_day_of_month_for (31, &_inner_error_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = _tmp6_;
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_propagate_error (error, _inner_error_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return;
#line 836 "calendar-date.c"
		} else {
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_clear_error (&_inner_error_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return;
#line 844 "calendar-date.c"
		}
	}
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = california_calendar_month_DEC;
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = california_calendar_year_new (100000);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = _tmp9_;
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp11_ = california_calendar_date_new (_tmp5_, _tmp8_, _tmp10_, &_inner_error_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp12_ = _tmp11_;
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp10_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = _tmp12_;
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_propagate_error (error, _inner_error_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_g_object_unref0 (_tmp5_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return;
#line 871 "calendar-date.c"
		} else {
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_g_object_unref0 (_tmp5_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_clear_error (&_inner_error_);
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return;
#line 881 "calendar-date.c"
		}
	}
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp13_ = california_calendar_date_get_latest ();
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = _tmp13_;
#line 164 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_latest (_tmp7_);
#line 157 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp7_);
#line 157 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp5_);
#line 894 "calendar-date.c"
}


void california_calendar_date_terminate (void) {
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
#line 168 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_date_get_earliest ();
#line 168 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _tmp0_;
#line 168 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_earliest (NULL);
#line 169 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_date_get_latest ();
#line 169 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = _tmp2_;
#line 169 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_latest (NULL);
#line 915 "calendar-date.c"
}


/**
     * Returns the {@link Week} the {@link Date} falls in.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self ? g_object_ref (self) : NULL;
#line 925 "calendar-date.c"
}


CaliforniaCalendarWeek* california_calendar_date_week_of (CaliforniaCalendarDate* self, CaliforniaCalendarFirstOfWeek first) {
	CaliforniaCalendarWeek* result = NULL;
	gint ahead = 0;
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp1_ = 0;
	gint _tmp2_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp3_ = 0;
	CaliforniaCalendarDayOfWeek* _tmp4_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp5_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	CaliforniaCalendarDate* start = NULL;
	gint _tmp10_ = 0;
	CaliforniaCalendarDate* end = NULL;
	CaliforniaCalendarDate* _tmp16_ = NULL;
	CaliforniaCalendarDate* _tmp17_ = NULL;
	gint week_of_year = 0;
	CaliforniaCalendarFirstOfWeek _tmp18_ = 0;
	GDate first_of_month = {0};
	CaliforniaCalendarMonth* _tmp21_ = NULL;
	GDateMonth _tmp22_ = 0;
	CaliforniaCalendarYear* _tmp23_ = NULL;
	GDateYear _tmp24_ = 0U;
	gboolean _tmp25_ = FALSE;
	gint week_of_month = 0;
	CaliforniaCalendarFirstOfWeek _tmp26_ = 0;
	CaliforniaCalendarDate* _tmp31_ = NULL;
	CaliforniaCalendarDate* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	CaliforniaCalendarMonthOfYear* _tmp35_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp36_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp37_ = 0;
	CaliforniaCalendarWeek* _tmp38_ = NULL;
	CaliforniaCalendarWeek* _tmp39_ = NULL;
#line 175 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_week;
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = first;
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_day_of_week_ordinal (_tmp0_, _tmp1_);
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = first;
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = california_calendar_first_of_week_as_day_of_week (_tmp3_);
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = _tmp4_;
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = first;
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = california_calendar_day_of_week_ordinal (_tmp5_, _tmp6_);
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = _tmp2_ - _tmp7_;
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp5_);
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	ahead = _tmp8_;
#line 178 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = ahead;
#line 178 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp9_ >= 0, "ahead >= 0");
#line 181 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = ahead;
#line 181 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp10_ == 0) {
#line 998 "calendar-date.c"
		CaliforniaCalendarDate* _tmp11_ = NULL;
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = _g_object_ref0 (self);
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (start);
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
		start = _tmp11_;
#line 1006 "calendar-date.c"
	} else {
		GDate clone = {0};
		GDate _tmp12_ = {0};
		gint _tmp13_ = 0;
		GDate _tmp14_ = {0};
		CaliforniaCalendarDate* _tmp15_ = NULL;
#line 184 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = self->priv->gdate;
#line 184 "/home/jim/git/california/src/calendar/calendar-date.vala"
		clone = _tmp12_;
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = ahead;
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_date_subtract_days (&clone, (guint) _tmp13_);
#line 186 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = clone;
#line 186 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = california_calendar_date_new_from_gdate (&_tmp14_);
#line 186 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (start);
#line 186 "/home/jim/git/california/src/calendar/calendar-date.vala"
		start = _tmp15_;
#line 1029 "calendar-date.c"
	}
#line 190 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = start;
#line 190 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_date_adjust_by (_tmp16_, CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT - 1, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 190 "/home/jim/git/california/src/calendar/calendar-date.vala"
	end = _tmp17_;
#line 194 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = first;
#line 194 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp18_) {
#line 194 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY:
#line 1043 "calendar-date.c"
		{
			guint _tmp19_ = 0U;
#line 196 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp19_ = g_date_get_monday_week_of_year (&self->priv->gdate);
#line 196 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_year = (gint) _tmp19_;
#line 197 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1052 "calendar-date.c"
		}
#line 194 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY:
#line 1056 "calendar-date.c"
		{
			guint _tmp20_ = 0U;
#line 200 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp20_ = g_date_get_sunday_week_of_year (&self->priv->gdate);
#line 200 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_year = (gint) _tmp20_;
#line 201 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1065 "calendar-date.c"
		}
		default:
		{
#line 204 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 1071 "calendar-date.c"
		}
	}
#line 208 "/home/jim/git/california/src/calendar/calendar-date.vala"
	memset (&first_of_month, 0, sizeof (GDate));
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = self->priv->_month;
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = california_calendar_month_to_date_month (_tmp21_);
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp23_ = self->priv->_year;
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = california_calendar_year_to_date_year (_tmp23_);
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&first_of_month, (GDateDay) 1, (gint) _tmp22_, _tmp24_);
#line 210 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp25_ = g_date_valid (&first_of_month);
#line 210 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp25_, "first_of_month.valid()");
#line 213 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp26_ = first;
#line 213 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp26_) {
#line 213 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY:
#line 1096 "calendar-date.c"
		{
			gint _tmp27_ = 0;
			guint _tmp28_ = 0U;
#line 215 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp27_ = week_of_year;
#line 215 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp28_ = g_date_get_monday_week_of_year (&first_of_month);
#line 215 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_month = (_tmp27_ - ((gint) _tmp28_)) + 1;
#line 216 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1108 "calendar-date.c"
		}
#line 213 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY:
#line 1112 "calendar-date.c"
		{
			gint _tmp29_ = 0;
			guint _tmp30_ = 0U;
#line 219 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp29_ = week_of_year;
#line 219 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp30_ = g_date_get_sunday_week_of_year (&first_of_month);
#line 219 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_month = (_tmp29_ - ((gint) _tmp30_)) + 1;
#line 220 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1124 "calendar-date.c"
		}
		default:
		{
#line 223 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 1130 "calendar-date.c"
		}
	}
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp31_ = start;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp32_ = end;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp33_ = week_of_month;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp34_ = week_of_year;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp35_ = california_calendar_date_month_of_year (self);
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp36_ = _tmp35_;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp37_ = first;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp38_ = california_calendar_week_new (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp36_, _tmp37_);
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp39_ = _tmp38_;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp36_);
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp39_;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (end);
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (start);
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1161 "calendar-date.c"
}


/**
     * Returns the {@link MonthOfYear} the {@link Date} falls in.
     */
CaliforniaCalendarMonthOfYear* california_calendar_date_month_of_year (CaliforniaCalendarDate* self) {
	CaliforniaCalendarMonthOfYear* result = NULL;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp2_ = NULL;
#line 232 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 233 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_month;
#line 233 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = self->priv->_year;
#line 233 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_month_of_year_new (_tmp0_, _tmp1_);
#line 233 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 233 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1185 "calendar-date.c"
}


/**
     * @inheritDoc
     */
static CaliforniaCalendarDate* california_calendar_date_real_adjust (CaliforniaCalendarUnit* base, gint quantity) {
	CaliforniaCalendarDate * self;
	CaliforniaCalendarDate* result = NULL;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 239 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 240 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = quantity;
#line 240 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_date_adjust_by (self, _tmp0_, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 240 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_;
#line 240 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1207 "calendar-date.c"
}


/**
     * Returns a new {@link Date} adjusted from this Date by the specifed quantity of time.
     *
     * Subtraction (adjusting to a past date) is acheived by using a negative quantity.
     */
CaliforniaCalendarDate* california_calendar_date_adjust_by (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit) {
	CaliforniaCalendarDate* result = NULL;
	gint _tmp0_ = 0;
	GDate clone = {0};
	GDate _tmp2_ = {0};
	CaliforniaCalendarDateUnit _tmp3_ = 0;
	GDate _tmp16_ = {0};
	CaliforniaCalendarDate* _tmp17_ = NULL;
#line 248 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 249 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = quantity;
#line 249 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp0_ == 0) {
#line 1230 "calendar-date.c"
		CaliforniaCalendarDate* _tmp1_ = NULL;
#line 250 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 250 "/home/jim/git/california/src/calendar/calendar-date.vala"
		result = _tmp1_;
#line 250 "/home/jim/git/california/src/calendar/calendar-date.vala"
		return result;
#line 1238 "calendar-date.c"
	}
#line 252 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = self->priv->gdate;
#line 252 "/home/jim/git/california/src/calendar/calendar-date.vala"
	clone = _tmp2_;
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = unit;
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp3_) {
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_DAY:
#line 1250 "calendar-date.c"
		{
			gint _tmp4_ = 0;
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp4_ = quantity;
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp4_ > 0) {
#line 1257 "calendar-date.c"
				gint _tmp5_ = 0;
#line 256 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp5_ = quantity;
#line 256 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_days (&clone, (guint) _tmp5_);
#line 1263 "calendar-date.c"
			} else {
				gint _tmp6_ = 0;
#line 258 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp6_ = quantity;
#line 258 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_days (&clone, (guint) (-_tmp6_));
#line 1270 "calendar-date.c"
			}
#line 259 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1274 "calendar-date.c"
		}
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_WEEK:
#line 1278 "calendar-date.c"
		{
			gint _tmp7_ = 0;
#line 262 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp7_ = quantity;
#line 262 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp7_ > 0) {
#line 1285 "calendar-date.c"
				gint _tmp8_ = 0;
#line 263 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp8_ = quantity;
#line 263 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_days (&clone, (guint) (_tmp8_ * CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT));
#line 1291 "calendar-date.c"
			} else {
				gint _tmp9_ = 0;
#line 265 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp9_ = quantity;
#line 265 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_days (&clone, (guint) ((-_tmp9_) * CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT));
#line 1298 "calendar-date.c"
			}
#line 266 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1302 "calendar-date.c"
		}
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_MONTH:
#line 1306 "calendar-date.c"
		{
			gint _tmp10_ = 0;
#line 269 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp10_ = quantity;
#line 269 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp10_ > 0) {
#line 1313 "calendar-date.c"
				gint _tmp11_ = 0;
#line 270 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp11_ = quantity;
#line 270 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_months (&clone, (guint) _tmp11_);
#line 1319 "calendar-date.c"
			} else {
				gint _tmp12_ = 0;
#line 272 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp12_ = quantity;
#line 272 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_months (&clone, (guint) (-_tmp12_));
#line 1326 "calendar-date.c"
			}
#line 273 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1330 "calendar-date.c"
		}
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_YEAR:
#line 1334 "calendar-date.c"
		{
			gint _tmp13_ = 0;
#line 276 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp13_ = quantity;
#line 276 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp13_ > 0) {
#line 1341 "calendar-date.c"
				gint _tmp14_ = 0;
#line 277 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp14_ = quantity;
#line 277 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_years (&clone, (guint) _tmp14_);
#line 1347 "calendar-date.c"
			} else {
				gint _tmp15_ = 0;
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp15_ = quantity;
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_years (&clone, (guint) (-_tmp15_));
#line 1354 "calendar-date.c"
			}
#line 280 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1358 "calendar-date.c"
		}
		default:
		{
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 1364 "calendar-date.c"
		}
	}
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = clone;
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_date_new_from_gdate (&_tmp16_);
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp17_;
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1375 "calendar-date.c"
}


/**
     * Returns the {@link Date} of the upcoming (next chronological) Date that matches
     * the predicate's requirements.
     *
     * inclusive indicates if this Date is included in the search.
     *
     * @see prior
     */
CaliforniaCalendarDate* california_calendar_date_upcoming (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeePredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
#line 297 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 298 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = inclusive;
#line 298 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = predicate;
#line 298 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1__target = predicate_target;
#line 298 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_date_upcoming_prior (self, _tmp0_, 1, _tmp1_, _tmp1__target);
#line 298 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 298 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1407 "calendar-date.c"
}


/**
     * Returns the {@link Date} of the prior (next chronological) Date that matches
     * the predicate's requirements.
     *
     * inclusive indicates if this Date is included in the search.
     *
     * @see upcoming
     */
CaliforniaCalendarDate* california_calendar_date_prior (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeePredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
#line 309 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = inclusive;
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = predicate;
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1__target = predicate_target;
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_date_upcoming_prior (self, _tmp0_, -1, _tmp1_, _tmp1__target);
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1439 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_upcoming_prior (CaliforniaCalendarDate* self, gboolean inclusive, gint adjustment, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarDate* current = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
#line 313 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = inclusive;
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp1_) {
#line 1455 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = _g_object_ref0 (self);
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (_tmp0_);
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp2_;
#line 1463 "calendar-date.c"
	} else {
		gint _tmp3_ = 0;
		gpointer _tmp4_ = NULL;
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = adjustment;
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp3_);
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (_tmp0_);
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = (CaliforniaCalendarDate*) _tmp4_;
#line 1475 "calendar-date.c"
	}
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = _g_object_ref0 (_tmp0_);
#line 314 "/home/jim/git/california/src/calendar/calendar-date.vala"
	current = _tmp5_;
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
	while (TRUE) {
#line 1483 "calendar-date.c"
		GeePredicate _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		CaliforniaCalendarDate* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		CaliforniaCalendarDate* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gpointer _tmp11_ = NULL;
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = predicate;
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6__target = predicate_target;
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = current;
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp8_ = _tmp6_ (_tmp7_, _tmp6__target);
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (!(!_tmp8_)) {
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1503 "calendar-date.c"
		}
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = current;
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = adjustment;
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp10_);
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (current);
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
		current = (CaliforniaCalendarDate*) _tmp11_;
#line 1515 "calendar-date.c"
	}
#line 318 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = current;
#line 318 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp0_);
#line 318 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1523 "calendar-date.c"
}


/**
     * @inheritDoc
     */
static gint california_calendar_date_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 324 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 324 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), 0);
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = other;
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (self != _tmp1_) {
#line 1543 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		GDate _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = other;
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = _tmp2_->priv->gdate;
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = g_date_days_between (&self->priv->gdate, &_tmp3_);
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp4_;
#line 1555 "calendar-date.c"
	} else {
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = 0;
#line 1559 "calendar-date.c"
	}
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1565 "calendar-date.c"
}


/**
     * Returns a {@link Date} clamped between the two supplied Dates, inclusive.
     *
     * @see Span.clamp_between
     */
CaliforniaCalendarDate* california_calendar_date_clamp (CaliforniaCalendarDate* self, CaliforniaCalendarDate* min, CaliforniaCalendarDate* max) {
	CaliforniaCalendarDate* result = NULL;
	GDate clone = {0};
	GDate _tmp0_ = {0};
	CaliforniaCalendarDate* _tmp1_ = NULL;
	GDate _tmp2_ = {0};
	CaliforniaCalendarDate* _tmp3_ = NULL;
	GDate _tmp4_ = {0};
	GDate _tmp5_ = {0};
	CaliforniaCalendarDate* _tmp6_ = NULL;
#line 333 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 333 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (min), NULL);
#line 333 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (max), NULL);
#line 334 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->gdate;
#line 334 "/home/jim/git/california/src/calendar/calendar-date.vala"
	clone = _tmp0_;
#line 335 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = min;
#line 335 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_->priv->gdate;
#line 335 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = max;
#line 335 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = _tmp3_->priv->gdate;
#line 335 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_clamp (&clone, &_tmp2_, &_tmp4_);
#line 337 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = clone;
#line 337 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = california_calendar_date_new_from_gdate (&_tmp5_);
#line 337 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp6_;
#line 337 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1612 "calendar-date.c"
}


static gint california_calendar_date_real_compare_to (GeeComparable* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 340 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 340 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), 0);
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = other;
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (self != _tmp1_) {
#line 1629 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		GDate _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = other;
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = _tmp2_->priv->gdate;
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = g_date_compare (&self->priv->gdate, &_tmp3_);
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp4_;
#line 1641 "calendar-date.c"
	} else {
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = 0;
#line 1645 "calendar-date.c"
	}
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1651 "calendar-date.c"
}


static gboolean california_calendar_date_real_equal_to (GeeHashable* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gboolean result = FALSE;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 344 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 344 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), FALSE);
#line 345 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = other;
#line 345 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 345 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_ == 0;
#line 345 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1672 "calendar-date.c"
}


static guint california_calendar_date_real_hash (GeeHashable* base) {
	CaliforniaCalendarDate * self;
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 348 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_date_get_julian (&self->priv->gdate);
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1688 "calendar-date.c"
}


gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt) {
	gchar* result = NULL;
	gchar* buf = NULL;
	gchar* _tmp0_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 352 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 352 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_new0 (gchar, 256);
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf = _tmp0_;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf_length1 = 256;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_buf_size_ = buf_length1;
#line 356 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = fmt;
#line 356 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_strftime (buf, buf_length1, _tmp1_, &self->priv->gdate);
#line 358 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = g_strdup ((const gchar*) buf);
#line 358 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 358 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf = (g_free (buf), NULL);
#line 358 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1724 "calendar-date.c"
}


/**
     * Returns the {@link Date} in a localized standardized format, i.e. "08/23/01"
     */
gchar* california_calendar_date_to_standard_string (CaliforniaCalendarDate* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 364 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_FMT_FULL_DATE;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_date_format (self, _tmp0_);
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1745 "calendar-date.c"
}


/**
     * Returns the {@link Date} in a prettified, localized format according to supplied
     * {@link PrettyFlag}s.
     *
     * Returns "Today" (localized) if this matches {@link System.today} unless the NO_TODAY flag
     * or INCLUDE_YEAR flag is specified.
     */
gchar* california_calendar_date_to_pretty_string (CaliforniaCalendarDate* self, CaliforniaCalendarDatePrettyFlag flags) {
	gchar* result = NULL;
	gboolean compact = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp0_ = 0;
	gboolean abbrev = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp1_ = 0;
	gboolean with_year = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp2_ = 0;
	gboolean with_other_year = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp3_ = 0;
	gboolean no_today = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp4_ = 0;
	gboolean no_dow = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	const gchar* fmt = NULL;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 376 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = flags;
#line 376 "/home/jim/git/california/src/calendar/calendar-date.vala"
	compact = (_tmp0_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT) != 0;
#line 377 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = flags;
#line 377 "/home/jim/git/california/src/calendar/calendar-date.vala"
	abbrev = (_tmp1_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV) != 0;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = flags;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
	with_year = (_tmp2_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR) != 0;
#line 379 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = flags;
#line 379 "/home/jim/git/california/src/calendar/calendar-date.vala"
	with_other_year = (_tmp3_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR) != 0;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = flags;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
	no_today = (_tmp4_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY) != 0;
#line 381 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = flags;
#line 381 "/home/jim/git/california/src/calendar/calendar-date.vala"
	no_dow = (_tmp5_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK) != 0;
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = no_today;
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp8_) {
#line 1815 "calendar-date.c"
		gboolean _tmp9_ = FALSE;
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = with_year;
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = !_tmp9_;
#line 1821 "calendar-date.c"
	} else {
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = FALSE;
#line 1825 "calendar-date.c"
	}
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp7_) {
#line 1829 "calendar-date.c"
		CaliforniaCalendarDate* _tmp10_ = NULL;
		CaliforniaCalendarDate* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = california_calendar_system_get_today ();
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = _tmp10_;
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_HASHABLE, GeeHashable), _tmp11_);
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = _tmp12_;
#line 1841 "calendar-date.c"
	} else {
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = FALSE;
#line 1845 "calendar-date.c"
	}
#line 383 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp6_) {
#line 1849 "calendar-date.c"
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = _ ("Today");
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
		result = _tmp14_;
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
		return result;
#line 1860 "calendar-date.c"
	}
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = with_year;
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp17_) {
#line 1866 "calendar-date.c"
		gboolean _tmp18_ = FALSE;
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp18_ = with_other_year;
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp16_ = _tmp18_;
#line 1872 "calendar-date.c"
	} else {
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp16_ = FALSE;
#line 1876 "calendar-date.c"
	}
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp16_) {
#line 1880 "calendar-date.c"
		CaliforniaCalendarYear* _tmp19_ = NULL;
		CaliforniaCalendarDate* _tmp20_ = NULL;
		CaliforniaCalendarDate* _tmp21_ = NULL;
		CaliforniaCalendarYear* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp19_ = self->priv->_year;
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp20_ = california_calendar_system_get_today ();
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp21_ = _tmp20_;
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp22_ = _tmp21_->priv->_year;
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp23_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_HASHABLE, GeeHashable), _tmp22_);
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = !_tmp23_;
#line 1898 "calendar-date.c"
	} else {
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = FALSE;
#line 1902 "calendar-date.c"
	}
#line 386 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp15_) {
#line 387 "/home/jim/git/california/src/calendar/calendar-date.vala"
		with_year = TRUE;
#line 1908 "calendar-date.c"
	}
#line 390 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = abbrev;
#line 390 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp24_) {
#line 1914 "calendar-date.c"
		gboolean _tmp25_ = FALSE;
#line 391 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp25_ = no_dow;
#line 391 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_tmp25_) {
#line 1920 "calendar-date.c"
			const gchar* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
#line 392 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp27_ = with_year;
#line 392 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp27_) {
#line 1927 "calendar-date.c"
				const gchar* _tmp28_ = NULL;
#line 392 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp28_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW;
#line 392 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp26_ = _tmp28_;
#line 1933 "calendar-date.c"
			} else {
				const gchar* _tmp29_ = NULL;
#line 392 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp29_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW_NO_YEAR;
#line 392 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp26_ = _tmp29_;
#line 1940 "calendar-date.c"
			}
#line 392 "/home/jim/git/california/src/calendar/calendar-date.vala"
			fmt = _tmp26_;
#line 1944 "calendar-date.c"
		} else {
			const gchar* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
#line 394 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp31_ = with_year;
#line 394 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp31_) {
#line 1952 "calendar-date.c"
				const gchar* _tmp32_ = NULL;
#line 394 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp32_ = california_calendar_FMT_PRETTY_DATE_ABBREV;
#line 394 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp30_ = _tmp32_;
#line 1958 "calendar-date.c"
			} else {
				const gchar* _tmp33_ = NULL;
#line 394 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp33_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_YEAR;
#line 394 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp30_ = _tmp33_;
#line 1965 "calendar-date.c"
			}
#line 394 "/home/jim/git/california/src/calendar/calendar-date.vala"
			fmt = _tmp30_;
#line 1969 "calendar-date.c"
		}
	} else {
		gboolean _tmp34_ = FALSE;
#line 395 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp34_ = compact;
#line 395 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_tmp34_) {
#line 1977 "calendar-date.c"
			gboolean _tmp35_ = FALSE;
#line 396 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp35_ = no_dow;
#line 396 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp35_) {
#line 1983 "calendar-date.c"
				const gchar* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
#line 397 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp37_ = with_year;
#line 397 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp37_) {
#line 1990 "calendar-date.c"
					const gchar* _tmp38_ = NULL;
#line 397 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp38_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW;
#line 397 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp36_ = _tmp38_;
#line 1996 "calendar-date.c"
				} else {
					const gchar* _tmp39_ = NULL;
#line 397 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp39_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW_NO_YEAR;
#line 397 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp36_ = _tmp39_;
#line 2003 "calendar-date.c"
				}
#line 397 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp36_;
#line 2007 "calendar-date.c"
			} else {
				const gchar* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
#line 399 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp41_ = with_year;
#line 399 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp41_) {
#line 2015 "calendar-date.c"
					const gchar* _tmp42_ = NULL;
#line 399 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp42_ = california_calendar_FMT_PRETTY_DATE_COMPACT;
#line 399 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp40_ = _tmp42_;
#line 2021 "calendar-date.c"
				} else {
					const gchar* _tmp43_ = NULL;
#line 399 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp43_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_YEAR;
#line 399 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp40_ = _tmp43_;
#line 2028 "calendar-date.c"
				}
#line 399 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp40_;
#line 2032 "calendar-date.c"
			}
		} else {
			gboolean _tmp44_ = FALSE;
#line 401 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp44_ = no_dow;
#line 401 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp44_) {
#line 2040 "calendar-date.c"
				const gchar* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
#line 402 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp46_ = with_year;
#line 402 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp46_) {
#line 2047 "calendar-date.c"
					const gchar* _tmp47_ = NULL;
#line 402 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp47_ = california_calendar_FMT_PRETTY_DATE_NO_DOW;
#line 402 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp45_ = _tmp47_;
#line 2053 "calendar-date.c"
				} else {
					const gchar* _tmp48_ = NULL;
#line 402 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp48_ = california_calendar_FMT_PRETTY_DATE_NO_DOW_NO_YEAR;
#line 402 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp45_ = _tmp48_;
#line 2060 "calendar-date.c"
				}
#line 402 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp45_;
#line 2064 "calendar-date.c"
			} else {
				const gchar* _tmp49_ = NULL;
				gboolean _tmp50_ = FALSE;
#line 404 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp50_ = with_year;
#line 404 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp50_) {
#line 2072 "calendar-date.c"
					const gchar* _tmp51_ = NULL;
#line 404 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp51_ = california_calendar_FMT_PRETTY_DATE;
#line 404 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp49_ = _tmp51_;
#line 2078 "calendar-date.c"
				} else {
					const gchar* _tmp52_ = NULL;
#line 404 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp52_ = california_calendar_FMT_PRETTY_DATE_NO_YEAR;
#line 404 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp49_ = _tmp52_;
#line 2085 "calendar-date.c"
				}
#line 404 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp49_;
#line 2089 "calendar-date.c"
			}
		}
	}
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp53_ = fmt;
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp54_ = california_calendar_date_format (self, _tmp53_);
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp55_ = _tmp54_;
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp56_ = california_string_remove_leading_chars (_tmp55_, (gunichar) '0', " /-:;,.");
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp57_ = _tmp56_;
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp58_ = california_string_reduce_whitespace (_tmp57_);
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp59_ = _tmp58_;
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_free0 (_tmp57_);
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_free0 (_tmp55_);
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp59_;
#line 408 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2115 "calendar-date.c"
}


static gchar* california_calendar_date_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarDate * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 411 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 412 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_date_format (self, "%x");
#line 412 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 412 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2131 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_get_earliest (void) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* _tmp0_ = NULL;
#line 68 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_date__earliest;
#line 68 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 68 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2144 "calendar-date.c"
}


static void california_calendar_date_set_earliest (CaliforniaCalendarDate* value) {
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 68 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 68 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 68 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (california_calendar_date__earliest);
#line 68 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date__earliest = _tmp1_;
#line 2159 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_get_latest (void) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* _tmp0_ = NULL;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_date__latest;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2172 "calendar-date.c"
}


static void california_calendar_date_set_latest (CaliforniaCalendarDate* value) {
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (california_calendar_date__latest);
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date__latest = _tmp1_;
#line 2187 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_real_get_start_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* self;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = self;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2200 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_real_get_end_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* self;
#line 87 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 87 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = self;
#line 87 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2213 "calendar-date.c"
}


CaliforniaCalendarDayOfWeek* california_calendar_date_get_day_of_week (CaliforniaCalendarDate* self) {
	CaliforniaCalendarDayOfWeek* result;
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_week;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2228 "calendar-date.c"
}


static void california_calendar_date_set_day_of_week (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfWeek* value) {
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp1_ = NULL;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_week);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_week = _tmp1_;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-week");
#line 2247 "calendar-date.c"
}


CaliforniaCalendarDayOfMonth* california_calendar_date_get_day_of_month (CaliforniaCalendarDate* self) {
	CaliforniaCalendarDayOfMonth* result;
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_month;
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2262 "calendar-date.c"
}


static void california_calendar_date_set_day_of_month (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfMonth* value) {
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_month);
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_month = _tmp1_;
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-month");
#line 2281 "calendar-date.c"
}


gint california_calendar_date_get_day_of_year (CaliforniaCalendarDate* self) {
	gint result;
	gint _tmp0_ = 0;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), 0);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_year;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2296 "calendar-date.c"
}


static void california_calendar_date_set_day_of_year (CaliforniaCalendarDate* self, gint value) {
	gint _tmp0_ = 0;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_year = _tmp0_;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-year");
#line 2310 "calendar-date.c"
}


CaliforniaCalendarMonth* california_calendar_date_get_month (CaliforniaCalendarDate* self) {
	CaliforniaCalendarMonth* result;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_month;
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2325 "calendar-date.c"
}


static void california_calendar_date_set_month (CaliforniaCalendarDate* self, CaliforniaCalendarMonth* value) {
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarMonth* _tmp1_ = NULL;
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_month);
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_month = _tmp1_;
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "month");
#line 2344 "calendar-date.c"
}


CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self) {
	CaliforniaCalendarYear* result;
	CaliforniaCalendarYear* _tmp0_ = NULL;
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_year;
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2359 "calendar-date.c"
}


static void california_calendar_date_set_year (CaliforniaCalendarDate* self, CaliforniaCalendarYear* value) {
	CaliforniaCalendarYear* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_year);
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_year = _tmp1_;
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "year");
#line 2378 "calendar-date.c"
}


static void california_calendar_date_class_init (CaliforniaCalendarDateClass * klass) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarDatePrivate));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	((CaliforniaCalendarUnitClass *) klass)->adjust = california_calendar_date_real_adjust;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	((CaliforniaCalendarUnitClass *) klass)->difference = california_calendar_date_real_difference;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_calendar_date_real_to_string;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_SPAN_CLASS (klass)->get_start_date = california_calendar_date_real_get_start_date;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_SPAN_CLASS (klass)->get_end_date = california_calendar_date_real_get_end_date;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_date_get_property;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_date_set_property;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_date_finalize;
#line 2403 "calendar-date.c"
	/**
	     * @inheritDoc
	     *
	     * Overridden to prevent a reference cycle in {@link Span.start_date}.
	     */
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_START_DATE, g_param_spec_object ("start-date", "start-date", "start-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2411 "calendar-date.c"
	/**
	     * @inheritDoc
	     *
	     * Overridden to prevent a reference cycle in {@link Span.end_date}.
	     */
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_END_DATE, g_param_spec_object ("end-date", "end-date", "end-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK, g_param_spec_object ("day-of-week", "day-of-week", "day-of-week", CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH, g_param_spec_object ("day-of-month", "day-of-month", "day-of-month", CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR, g_param_spec_int ("day-of-year", "day-of-year", "day-of-year", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_MONTH, g_param_spec_object ("month", "month", "month", CALIFORNIA_CALENDAR_TYPE_MONTH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_YEAR, g_param_spec_object ("year", "year", "year", CALIFORNIA_CALENDAR_TYPE_YEAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2429 "calendar-date.c"
}


static void california_calendar_date_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_date_real_compare_to;
#line 2438 "calendar-date.c"
}


static void california_calendar_date_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_date_real_equal_to;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_date_real_hash;
#line 2449 "calendar-date.c"
}


static void california_calendar_date_instance_init (CaliforniaCalendarDate * self) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv = CALIFORNIA_CALENDAR_DATE_GET_PRIVATE (self);
#line 2456 "calendar-date.c"
}


static void california_calendar_date_finalize (GObject* obj) {
	CaliforniaCalendarDate * self;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_week);
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_month);
#line 92 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_month);
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_year);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (california_calendar_date_parent_class)->finalize (obj);
#line 2474 "calendar-date.c"
}


/**
 * An immutable representation of a single date in time (year/month/day).
 *
 * This is primarily a GObject-ification of GLib's Date struct, with the added restriction that
 * this class is immutable.  This means this object is incapable of representing a DMY prior to
 * Year 1 (BCE).
 *
 * GLib.Date has many powerful features for representing a calendar day, but it's interface is
 * inconvenient when working in Vala.  It can also exist in an uninitialized and an invalid
 * state.  It's desired to avoid both of those.  It is also not an Object, has no signals or
 * properties, doesn't work well with Gee, and is mutable.  This class attempts to solve these
 * issues.
 */
GType california_calendar_date_get_type (void) {
	static volatile gsize california_calendar_date_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarDate), 0, (GInstanceInitFunc) california_calendar_date_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_date_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_date_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_date_type_id;
		california_calendar_date_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_UNIT, "CaliforniaCalendarDate", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_date_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_date_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_date_type_id__volatile, california_calendar_date_type_id);
	}
	return california_calendar_date_type_id__volatile;
}


static void _vala_california_calendar_date_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_START_DATE:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_END_DATE:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_day_of_week (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_day_of_month (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_int (value, california_calendar_date_get_day_of_year (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_month (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_year (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2554 "calendar-date.c"
		default:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2560 "calendar-date.c"
	}
}


static void _vala_california_calendar_date_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_week (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_month (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_year (self, g_value_get_int (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_month (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_year (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2600 "calendar-date.c"
		default:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2606 "calendar-date.c"
	}
}



