/* util-scheduled.c generated by valac 0.26.0, the Vala compiler
 * generated from util-scheduled.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

typedef struct _CaliforniaSleepSecAsyncData CaliforniaSleepSecAsyncData;
typedef struct _CaliforniaSleepMsecAsyncData CaliforniaSleepMsecAsyncData;

#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_TYPE_SCHEDULED (california_scheduled_get_type ())
#define CALIFORNIA_SCHEDULED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduled))
#define CALIFORNIA_SCHEDULED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduledClass))
#define CALIFORNIA_IS_SCHEDULED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_SCHEDULED))
#define CALIFORNIA_IS_SCHEDULED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_SCHEDULED))
#define CALIFORNIA_SCHEDULED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduledClass))

typedef struct _CaliforniaScheduled CaliforniaScheduled;
typedef struct _CaliforniaScheduledClass CaliforniaScheduledClass;
typedef struct _CaliforniaScheduledPrivate CaliforniaScheduledPrivate;

#define CALIFORNIA_SCHEDULED_TYPE_RESCHEDULE (california_scheduled_reschedule_get_type ())

struct _CaliforniaSleepSecAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	guint seconds;
	guint id;
	guint _tmp0_;
	guint _tmp1_;
};

struct _CaliforniaSleepMsecAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	guint milliseconds;
	guint id;
	guint _tmp0_;
	guint _tmp1_;
};

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaScheduled {
	CaliforniaBaseObject parent_instance;
	CaliforniaScheduledPrivate * priv;
};

struct _CaliforniaScheduledClass {
	CaliforniaBaseObjectClass parent_class;
};

typedef void (*CaliforniaScheduledScheduleOnce) (void* user_data);
typedef enum  {
	CALIFORNIA_SCHEDULED_RESCHEDULE_AGAIN,
	CALIFORNIA_SCHEDULED_RESCHEDULE_HALT
} CaliforniaScheduledReschedule;

typedef CaliforniaScheduledReschedule (*CaliforniaScheduledScheduleContinuous) (void* user_data);
struct _CaliforniaScheduledPrivate {
	gboolean _is_executing;
	guint source_id;
	CaliforniaScheduledScheduleOnce schedule_once;
	gpointer schedule_once_target;
	GDestroyNotify schedule_once_target_destroy_notify;
	CaliforniaScheduledScheduleContinuous schedule_continuous;
	gpointer schedule_continuous_target;
	GDestroyNotify schedule_continuous_target_destroy_notify;
};


static gpointer california_scheduled_parent_class = NULL;

static void california_sleep_sec_async_data_free (gpointer _data);
void california_sleep_sec_async (guint seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void california_sleep_sec_finish (GAsyncResult* _res_);
static gboolean california_sleep_sec_async_co (CaliforniaSleepSecAsyncData* _data_);
static gboolean _california_sleep_sec_async_co_gsource_func (gpointer self);
static void california_sleep_msec_async_data_free (gpointer _data);
void california_sleep_msec_async (guint milliseconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void california_sleep_msec_finish (GAsyncResult* _res_);
static gboolean california_sleep_msec_async_co (CaliforniaSleepMsecAsyncData* _data_);
static gboolean _california_sleep_msec_async_co_gsource_func (gpointer self);
GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_scheduled_get_type (void) G_GNUC_CONST;
GType california_scheduled_reschedule_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_SCHEDULED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduledPrivate))
enum  {
	CALIFORNIA_SCHEDULED_DUMMY_PROPERTY,
	CALIFORNIA_SCHEDULED_IS_SCHEDULED,
	CALIFORNIA_SCHEDULED_IS_CONTINUOUS,
	CALIFORNIA_SCHEDULED_IS_EXECUTING
};
void california_scheduled_cancel (CaliforniaScheduled* self);
#define CALIFORNIA_SCHEDULED_PROP_IS_SCHEDULED "is-scheduled"
#define CALIFORNIA_SCHEDULED_PROP_IS_CONTINUOUS "is-continuous"
#define CALIFORNIA_SCHEDULED_PROP_IS_EXECUTING "is-executing"
CaliforniaScheduled* california_scheduled_new_continuous_at_idle (CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_continuous_at_idle (GType object_type, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
static gboolean california_scheduled_on_continuous (CaliforniaScheduled* self);
static gboolean _california_scheduled_on_continuous_gsource_func (gpointer self);
CaliforniaScheduled* california_scheduled_new_once_at_idle (CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_once_at_idle (GType object_type, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
static gboolean california_scheduled_on_once (CaliforniaScheduled* self);
static gboolean _california_scheduled_on_once_gsource_func (gpointer self);
CaliforniaScheduled* california_scheduled_new_continuous_every_msec (guint msec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_continuous_every_msec (GType object_type, guint msec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_new_once_after_msec (guint msec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_once_after_msec (GType object_type, guint msec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_new_continuous_every_sec (guint sec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_continuous_every_sec (GType object_type, guint sec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_new_once_after_sec (guint sec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_once_after_sec (GType object_type, guint sec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
void california_scheduled_wait (CaliforniaScheduled* self, GMainContext* main_context);
gboolean california_scheduled_get_is_scheduled (CaliforniaScheduled* self);
gboolean california_scheduled_get_is_executing (CaliforniaScheduled* self);
static void california_scheduled_set_is_executing (CaliforniaScheduled* self, gboolean value);
static gchar* california_scheduled_real_to_string (CaliforniaBaseObject* base);
CaliforniaScheduled* california_scheduled_new (void);
CaliforniaScheduled* california_scheduled_construct (GType object_type);
gboolean california_scheduled_get_is_continuous (CaliforniaScheduled* self);
static void california_scheduled_finalize (GObject* obj);
static void _vala_california_scheduled_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_scheduled_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void california_sleep_sec_async_data_free (gpointer _data) {
	CaliforniaSleepSecAsyncData* _data_;
	_data_ = _data;
	g_slice_free (CaliforniaSleepSecAsyncData, _data_);
}


void california_sleep_sec_async (guint seconds, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CaliforniaSleepSecAsyncData* _data_;
	guint _tmp0_ = 0U;
	_data_ = g_slice_new0 (CaliforniaSleepSecAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, california_sleep_sec_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, california_sleep_sec_async_data_free);
	_tmp0_ = seconds;
	_data_->seconds = _tmp0_;
	california_sleep_sec_async_co (_data_);
}


void california_sleep_sec_finish (GAsyncResult* _res_) {
	CaliforniaSleepSecAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * Perform an asynchronous delay for the specified number of seconds.
*/
static gboolean _california_sleep_sec_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = california_sleep_sec_async_co (self);
#line 13 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 193 "util-scheduled.c"
}


static gboolean california_sleep_sec_async_co (CaliforniaSleepSecAsyncData* _data_) {
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
	switch (_data_->_state_) {
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
		case 0:
#line 202 "util-scheduled.c"
		goto _state_0;
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
		case 1:
#line 206 "util-scheduled.c"
		goto _state_1;
		default:
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_assert_not_reached ();
#line 211 "util-scheduled.c"
	}
	_state_0:
#line 13 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp0_ = 0U;
#line 13 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp0_ = _data_->seconds;
#line 13 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp1_ = 0U;
#line 13 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->_tmp0_, _california_sleep_sec_async_co_gsource_func, _data_, NULL);
#line 13 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->id = _data_->_tmp1_;
#line 14 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_state_ = 1;
#line 14 "/home/jim/git/california/src/util/util-scheduled.vala"
	return FALSE;
#line 228 "util-scheduled.c"
	_state_1:
	;
#line 15 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_source_remove (_data_->id);
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
	if (_data_->_state_ == 0) {
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 237 "util-scheduled.c"
	} else {
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 241 "util-scheduled.c"
	}
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_object_unref (_data_->_async_result);
#line 12 "/home/jim/git/california/src/util/util-scheduled.vala"
	return FALSE;
#line 247 "util-scheduled.c"
}


static void california_sleep_msec_async_data_free (gpointer _data) {
	CaliforniaSleepMsecAsyncData* _data_;
	_data_ = _data;
	g_slice_free (CaliforniaSleepMsecAsyncData, _data_);
}


void california_sleep_msec_async (guint milliseconds, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CaliforniaSleepMsecAsyncData* _data_;
	guint _tmp0_ = 0U;
	_data_ = g_slice_new0 (CaliforniaSleepMsecAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, california_sleep_msec_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, california_sleep_msec_async_data_free);
	_tmp0_ = milliseconds;
	_data_->milliseconds = _tmp0_;
	california_sleep_msec_async_co (_data_);
}


void california_sleep_msec_finish (GAsyncResult* _res_) {
	CaliforniaSleepMsecAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * Perform an asynchronous delay for the specified number of milliseconds.
*/
static gboolean _california_sleep_msec_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = california_sleep_msec_async_co (self);
#line 22 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 284 "util-scheduled.c"
}


static gboolean california_sleep_msec_async_co (CaliforniaSleepMsecAsyncData* _data_) {
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
	switch (_data_->_state_) {
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
		case 0:
#line 293 "util-scheduled.c"
		goto _state_0;
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
		case 1:
#line 297 "util-scheduled.c"
		goto _state_1;
		default:
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_assert_not_reached ();
#line 302 "util-scheduled.c"
	}
	_state_0:
#line 22 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp0_ = 0U;
#line 22 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp0_ = _data_->milliseconds;
#line 22 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp1_ = 0U;
#line 22 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _data_->_tmp0_, _california_sleep_msec_async_co_gsource_func, _data_, NULL);
#line 22 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->id = _data_->_tmp1_;
#line 23 "/home/jim/git/california/src/util/util-scheduled.vala"
	_data_->_state_ = 1;
#line 23 "/home/jim/git/california/src/util/util-scheduled.vala"
	return FALSE;
#line 319 "util-scheduled.c"
	_state_1:
	;
#line 24 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_source_remove (_data_->id);
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
	if (_data_->_state_ == 0) {
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 328 "util-scheduled.c"
	} else {
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 332 "util-scheduled.c"
	}
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_object_unref (_data_->_async_result);
#line 21 "/home/jim/git/california/src/util/util-scheduled.vala"
	return FALSE;
#line 338 "util-scheduled.c"
}


/**
     * Return value for {@link ScheduleContinuous} indicating if the code should remain scheduled.
     */
GType california_scheduled_reschedule_get_type (void) {
	static volatile gsize california_scheduled_reschedule_type_id__volatile = 0;
	if (g_once_init_enter (&california_scheduled_reschedule_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_SCHEDULED_RESCHEDULE_AGAIN, "CALIFORNIA_SCHEDULED_RESCHEDULE_AGAIN", "again"}, {CALIFORNIA_SCHEDULED_RESCHEDULE_HALT, "CALIFORNIA_SCHEDULED_RESCHEDULE_HALT", "halt"}, {0, NULL, NULL}};
		GType california_scheduled_reschedule_type_id;
		california_scheduled_reschedule_type_id = g_enum_register_static ("CaliforniaScheduledReschedule", values);
		g_once_init_leave (&california_scheduled_reschedule_type_id__volatile, california_scheduled_reschedule_type_id);
	}
	return california_scheduled_reschedule_type_id__volatile;
}


/**
     * Schedule code to execute continuously when the event loop is idle.
     */
static gboolean _california_scheduled_on_continuous_gsource_func (gpointer self) {
	gboolean result;
	result = california_scheduled_on_continuous ((CaliforniaScheduled*) self);
#line 95 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 365 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_construct_continuous_at_idle (GType object_type, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority) {
	CaliforniaScheduled * self = NULL;
	CaliforniaScheduledScheduleContinuous _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gint _tmp1_ = 0;
	guint _tmp2_ = 0U;
#line 92 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = (CaliforniaScheduled*) california_base_object_construct (object_type);
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = cb;
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = cb_target;
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_continuous_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_continuous_target_destroy_notify (self->priv->schedule_continuous_target), NULL);
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = NULL;
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target = NULL;
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target_destroy_notify = NULL;
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = _tmp0_;
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target = _tmp0__target;
#line 93 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target_destroy_notify = NULL;
#line 95 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = priority;
#line 95 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = g_idle_add_full (_tmp1_, _california_scheduled_on_continuous_gsource_func, g_object_ref (self), g_object_unref);
#line 95 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = _tmp2_;
#line 92 "/home/jim/git/california/src/util/util-scheduled.vala"
	return self;
#line 403 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_new_continuous_at_idle (CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority) {
#line 92 "/home/jim/git/california/src/util/util-scheduled.vala"
	return california_scheduled_construct_continuous_at_idle (CALIFORNIA_TYPE_SCHEDULED, cb, cb_target, priority);
#line 410 "util-scheduled.c"
}


/**
     * Schedule code to execute once when the event loop is idle.
     */
static gboolean _california_scheduled_on_once_gsource_func (gpointer self) {
	gboolean result;
	result = california_scheduled_on_once ((CaliforniaScheduled*) self);
#line 104 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 422 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_construct_once_at_idle (GType object_type, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority) {
	CaliforniaScheduled * self = NULL;
	CaliforniaScheduledScheduleOnce _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gint _tmp1_ = 0;
	guint _tmp2_ = 0U;
#line 101 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = (CaliforniaScheduled*) california_base_object_construct (object_type);
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = cb;
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = cb_target;
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_once_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_once_target_destroy_notify (self->priv->schedule_once_target), NULL);
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = NULL;
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target = NULL;
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target_destroy_notify = NULL;
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = _tmp0_;
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target = _tmp0__target;
#line 102 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target_destroy_notify = NULL;
#line 104 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = priority;
#line 104 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = g_idle_add_full (_tmp1_, _california_scheduled_on_once_gsource_func, g_object_ref (self), g_object_unref);
#line 104 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = _tmp2_;
#line 101 "/home/jim/git/california/src/util/util-scheduled.vala"
	return self;
#line 460 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_new_once_at_idle (CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority) {
#line 101 "/home/jim/git/california/src/util/util-scheduled.vala"
	return california_scheduled_construct_once_at_idle (CALIFORNIA_TYPE_SCHEDULED, cb, cb_target, priority);
#line 467 "util-scheduled.c"
}


/**
     * Schedule code to execute every n milliseconds.
     */
CaliforniaScheduled* california_scheduled_construct_continuous_every_msec (GType object_type, guint msec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority) {
	CaliforniaScheduled * self = NULL;
	CaliforniaScheduledScheduleContinuous _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	guint _tmp1_ = 0U;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
#line 110 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = (CaliforniaScheduled*) california_base_object_construct (object_type);
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = cb;
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = cb_target;
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_continuous_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_continuous_target_destroy_notify (self->priv->schedule_continuous_target), NULL);
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = NULL;
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target = NULL;
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target_destroy_notify = NULL;
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = _tmp0_;
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target = _tmp0__target;
#line 111 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target_destroy_notify = NULL;
#line 113 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = msec;
#line 113 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = priority;
#line 113 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp3_ = g_timeout_add_full (_tmp2_, _tmp1_, _california_scheduled_on_continuous_gsource_func, g_object_ref (self), g_object_unref);
#line 113 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = _tmp3_;
#line 110 "/home/jim/git/california/src/util/util-scheduled.vala"
	return self;
#line 511 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_new_continuous_every_msec (guint msec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority) {
#line 110 "/home/jim/git/california/src/util/util-scheduled.vala"
	return california_scheduled_construct_continuous_every_msec (CALIFORNIA_TYPE_SCHEDULED, msec, cb, cb_target, priority);
#line 518 "util-scheduled.c"
}


/**
     * Schedule code to execute once after n milliseconds has elapsed.
     */
CaliforniaScheduled* california_scheduled_construct_once_after_msec (GType object_type, guint msec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority) {
	CaliforniaScheduled * self = NULL;
	CaliforniaScheduledScheduleOnce _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	guint _tmp1_ = 0U;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
#line 119 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = (CaliforniaScheduled*) california_base_object_construct (object_type);
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = cb;
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = cb_target;
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_once_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_once_target_destroy_notify (self->priv->schedule_once_target), NULL);
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = NULL;
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target = NULL;
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target_destroy_notify = NULL;
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = _tmp0_;
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target = _tmp0__target;
#line 120 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target_destroy_notify = NULL;
#line 122 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = msec;
#line 122 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = priority;
#line 122 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp3_ = g_timeout_add_full (_tmp2_, _tmp1_, _california_scheduled_on_once_gsource_func, g_object_ref (self), g_object_unref);
#line 122 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = _tmp3_;
#line 119 "/home/jim/git/california/src/util/util-scheduled.vala"
	return self;
#line 562 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_new_once_after_msec (guint msec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority) {
#line 119 "/home/jim/git/california/src/util/util-scheduled.vala"
	return california_scheduled_construct_once_after_msec (CALIFORNIA_TYPE_SCHEDULED, msec, cb, cb_target, priority);
#line 569 "util-scheduled.c"
}


/**
     * Schedule code to execute after n seconds.
     */
CaliforniaScheduled* california_scheduled_construct_continuous_every_sec (GType object_type, guint sec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority) {
	CaliforniaScheduled * self = NULL;
	CaliforniaScheduledScheduleContinuous _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	guint _tmp1_ = 0U;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
#line 128 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = (CaliforniaScheduled*) california_base_object_construct (object_type);
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = cb;
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = cb_target;
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_continuous_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_continuous_target_destroy_notify (self->priv->schedule_continuous_target), NULL);
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = NULL;
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target = NULL;
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target_destroy_notify = NULL;
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = _tmp0_;
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target = _tmp0__target;
#line 129 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target_destroy_notify = NULL;
#line 131 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = sec;
#line 131 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = priority;
#line 131 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp3_ = g_timeout_add_seconds_full (_tmp2_, _tmp1_, _california_scheduled_on_continuous_gsource_func, g_object_ref (self), g_object_unref);
#line 131 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = _tmp3_;
#line 128 "/home/jim/git/california/src/util/util-scheduled.vala"
	return self;
#line 613 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_new_continuous_every_sec (guint sec, CaliforniaScheduledScheduleContinuous cb, void* cb_target, gint priority) {
#line 128 "/home/jim/git/california/src/util/util-scheduled.vala"
	return california_scheduled_construct_continuous_every_sec (CALIFORNIA_TYPE_SCHEDULED, sec, cb, cb_target, priority);
#line 620 "util-scheduled.c"
}


/**
     * Schedule code to execute once after n seconds have elapsed.
     */
CaliforniaScheduled* california_scheduled_construct_once_after_sec (GType object_type, guint sec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority) {
	CaliforniaScheduled * self = NULL;
	CaliforniaScheduledScheduleOnce _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	guint _tmp1_ = 0U;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
#line 137 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = (CaliforniaScheduled*) california_base_object_construct (object_type);
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = cb;
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = cb_target;
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_once_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_once_target_destroy_notify (self->priv->schedule_once_target), NULL);
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = NULL;
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target = NULL;
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target_destroy_notify = NULL;
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = _tmp0_;
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target = _tmp0__target;
#line 138 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target_destroy_notify = NULL;
#line 140 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = sec;
#line 140 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = priority;
#line 140 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp3_ = g_timeout_add_seconds_full (_tmp2_, _tmp1_, _california_scheduled_on_once_gsource_func, g_object_ref (self), g_object_unref);
#line 140 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = _tmp3_;
#line 137 "/home/jim/git/california/src/util/util-scheduled.vala"
	return self;
#line 664 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_new_once_after_sec (guint sec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority) {
#line 137 "/home/jim/git/california/src/util/util-scheduled.vala"
	return california_scheduled_construct_once_after_sec (CALIFORNIA_TYPE_SCHEDULED, sec, cb, cb_target, priority);
#line 671 "util-scheduled.c"
}


/**
     * Cancel executing of scheduled code.
     *
     * Dropping the last reference to this object will also cancel execution.
     */
void california_scheduled_cancel (CaliforniaScheduled* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 152 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_if_fail (CALIFORNIA_IS_SCHEDULED (self));
#line 153 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = self->priv->source_id;
#line 153 "/home/jim/git/california/src/util/util-scheduled.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 154 "/home/jim/git/california/src/util/util-scheduled.vala"
		return;
#line 691 "util-scheduled.c"
	}
#line 156 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = self->priv->source_id;
#line 156 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_source_remove (_tmp1_);
#line 157 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = (guint) 0;
#line 699 "util-scheduled.c"
}


/**
     * Wait for the scheduled code to execute.
     *
     * This waits for execution by spinning the event loop, which can cause reentrancy.  There is
     * also the danger of waiting for continuously executing code that never returns
     * {@link Reschedule.HALT}.  In that case, wait() will never return.
     *
     * If the scheduled code has been cancelled, is executing, or has already executed, wait()
     * immediately returns.
     */
void california_scheduled_wait (CaliforniaScheduled* self, GMainContext* main_context) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 170 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_if_fail (CALIFORNIA_IS_SCHEDULED (self));
#line 170 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_if_fail (main_context != NULL);
#line 171 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = california_scheduled_get_is_scheduled (self);
#line 171 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = _tmp1_;
#line 171 "/home/jim/git/california/src/util/util-scheduled.vala"
	if (!_tmp2_) {
#line 171 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp0_ = TRUE;
#line 729 "util-scheduled.c"
	} else {
		gboolean _tmp3_ = FALSE;
#line 171 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp3_ = self->priv->_is_executing;
#line 171 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp0_ = _tmp3_;
#line 736 "util-scheduled.c"
	}
#line 171 "/home/jim/git/california/src/util/util-scheduled.vala"
	if (_tmp0_) {
#line 172 "/home/jim/git/california/src/util/util-scheduled.vala"
		return;
#line 742 "util-scheduled.c"
	}
#line 174 "/home/jim/git/california/src/util/util-scheduled.vala"
	while (TRUE) {
#line 746 "util-scheduled.c"
		GMainContext* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		GMainContext* _tmp6_ = NULL;
#line 174 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp4_ = main_context;
#line 174 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp5_ = g_main_context_pending (_tmp4_);
#line 174 "/home/jim/git/california/src/util/util-scheduled.vala"
		if (!_tmp5_) {
#line 174 "/home/jim/git/california/src/util/util-scheduled.vala"
			break;
#line 758 "util-scheduled.c"
		}
#line 175 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp6_ = main_context;
#line 175 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_main_context_iteration (_tmp6_, FALSE);
#line 764 "util-scheduled.c"
	}
}


static gboolean california_scheduled_on_once (CaliforniaScheduled* self) {
	gboolean result = FALSE;
	CaliforniaScheduledScheduleOnce _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 178 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_val_if_fail (CALIFORNIA_IS_SCHEDULED (self), FALSE);
#line 179 "/home/jim/git/california/src/util/util-scheduled.vala"
	california_scheduled_set_is_executing (self, TRUE);
#line 180 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = self->priv->schedule_once;
#line 180 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = self->priv->schedule_once_target;
#line 180 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ (_tmp0__target);
#line 181 "/home/jim/git/california/src/util/util-scheduled.vala"
	california_scheduled_set_is_executing (self, FALSE);
#line 184 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->source_id = (guint) 0;
#line 186 "/home/jim/git/california/src/util/util-scheduled.vala"
	result = FALSE;
#line 186 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 791 "util-scheduled.c"
}


static gboolean california_scheduled_on_continuous (CaliforniaScheduled* self) {
	gboolean result = FALSE;
	CaliforniaScheduledReschedule reschedule = 0;
	CaliforniaScheduledScheduleContinuous _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	CaliforniaScheduledReschedule _tmp1_ = 0;
	CaliforniaScheduledReschedule _tmp2_ = 0;
#line 189 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_val_if_fail (CALIFORNIA_IS_SCHEDULED (self), FALSE);
#line 190 "/home/jim/git/california/src/util/util-scheduled.vala"
	california_scheduled_set_is_executing (self, TRUE);
#line 191 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = self->priv->schedule_continuous;
#line 191 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = self->priv->schedule_continuous_target;
#line 191 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = _tmp0_ (_tmp0__target);
#line 191 "/home/jim/git/california/src/util/util-scheduled.vala"
	reschedule = _tmp1_;
#line 192 "/home/jim/git/california/src/util/util-scheduled.vala"
	california_scheduled_set_is_executing (self, FALSE);
#line 194 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = reschedule;
#line 194 "/home/jim/git/california/src/util/util-scheduled.vala"
	switch (_tmp2_) {
#line 194 "/home/jim/git/california/src/util/util-scheduled.vala"
		case CALIFORNIA_SCHEDULED_RESCHEDULE_AGAIN:
#line 822 "util-scheduled.c"
		{
#line 196 "/home/jim/git/california/src/util/util-scheduled.vala"
			result = TRUE;
#line 196 "/home/jim/git/california/src/util/util-scheduled.vala"
			return result;
#line 828 "util-scheduled.c"
		}
#line 194 "/home/jim/git/california/src/util/util-scheduled.vala"
		case CALIFORNIA_SCHEDULED_RESCHEDULE_HALT:
#line 832 "util-scheduled.c"
		{
#line 199 "/home/jim/git/california/src/util/util-scheduled.vala"
			self->priv->source_id = (guint) 0;
#line 201 "/home/jim/git/california/src/util/util-scheduled.vala"
			result = FALSE;
#line 201 "/home/jim/git/california/src/util/util-scheduled.vala"
			return result;
#line 840 "util-scheduled.c"
		}
		default:
		{
#line 204 "/home/jim/git/california/src/util/util-scheduled.vala"
			g_assert_not_reached ();
#line 846 "util-scheduled.c"
		}
	}
}


static gchar* california_scheduled_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaScheduled * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	CaliforniaScheduledScheduleOnce _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
#line 208 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduled);
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1_ = self->priv->schedule_once;
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp1__target = self->priv->schedule_once_target;
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
	if (_tmp1_ != NULL) {
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp0_ = "once";
#line 870 "util-scheduled.c"
	} else {
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
		_tmp0_ = "continuously";
#line 874 "util-scheduled.c"
	}
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp2_ = self->priv->source_id;
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp3_ = g_strdup_printf ("Scheduled %s:%u", _tmp0_, _tmp2_);
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
	result = _tmp3_;
#line 209 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 884 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_construct (GType object_type) {
	CaliforniaScheduled * self = NULL;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = (CaliforniaScheduled*) california_base_object_construct (object_type);
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	return self;
#line 894 "util-scheduled.c"
}


CaliforniaScheduled* california_scheduled_new (void) {
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	return california_scheduled_construct (CALIFORNIA_TYPE_SCHEDULED);
#line 901 "util-scheduled.c"
}


gboolean california_scheduled_get_is_scheduled (CaliforniaScheduled* self) {
	gboolean result;
	guint _tmp0_ = 0U;
#line 69 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_val_if_fail (CALIFORNIA_IS_SCHEDULED (self), FALSE);
#line 69 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = self->priv->source_id;
#line 69 "/home/jim/git/california/src/util/util-scheduled.vala"
	result = _tmp0_ != ((guint) 0);
#line 69 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 916 "util-scheduled.c"
}


gboolean california_scheduled_get_is_continuous (CaliforniaScheduled* self) {
	gboolean result;
	CaliforniaScheduledScheduleContinuous _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 76 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_val_if_fail (CALIFORNIA_IS_SCHEDULED (self), FALSE);
#line 76 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = self->priv->schedule_continuous;
#line 76 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0__target = self->priv->schedule_continuous_target;
#line 76 "/home/jim/git/california/src/util/util-scheduled.vala"
	result = _tmp0_ != NULL;
#line 76 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 934 "util-scheduled.c"
}


gboolean california_scheduled_get_is_executing (CaliforniaScheduled* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_val_if_fail (CALIFORNIA_IS_SCHEDULED (self), FALSE);
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = self->priv->_is_executing;
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	result = _tmp0_;
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	return result;
#line 949 "util-scheduled.c"
}


static void california_scheduled_set_is_executing (CaliforniaScheduled* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_return_if_fail (CALIFORNIA_IS_SCHEDULED (self));
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	_tmp0_ = value;
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->_is_executing = _tmp0_;
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_object_notify ((GObject *) self, "is-executing");
#line 963 "util-scheduled.c"
}


static void california_scheduled_class_init (CaliforniaScheduledClass * klass) {
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	california_scheduled_parent_class = g_type_class_peek_parent (klass);
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaScheduledPrivate));
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_scheduled_real_to_string;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_scheduled_get_property;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_scheduled_set_property;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	G_OBJECT_CLASS (klass)->finalize = california_scheduled_finalize;
#line 980 "util-scheduled.c"
	/**
	     * Returns true if the callback is still scheduled for execution.
	     */
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_SCHEDULED_IS_SCHEDULED, g_param_spec_boolean ("is-scheduled", "is-scheduled", "is-scheduled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 986 "util-scheduled.c"
	/**
	     * Returns true if the code is scheduled for continuous execution.
	     *
	     * May return true even if the code is no longer scheduled for execution.
	     */
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_SCHEDULED_IS_CONTINUOUS, g_param_spec_boolean ("is-continuous", "is-continuous", "is-continuous", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 994 "util-scheduled.c"
	/**
	     * Returns true if the code is currently executing.
	     *
	     * Note: this is not thread-safe.
	     */
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_SCHEDULED_IS_EXECUTING, g_param_spec_boolean ("is-executing", "is-executing", "is-executing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1002 "util-scheduled.c"
}


static void california_scheduled_instance_init (CaliforniaScheduled * self) {
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv = CALIFORNIA_SCHEDULED_GET_PRIVATE (self);
#line 83 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->_is_executing = FALSE;
#line 86 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = NULL;
#line 87 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = NULL;
#line 1015 "util-scheduled.c"
}


static void california_scheduled_finalize (GObject* obj) {
	CaliforniaScheduled * self;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduled);
#line 144 "/home/jim/git/california/src/util/util-scheduled.vala"
	california_scheduled_cancel (self);
#line 86 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_once_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_once_target_destroy_notify (self->priv->schedule_once_target), NULL);
#line 86 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once = NULL;
#line 86 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target = NULL;
#line 86 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_once_target_destroy_notify = NULL;
#line 87 "/home/jim/git/california/src/util/util-scheduled.vala"
	(self->priv->schedule_continuous_target_destroy_notify == NULL) ? NULL : (self->priv->schedule_continuous_target_destroy_notify (self->priv->schedule_continuous_target), NULL);
#line 87 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous = NULL;
#line 87 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target = NULL;
#line 87 "/home/jim/git/california/src/util/util-scheduled.vala"
	self->priv->schedule_continuous_target_destroy_notify = NULL;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	G_OBJECT_CLASS (california_scheduled_parent_class)->finalize (obj);
#line 1043 "util-scheduled.c"
}


/**
 * A reference-counted source ID to better control execution of Idle and Timeout callbacks in the
 * event loop.
 *
 * Idle and Timeout provide "fire and forget" ways to schedule events to be executed later.
 * Cancelling those calls after scheduling them is easy to get wrong, since the returned uint (the
 * source ID) is invalid once the callback has been removed from the scheduler, which must be done
 * manually by the calling code.
 *
 * Scheduled manages the validity of the source ID.  It also simplifies writing delegates for the
 * callback (especially for the Idle case) to make it easier to write Vala anonoymous functions.
 *
 * Note that if the last reference to a Scheduled is dropped the callback will be cancelled if its
 * not already executed and continuous callbacks will halt.
 */
GType california_scheduled_get_type (void) {
	static volatile gsize california_scheduled_type_id__volatile = 0;
	if (g_once_init_enter (&california_scheduled_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaScheduledClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_scheduled_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaScheduled), 0, (GInstanceInitFunc) california_scheduled_instance_init, NULL };
		GType california_scheduled_type_id;
		california_scheduled_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaScheduled", &g_define_type_info, 0);
		g_once_init_leave (&california_scheduled_type_id__volatile, california_scheduled_type_id);
	}
	return california_scheduled_type_id__volatile;
}


static void _vala_california_scheduled_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaScheduled * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduled);
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	switch (property_id) {
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		case CALIFORNIA_SCHEDULED_IS_SCHEDULED:
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_value_set_boolean (value, california_scheduled_get_is_scheduled (self));
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		break;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		case CALIFORNIA_SCHEDULED_IS_CONTINUOUS:
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_value_set_boolean (value, california_scheduled_get_is_continuous (self));
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		break;
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		case CALIFORNIA_SCHEDULED_IS_EXECUTING:
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		g_value_set_boolean (value, california_scheduled_get_is_executing (self));
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		break;
#line 1097 "util-scheduled.c"
		default:
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		break;
#line 1103 "util-scheduled.c"
	}
}


static void _vala_california_scheduled_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaScheduled * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduled);
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
	switch (property_id) {
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		case CALIFORNIA_SCHEDULED_IS_EXECUTING:
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		california_scheduled_set_is_executing (self, g_value_get_boolean (value));
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		break;
#line 1119 "util-scheduled.c"
		default:
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 43 "/home/jim/git/california/src/util/util-scheduled.vala"
		break;
#line 1125 "util-scheduled.c"
	}
}



