/* toolkit-deck.c generated by valac 0.26.0, the Vala compiler
 * generated from toolkit-deck.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TOOLKIT_TYPE_DECK (california_toolkit_deck_get_type ())
#define CALIFORNIA_TOOLKIT_DECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck))
#define CALIFORNIA_TOOLKIT_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))
#define CALIFORNIA_TOOLKIT_IS_DECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_IS_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_DECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))

typedef struct _CaliforniaToolkitDeck CaliforniaToolkitDeck;
typedef struct _CaliforniaToolkitDeckClass CaliforniaToolkitDeckClass;
typedef struct _CaliforniaToolkitDeckPrivate CaliforniaToolkitDeckPrivate;

#define CALIFORNIA_TOOLKIT_TYPE_CARD (california_toolkit_card_get_type ())
#define CALIFORNIA_TOOLKIT_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard))
#define CALIFORNIA_TOOLKIT_IS_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD))
#define CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCardIface))

typedef struct _CaliforniaToolkitCard CaliforniaToolkitCard;
typedef struct _CaliforniaToolkitCardIface CaliforniaToolkitCardIface;

#define CALIFORNIA_TOOLKIT_CARD_TYPE_JUMP (california_toolkit_card_jump_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_TOOLKIT_CARD_TYPE_DISMISS_REASON (california_toolkit_card_dismiss_reason_get_type ())

#define CALIFORNIA_TYPE_ITERABLE (california_iterable_get_type ())
#define CALIFORNIA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterable))
#define CALIFORNIA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))
#define CALIFORNIA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))

typedef struct _CaliforniaIterable CaliforniaIterable;
typedef struct _CaliforniaIterableClass CaliforniaIterableClass;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaToolkitDeck {
	GtkStack parent_instance;
	CaliforniaToolkitDeckPrivate * priv;
};

struct _CaliforniaToolkitDeckClass {
	GtkStackClass parent_class;
};

typedef enum  {
	CALIFORNIA_TOOLKIT_CARD_JUMP_HOME,
	CALIFORNIA_TOOLKIT_CARD_JUMP_BACK,
	CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT
} CaliforniaToolkitCardJump;

struct _CaliforniaToolkitCardIface {
	GTypeInterface parent_iface;
	void (*jumped_to) (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
	const gchar* (*get_card_id) (CaliforniaToolkitCard* self);
	const gchar* (*get_title) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_default_widget) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_initial_focus) (CaliforniaToolkitCard* self);
};

struct _CaliforniaToolkitDeckPrivate {
	CaliforniaToolkitCard* _top;
	GeeList* list;
	GeeDeque* navigation_stack;
	GeeHashMap* names;
};

typedef enum  {
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_SUCCESS,
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_FAILED,
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_USER_CLOSED,
	CALIFORNIA_TOOLKIT_CARD_DISMISS_REASON_ABORTED
} CaliforniaToolkitCardDismissReason;


static gpointer california_toolkit_deck_parent_class = NULL;

GType california_toolkit_deck_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_jump_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_TOOLKIT_DECK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckPrivate))
enum  {
	CALIFORNIA_TOOLKIT_DECK_DUMMY_PROPERTY,
	CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET,
	CALIFORNIA_TOOLKIT_DECK_SIZE,
	CALIFORNIA_TOOLKIT_DECK_CARDS,
	CALIFORNIA_TOOLKIT_DECK_HOME,
	CALIFORNIA_TOOLKIT_DECK_TOP
};
static void california_toolkit_deck_on_card_mapped (CaliforniaToolkitDeck* self, GtkWidget* widget);
static void _california_toolkit_deck_on_card_mapped_gtk_widget_map (GtkWidget* _sender, gpointer self);
static void california_toolkit_deck_on_card_realized (CaliforniaToolkitDeck* self, GtkWidget* card);
static void _california_toolkit_deck_on_card_realized_gtk_widget_realize (GtkWidget* _sender, gpointer self);
CaliforniaToolkitDeck* california_toolkit_deck_new (void);
CaliforniaToolkitDeck* california_toolkit_deck_construct (GType object_type);
#define CALIFORNIA_TOOLKIT_DEFAULT_STACK_TRANSITION_DURATION_MSEC 300
static void california_toolkit_deck_on_child_to_top (CaliforniaToolkitDeck* self);
static void _california_toolkit_deck_on_child_to_top_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
CaliforniaToolkitCard* california_toolkit_deck_get_top (CaliforniaToolkitDeck* self);
static void california_toolkit_deck_on_jump_to_card_instance (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, GValue* message);
static void _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card (CaliforniaToolkitCard* _sender, CaliforniaToolkitCard* next, GValue* message, gpointer self);
static void california_toolkit_deck_on_jump_to_card_by_name (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, const gchar* name, GValue* message);
static void _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name (CaliforniaToolkitCard* _sender, const gchar* name, GValue* message, gpointer self);
static void california_toolkit_deck_on_jump_back (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
static void _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back (CaliforniaToolkitCard* _sender, gpointer self);
static void california_toolkit_deck_on_jump_home (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
static void _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home (CaliforniaToolkitCard* _sender, gpointer self);
GType california_toolkit_card_dismiss_reason_get_type (void) G_GNUC_CONST;
static void california_toolkit_deck_on_dismiss (CaliforniaToolkitDeck* self, CaliforniaToolkitCardDismissReason reason);
static void _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss (CaliforniaToolkitCard* _sender, CaliforniaToolkitCardDismissReason reason, gpointer self);
static void california_toolkit_deck_on_error_message (CaliforniaToolkitDeck* self, const gchar* user_message);
static void _california_toolkit_deck_on_error_message_california_toolkit_card_error_message (CaliforniaToolkitCard* _sender, const gchar* user_message, gpointer self);
static void california_toolkit_deck_set_top (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* value);
void california_toolkit_deck_add_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
void california_toolkit_deck_add_cards (CaliforniaToolkitDeck* self, GeeList* cards);
GType california_iterable_get_type (void) G_GNUC_CONST;
CaliforniaIterable* california_iterate (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer g, ...);
GeeArrayList* california_iterable_to_array_list (CaliforniaIterable* self, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
gint california_toolkit_deck_get_size (CaliforniaToolkitDeck* self);
gboolean california_string_is_empty (const gchar* str);
const gchar* california_toolkit_card_get_card_id (CaliforniaToolkitCard* self);
const gchar* california_toolkit_card_get_title (CaliforniaToolkitCard* self);
CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self);
void california_toolkit_card_jumped_to (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
void california_toolkit_deck_remove_cards (CaliforniaToolkitDeck* self, GeeCollection* cards);
static GValue* california_toolkit_deck_strip_null_value (CaliforniaToolkitDeck* self, GValue* message);
static GValue* _g_value_dup (GValue* self);
void california_toolkit_deck_go_home (CaliforniaToolkitDeck* self, GValue* message);
static void _vala_GValue_free (GValue* self);
static void california_toolkit_deck_on_jump_to_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, CaliforniaToolkitCardJump reason, GValue* message);
GtkWidget* california_toolkit_card_get_default_widget (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_card_get_initial_focus (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_deck_get_default_widget (CaliforniaToolkitDeck* self);
GeeList* california_toolkit_deck_get_cards (CaliforniaToolkitDeck* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void california_toolkit_deck_finalize (GObject* obj);
static void _vala_california_toolkit_deck_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_toolkit_deck_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _california_toolkit_deck_on_card_mapped_gtk_widget_map (GtkWidget* _sender, gpointer self) {
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_card_mapped ((CaliforniaToolkitDeck*) self, _sender);
#line 162 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_card_realized_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_card_realized ((CaliforniaToolkitDeck*) self, _sender);
#line 169 "toolkit-deck.c"
}


/**
     * Create a new {@link Deck}.
     *
     * By default the Deck configures the underlying Gtk.Stack to slide left and right, depending
     * on the position of the {@link Card}s.  This can be changed, but the recommended
     * transition types are SLIDE_LEFT_RIGHT and SLIDE_UP_DOWN.
     */
static void _california_toolkit_deck_on_child_to_top_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_child_to_top ((CaliforniaToolkitDeck*) self);
#line 183 "toolkit-deck.c"
}


CaliforniaToolkitDeck* california_toolkit_deck_construct (GType object_type) {
	CaliforniaToolkitDeck * self = NULL;
#line 73 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self = (CaliforniaToolkitDeck*) g_object_new (object_type, NULL);
#line 74 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_transition_type (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
#line 75 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_transition_duration (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), (guint) CALIFORNIA_TOOLKIT_DEFAULT_STACK_TRANSITION_DURATION_MSEC);
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::visible-child", (GCallback) _california_toolkit_deck_on_child_to_top_g_object_notify, self, 0);
#line 73 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self;
#line 199 "toolkit-deck.c"
}


CaliforniaToolkitDeck* california_toolkit_deck_new (void) {
#line 73 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return california_toolkit_deck_construct (CALIFORNIA_TOOLKIT_TYPE_DECK);
#line 206 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card (CaliforniaToolkitCard* _sender, CaliforniaToolkitCard* next, GValue* message, gpointer self) {
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card_instance ((CaliforniaToolkitDeck*) self, _sender, next, message);
#line 213 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name (CaliforniaToolkitCard* _sender, const gchar* name, GValue* message, gpointer self) {
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card_by_name ((CaliforniaToolkitDeck*) self, _sender, name, message);
#line 220 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back (CaliforniaToolkitCard* _sender, gpointer self) {
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_back ((CaliforniaToolkitDeck*) self, _sender);
#line 227 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home (CaliforniaToolkitCard* _sender, gpointer self) {
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_home ((CaliforniaToolkitDeck*) self, _sender);
#line 234 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss (CaliforniaToolkitCard* _sender, CaliforniaToolkitCardDismissReason reason, gpointer self) {
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_dismiss ((CaliforniaToolkitDeck*) self, reason);
#line 241 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_error_message_california_toolkit_card_error_message (CaliforniaToolkitCard* _sender, const gchar* user_message, gpointer self) {
#line 95 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_error_message ((CaliforniaToolkitDeck*) self, user_message);
#line 248 "toolkit-deck.c"
}


static void california_toolkit_deck_on_child_to_top (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	CaliforniaToolkitCard* _tmp17_ = NULL;
#line 87 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ != NULL) {
#line 263 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		CaliforniaToolkitCard* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		CaliforniaToolkitCard* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		CaliforniaToolkitCard* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		CaliforniaToolkitCard* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		CaliforniaToolkitCard* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		GeeDeque* _tmp13_ = NULL;
		CaliforniaToolkitCard* _tmp14_ = NULL;
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = self->priv->_top;
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-to-card", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp2_, NULL, FALSE);
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card, self);
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = self->priv->_top;
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-to-card-by-name", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp4_, NULL, FALSE);
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name, self);
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = self->priv->_top;
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-back", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp6_, NULL, FALSE);
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back, self);
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = self->priv->_top;
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-home", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp8_, NULL, FALSE);
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home, self);
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = self->priv->_top;
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("dismiss", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp10_, NULL, FALSE);
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss, self);
#line 95 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp11_ = self->priv->_top;
#line 95 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("error-message", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp12_, NULL, FALSE);
#line 95 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _california_toolkit_deck_on_error_message_california_toolkit_card_error_message, self);
#line 97 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = self->priv->navigation_stack;
#line 97 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = self->priv->_top;
#line 97 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gee_deque_offer_head (_tmp13_, _tmp14_);
#line 98 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_set_top (self, NULL);
#line 322 "toolkit-deck.c"
	}
#line 102 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack));
#line 102 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = _tmp15_;
#line 102 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_set_top (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, CALIFORNIA_TOOLKIT_TYPE_CARD) ? ((CaliforniaToolkitCard*) _tmp16_) : NULL);
#line 103 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = self->priv->_top;
#line 103 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp17_ != NULL) {
#line 334 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp18_ = NULL;
		CaliforniaToolkitCard* _tmp19_ = NULL;
		CaliforniaToolkitCard* _tmp20_ = NULL;
		CaliforniaToolkitCard* _tmp21_ = NULL;
		CaliforniaToolkitCard* _tmp22_ = NULL;
		CaliforniaToolkitCard* _tmp23_ = NULL;
#line 104 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp18_ = self->priv->_top;
#line 104 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp18_, "jump-to-card", (GCallback) _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card, self, 0);
#line 105 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp19_ = self->priv->_top;
#line 105 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp19_, "jump-to-card-by-name", (GCallback) _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name, self, 0);
#line 106 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp20_ = self->priv->_top;
#line 106 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp20_, "jump-back", (GCallback) _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back, self, 0);
#line 107 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp21_ = self->priv->_top;
#line 107 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp21_, "jump-home", (GCallback) _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home, self, 0);
#line 108 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp22_ = self->priv->_top;
#line 108 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp22_, "dismiss", (GCallback) _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss, self, 0);
#line 109 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp23_ = self->priv->_top;
#line 109 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp23_, "error-message", (GCallback) _california_toolkit_deck_on_error_message_california_toolkit_card_error_message, self, 0);
#line 365 "toolkit-deck.c"
	}
}


/**
     * A helper method for {@link add_cards}.
     */
void california_toolkit_deck_add_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaIterable* _tmp1_ = NULL;
	CaliforniaIterable* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 116 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 116 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = card;
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = california_iterate (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, NULL);
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = california_iterable_to_array_list (_tmp2_, NULL, NULL, NULL);
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_;
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_add_cards (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_LIST, GeeList));
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp4_);
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp2_);
#line 399 "toolkit-deck.c"
}


/**
     * Add {@link Card}s to the {@link Deck}.
     *
     * Cards can be added in multiple batches, but the ordering is important as it dictates how
     * they're presented to the user via transitions and slides.
     *
     * The first Card added is the "home" Card.  The Deck will automatically show it first.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self ? g_object_ref (self) : NULL;
#line 414 "toolkit-deck.c"
}


void california_toolkit_deck_add_cards (CaliforniaToolkitDeck* self, GeeList* cards) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeList* _tmp3_ = NULL;
	gboolean set_home_visible = FALSE;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	GeeList* _tmp61_ = NULL;
#line 128 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 128 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GEE_IS_LIST (cards));
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = cards;
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp2_ == 0) {
#line 130 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 443 "toolkit-deck.c"
	}
#line 132 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = cards;
#line 132 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "adding-removing-cards", _tmp3_, NULL);
#line 135 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = california_toolkit_deck_get_size (self);
#line 135 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = _tmp4_;
#line 135 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	set_home_visible = _tmp5_ == 0;
#line 455 "toolkit-deck.c"
	{
		GeeList* _card_list = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		gint _card_size = 0;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _card_index = 0;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = cards;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_list = _tmp7_;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = _card_list;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp10_ = _tmp9_;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_size = _tmp10_;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_index = -1;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 483 "toolkit-deck.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			CaliforniaToolkitCard* card = NULL;
			GeeList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			CaliforniaToolkitCard* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			GeeHashMap* _tmp21_ = NULL;
			CaliforniaToolkitCard* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			CaliforniaToolkitCard* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			GeeHashMap* _tmp41_ = NULL;
			CaliforniaToolkitCard* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			CaliforniaToolkitCard* _tmp45_ = NULL;
			CaliforniaToolkitCard* _tmp46_ = NULL;
			CaliforniaToolkitCard* _tmp47_ = NULL;
			GeeList* _tmp48_ = NULL;
			CaliforniaToolkitCard* _tmp49_ = NULL;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp11_ = _card_index;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_card_index = _tmp11_ + 1;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp12_ = _card_index;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp13_ = _card_size;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 525 "toolkit-deck.c"
			}
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp14_ = _card_list;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp15_ = _card_index;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp16_;
#line 140 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = card;
#line 140 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp18_ = california_toolkit_card_get_card_id (_tmp17_);
#line 140 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp19_ = _tmp18_;
#line 140 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = california_string_is_empty (_tmp19_);
#line 140 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_vala_assert (!_tmp20_, "!String.is_empty(card.card_id)");
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp21_ = self->priv->names;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp22_ = card;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp23_ = california_toolkit_card_get_card_id (_tmp22_);
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp24_ = _tmp23_;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp25_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_);
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_vala_assert (!_tmp25_, "!names.has_key(card.card_id)");
#line 143 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp26_ = card;
#line 143 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp27_ = california_toolkit_card_get_title (_tmp26_);
#line 143 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp28_ = _tmp27_;
#line 143 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp29_ = california_string_is_empty (_tmp28_);
#line 143 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (_tmp29_) {
#line 567 "toolkit-deck.c"
				CaliforniaToolkitCard* _tmp30_ = NULL;
				CaliforniaToolkitCard* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp30_ = card;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp31_ = card;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp32_ = california_toolkit_card_get_card_id (_tmp31_);
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp33_ = _tmp32_;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				gtk_stack_add_named (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget), _tmp33_);
#line 582 "toolkit-deck.c"
			} else {
				CaliforniaToolkitCard* _tmp34_ = NULL;
				CaliforniaToolkitCard* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				CaliforniaToolkitCard* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp34_ = card;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp35_ = card;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp36_ = california_toolkit_card_get_card_id (_tmp35_);
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp37_ = _tmp36_;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp38_ = card;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp39_ = california_toolkit_card_get_title (_tmp38_);
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp40_ = _tmp39_;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				gtk_stack_add_titled (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), _tmp37_, _tmp40_);
#line 607 "toolkit-deck.c"
			}
#line 148 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp41_ = self->priv->names;
#line 148 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp42_ = card;
#line 148 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp43_ = california_toolkit_card_get_card_id (_tmp42_);
#line 148 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp44_ = _tmp43_;
#line 148 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp45_ = card;
#line 148 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp44_, _tmp45_);
#line 153 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp46_ = card;
#line 153 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget), "map", (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self, 0);
#line 156 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp47_ = card;
#line 156 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget), "realize", (GCallback) _california_toolkit_deck_on_card_realized_gtk_widget_realize, self, 0);
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp48_ = self->priv->list;
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp49_ = card;
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_COLLECTION, GeeCollection), _tmp49_);
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 637 "toolkit-deck.c"
		}
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_list);
#line 641 "toolkit-deck.c"
	}
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp51_ = set_home_visible;
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp51_) {
#line 647 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp52_ = NULL;
		CaliforniaToolkitCard* _tmp53_ = NULL;
		CaliforniaToolkitCard* _tmp54_ = NULL;
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp52_ = california_toolkit_deck_get_home (self);
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp53_ = _tmp52_;
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp54_ = _tmp53_;
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp50_ = _tmp54_ != NULL;
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp54_);
#line 661 "toolkit-deck.c"
	} else {
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp50_ = FALSE;
#line 665 "toolkit-deck.c"
	}
#line 162 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp50_) {
#line 669 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp55_ = NULL;
		CaliforniaToolkitCard* _tmp56_ = NULL;
		CaliforniaToolkitCard* _tmp57_ = NULL;
		CaliforniaToolkitCard* _tmp58_ = NULL;
		CaliforniaToolkitCard* _tmp59_ = NULL;
		CaliforniaToolkitCard* _tmp60_ = NULL;
#line 163 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp55_ = california_toolkit_deck_get_home (self);
#line 163 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp56_ = _tmp55_;
#line 163 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp57_ = _tmp56_;
#line 163 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget));
#line 163 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp57_);
#line 164 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp58_ = california_toolkit_deck_get_home (self);
#line 164 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp59_ = _tmp58_;
#line 164 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp60_ = _tmp59_;
#line 164 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_card_jumped_to (_tmp60_, NULL, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, NULL);
#line 164 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp60_);
#line 696 "toolkit-deck.c"
	}
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp61_ = cards;
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "added-removed-cards", _tmp61_, NULL);
#line 702 "toolkit-deck.c"
}


/**
     * Removes {@link Card}s from the {@link Deck}.
     *
     * If the {@link top} card is removed, the Deck will return {@link home}, clearing the
     * navigation stack in the process.
     */
void california_toolkit_deck_remove_cards (CaliforniaToolkitDeck* self, GeeCollection* cards) {
	gboolean displaying = FALSE;
	CaliforniaToolkitCard* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GeeCollection* _tmp45_ = NULL;
#line 176 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 176 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GEE_IS_COLLECTION (cards));
#line 177 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 177 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	displaying = _tmp0_ != NULL;
#line 179 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = cards;
#line 179 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "adding-removing-cards", NULL, _tmp1_);
#line 732 "toolkit-deck.c"
	{
		GeeIterator* _card_it = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = cards;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_it = _tmp3_;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 745 "toolkit-deck.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			CaliforniaToolkitCard* card = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			GeeHashMap* _tmp8_ = NULL;
			CaliforniaToolkitCard* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			CaliforniaToolkitCard* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			CaliforniaToolkitCard* _tmp18_ = NULL;
			guint _tmp19_ = 0U;
			CaliforniaToolkitCard* _tmp20_ = NULL;
			CaliforniaToolkitCard* _tmp21_ = NULL;
			CaliforniaToolkitCard* _tmp22_ = NULL;
			GeeDeque* _tmp23_ = NULL;
			CaliforniaToolkitCard* _tmp24_ = NULL;
			GeeHashMap* _tmp25_ = NULL;
			CaliforniaToolkitCard* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			GeeList* _tmp29_ = NULL;
			CaliforniaToolkitCard* _tmp30_ = NULL;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp4_ = _card_it;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp5_) {
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 779 "toolkit-deck.c"
			}
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = _card_it;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp7_;
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp8_ = self->priv->names;
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp9_ = card;
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = california_toolkit_card_get_card_id (_tmp9_);
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp11_ = _tmp10_;
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp12_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_);
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp12_) {
#line 799 "toolkit-deck.c"
				CaliforniaToolkitCard* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp13_ = card;
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp14_ = california_toolkit_card_get_card_id (_tmp13_);
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp15_ = _tmp14_;
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				g_message ("toolkit-deck.vala:183: Card %s not found in Deck", _tmp15_);
#line 185 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_g_object_unref0 (card);
#line 185 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				continue;
#line 815 "toolkit-deck.c"
			}
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp16_ = card;
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("map", gtk_widget_get_type (), &_tmp17_, NULL, FALSE);
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self);
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp18_ = card;
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("realize", gtk_widget_get_type (), &_tmp19_, NULL, FALSE);
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_realized_gtk_widget_realize, self);
#line 191 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = card;
#line 191 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
#line 193 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp21_ = self->priv->_top;
#line 193 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp22_ = card;
#line 193 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (_tmp21_ == _tmp22_) {
#line 194 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				california_toolkit_deck_set_top (self, NULL);
#line 841 "toolkit-deck.c"
			}
#line 196 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp23_ = self->priv->navigation_stack;
#line 196 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp24_ = card;
#line 196 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), _tmp24_);
#line 197 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp25_ = self->priv->names;
#line 197 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp26_ = card;
#line 197 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp27_ = california_toolkit_card_get_card_id (_tmp26_);
#line 197 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp28_ = _tmp27_;
#line 197 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp28_, NULL);
#line 198 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp29_ = self->priv->list;
#line 198 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp30_ = card;
#line 198 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection), _tmp30_);
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 867 "toolkit-deck.c"
		}
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_it);
#line 871 "toolkit-deck.c"
	}
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp33_ = displaying;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp33_) {
#line 877 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp34_ = NULL;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp34_ = self->priv->_top;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp32_ = _tmp34_ == NULL;
#line 883 "toolkit-deck.c"
	} else {
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp32_ = FALSE;
#line 887 "toolkit-deck.c"
	}
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp32_) {
#line 891 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp35_ = NULL;
		CaliforniaToolkitCard* _tmp36_ = NULL;
		CaliforniaToolkitCard* _tmp37_ = NULL;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp35_ = california_toolkit_deck_get_home (self);
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp36_ = _tmp35_;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp37_ = _tmp36_;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp31_ = _tmp37_ != NULL;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp37_);
#line 905 "toolkit-deck.c"
	} else {
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp31_ = FALSE;
#line 909 "toolkit-deck.c"
	}
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp31_) {
#line 913 "toolkit-deck.c"
		GeeDeque* _tmp38_ = NULL;
		CaliforniaToolkitCard* _tmp39_ = NULL;
		CaliforniaToolkitCard* _tmp40_ = NULL;
		CaliforniaToolkitCard* _tmp41_ = NULL;
		CaliforniaToolkitCard* _tmp42_ = NULL;
		CaliforniaToolkitCard* _tmp43_ = NULL;
		CaliforniaToolkitCard* _tmp44_ = NULL;
#line 203 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp38_ = self->priv->navigation_stack;
#line 203 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_COLLECTION, GeeCollection));
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp39_ = california_toolkit_deck_get_home (self);
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp40_ = _tmp39_;
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp41_ = _tmp40_;
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget));
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp41_);
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp42_ = california_toolkit_deck_get_home (self);
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp43_ = _tmp42_;
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp44_ = _tmp43_;
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_card_jumped_to (_tmp44_, NULL, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, NULL);
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp44_);
#line 945 "toolkit-deck.c"
	}
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp45_ = cards;
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "added-removed-cards", NULL, _tmp45_);
#line 951 "toolkit-deck.c"
}


static GValue* _g_value_dup (GValue* self) {
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 958 "toolkit-deck.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self ? _g_value_dup (self) : NULL;
#line 965 "toolkit-deck.c"
}


static GValue* california_toolkit_deck_strip_null_value (CaliforniaToolkitDeck* self, GValue* message) {
	GValue* result = NULL;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GValue* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GValue* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GValue* _tmp22_ = NULL;
	GValue* _tmp23_ = NULL;
#line 211 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 212 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = message;
#line 212 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ == NULL) {
#line 213 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = NULL;
#line 213 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 990 "toolkit-deck.c"
	}
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = message;
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = G_VALUE_HOLDS (_tmp1_, G_TYPE_STRING);
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp2_) {
#line 998 "toolkit-deck.c"
		GValue* _tmp3_ = NULL;
		GValue* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GValue* _tmp7_ = NULL;
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = message;
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = g_value_get_string (_tmp4_);
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp5_ != NULL) {
#line 1009 "toolkit-deck.c"
			GValue* _tmp6_ = NULL;
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = message;
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp3_ = _tmp6_;
#line 1015 "toolkit-deck.c"
		} else {
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp3_ = NULL;
#line 1019 "toolkit-deck.c"
		}
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = __g_value_dup0 (_tmp3_);
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = _tmp7_;
#line 216 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 1027 "toolkit-deck.c"
	}
#line 218 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = message;
#line 218 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = G_VALUE_HOLDS (_tmp8_, G_TYPE_OBJECT);
#line 218 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp9_) {
#line 1035 "toolkit-deck.c"
		GValue* _tmp10_ = NULL;
		GValue* _tmp11_ = NULL;
		GObject* _tmp12_ = NULL;
		GValue* _tmp14_ = NULL;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp11_ = message;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp12_ = g_value_get_object (_tmp11_);
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp12_ != NULL) {
#line 1046 "toolkit-deck.c"
			GValue* _tmp13_ = NULL;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp13_ = message;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = _tmp13_;
#line 1052 "toolkit-deck.c"
		} else {
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = NULL;
#line 1056 "toolkit-deck.c"
		}
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = __g_value_dup0 (_tmp10_);
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = _tmp14_;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 1064 "toolkit-deck.c"
	}
#line 221 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = message;
#line 221 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = G_VALUE_HOLDS (_tmp15_, G_TYPE_POINTER);
#line 221 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp16_) {
#line 1072 "toolkit-deck.c"
		GValue* _tmp17_ = NULL;
		GValue* _tmp18_ = NULL;
		void* _tmp19_ = NULL;
		GValue* _tmp21_ = NULL;
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp18_ = message;
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp19_ = g_value_get_pointer (_tmp18_);
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp19_ != NULL) {
#line 1083 "toolkit-deck.c"
			GValue* _tmp20_ = NULL;
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = message;
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = _tmp20_;
#line 1089 "toolkit-deck.c"
		} else {
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = NULL;
#line 1093 "toolkit-deck.c"
		}
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp21_ = __g_value_dup0 (_tmp17_);
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = _tmp21_;
#line 222 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 1101 "toolkit-deck.c"
	}
#line 224 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp22_ = message;
#line 224 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp23_ = __g_value_dup0 (_tmp22_);
#line 224 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp23_;
#line 224 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1111 "toolkit-deck.c"
}


/**
     * Force the {@link Deck} to jump to the {@link home} {@link Card}.
     *
     * In general, Deck avoids jumping to a Card if it's already displayed (on top).  However, for
     * this call it will call the Card's {@link Card.jumped_to} method and pass the supplied
     * message every time, even if already on top.  This allows for this call to be used for Deck
     * initialization.
     */
static void _vala_GValue_free (GValue* self) {
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_value_unset (self);
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_free (self);
#line 1128 "toolkit-deck.c"
}


void california_toolkit_deck_go_home (CaliforniaToolkitDeck* self, GValue* message) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeDeque* _tmp4_ = NULL;
	CaliforniaToolkitCard* _tmp5_ = NULL;
	CaliforniaToolkitCard* _tmp6_ = NULL;
	CaliforniaToolkitCard* _tmp7_ = NULL;
	CaliforniaToolkitCard* _tmp8_ = NULL;
	CaliforniaToolkitCard* _tmp9_ = NULL;
	CaliforniaToolkitCard* _tmp10_ = NULL;
	GValue* _tmp11_ = NULL;
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
#line 235 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 236 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = california_toolkit_deck_get_home (self);
#line 236 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _tmp0_;
#line 236 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 236 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_ == NULL;
#line 236 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp2_);
#line 236 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_) {
#line 237 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1163 "toolkit-deck.c"
	}
#line 240 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = self->priv->navigation_stack;
#line 240 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 242 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = california_toolkit_deck_get_home (self);
#line 242 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp6_ = _tmp5_;
#line 242 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp7_ = _tmp6_;
#line 242 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
#line 242 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp7_);
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = california_toolkit_deck_get_home (self);
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = _tmp8_;
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp10_ = _tmp9_;
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp11_ = message;
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp12_ = california_toolkit_deck_strip_null_value (self, _tmp11_);
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp13_ = _tmp12_;
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_card_jumped_to (_tmp10_, NULL, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, _tmp13_);
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	__vala_GValue_free0 (_tmp13_);
#line 243 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp10_);
#line 1197 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, CaliforniaToolkitCardJump reason, GValue* message) {
	GtkWidget* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeCollection* _tmp7_ = NULL;
	GeeCollection* _tmp8_ = NULL;
	CaliforniaToolkitCard* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	CaliforniaToolkitCard* _tmp15_ = NULL;
	CaliforniaToolkitCard* _tmp16_ = NULL;
	CaliforniaToolkitCard* _tmp17_ = NULL;
	CaliforniaToolkitCardJump _tmp18_ = 0;
	GValue* _tmp19_ = NULL;
	GValue* _tmp20_ = NULL;
	GValue* _tmp21_ = NULL;
#line 246 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 246 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 246 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (next));
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack));
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = next;
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ == _tmp1_) {
#line 1230 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = next;
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = california_toolkit_card_get_card_id (_tmp2_);
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = _tmp3_;
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_debug ("toolkit-deck.vala:249: Already showing card %s", _tmp4_);
#line 251 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1244 "toolkit-deck.c"
	}
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = self->priv->names;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp6_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_MAP, GeeMap));
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp7_ = _tmp6_;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = _tmp7_;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = next;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp11_ = !_tmp10_;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp8_);
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp11_) {
#line 1264 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp12_ = next;
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = california_toolkit_card_get_card_id (_tmp12_);
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = _tmp13_;
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:256: Card %s not registered with Deck", _tmp14_);
#line 258 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1278 "toolkit-deck.c"
	}
#line 261 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = next;
#line 261 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = next;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = card;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp18_ = reason;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp19_ = message;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp20_ = california_toolkit_deck_strip_null_value (self, _tmp19_);
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp21_ = _tmp20_;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_card_jumped_to (_tmp16_, _tmp17_, _tmp18_, _tmp21_);
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	__vala_GValue_free0 (_tmp21_);
#line 1300 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card_instance (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, GValue* message) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	GValue* _tmp2_ = NULL;
#line 265 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 265 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 265 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (next));
#line 266 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = card;
#line 266 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = next;
#line 266 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = message;
#line 266 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card (self, _tmp0_, _tmp1_, CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT, _tmp2_);
#line 1322 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card_by_name (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, const gchar* name, GValue* message) {
	CaliforniaToolkitCard* next = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
#line 269 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 269 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 269 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (name != NULL);
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->names;
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = name;
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	next = (CaliforniaToolkitCard*) _tmp2_;
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = next;
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_ != NULL) {
#line 1350 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp4_ = NULL;
		CaliforniaToolkitCard* _tmp5_ = NULL;
		GValue* _tmp6_ = NULL;
#line 272 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = card;
#line 272 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = next;
#line 272 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = message;
#line 272 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp4_, _tmp5_, CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT, _tmp6_);
#line 1362 "toolkit-deck.c"
	} else {
		const gchar* _tmp7_ = NULL;
#line 274 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = name;
#line 274 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:274: Card %s not found in Deck", _tmp7_);
#line 1369 "toolkit-deck.c"
	}
#line 269 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (next);
#line 1373 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_back (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	GeeDeque* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->navigation_stack;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (!_tmp2_) {
#line 1393 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp3_ = NULL;
		GeeDeque* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		CaliforniaToolkitCard* _tmp6_ = NULL;
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = card;
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = self->priv->navigation_stack;
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = gee_deque_poll_head (_tmp4_);
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = (CaliforniaToolkitCard*) _tmp5_;
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp3_, _tmp6_, CALIFORNIA_TOOLKIT_CARD_JUMP_BACK, NULL);
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp6_);
#line 1410 "toolkit-deck.c"
	}
}


static void california_toolkit_deck_on_jump_home (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	GeeDeque* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 283 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 283 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 285 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->navigation_stack;
#line 285 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 287 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = california_toolkit_deck_get_home (self);
#line 287 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 287 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_;
#line 287 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 287 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp3_);
#line 287 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp4_) {
#line 1441 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp5_ = NULL;
		CaliforniaToolkitCard* _tmp6_ = NULL;
		CaliforniaToolkitCard* _tmp7_ = NULL;
		CaliforniaToolkitCard* _tmp8_ = NULL;
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = card;
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = california_toolkit_deck_get_home (self);
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = _tmp6_;
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = _tmp7_;
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp5_, _tmp8_, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, NULL);
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp8_);
#line 1458 "toolkit-deck.c"
	} else {
#line 290 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:290: No home card in Deck");
#line 1462 "toolkit-deck.c"
	}
}


static void california_toolkit_deck_on_dismiss (CaliforniaToolkitDeck* self, CaliforniaToolkitCardDismissReason reason) {
	CaliforniaToolkitCardDismissReason _tmp0_ = 0;
#line 293 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = reason;
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "dismiss", _tmp0_);
#line 1475 "toolkit-deck.c"
}


static void california_toolkit_deck_on_error_message (CaliforniaToolkitDeck* self, const gchar* user_message) {
	const gchar* _tmp0_ = NULL;
#line 297 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 297 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (user_message != NULL);
#line 298 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = user_message;
#line 298 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "error-message", _tmp0_);
#line 1489 "toolkit-deck.c"
}


static void california_toolkit_deck_on_card_mapped (CaliforniaToolkitDeck* self, GtkWidget* widget) {
	CaliforniaToolkitCard* card = NULL;
	GtkWidget* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	CaliforniaToolkitCard* _tmp16_ = NULL;
	GtkWidget* _tmp17_ = NULL;
	GtkWidget* _tmp18_ = NULL;
#line 301 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 301 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 302 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = widget;
#line 302 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard));
#line 302 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	card = _tmp1_;
#line 304 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = card;
#line 304 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = california_toolkit_card_get_default_widget (_tmp2_);
#line 304 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_;
#line 304 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp4_ != NULL) {
#line 1521 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 305 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = card;
#line 305 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = california_toolkit_card_get_default_widget (_tmp5_);
#line 305 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = _tmp6_;
#line 305 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = gtk_widget_get_can_default (_tmp7_);
#line 305 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = _tmp8_;
#line 305 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp9_) {
#line 1539 "toolkit-deck.c"
			CaliforniaToolkitCard* _tmp10_ = NULL;
			GtkWidget* _tmp11_ = NULL;
			GtkWidget* _tmp12_ = NULL;
#line 306 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = card;
#line 306 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp11_ = california_toolkit_card_get_default_widget (_tmp10_);
#line 306 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp12_ = _tmp11_;
#line 306 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gtk_widget_grab_default (_tmp12_);
#line 1551 "toolkit-deck.c"
		} else {
			CaliforniaToolkitCard* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 308 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp13_ = card;
#line 308 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp14_ = california_toolkit_card_get_card_id (_tmp13_);
#line 308 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp15_ = _tmp14_;
#line 308 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_message ("toolkit-deck.vala:308: Card %s specifies default widget that cannot be" \
" default", _tmp15_);
#line 1564 "toolkit-deck.c"
		}
	}
#line 311 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = card;
#line 311 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = california_toolkit_card_get_initial_focus (_tmp16_);
#line 311 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp18_ = _tmp17_;
#line 311 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp18_ != NULL) {
#line 1575 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp19_ = NULL;
		GtkWidget* _tmp20_ = NULL;
		GtkWidget* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 312 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp19_ = card;
#line 312 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp20_ = california_toolkit_card_get_initial_focus (_tmp19_);
#line 312 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp21_ = _tmp20_;
#line 312 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_object_get (_tmp21_, "can-focus", &_tmp22_, NULL);
#line 312 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp23_ = _tmp22_;
#line 312 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp23_) {
#line 1593 "toolkit-deck.c"
			CaliforniaToolkitCard* _tmp24_ = NULL;
			GtkWidget* _tmp25_ = NULL;
			GtkWidget* _tmp26_ = NULL;
#line 313 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp24_ = card;
#line 313 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp25_ = california_toolkit_card_get_initial_focus (_tmp24_);
#line 313 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp26_ = _tmp25_;
#line 313 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gtk_widget_grab_focus (_tmp26_);
#line 1605 "toolkit-deck.c"
		} else {
			CaliforniaToolkitCard* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
#line 315 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp27_ = card;
#line 315 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp28_ = california_toolkit_card_get_card_id (_tmp27_);
#line 315 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp29_ = _tmp28_;
#line 315 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_message ("toolkit-deck.vala:315: Card %s specifies initial focus that cannot foc" \
"us", _tmp29_);
#line 1618 "toolkit-deck.c"
		}
	}
#line 301 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (card);
#line 1623 "toolkit-deck.c"
}


static void california_toolkit_deck_on_card_realized (CaliforniaToolkitDeck* self, GtkWidget* card) {
#line 322 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 322 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GTK_IS_WIDGET (card));
#line 1632 "toolkit-deck.c"
}


GtkWidget* california_toolkit_deck_get_default_widget (CaliforniaToolkitDeck* self) {
	GtkWidget* result;
#line 20 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 20 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = NULL;
#line 20 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1644 "toolkit-deck.c"
}


gint california_toolkit_deck_get_size (CaliforniaToolkitDeck* self) {
	gint result;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), 0);
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->list;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp2_;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1665 "toolkit-deck.c"
}


GeeList* california_toolkit_deck_get_cards (CaliforniaToolkitDeck* self) {
	GeeList* result;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->list;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp2_;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1686 "toolkit-deck.c"
}


CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* result;
	CaliforniaToolkitCard* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = self->priv->list;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_ > 0) {
#line 1706 "toolkit-deck.c"
		GeeList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = self->priv->list;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = gee_list_get (_tmp4_, 0);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp0_);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = (CaliforniaToolkitCard*) _tmp5_;
#line 1717 "toolkit-deck.c"
	} else {
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp0_);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = NULL;
#line 1723 "toolkit-deck.c"
	}
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp0_;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1729 "toolkit-deck.c"
}


CaliforniaToolkitCard* california_toolkit_deck_get_top (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* result;
	CaliforniaToolkitCard* _tmp0_ = NULL;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp0_;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1744 "toolkit-deck.c"
}


static void california_toolkit_deck_set_top (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* value) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = value;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->_top);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->_top = _tmp1_;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_notify ((GObject *) self, "top");
#line 1763 "toolkit-deck.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (n_param_values == 3);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data1 = closure->data;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data2 = param_values->data[0].v_pointer;
#line 1782 "toolkit-deck.c"
	} else {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data1 = param_values->data[0].v_pointer;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data2 = closure->data;
#line 1788 "toolkit-deck.c"
	}
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 1794 "toolkit-deck.c"
}


static void california_toolkit_deck_class_init (CaliforniaToolkitDeckClass * klass) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaToolkitDeckPrivate));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_toolkit_deck_get_property;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_toolkit_deck_set_property;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->finalize = california_toolkit_deck_finalize;
#line 1809 "toolkit-deck.c"
	/**
	     * @inheritedDoc
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET, g_param_spec_object ("default-widget", "default-widget", "default-widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1815 "toolkit-deck.c"
	/**
	     * The number of {@link Card}s registered to the {@link Deck}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1821 "toolkit-deck.c"
	/**
	     * All registered {@link Card}s returned as a read-only List.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_CARDS, g_param_spec_object ("cards", "cards", "cards", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1827 "toolkit-deck.c"
	/**
	     * The home {@link Card}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_HOME, g_param_spec_object ("home", "home", "home", CALIFORNIA_TOOLKIT_TYPE_CARD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1833 "toolkit-deck.c"
	/**
	     * The current displayed {@link Card}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_TOP, g_param_spec_object ("top", "top", "top", CALIFORNIA_TOOLKIT_TYPE_CARD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1839 "toolkit-deck.c"
	/**
	     * Fired before {@link Card}s are added or removed.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("adding_removing_cards", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_LIST, GEE_TYPE_COLLECTION);
#line 1845 "toolkit-deck.c"
	/**
	     * Fired after {@link Card}s are added or removed.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("added_removed_cards", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_LIST, GEE_TYPE_COLLECTION);
#line 1851 "toolkit-deck.c"
	/**
	     * @see Card.dismiss
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("dismiss", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, CALIFORNIA_TOOLKIT_CARD_TYPE_DISMISS_REASON);
#line 1857 "toolkit-deck.c"
	/**
	     * @see Card.failure
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("error_message", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 1863 "toolkit-deck.c"
}


static void california_toolkit_deck_instance_init (CaliforniaToolkitDeck * self) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv = CALIFORNIA_TOOLKIT_DECK_GET_PRIVATE (self);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->_top = NULL;
#line 42 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = gee_linked_list_new (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 42 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
#line 43 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_linked_list_new (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 43 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->navigation_stack = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_DEQUE, GeeDeque);
#line 44 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 44 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->names = _tmp2_;
#line 1887 "toolkit-deck.c"
}


static void california_toolkit_deck_finalize (GObject* obj) {
	CaliforniaToolkitDeck * self;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 1895 "toolkit-deck.c"
	{
		GeeIterator* _card_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = self->priv->names;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap));
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = _tmp1_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = _tmp2_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = _tmp4_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp3_);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_it = _tmp5_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 1922 "toolkit-deck.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			CaliforniaToolkitCard* card = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			CaliforniaToolkitCard* _tmp10_ = NULL;
			guint _tmp11_ = 0U;
			CaliforniaToolkitCard* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = _card_it;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp7_) {
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 1940 "toolkit-deck.c"
			}
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp8_ = _card_it;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp9_;
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = card;
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("map", gtk_widget_get_type (), &_tmp11_, NULL, FALSE);
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self);
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp12_ = card;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("realize", gtk_widget_get_type (), &_tmp13_, NULL, FALSE);
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_realized_gtk_widget_realize, self);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 1962 "toolkit-deck.c"
		}
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_it);
#line 1966 "toolkit-deck.c"
	}
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->_top);
#line 42 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->list);
#line 43 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->navigation_stack);
#line 44 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->names);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (california_toolkit_deck_parent_class)->finalize (obj);
#line 1978 "toolkit-deck.c"
}


/**
 * A Deck is a collection of {@link Card}s maintained within a Gtk.Stack.
 *
 * Cards control navigation through their various signals, which Deck monitors and acts upon.
 * It also notifies Cards of nagivation changes which affect them via their abstract methods.
 */
GType california_toolkit_deck_get_type (void) {
	static volatile gsize california_toolkit_deck_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_deck_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaToolkitDeckClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_toolkit_deck_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaToolkitDeck), 0, (GInstanceInitFunc) california_toolkit_deck_instance_init, NULL };
		GType california_toolkit_deck_type_id;
		california_toolkit_deck_type_id = g_type_register_static (gtk_stack_get_type (), "CaliforniaToolkitDeck", &g_define_type_info, 0);
		g_once_init_leave (&california_toolkit_deck_type_id__volatile, california_toolkit_deck_type_id);
	}
	return california_toolkit_deck_type_id__volatile;
}


static void _vala_california_toolkit_deck_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitDeck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_object (value, california_toolkit_deck_get_default_widget (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_SIZE:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_int (value, california_toolkit_deck_get_size (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_CARDS:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_take_object (value, california_toolkit_deck_get_cards (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_HOME:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_take_object (value, california_toolkit_deck_get_home (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_TOP:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_object (value, california_toolkit_deck_get_top (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 2035 "toolkit-deck.c"
		default:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 2041 "toolkit-deck.c"
	}
}


static void _vala_california_toolkit_deck_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitDeck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_TOP:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_set_top (self, g_value_get_object (value));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 2057 "toolkit-deck.c"
		default:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 2063 "toolkit-deck.c"
	}
}



