/* toolkit-card.c generated by valac 0.25.1, the Vala compiler
 * generated from toolkit-card.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define CALIFORNIA_TOOLKIT_TYPE_CARD (california_toolkit_card_get_type ())
#define CALIFORNIA_TOOLKIT_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard))
#define CALIFORNIA_TOOLKIT_IS_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD))
#define CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCardIface))

typedef struct _CaliforniaToolkitCard CaliforniaToolkitCard;
typedef struct _CaliforniaToolkitCardIface CaliforniaToolkitCardIface;

#define CALIFORNIA_TOOLKIT_CARD_TYPE_JUMP (california_toolkit_card_jump_get_type ())

#define CALIFORNIA_TOOLKIT_TYPE_DECK (california_toolkit_deck_get_type ())
#define CALIFORNIA_TOOLKIT_DECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck))
#define CALIFORNIA_TOOLKIT_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))
#define CALIFORNIA_TOOLKIT_IS_DECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_IS_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_DECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))

typedef struct _CaliforniaToolkitDeck CaliforniaToolkitDeck;
typedef struct _CaliforniaToolkitDeckClass CaliforniaToolkitDeckClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	CALIFORNIA_TOOLKIT_CARD_JUMP_HOME,
	CALIFORNIA_TOOLKIT_CARD_JUMP_BACK,
	CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT
} CaliforniaToolkitCardJump;

struct _CaliforniaToolkitCardIface {
	GTypeInterface parent_iface;
	void (*jumped_to) (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
	const gchar* (*get_card_id) (CaliforniaToolkitCard* self);
	const gchar* (*get_title) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_default_widget) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_initial_focus) (CaliforniaToolkitCard* self);
};



GType california_toolkit_card_jump_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_get_type (void) G_GNUC_CONST;
void california_toolkit_card_jumped_to (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
void california_toolkit_card_notify_user_closed (CaliforniaToolkitCard* self);
void california_toolkit_card_notify_aborted (CaliforniaToolkitCard* self);
void california_toolkit_card_notify_success (CaliforniaToolkitCard* self);
void california_toolkit_card_notify_failure (CaliforniaToolkitCard* self, const gchar* user_message);
void california_toolkit_card_jump_home_or_user_closed (CaliforniaToolkitCard* self);
GType california_toolkit_deck_get_type (void) G_GNUC_CONST;
CaliforniaToolkitDeck* california_toolkit_card_get_deck (CaliforniaToolkitCard* self);
CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self);
const gchar* california_toolkit_card_get_card_id (CaliforniaToolkitCard* self);
const gchar* california_toolkit_card_get_title (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_card_get_default_widget (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_card_get_initial_focus (CaliforniaToolkitCard* self);
static void g_cclosure_user_marshal_VOID__OBJECT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


/**
     * Enumerates the various reasons a {@link Card} may be jumped to.
     */
GType california_toolkit_card_jump_get_type (void) {
	static volatile gsize california_toolkit_card_jump_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_card_jump_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, "CALIFORNIA_TOOLKIT_CARD_JUMP_HOME", "home"}, {CALIFORNIA_TOOLKIT_CARD_JUMP_BACK, "CALIFORNIA_TOOLKIT_CARD_JUMP_BACK", "back"}, {CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT, "CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT", "direct"}, {0, NULL, NULL}};
		GType california_toolkit_card_jump_type_id;
		california_toolkit_card_jump_type_id = g_enum_register_static ("CaliforniaToolkitCardJump", values);
		g_once_init_leave (&california_toolkit_card_jump_type_id__volatile, california_toolkit_card_jump_type_id);
	}
	return california_toolkit_card_jump_type_id__volatile;
}


/**
     * Called by {@link Deck} when the {@link Card} has been activated, i.e. put to the "top" of
     * the Deck.
     *
     * message may be null even if the Card expects one; generally this means {@link jump_back}
     * or {@link jump_home} was invoked, resulting in this Card being activated.  The supplied
     * {@link Jump} reason is useful for context.  There are code paths where {@link Jump.HOME}
     * accepts a message; {@link Jump.BACK} will never supply a message.
     *
     * Due to some mechanism inside of GSignal or Vala, it's possible for a caller to pass null
     * that gets translated into a Value object holding a null pointer.  Deck will watch for this
     * situation and convert those Values into a null reference.  This means passing Value(null)
     * as a message is impossible.
     *
     * In order for this null-checking to work, the message must be holding a pointer, Object, or
     * a string.  Other types (including Vala-generated fundamental types!) are not safe-guarded.
     *
     * This is called before dealing with {@link default_widget} and {@link initial_focus}, so
     * changes to those properties in this call, if need be.
     */
void california_toolkit_card_jumped_to (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message) {
#line 166 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self));
#line 166 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->jumped_to (self, from, reason, message);
#line 116 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} due to the user requesting it be closed or cancelled.
     */
void california_toolkit_card_notify_user_closed (CaliforniaToolkitCard* self) {
#line 172 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", TRUE, TRUE);
#line 126 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} due to programmatic reasons.
     */
void california_toolkit_card_notify_aborted (CaliforniaToolkitCard* self) {
#line 179 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", FALSE, TRUE);
#line 136 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} and notify that the user has successfully completed the task.
     */
void california_toolkit_card_notify_success (CaliforniaToolkitCard* self) {
#line 186 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", TRUE, FALSE);
#line 187 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "success");
#line 148 "toolkit-card.c"
}


/**
     * Dismiss the {@link Deck} and notify that the operation has failed.
     */
void california_toolkit_card_notify_failure (CaliforniaToolkitCard* self, const gchar* user_message) {
	const gchar* _tmp0_ = NULL;
#line 194 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "dismiss", TRUE, FALSE);
#line 195 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp0_ = user_message;
#line 195 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_signal_emit_by_name (self, "failure", _tmp0_);
#line 163 "toolkit-card.c"
}


/**
     * Jump home or, if this {@link Card} is the home card, dismiss {@link Deck}.
     */
void california_toolkit_card_jump_home_or_user_closed (CaliforniaToolkitCard* self) {
	CaliforniaToolkitDeck* _tmp0_ = NULL;
	CaliforniaToolkitDeck* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
	CaliforniaToolkitCard* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp0_ = california_toolkit_card_get_deck (self);
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp1_ = _tmp0_;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp2_ = california_toolkit_deck_get_home (_tmp1_);
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp3_ = _tmp2_;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp4_ = _tmp3_;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp5_ = _tmp4_ == self;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_g_object_unref0 (_tmp4_);
#line 202 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (_tmp5_) {
#line 203 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		california_toolkit_card_notify_user_closed (self);
#line 195 "toolkit-card.c"
	} else {
#line 205 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_emit_by_name (self, "jump-home");
#line 199 "toolkit-card.c"
	}
}


const gchar* california_toolkit_card_get_card_id (CaliforniaToolkitCard* self) {
#line 46 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 46 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_card_id (self);
#line 209 "toolkit-card.c"
}


const gchar* california_toolkit_card_get_title (CaliforniaToolkitCard* self) {
#line 53 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 53 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_title (self);
#line 218 "toolkit-card.c"
}


GtkWidget* california_toolkit_card_get_default_widget (CaliforniaToolkitCard* self) {
#line 60 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 60 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_default_widget (self);
#line 227 "toolkit-card.c"
}


GtkWidget* california_toolkit_card_get_initial_focus (CaliforniaToolkitCard* self) {
#line 70 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 70 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE (self)->get_initial_focus (self);
#line 236 "toolkit-card.c"
}


CaliforniaToolkitDeck* california_toolkit_card_get_deck (CaliforniaToolkitCard* self) {
	CaliforniaToolkitDeck* result;
	GtkContainer* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
#line 75 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (self), NULL);
#line 75 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp0_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WIDGET, GtkWidget));
#line 75 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	_tmp1_ = _tmp0_;
#line 75 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, CALIFORNIA_TOOLKIT_TYPE_DECK) ? ((CaliforniaToolkitDeck*) _tmp1_) : NULL;
#line 75 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	return result;
#line 254 "toolkit-card.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_if_fail (n_param_values == 3);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = closure->data;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = param_values->data[0].v_pointer;
#line 273 "toolkit-card.c"
	} else {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = param_values->data[0].v_pointer;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = closure->data;
#line 279 "toolkit-card.c"
	}
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback = (GMarshalFunc_VOID__OBJECT_BOXED) (marshal_data ? marshal_data : cc->callback);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boxed (param_values + 2), data2);
#line 285 "toolkit-card.c"
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_if_fail (n_param_values == 3);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = closure->data;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = param_values->data[0].v_pointer;
#line 304 "toolkit-card.c"
	} else {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = param_values->data[0].v_pointer;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = closure->data;
#line 310 "toolkit-card.c"
	}
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
#line 316 "toolkit-card.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	g_return_if_fail (n_param_values == 3);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = closure->data;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = param_values->data[0].v_pointer;
#line 335 "toolkit-card.c"
	} else {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data1 = param_values->data[0].v_pointer;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		data2 = closure->data;
#line 341 "toolkit-card.c"
	}
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
#line 347 "toolkit-card.c"
}


static void california_toolkit_card_base_init (CaliforniaToolkitCardIface * iface) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	static gboolean initialized = FALSE;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
	if (!initialized) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		initialized = TRUE;
#line 358 "toolkit-card.c"
		/**
		     * Each {@link Card} has its own identifier that should be unique within the {@link Deck}.
		     *
		     * In the Gtk.Stack, this is its name.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("card-id", "card-id", "card-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 366 "toolkit-card.c"
		/**
		     * A user-visible string that may be used elsewhere in the application.
		     *
		     * Gtk.StackSwitcher uses this title.  {@link Deck} does not use the title in any way.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 374 "toolkit-card.c"
		/** 
		     * The widget the {@link Card} wants to be default when navigated to.
		     *
		     * The widget must have can-default set to true.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("default-widget", "default-widget", "default-widget", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 382 "toolkit-card.c"
		/**
		     * The widget the {@link Card} wants to have initial focus when navigated to.
		     *
		     * Focus is set after {@link default_widget} is handled, so if this widget has receives-default
		     * set to true, it will get the default as well.
		     *
		     * The widget must have can-focus set to true.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("initial-focus", "initial-focus", "initial-focus", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 393 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} wishes to jump to another Card in the same {@link Deck.}
		     *
		     * Each Card can accept a message which parameterizes its activation.  It's up to Cards
		     * navigating to the new one to construct and pass an appropriate message.
		     *
		     * @see jump_to_card_by_name
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("jump_to_card", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOXED, G_TYPE_NONE, 2, CALIFORNIA_TOOLKIT_TYPE_CARD, G_TYPE_VALUE);
#line 404 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} wishes to jump to another Card by its name.
		     *
		     * @see jump_to_card
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("jump_to_card_by_name", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VALUE);
#line 412 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} wishes to jump to the previous Card in the {@link Deck}.
		     *
		     * Note that this Card's position in the navigation stack is lost; there is no "jump forward".
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("jump_back", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 420 "toolkit-card.c"
		/**
		     * Fired when the {@link Card} wishes to jump to the first Card in the {@link Deck}.
		     *
		     * This clears the Deck's navigation stack, meaning {@link jump_back} will not return to
		     * this Card.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("jump_home", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 429 "toolkit-card.c"
		/**
		     * Fired when the {@link Deck}'s work is cancelled, closed, failure, or a success, whether due
		     * to programmatic reasons or by user request.
		     *
		     * user_request indicates if the dismissal is due to a user request or programmatic reasons.
		     * closed indicates that there is no qualitative signal (i.e. {@link success}, {@link failure})
		     * to follow.
		     *
		     * Implementing classes should use one of the notify_ methods to ensure that proper signal
		     * order is maintained.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("dismiss", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
#line 443 "toolkit-card.c"
		/**
		     * Fired when the {@link Deck}'s work has completed successfully.
		     *
		     * This should only be fired if the Deck requires valid input from the user to perform
		     * some intensive operation.  Merely displaying information and closing the Deck
		     * should simply fire {@link dismiss}.
		     *
		     * Implementing classes should use one of the notify_ methods to ensure that proper signal
		     * order is maintained.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("success", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 456 "toolkit-card.c"
		/**
		     * Fired when the {@link Deck}'s work has failed to complete.
		     *
		     * This should only be fired if the Deck requires valid input from the user to perform
		     * some intensive operation.  Merely displaying information and closing the Deck
		     * should simply fire {@link dismiss}.
		     *
		     * Implementing classes should use one of the notify_ methods to ensure that proper signal
		     * order is maintained.
		     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-card.vala"
		g_signal_new ("failure", CALIFORNIA_TOOLKIT_TYPE_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 469 "toolkit-card.c"
	}
}


/**
 * A Card is a single pane of widget(s) in a {@link Deck}.
 *
 * The navigation of Cards is tracked within their Deck, and Cards can request navigation via their
 * various signals.  They're also notified when nevigation which affects them is made.
 */
GType california_toolkit_card_get_type (void) {
	static volatile gsize california_toolkit_card_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_card_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaToolkitCardIface), (GBaseInitFunc) california_toolkit_card_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType california_toolkit_card_type_id;
		california_toolkit_card_type_id = g_type_register_static (G_TYPE_INTERFACE, "CaliforniaToolkitCard", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (california_toolkit_card_type_id, GTK_TYPE_WIDGET);
		g_once_init_leave (&california_toolkit_card_type_id__volatile, california_toolkit_card_type_id);
	}
	return california_toolkit_card_type_id__volatile;
}



