/* util-uri.c generated by valac 0.24.0, the Vala compiler
 * generated from util-uri.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))

typedef enum  {
	URI_ERROR_INVALID
} URIError;
#define URI_ERROR uri_error_quark ()


GQuark uri_error_quark (void);
gboolean california_uri_is_valid (const gchar* uri, gchar** supported_schemes, int supported_schemes_length1);
gboolean california_string_is_empty (const gchar* str);
static void _vala_SoupURI_free (SoupURI* self);
SoupURI* california_uri_parse (const gchar* uri, GError** error);


GQuark uri_error_quark (void) {
	return g_quark_from_static_string ("uri_error-quark");
}


/**
 * Basic validation of a string intended to be parsed as an absolute URI.
 *
 * If null or an empty array is passed for "supported_schemes", then the only character checked
 * for is the presence of a colon separating the scheme from the remainder of the URI.
 *
 * If "supported_schemes" are specified, then the entire scheme (name and separator) should be
 * included, i.e. "http://", "mailto:", etc.
 */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 66 "util-uri.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1274 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1274 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1275 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1275 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1275 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1275 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 86 "util-uri.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 93 "util-uri.c"
}


gboolean california_uri_is_valid (const gchar* uri, gchar** supported_schemes, int supported_schemes_length1) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* stripped = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	SoupURI* parsed = NULL;
	const gchar* _tmp18_ = NULL;
	SoupURI* _tmp19_ = NULL;
	SoupURI* _tmp20_ = NULL;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp1_ = uri;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp1_ != NULL) {
#line 116 "util-uri.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp2_ = uri;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp3_ = string_strip (_tmp2_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp0_ = _tmp3_;
#line 127 "util-uri.c"
	} else {
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp0_ = NULL;
#line 133 "util-uri.c"
	}
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp4_ = g_strdup (_tmp0_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	stripped = _tmp4_;
#line 29 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp5_ = stripped;
#line 29 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp6_ = california_string_is_empty (_tmp5_);
#line 29 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp6_) {
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		result = FALSE;
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (stripped);
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		return result;
#line 153 "util-uri.c"
	}
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp8_ = supported_schemes;
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp8__length1 = supported_schemes_length1;
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp8_ == NULL) {
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp7_ = TRUE;
#line 163 "util-uri.c"
	} else {
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp9_ = supported_schemes;
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp9__length1 = supported_schemes_length1;
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp7_ = _tmp9__length1 == 0;
#line 173 "util-uri.c"
	}
#line 32 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp7_) {
#line 177 "util-uri.c"
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 33 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp10_ = stripped;
#line 33 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp11_ = string_contains (_tmp10_, ":");
#line 33 "/home/jim/git/california/src/util/util-uri.vala"
		if (!_tmp11_) {
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
			result = FALSE;
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
			_g_free0 (stripped);
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
			_g_free0 (_tmp0_);
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
			return result;
#line 194 "util-uri.c"
		}
	} else {
		gboolean found = FALSE;
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gboolean _tmp17_ = FALSE;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
		found = FALSE;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp12_ = supported_schemes;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp12__length1 = supported_schemes_length1;
#line 207 "util-uri.c"
		{
			gchar** scheme_collection = NULL;
			gint scheme_collection_length1 = 0;
			gint _scheme_collection_size_ = 0;
			gint scheme_it = 0;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
			scheme_collection = _tmp12_;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
			scheme_collection_length1 = _tmp12__length1;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
			for (scheme_it = 0; scheme_it < _tmp12__length1; scheme_it = scheme_it + 1) {
#line 219 "util-uri.c"
				gchar* _tmp13_ = NULL;
				gchar* scheme = NULL;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
				_tmp13_ = g_strdup (scheme_collection[scheme_it]);
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
				scheme = _tmp13_;
#line 226 "util-uri.c"
				{
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
#line 38 "/home/jim/git/california/src/util/util-uri.vala"
					_tmp14_ = stripped;
#line 38 "/home/jim/git/california/src/util/util-uri.vala"
					_tmp15_ = scheme;
#line 38 "/home/jim/git/california/src/util/util-uri.vala"
					_tmp16_ = g_str_has_prefix (_tmp14_, _tmp15_);
#line 38 "/home/jim/git/california/src/util/util-uri.vala"
					if (_tmp16_) {
#line 39 "/home/jim/git/california/src/util/util-uri.vala"
						found = TRUE;
#line 41 "/home/jim/git/california/src/util/util-uri.vala"
						_g_free0 (scheme);
#line 41 "/home/jim/git/california/src/util/util-uri.vala"
						break;
#line 245 "util-uri.c"
					}
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
					_g_free0 (scheme);
#line 249 "util-uri.c"
				}
			}
		}
#line 45 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp17_ = found;
#line 45 "/home/jim/git/california/src/util/util-uri.vala"
		if (!_tmp17_) {
#line 46 "/home/jim/git/california/src/util/util-uri.vala"
			result = FALSE;
#line 46 "/home/jim/git/california/src/util/util-uri.vala"
			_g_free0 (stripped);
#line 46 "/home/jim/git/california/src/util/util-uri.vala"
			_g_free0 (_tmp0_);
#line 46 "/home/jim/git/california/src/util/util-uri.vala"
			return result;
#line 265 "util-uri.c"
		}
	}
#line 50 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp18_ = uri;
#line 50 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp19_ = soup_uri_new (_tmp18_);
#line 50 "/home/jim/git/california/src/util/util-uri.vala"
	parsed = _tmp19_;
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp20_ = parsed;
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	result = _tmp20_ != NULL;
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	__vala_SoupURI_free0 (parsed);
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	_g_free0 (stripped);
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	_g_free0 (_tmp0_);
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	return result;
#line 286 "util-uri.c"
}


/**
 * Checked creation of a Soup.URI object.
 *
 * This shouldn't be used to create "empty" Soup.URI objects.
 *
 * @throws URIError
 */
SoupURI* california_uri_parse (const gchar* uri, GError** error) {
	SoupURI* result = NULL;
	SoupURI* parsed = NULL;
	const gchar* _tmp0_ = NULL;
	SoupURI* _tmp1_ = NULL;
	SoupURI* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 62 "/home/jim/git/california/src/util/util-uri.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 63 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp0_ = uri;
#line 63 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp1_ = soup_uri_new (_tmp0_);
#line 63 "/home/jim/git/california/src/util/util-uri.vala"
	parsed = _tmp1_;
#line 64 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp2_ = parsed;
#line 64 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp2_ == NULL) {
#line 316 "util-uri.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 65 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp3_ = uri;
#line 65 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp4_ = g_error_new (URI_ERROR, URI_ERROR_INVALID, "Invalid URI: %s", _tmp3_);
#line 65 "/home/jim/git/california/src/util/util-uri.vala"
		_inner_error_ = _tmp4_;
#line 65 "/home/jim/git/california/src/util/util-uri.vala"
		g_propagate_error (error, _inner_error_);
#line 65 "/home/jim/git/california/src/util/util-uri.vala"
		__vala_SoupURI_free0 (parsed);
#line 65 "/home/jim/git/california/src/util/util-uri.vala"
		return NULL;
#line 331 "util-uri.c"
	}
#line 67 "/home/jim/git/california/src/util/util-uri.vala"
	result = parsed;
#line 67 "/home/jim/git/california/src/util/util-uri.vala"
	return result;
#line 337 "util-uri.c"
}



