/* util-gfx.c generated by valac 0.24.0, the Vala compiler
 * generated from util-gfx.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>




void california_gfx_rgb_string_to_rgba (const gchar* rgb_string, GdkRGBA* default_rgba, gboolean* used_default, GdkRGBA* result);
gboolean california_string_is_empty (const gchar* str);
guint32 california_gfx_rgba_to_pixel (GdkRGBA* rgba);
guint8 california_gfx_fp_to_uint8 (gdouble value);
gchar* california_gfx_rgba_to_uint8_rgb_string (GdkRGBA* rgba);

const GdkRGBA CALIFORNIA_GFX_BLACK = {0.0, 0.0, 0.0, 1.0};
const GdkRGBA CALIFORNIA_GFX_WHITE = {1.0, 1.0, 1.0, 1.0};

/**
 * Convert an RGBA string into an RGBA structure.
 *
 * The string can be in any of the forms that Gdk.RGBA.parse accepts.  If unable to parse the
 * string, the {@link default_rgba} is returned and {@link used_default} is set to true.
 */
void california_gfx_rgb_string_to_rgba (const gchar* rgb_string, GdkRGBA* default_rgba, gboolean* used_default, GdkRGBA* result) {
	gboolean _vala_used_default = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkRGBA rgba = {0};
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 18 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_if_fail (default_rgba != NULL);
#line 19 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = rgb_string;
#line 19 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 19 "/home/jim/git/california/src/util/util-gfx.vala"
	if (_tmp1_) {
#line 52 "util-gfx.c"
		GdkRGBA _tmp2_ = {0};
#line 20 "/home/jim/git/california/src/util/util-gfx.vala"
		_vala_used_default = TRUE;
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp2_ = *default_rgba;
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
		*result = _tmp2_;
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
		if (used_default) {
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
			*used_default = _vala_used_default;
#line 64 "util-gfx.c"
		}
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
		return;
#line 68 "util-gfx.c"
	}
#line 25 "/home/jim/git/california/src/util/util-gfx.vala"
	memset (&rgba, 0, sizeof (GdkRGBA));
#line 26 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = rgb_string;
#line 26 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = gdk_rgba_parse (&rgba, _tmp3_);
#line 26 "/home/jim/git/california/src/util/util-gfx.vala"
	if (!_tmp4_) {
#line 78 "util-gfx.c"
		const gchar* _tmp5_ = NULL;
		GdkRGBA _tmp6_ = {0};
#line 27 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp5_ = rgb_string;
#line 27 "/home/jim/git/california/src/util/util-gfx.vala"
		g_debug ("util-gfx.vala:27: Unable to parse RGBA color \"%s\"", _tmp5_);
#line 29 "/home/jim/git/california/src/util/util-gfx.vala"
		_vala_used_default = TRUE;
#line 31 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp6_ = *default_rgba;
#line 31 "/home/jim/git/california/src/util/util-gfx.vala"
		*result = _tmp6_;
#line 31 "/home/jim/git/california/src/util/util-gfx.vala"
		if (used_default) {
#line 31 "/home/jim/git/california/src/util/util-gfx.vala"
			*used_default = _vala_used_default;
#line 95 "util-gfx.c"
		}
#line 31 "/home/jim/git/california/src/util/util-gfx.vala"
		return;
#line 99 "util-gfx.c"
	}
#line 34 "/home/jim/git/california/src/util/util-gfx.vala"
	_vala_used_default = FALSE;
#line 36 "/home/jim/git/california/src/util/util-gfx.vala"
	*result = rgba;
#line 36 "/home/jim/git/california/src/util/util-gfx.vala"
	if (used_default) {
#line 36 "/home/jim/git/california/src/util/util-gfx.vala"
		*used_default = _vala_used_default;
#line 109 "util-gfx.c"
	}
#line 36 "/home/jim/git/california/src/util/util-gfx.vala"
	return;
#line 113 "util-gfx.c"
}


/**
 * Converts the Gdk.RGBA into a 32-bit pixel representation.
 */
guint32 california_gfx_rgba_to_pixel (GdkRGBA* rgba) {
	guint32 result = 0U;
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	guint8 _tmp2_ = 0U;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	guint8 _tmp5_ = 0U;
	GdkRGBA _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	guint8 _tmp8_ = 0U;
	GdkRGBA _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	guint8 _tmp11_ = 0U;
#line 42 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_val_if_fail (rgba != NULL, 0U);
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = *rgba;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = _tmp0_.red;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = california_gfx_fp_to_uint8 (_tmp1_);
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = *rgba;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = _tmp3_.green;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = california_gfx_fp_to_uint8 (_tmp4_);
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp6_ = *rgba;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp7_ = _tmp6_.blue;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp8_ = california_gfx_fp_to_uint8 (_tmp7_);
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp9_ = *rgba;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp10_ = _tmp9_.alpha;
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp11_ = california_gfx_fp_to_uint8 (_tmp10_);
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	result = (((((guint32) _tmp2_) << 24) | (((guint32) _tmp5_) << 16)) | (((guint32) _tmp8_) << 8)) | ((guint32) _tmp11_);
#line 43 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 164 "util-gfx.c"
}


inline guint8 california_gfx_fp_to_uint8 (gdouble value) {
	guint8 result = 0U;
	gdouble _tmp0_ = 0.0;
	guint8 _tmp1_ = 0U;
	gdouble _tmp2_ = 0.0;
#line 50 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = value;
#line 50 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = G_MAXUINT8;
#line 50 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = round (_tmp0_ * ((gdouble) _tmp1_));
#line 50 "/home/jim/git/california/src/util/util-gfx.vala"
	result = (guint8) _tmp2_;
#line 50 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 183 "util-gfx.c"
}


/**
 * Converts the Gdk.RGBA into an RGB string representation ("#ad12c3")
 *
 * Note that alpha channel information is lost in this conversion.
 */
gchar* california_gfx_rgba_to_uint8_rgb_string (GdkRGBA* rgba) {
	gchar* result = NULL;
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	guint8 _tmp2_ = 0U;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	guint8 _tmp5_ = 0U;
	GdkRGBA _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	guint8 _tmp8_ = 0U;
	gchar* _tmp9_ = NULL;
#line 58 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_val_if_fail (rgba != NULL, NULL);
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = *rgba;
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = _tmp0_.red;
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = california_gfx_fp_to_uint8 (_tmp1_);
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = *rgba;
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = _tmp3_.green;
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = california_gfx_fp_to_uint8 (_tmp4_);
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp6_ = *rgba;
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp7_ = _tmp6_.blue;
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp8_ = california_gfx_fp_to_uint8 (_tmp7_);
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp9_ = g_strdup_printf ("#%02x%02x%02x", (guint) _tmp2_, (guint) _tmp5_, (guint) _tmp8_);
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	result = _tmp9_;
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 230 "util-gfx.c"
}



