/* component-event.c generated by valac 0.24.0, the Vala compiler
 * generated from component-event.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libical/ical.h>
#include <glib/gi18n-lib.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COMPONENT_TYPE_INSTANCE (california_component_instance_get_type ())
#define CALIFORNIA_COMPONENT_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance))
#define CALIFORNIA_COMPONENT_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))
#define CALIFORNIA_COMPONENT_IS_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_IS_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))

typedef struct _CaliforniaComponentInstance CaliforniaComponentInstance;
typedef struct _CaliforniaComponentInstanceClass CaliforniaComponentInstanceClass;
typedef struct _CaliforniaComponentInstancePrivate CaliforniaComponentInstancePrivate;

#define CALIFORNIA_COMPONENT_TYPE_UID (california_component_uid_get_type ())
#define CALIFORNIA_COMPONENT_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUID))
#define CALIFORNIA_COMPONENT_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))
#define CALIFORNIA_COMPONENT_IS_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_IS_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_UID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))

typedef struct _CaliforniaComponentUID CaliforniaComponentUID;
typedef struct _CaliforniaComponentUIDClass CaliforniaComponentUIDClass;

#define CALIFORNIA_COMPONENT_TYPE_EVENT (california_component_event_get_type ())
#define CALIFORNIA_COMPONENT_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent))
#define CALIFORNIA_COMPONENT_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))
#define CALIFORNIA_COMPONENT_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))

typedef struct _CaliforniaComponentEvent CaliforniaComponentEvent;
typedef struct _CaliforniaComponentEventClass CaliforniaComponentEventClass;
typedef struct _CaliforniaComponentEventPrivate CaliforniaComponentEventPrivate;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN (california_calendar_exact_time_span_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpan))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))

typedef struct _CaliforniaCalendarExactTimeSpan CaliforniaCalendarExactTimeSpan;
typedef struct _CaliforniaCalendarExactTimeSpanClass CaliforniaCalendarExactTimeSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN (california_calendar_unit_span_get_type ())
#define CALIFORNIA_CALENDAR_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))

typedef struct _CaliforniaCalendarUnitSpan CaliforniaCalendarUnitSpan;
typedef struct _CaliforniaCalendarUnitSpanClass CaliforniaCalendarUnitSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;

#define CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS (california_component_event_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_BACKING_TYPE_SOURCE (california_backing_source_get_type ())
#define CALIFORNIA_BACKING_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource))
#define CALIFORNIA_BACKING_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))
#define CALIFORNIA_BACKING_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))

typedef struct _CaliforniaBackingSource CaliforniaBackingSource;
typedef struct _CaliforniaBackingSourceClass CaliforniaBackingSourceClass;

#define CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE (california_backing_calendar_source_get_type ())
#define CALIFORNIA_BACKING_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSource))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))

typedef struct _CaliforniaBackingCalendarSource CaliforniaBackingCalendarSource;
typedef struct _CaliforniaBackingCalendarSourceClass CaliforniaBackingCalendarSourceClass;

#define CALIFORNIA_COMPONENT_TYPE_DATE_TIME (california_component_date_time_get_type ())
#define CALIFORNIA_COMPONENT_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTime))
#define CALIFORNIA_COMPONENT_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))

typedef struct _CaliforniaComponentDateTime CaliforniaComponentDateTime;
typedef struct _CaliforniaComponentDateTimeClass CaliforniaComponentDateTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;

#define CALIFORNIA_CALENDAR_DATE_TYPE_PRETTY_FLAG (california_calendar_date_pretty_flag_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;

#define CALIFORNIA_CALENDAR_WALL_TIME_TYPE_PRETTY_FLAG (california_calendar_wall_time_pretty_flag_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_DURATION (california_calendar_duration_get_type ())
#define CALIFORNIA_CALENDAR_DURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration))
#define CALIFORNIA_CALENDAR_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))
#define CALIFORNIA_CALENDAR_IS_DURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_IS_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_DURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))

typedef struct _CaliforniaCalendarDuration CaliforniaCalendarDuration;
typedef struct _CaliforniaCalendarDurationClass CaliforniaCalendarDurationClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaComponentInstance {
	CaliforniaBaseObject parent_instance;
	CaliforniaComponentInstancePrivate * priv;
};

struct _CaliforniaComponentInstanceClass {
	CaliforniaBaseObjectClass parent_class;
	void (*notify_altered) (CaliforniaComponentInstance* self, gboolean from_full_update);
	void (*update_from_component) (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
	CaliforniaComponentInstance* (*clone) (CaliforniaComponentInstance* self, GError** error);
	gboolean (*is_valid) (CaliforniaComponentInstance* self, gboolean and_useful);
	gboolean (*equal_to) (CaliforniaComponentInstance* self, CaliforniaComponentInstance* other);
	guint (*hash) (CaliforniaComponentInstance* self);
};

struct _CaliforniaComponentEvent {
	CaliforniaComponentInstance parent_instance;
	CaliforniaComponentEventPrivate * priv;
};

struct _CaliforniaComponentEventClass {
	CaliforniaComponentInstanceClass parent_class;
};

typedef enum  {
	CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED
} CaliforniaComponentEventStatus;

struct _CaliforniaComponentEventPrivate {
	gchar* _summary;
	gchar* _description;
	CaliforniaCalendarExactTimeSpan* _exact_time_span;
	CaliforniaCalendarDateSpan* _date_span;
	gchar* _location;
	CaliforniaComponentEventStatus _status;
};

typedef enum  {
	CALIFORNIA_COMPONENT_ERROR_INVALID,
	CALIFORNIA_COMPONENT_ERROR_MISMATCH,
	CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE
} CaliforniaComponentError;
#define CALIFORNIA_COMPONENT_ERROR california_component_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV = 1 << 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT = 1 << 1,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR = 1 << 2,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY = 1 << 3,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK = 1 << 4
} CaliforniaCalendarDatePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS = 1 << 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES = 1 << 1,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY = 1 << 2,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM = 1 << 3
} CaliforniaCalendarWallTimePrettyFlag;


static gpointer california_component_event_parent_class = NULL;
static GeeComparableIface* california_component_event_gee_comparable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_component_instance_get_type (void) G_GNUC_CONST;
GType california_component_uid_get_type (void) G_GNUC_CONST;
GType california_component_event_get_type (void) G_GNUC_CONST;
GType california_calendar_exact_time_span_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
GType california_component_event_status_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventPrivate))
enum  {
	CALIFORNIA_COMPONENT_EVENT_DUMMY_PROPERTY,
	CALIFORNIA_COMPONENT_EVENT_SUMMARY,
	CALIFORNIA_COMPONENT_EVENT_DESCRIPTION,
	CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN,
	CALIFORNIA_COMPONENT_EVENT_DATE_SPAN,
	CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY,
	CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING,
	CALIFORNIA_COMPONENT_EVENT_LOCATION,
	CALIFORNIA_COMPONENT_EVENT_STATUS
};
#define CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY "summary"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION "description"
#define CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN "exact-time-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN "date-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_IS_ALL_DAY "is-all-day"
#define CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION "location"
#define CALIFORNIA_COMPONENT_EVENT_PROP_STATUS "status"
GType california_backing_source_get_type (void) G_GNUC_CONST;
GType california_backing_calendar_source_get_type (void) G_GNUC_CONST;
CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentInstance* california_component_instance_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, icalcomponent_kind kind, GError** error);
static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec);
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
CaliforniaComponentEvent* california_component_event_new_blank (void);
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type);
CaliforniaComponentInstance* california_component_instance_construct_blank (GType object_type, icalcomponent_kind kind);
static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_instance_update_from_component (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value);
GType california_component_date_time_get_type (void) G_GNUC_CONST;
GQuark california_component_error_quark (void);
CaliforniaComponentDateTime* california_component_date_time_new (icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
CaliforniaComponentDateTime* california_component_date_time_construct (GType object_type, icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
GQuark california_calendar_error_quark (void);
void california_component_date_time_to_span (CaliforniaComponentDateTime* dt_start, CaliforniaComponentDateTime* dt_end, gboolean dtend_inclusive, CaliforniaCalendarDateSpan** date_span, CaliforniaCalendarExactTimeSpan** exact_time_span, GError** error);
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span);
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span);
void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value);
gboolean california_component_instance_get_in_full_update (CaliforniaComponentInstance* self);
gint california_component_instance_remove_all_properties (CaliforniaComponentInstance* self, icalproperty_kind kind);
icalcomponent* california_component_instance_get_ical_component (CaliforniaComponentInstance* self);
const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self);
const gchar* california_component_event_get_description (CaliforniaComponentEvent* self);
CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self);
CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self);
void california_component_instance_exact_time_span_to_ical (CaliforniaCalendarExactTimeSpan* exact_time_span, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
void california_component_instance_date_span_to_ical (CaliforniaCalendarDateSpan* date_span, gboolean dtend_inclusive, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
const gchar* california_component_event_get_location (CaliforniaComponentEvent* self);
CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self);
void california_component_instance_notify_altered (CaliforniaComponentInstance* self, gboolean from_full_update);
static CaliforniaComponentInstance* california_component_event_real_clone (CaliforniaComponentInstance* base, GError** error);
CaliforniaBackingCalendarSource* california_component_instance_get_calendar_source (CaliforniaComponentInstance* self);
CaliforniaComponentInstance* california_component_instance_get_master (CaliforniaComponentInstance* self);
void california_component_instance_set_master (CaliforniaComponentInstance* self, CaliforniaComponentInstance* value);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_to_timezone (CaliforniaCalendarExactTimeSpan* self, CaliforniaCalendarTimezone* new_tz);
CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span);
static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value);
static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value);
void california_component_event_adjust_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span);
gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_start_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarTimezone* california_calendar_exact_time_get_tz (CaliforniaCalendarExactTime* self);
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_exact_time_to_wall_time (CaliforniaCalendarExactTime* self);
CaliforniaCalendarExactTime* california_calendar_exact_time_new (CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct (GType object_type, CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_end_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_new (CaliforniaCalendarExactTime* start_exact_time, CaliforniaCalendarExactTime* end_exact_time);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_construct (GType object_type, CaliforniaCalendarExactTime* start_exact_time, CaliforniaCalendarExactTime* end_exact_time);
void california_component_event_all_day_to_timed_event (CaliforniaComponentEvent* self, CaliforniaCalendarWallTime* start_time, CaliforniaCalendarWallTime* end_time, CaliforniaCalendarTimezone* timezone);
void california_component_event_timed_to_all_day_event (CaliforniaComponentEvent* self);
gchar* california_component_event_get_event_time_pretty_string (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* timezone);
GType california_calendar_date_pretty_flag_get_type (void) G_GNUC_CONST;
GType california_calendar_year_get_type (void) G_GNUC_CONST;
CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self);
CaliforniaCalendarDate* california_calendar_system_get_today (void);
gboolean california_calendar_span_get_is_same_day (CaliforniaCalendarSpan* self);
gchar* california_calendar_date_to_pretty_string (CaliforniaCalendarDate* self, CaliforniaCalendarDatePrettyFlag flags);
gboolean california_calendar_exact_time_span_get_is_same_day (CaliforniaCalendarExactTimeSpan* self);
GType california_calendar_wall_time_pretty_flag_get_type (void) G_GNUC_CONST;
gchar* california_calendar_exact_time_to_pretty_time_string (CaliforniaCalendarExactTime* self, CaliforniaCalendarWallTimePrettyFlag time_flags);
CaliforniaCalendarDate* california_calendar_exact_time_span_get_start_date (CaliforniaCalendarExactTimeSpan* self);
gchar* california_calendar_exact_time_to_pretty_date_string (CaliforniaCalendarExactTime* self, CaliforniaCalendarDatePrettyFlag date_flags);
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base, gboolean and_useful);
gboolean california_string_is_empty (const gchar* str);
gboolean california_component_instance_is_valid (CaliforniaComponentInstance* self, gboolean and_useful);
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other);
CaliforniaComponentDateTime* california_component_instance_get_rid (CaliforniaComponentInstance* self);
CaliforniaCalendarExactTime* california_component_instance_get_dtstamp (CaliforniaComponentInstance* self);
gint california_component_instance_get_sequence (CaliforniaComponentInstance* self);
CaliforniaComponentUID* california_component_instance_get_uid (CaliforniaComponentInstance* self);
static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self);
GType california_calendar_duration_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDuration* california_calendar_exact_time_span_get_duration (CaliforniaCalendarExactTimeSpan* self);
guint64 california_calendar_duration_get_days (CaliforniaCalendarDuration* self);
static void california_component_event_finalize (GObject* obj);
static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType california_component_event_status_get_type (void) {
	static volatile gsize california_component_event_status_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_status_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE, "CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE", "tentative"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED", "confirmed"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED", "cancelled"}, {0, NULL, NULL}};
		GType california_component_event_status_type_id;
		california_component_event_status_type_id = g_enum_register_static ("CaliforniaComponentEventStatus", values);
		g_once_init_leave (&california_component_event_status_type_id__volatile, california_component_event_status_type_id);
	}
	return california_component_event_status_type_id__volatile;
}


/**
     * Create an {@link Event} {@link Component} from an EDS CalComponent object.
     *
     * Throws a BackingError if the E.CalComponent's VTYPE is not VEVENT.
     */
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 99 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_on_notify ((CaliforniaComponentEvent*) self, pspec);
#line 436 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
	CaliforniaComponentEvent * self = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
	icalcomponent* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((calendar_source == NULL) || CALIFORNIA_BACKING_IS_CALENDAR_SOURCE (calendar_source), NULL);
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (ical_component != NULL, NULL);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = calendar_source;
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = ical_component;
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct (object_type, _tmp0_, _tmp1_, ICAL_VEVENT_COMPONENT, &_inner_error_);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (self);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		return NULL;
#line 463 "component-event.c"
	}
#line 99 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 469 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct (CALIFORNIA_COMPONENT_TYPE_EVENT, calendar_source, ical_component, error);
#line 476 "component-event.c"
}


/**
     * Creates a "blank" {@link Event} with a generated {@link uid}.
     *
     * A {@link Calendar.DateSpan} or a {@link Calendar.ExactTimeSpan} must be specified in order
     * to generate a minimally-valid Event.
     */
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type) {
	CaliforniaComponentEvent * self = NULL;
#line 109 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct_blank (object_type, ICAL_VEVENT_COMPONENT);
#line 111 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 494 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new_blank (void) {
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct_blank (CALIFORNIA_COMPONENT_TYPE_EVENT);
#line 501 "component-event.c"
}


/**
     * @inheritDoc
     */
static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error) {
	CaliforniaComponentEvent * self;
	icalcomponent* _tmp0_ = NULL;
	CaliforniaComponentUID* _tmp1_ = NULL;
	icalcomponent* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	icalcomponent* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	CaliforniaComponentDateTime* dt_start = NULL;
	icalcomponent* _tmp6_ = NULL;
	CaliforniaComponentDateTime* _tmp7_ = NULL;
	CaliforniaComponentDateTime* dt_end = NULL;
	icalcomponent* _tmp8_ = NULL;
	CaliforniaComponentDateTime* _tmp9_ = NULL;
	CaliforniaCalendarDateSpan* date_span = NULL;
	CaliforniaCalendarExactTimeSpan* exact_time_span = NULL;
	CaliforniaComponentDateTime* _tmp10_ = NULL;
	CaliforniaComponentDateTime* _tmp11_ = NULL;
	CaliforniaCalendarDateSpan* _tmp12_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp13_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp14_ = NULL;
	icalcomponent* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	icalcomponent* _tmp20_ = NULL;
	icalproperty_status _tmp21_ = 0;
	GError * _inner_error_ = NULL;
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (ical_component != NULL);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail ((supplied_uid == NULL) || CALIFORNIA_COMPONENT_IS_UID (supplied_uid));
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = ical_component;
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = supplied_uid;
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->update_from_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp0_, _tmp1_, &_inner_error_);
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 119 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 119 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 552 "component-event.c"
	}
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = ical_component;
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = icalcomponent_get_summary (_tmp2_);
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_summary (self, _tmp3_);
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = ical_component;
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = icalcomponent_get_description (_tmp4_);
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_description (self, _tmp5_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = ical_component;
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_component_date_time_new (_tmp6_, ICAL_DTSTART_PROPERTY, &_inner_error_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	dt_start = _tmp7_;
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 124 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 578 "component-event.c"
	}
#line 125 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = ical_component;
#line 125 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_component_date_time_new (_tmp8_, ICAL_DTEND_PROPERTY, &_inner_error_);
#line 125 "/home/jim/git/california/src/component/component-event.vala"
	dt_end = _tmp9_;
#line 125 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 125 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 125 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 125 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 594 "component-event.c"
	}
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = dt_start;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = dt_end;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	california_component_date_time_to_span (_tmp10_, _tmp11_, FALSE, &_tmp12_, &_tmp13_, &_inner_error_);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	date_span = _tmp12_;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	exact_time_span = _tmp13_;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (exact_time_span);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (date_span);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 624 "component-event.c"
	}
#line 131 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = exact_time_span;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp14_ != NULL) {
#line 630 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp15_ = NULL;
#line 132 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = exact_time_span;
#line 132 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_exact_time_span (self, _tmp15_);
#line 636 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp16_ = NULL;
		CaliforniaCalendarDateSpan* _tmp17_ = NULL;
#line 134 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = date_span;
#line 134 "/home/jim/git/california/src/component/component-event.vala"
		_vala_assert (_tmp16_ != NULL, "date_span != null");
#line 135 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = date_span;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp17_);
#line 648 "component-event.c"
	}
#line 138 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = ical_component;
#line 138 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = icalcomponent_get_location (_tmp18_);
#line 138 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_location (self, _tmp19_);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = ical_component;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = icalcomponent_get_status (_tmp20_);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
	switch (_tmp21_) {
#line 140 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_TENTATIVE:
#line 664 "component-event.c"
		{
#line 142 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE);
#line 143 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 670 "component-event.c"
		}
#line 140 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CANCELLED:
#line 674 "component-event.c"
		{
#line 146 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED);
#line 147 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 680 "component-event.c"
		}
		default:
#line 140 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CONFIRMED:
#line 685 "component-event.c"
		{
#line 151 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED);
#line 152 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 691 "component-event.c"
		}
	}
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_end);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_start);
#line 702 "component-event.c"
}


static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean altered = FALSE;
	GParamSpec* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	gboolean _tmp41_ = FALSE;
#line 156 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 156 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (G_IS_PARAM_SPEC (pspec));
#line 158 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_instance_get_in_full_update (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 158 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 158 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 159 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 727 "component-event.c"
	}
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	altered = TRUE;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = pspec;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_->name;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = _tmp3_;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 162 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY)) {
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 743 "component-event.c"
			default:
			{
				icalcomponent* _tmp7_ = NULL;
				icalcomponent* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 164 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_SUMMARY_PROPERTY);
#line 165 "/home/jim/git/california/src/component/component-event.vala"
				_tmp7_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 165 "/home/jim/git/california/src/component/component-event.vala"
				_tmp8_ = _tmp7_;
#line 165 "/home/jim/git/california/src/component/component-event.vala"
				_tmp9_ = self->priv->_summary;
#line 165 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_summary (_tmp8_, _tmp9_);
#line 166 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 761 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION)) {
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 767 "component-event.c"
			default:
			{
				icalcomponent* _tmp10_ = NULL;
				icalcomponent* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 169 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DESCRIPTION_PROPERTY);
#line 170 "/home/jim/git/california/src/component/component-event.vala"
				_tmp10_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 170 "/home/jim/git/california/src/component/component-event.vala"
				_tmp11_ = _tmp10_;
#line 170 "/home/jim/git/california/src/component/component-event.vala"
				_tmp12_ = self->priv->_description;
#line 170 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_description (_tmp11_, _tmp12_);
#line 171 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 785 "component-event.c"
			}
		}
	} else if ((_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN)) || (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN))) {
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 791 "component-event.c"
			default:
			{
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				CaliforniaCalendarDateSpan* _tmp15_ = NULL;
				icaltimetype ical_dtstart = {0};
				icaltimetype _tmp20_ = {0};
				icaltimetype ical_dtend = {0};
				icaltimetype _tmp21_ = {0};
				CaliforniaCalendarExactTimeSpan* _tmp22_ = NULL;
				icalcomponent* _tmp25_ = NULL;
				icalcomponent* _tmp26_ = NULL;
				icaltimetype _tmp27_ = {0};
				icalcomponent* _tmp28_ = NULL;
				icalcomponent* _tmp29_ = NULL;
				icaltimetype _tmp30_ = {0};
#line 178 "/home/jim/git/california/src/component/component-event.vala"
				_tmp15_ = self->priv->_date_span;
#line 178 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp15_ == NULL) {
#line 812 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
#line 178 "/home/jim/git/california/src/component/component-event.vala"
					_tmp16_ = self->priv->_exact_time_span;
#line 178 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = _tmp16_ == NULL;
#line 818 "component-event.c"
				} else {
#line 178 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = FALSE;
#line 822 "component-event.c"
				}
#line 178 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp14_) {
#line 178 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = TRUE;
#line 828 "component-event.c"
				} else {
					gboolean _tmp17_ = FALSE;
					CaliforniaCalendarDateSpan* _tmp18_ = NULL;
#line 179 "/home/jim/git/california/src/component/component-event.vala"
					_tmp18_ = self->priv->_date_span;
#line 179 "/home/jim/git/california/src/component/component-event.vala"
					if (_tmp18_ != NULL) {
#line 836 "component-event.c"
						CaliforniaCalendarExactTimeSpan* _tmp19_ = NULL;
#line 179 "/home/jim/git/california/src/component/component-event.vala"
						_tmp19_ = self->priv->_exact_time_span;
#line 179 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = _tmp19_ != NULL;
#line 842 "component-event.c"
					} else {
#line 179 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = FALSE;
#line 846 "component-event.c"
					}
#line 179 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = _tmp17_;
#line 850 "component-event.c"
				}
#line 178 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp13_) {
#line 180 "/home/jim/git/california/src/component/component-event.vala"
					return;
#line 856 "component-event.c"
				}
#line 185 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtstart = _tmp20_;
#line 186 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtend = _tmp21_;
#line 187 "/home/jim/git/california/src/component/component-event.vala"
				_tmp22_ = self->priv->_exact_time_span;
#line 187 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp22_ != NULL) {
#line 866 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp23_ = NULL;
#line 188 "/home/jim/git/california/src/component/component-event.vala"
					_tmp23_ = self->priv->_exact_time_span;
#line 188 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_exact_time_span_to_ical (_tmp23_, &ical_dtstart, &ical_dtend);
#line 872 "component-event.c"
				} else {
					CaliforniaCalendarDateSpan* _tmp24_ = NULL;
#line 190 "/home/jim/git/california/src/component/component-event.vala"
					_tmp24_ = self->priv->_date_span;
#line 190 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_date_span_to_ical (_tmp24_, FALSE, &ical_dtstart, &ical_dtend);
#line 879 "component-event.c"
				}
#line 192 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DTSTART_PROPERTY);
#line 193 "/home/jim/git/california/src/component/component-event.vala"
				_tmp25_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 193 "/home/jim/git/california/src/component/component-event.vala"
				_tmp26_ = _tmp25_;
#line 193 "/home/jim/git/california/src/component/component-event.vala"
				_tmp27_ = ical_dtstart;
#line 193 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtstart (_tmp26_, _tmp27_);
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DTEND_PROPERTY);
#line 196 "/home/jim/git/california/src/component/component-event.vala"
				_tmp28_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 196 "/home/jim/git/california/src/component/component-event.vala"
				_tmp29_ = _tmp28_;
#line 196 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = ical_dtend;
#line 196 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtend (_tmp29_, _tmp30_);
#line 197 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 903 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION)) {
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 909 "component-event.c"
			default:
			{
				icalcomponent* _tmp31_ = NULL;
				icalcomponent* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_LOCATION_PROPERTY);
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = _tmp31_;
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = self->priv->_location;
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_location (_tmp32_, _tmp33_);
#line 202 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 927 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_STATUS)) {
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 933 "component-event.c"
			default:
			{
				CaliforniaComponentEventStatus _tmp34_ = 0;
#line 205 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_STATUS_PROPERTY);
#line 206 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = self->priv->_status;
#line 206 "/home/jim/git/california/src/component/component-event.vala"
				switch (_tmp34_) {
#line 206 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE:
#line 945 "component-event.c"
					{
						icalcomponent* _tmp35_ = NULL;
						icalcomponent* _tmp36_ = NULL;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
						_tmp35_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 208 "/home/jim/git/california/src/component/component-event.vala"
						_tmp36_ = _tmp35_;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp36_, ICAL_STATUS_TENTATIVE);
#line 209 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 957 "component-event.c"
					}
#line 206 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED:
#line 961 "component-event.c"
					{
						icalcomponent* _tmp37_ = NULL;
						icalcomponent* _tmp38_ = NULL;
#line 212 "/home/jim/git/california/src/component/component-event.vala"
						_tmp37_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 212 "/home/jim/git/california/src/component/component-event.vala"
						_tmp38_ = _tmp37_;
#line 212 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp38_, ICAL_STATUS_CANCELLED);
#line 213 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 973 "component-event.c"
					}
					default:
#line 206 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED:
#line 978 "component-event.c"
					{
						icalcomponent* _tmp39_ = NULL;
						icalcomponent* _tmp40_ = NULL;
#line 217 "/home/jim/git/california/src/component/component-event.vala"
						_tmp39_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 217 "/home/jim/git/california/src/component/component-event.vala"
						_tmp40_ = _tmp39_;
#line 217 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp40_, ICAL_STATUS_CONFIRMED);
#line 218 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 990 "component-event.c"
					}
				}
#line 220 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 995 "component-event.c"
			}
		}
	} else {
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 1001 "component-event.c"
			default:
			{
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				altered = FALSE;
#line 224 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1008 "component-event.c"
			}
		}
	}
#line 227 "/home/jim/git/california/src/component/component-event.vala"
	_tmp41_ = altered;
#line 227 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp41_) {
#line 228 "/home/jim/git/california/src/component/component-event.vala"
		california_component_instance_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), FALSE);
#line 1018 "component-event.c"
	}
}


/**
     * @inheritDoc
     */
static CaliforniaComponentInstance* california_component_event_real_clone (CaliforniaComponentInstance* base, GError** error) {
	CaliforniaComponentEvent * self;
	CaliforniaComponentInstance* result = NULL;
	CaliforniaComponentEvent* cloned_event = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
	CaliforniaBackingCalendarSource* _tmp1_ = NULL;
	icalcomponent* _tmp2_ = NULL;
	icalcomponent* _tmp3_ = NULL;
	CaliforniaComponentEvent* _tmp4_ = NULL;
	CaliforniaComponentInstance* _tmp5_ = NULL;
	CaliforniaComponentInstance* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 234 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_;
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_component_event_new (_tmp1_, _tmp3_, &_inner_error_);
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	cloned_event = _tmp4_;
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 235 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 235 "/home/jim/git/california/src/component/component-event.vala"
		return NULL;
#line 1058 "component-event.c"
	}
#line 236 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 236 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = _tmp5_;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ != NULL) {
#line 1066 "component-event.c"
		CaliforniaComponentEvent* _tmp7_ = NULL;
		CaliforniaComponentInstance* _tmp8_ = NULL;
		CaliforniaComponentInstance* _tmp9_ = NULL;
		CaliforniaBackingCalendarSource* _tmp10_ = NULL;
		CaliforniaBackingCalendarSource* _tmp11_ = NULL;
		CaliforniaComponentInstance* _tmp12_ = NULL;
		CaliforniaComponentInstance* _tmp13_ = NULL;
		icalcomponent* _tmp14_ = NULL;
		icalcomponent* _tmp15_ = NULL;
		CaliforniaComponentEvent* _tmp16_ = NULL;
		CaliforniaComponentEvent* _tmp17_ = NULL;
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = _tmp8_;
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_component_instance_get_calendar_source (_tmp9_);
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = _tmp10_;
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = _tmp12_;
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp14_ = california_component_instance_get_ical_component (_tmp13_);
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = _tmp14_;
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = california_component_event_new (_tmp11_, _tmp15_, &_inner_error_);
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp16_;
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		if (_inner_error_ != NULL) {
#line 237 "/home/jim/git/california/src/component/component-event.vala"
			g_propagate_error (error, _inner_error_);
#line 237 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (cloned_event);
#line 237 "/home/jim/git/california/src/component/component-event.vala"
			return NULL;
#line 1106 "component-event.c"
		}
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = cloned_event;
#line 237 "/home/jim/git/california/src/component/component-event.vala"
		california_component_instance_set_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp7_);
#line 1114 "component-event.c"
	}
#line 239 "/home/jim/git/california/src/component/component-event.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (cloned_event, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance);
#line 239 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1120 "component-event.c"
}


/**
     * Returns a {@link Calendar.DateSpan} for the {@link Event}.
     *
     * This will return a DateSpan whether the Event is a DATE or DATE-TIME VEVENT.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 249 "/home/jim/git/california/src/component/component-event.vala"
	return self ? g_object_ref (self) : NULL;
#line 1132 "component-event.c"
}


CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarDateSpan* result = NULL;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
	CaliforniaCalendarTimezone* _tmp4_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
#line 247 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 247 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((tz == NULL) || CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 248 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 248 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_ != NULL) {
#line 1150 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp1_ = NULL;
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
#line 249 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = self->priv->_date_span;
#line 249 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 249 "/home/jim/git/california/src/component/component-event.vala"
		result = _tmp2_;
#line 249 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1161 "component-event.c"
	}
#line 252 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = tz;
#line 252 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp4_ != NULL) {
#line 1167 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp5_ = NULL;
		CaliforniaCalendarTimezone* _tmp6_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp7_ = NULL;
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = self->priv->_exact_time_span;
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = tz;
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = california_calendar_exact_time_span_to_timezone (_tmp5_, _tmp6_);
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp7_;
#line 1181 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = self->priv->_exact_time_span;
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 252 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp9_;
#line 1193 "component-event.c"
	}
#line 251 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = california_calendar_date_span_new_from_exact_time_span (_tmp3_);
#line 251 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp10_;
#line 251 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp3_);
#line 251 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1203 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE VEVENT.
     *
     * {@link date_span} will be set and {@link exact_time_span} will be unset.
     *
     * @see set_event_exact_time_span
     */
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 262 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 262 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (date_span));
#line 263 "/home/jim/git/california/src/component/component-event.vala"
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = date_span;
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, _tmp0_);
#line 266 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, NULL);
#line 268 "/home/jim/git/california/src/component/component-event.vala"
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 1230 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE-TIME VEVENT.
     *
     * {@link exact_time_span} will be set and {@link date_span} will be unset.
     *
     * @see set_event_date_span
     */
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 278 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 278 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN (exact_time_span));
#line 279 "/home/jim/git/california/src/component/component-event.vala"
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 281 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = exact_time_span;
#line 281 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, _tmp0_);
#line 282 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, NULL);
#line 284 "/home/jim/git/california/src/component/component-event.vala"
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 1257 "component-event.c"
}


/**
     * Adjusts the dates of an {@link Event} while preserving {@link WallTime}, if present.
     *
     * This will preserve the DATE/DATE-TIME aspect of an Event while adjusting the start and
     * end {@link Calendar.Date}s.  If a DATE Event, then this is functionally equivalent to
     * {@link set_event_date_span}.  If a DATE-TIME event, then this is like
     * {@link set_event_exact_time_span} but without the hassle of preserving start and end times
     * while changing the dates.
     */
void california_component_event_adjust_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarExactTime* new_start_time = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
	CaliforniaCalendarExactTime* _tmp4_ = NULL;
	CaliforniaCalendarExactTime* _tmp5_ = NULL;
	CaliforniaCalendarTimezone* _tmp6_ = NULL;
	CaliforniaCalendarTimezone* _tmp7_ = NULL;
	CaliforniaCalendarDateSpan* _tmp8_ = NULL;
	CaliforniaCalendarDate* _tmp9_ = NULL;
	CaliforniaCalendarDate* _tmp10_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp11_ = NULL;
	CaliforniaCalendarExactTime* _tmp12_ = NULL;
	CaliforniaCalendarExactTime* _tmp13_ = NULL;
	CaliforniaCalendarWallTime* _tmp14_ = NULL;
	CaliforniaCalendarWallTime* _tmp15_ = NULL;
	CaliforniaCalendarExactTime* _tmp16_ = NULL;
	CaliforniaCalendarExactTime* _tmp17_ = NULL;
	CaliforniaCalendarExactTime* new_end_time = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp18_ = NULL;
	CaliforniaCalendarExactTime* _tmp19_ = NULL;
	CaliforniaCalendarExactTime* _tmp20_ = NULL;
	CaliforniaCalendarTimezone* _tmp21_ = NULL;
	CaliforniaCalendarTimezone* _tmp22_ = NULL;
	CaliforniaCalendarDateSpan* _tmp23_ = NULL;
	CaliforniaCalendarDate* _tmp24_ = NULL;
	CaliforniaCalendarDate* _tmp25_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp26_ = NULL;
	CaliforniaCalendarExactTime* _tmp27_ = NULL;
	CaliforniaCalendarExactTime* _tmp28_ = NULL;
	CaliforniaCalendarWallTime* _tmp29_ = NULL;
	CaliforniaCalendarWallTime* _tmp30_ = NULL;
	CaliforniaCalendarExactTime* _tmp31_ = NULL;
	CaliforniaCalendarExactTime* _tmp32_ = NULL;
	CaliforniaCalendarExactTime* _tmp33_ = NULL;
	CaliforniaCalendarExactTime* _tmp34_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp35_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp36_ = NULL;
#line 296 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 296 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (date_span));
#line 297 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_is_all_day (self);
#line 297 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 297 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 1319 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
#line 298 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = date_span;
#line 298 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp2_);
#line 300 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1327 "component-event.c"
	}
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = self->priv->_exact_time_span;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_calendar_exact_time_span_get_start_exact_time (_tmp3_);
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = _tmp4_;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = california_calendar_exact_time_get_tz (_tmp5_);
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = _tmp6_;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = date_span;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = _tmp9_;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = self->priv->_exact_time_span;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = california_calendar_exact_time_span_get_start_exact_time (_tmp11_);
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = _tmp12_;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = california_calendar_exact_time_to_wall_time (_tmp13_);
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = _tmp14_;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = california_calendar_exact_time_new (_tmp7_, _tmp10_, _tmp15_);
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = _tmp16_;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp15_);
#line 303 "/home/jim/git/california/src/component/component-event.vala"
	new_start_time = _tmp17_;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = self->priv->_exact_time_span;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = california_calendar_exact_time_span_get_end_exact_time (_tmp18_);
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = _tmp19_;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = california_calendar_exact_time_get_tz (_tmp20_);
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp22_ = _tmp21_;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp23_ = date_span;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp24_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp25_ = _tmp24_;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp26_ = self->priv->_exact_time_span;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp27_ = california_calendar_exact_time_span_get_end_exact_time (_tmp26_);
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp28_ = _tmp27_;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp29_ = california_calendar_exact_time_to_wall_time (_tmp28_);
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp30_ = _tmp29_;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp31_ = california_calendar_exact_time_new (_tmp22_, _tmp25_, _tmp30_);
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_tmp32_ = _tmp31_;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp30_);
#line 309 "/home/jim/git/california/src/component/component-event.vala"
	new_end_time = _tmp32_;
#line 315 "/home/jim/git/california/src/component/component-event.vala"
	_tmp33_ = new_start_time;
#line 315 "/home/jim/git/california/src/component/component-event.vala"
	_tmp34_ = new_end_time;
#line 315 "/home/jim/git/california/src/component/component-event.vala"
	_tmp35_ = california_calendar_exact_time_span_new (_tmp33_, _tmp34_);
#line 315 "/home/jim/git/california/src/component/component-event.vala"
	_tmp36_ = _tmp35_;
#line 315 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_event_exact_time_span (self, _tmp36_);
#line 315 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp36_);
#line 296 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_end_time);
#line 296 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_start_time);
#line 1413 "component-event.c"
}


/**
     * Convert an {@link Event} from an all-day to a timed event by only adding the time.
     *
     * Returns with no changes if {@link is_all_day} is false.
     */
void california_component_event_all_day_to_timed_event (CaliforniaComponentEvent* self, CaliforniaCalendarWallTime* start_time, CaliforniaCalendarWallTime* end_time, CaliforniaCalendarTimezone* timezone) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarTimezone* _tmp2_ = NULL;
	CaliforniaCalendarDateSpan* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarExactTime* _tmp7_ = NULL;
	CaliforniaCalendarExactTime* _tmp8_ = NULL;
	CaliforniaCalendarTimezone* _tmp9_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarWallTime* _tmp13_ = NULL;
	CaliforniaCalendarExactTime* _tmp14_ = NULL;
	CaliforniaCalendarExactTime* _tmp15_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp17_ = NULL;
#line 323 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 323 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (start_time));
#line 323 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (end_time));
#line 323 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (timezone));
#line 325 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_is_all_day (self);
#line 325 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 325 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp1_) {
#line 326 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1457 "component-event.c"
	}
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = timezone;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = self->priv->_date_span;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = _tmp4_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = start_time;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_calendar_exact_time_new (_tmp2_, _tmp5_, _tmp6_);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = _tmp7_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = timezone;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = self->priv->_date_span;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = _tmp11_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = end_time;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = california_calendar_exact_time_new (_tmp9_, _tmp12_, _tmp13_);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = _tmp14_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = california_calendar_exact_time_span_new (_tmp8_, _tmp15_);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = _tmp16_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_event_exact_time_span (self, _tmp17_);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp17_);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp15_);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp8_);
#line 1499 "component-event.c"
}


/**
     * Convert an {@link Event} from a timed event to an all-day event by removing the time.
     *
     * Returns with no changes if {@link is_all_day} is true.
     */
void california_component_event_timed_to_all_day_event (CaliforniaComponentEvent* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 342 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_is_all_day (self);
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp1_) {
#line 1519 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
		CaliforniaCalendarDateSpan* _tmp3_ = NULL;
#line 344 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = california_component_event_get_event_date_span (self, NULL);
#line 344 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp2_;
#line 344 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp3_);
#line 344 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 1530 "component-event.c"
	}
}


/**
     * Returns a prettified string describing the {@link Event}'s time span in as concise and
     * economical manner possible.
     *
     * @return null if no time/date information is specified
     */
gchar* california_component_event_get_event_time_pretty_string (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* timezone) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
	CaliforniaCalendarDatePrettyFlag date_flags = 0;
	CaliforniaCalendarDateSpan* date_span = NULL;
	CaliforniaCalendarTimezone* _tmp3_ = NULL;
	CaliforniaCalendarDateSpan* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarYear* _tmp9_ = NULL;
	CaliforniaCalendarYear* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarYear* _tmp13_ = NULL;
	CaliforniaCalendarYear* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gchar* span = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (timezone), NULL);
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = self->priv->_date_span;
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_ == NULL) {
#line 1571 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp2_ = NULL;
#line 354 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_exact_time_span;
#line 354 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 1577 "component-event.c"
	} else {
#line 354 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 1581 "component-event.c"
	}
#line 354 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_) {
#line 355 "/home/jim/git/california/src/component/component-event.vala"
		result = NULL;
#line 355 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1589 "component-event.c"
	}
#line 358 "/home/jim/git/california/src/component/component-event.vala"
	date_flags = CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE;
#line 359 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = timezone;
#line 359 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_component_event_get_event_date_span (self, _tmp3_);
#line 359 "/home/jim/git/california/src/component/component-event.vala"
	date_span = _tmp4_;
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = date_span;
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = _tmp7_;
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_calendar_date_get_year (_tmp8_);
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = _tmp9_;
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_system_get_today ();
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = _tmp11_;
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = california_calendar_date_get_year (_tmp12_);
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = _tmp13_;
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_HASHABLE, GeeHashable), _tmp14_);
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp15_) {
#line 360 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = TRUE;
#line 1623 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp16_ = NULL;
		CaliforniaCalendarDate* _tmp17_ = NULL;
		CaliforniaCalendarDate* _tmp18_ = NULL;
		CaliforniaCalendarYear* _tmp19_ = NULL;
		CaliforniaCalendarYear* _tmp20_ = NULL;
		CaliforniaCalendarDate* _tmp21_ = NULL;
		CaliforniaCalendarDate* _tmp22_ = NULL;
		CaliforniaCalendarYear* _tmp23_ = NULL;
		CaliforniaCalendarYear* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = date_span;
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = _tmp17_;
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp19_ = california_calendar_date_get_year (_tmp18_);
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp20_ = _tmp19_;
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp21_ = california_calendar_system_get_today ();
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = _tmp21_;
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp23_ = california_calendar_date_get_year (_tmp22_);
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp24_ = _tmp23_;
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp25_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_HASHABLE, GeeHashable), _tmp24_);
#line 361 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = !_tmp25_;
#line 1657 "component-event.c"
	}
#line 360 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp5_) {
#line 1661 "component-event.c"
		CaliforniaCalendarDatePrettyFlag _tmp26_ = 0;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_tmp26_ = date_flags;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		date_flags = _tmp26_ | CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR;
#line 1667 "component-event.c"
	}
#line 367 "/home/jim/git/california/src/component/component-event.vala"
	_tmp27_ = california_component_event_get_is_all_day (self);
#line 367 "/home/jim/git/california/src/component/component-event.vala"
	_tmp28_ = _tmp27_;
#line 367 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp28_) {
#line 1675 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
		_tmp29_ = date_span;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
		_tmp30_ = california_calendar_span_get_is_same_day (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 368 "/home/jim/git/california/src/component/component-event.vala"
		_tmp31_ = _tmp30_;
#line 368 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp31_) {
#line 1687 "component-event.c"
			CaliforniaCalendarDateSpan* _tmp32_ = NULL;
			CaliforniaCalendarDate* _tmp33_ = NULL;
			CaliforniaCalendarDate* _tmp34_ = NULL;
			CaliforniaCalendarDatePrettyFlag _tmp35_ = 0;
			gchar* _tmp36_ = NULL;
#line 371 "/home/jim/git/california/src/component/component-event.vala"
			_tmp32_ = date_span;
#line 371 "/home/jim/git/california/src/component/component-event.vala"
			_tmp33_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 371 "/home/jim/git/california/src/component/component-event.vala"
			_tmp34_ = _tmp33_;
#line 371 "/home/jim/git/california/src/component/component-event.vala"
			_tmp35_ = date_flags;
#line 371 "/home/jim/git/california/src/component/component-event.vala"
			_tmp36_ = california_calendar_date_to_pretty_string (_tmp34_, _tmp35_);
#line 371 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (span);
#line 371 "/home/jim/git/california/src/component/component-event.vala"
			span = _tmp36_;
#line 1707 "component-event.c"
		} else {
			const gchar* _tmp37_ = NULL;
			CaliforniaCalendarDateSpan* _tmp38_ = NULL;
			CaliforniaCalendarDate* _tmp39_ = NULL;
			CaliforniaCalendarDate* _tmp40_ = NULL;
			CaliforniaCalendarDatePrettyFlag _tmp41_ = 0;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			CaliforniaCalendarDateSpan* _tmp44_ = NULL;
			CaliforniaCalendarDate* _tmp45_ = NULL;
			CaliforniaCalendarDate* _tmp46_ = NULL;
			CaliforniaCalendarDatePrettyFlag _tmp47_ = 0;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp37_ = _ ("%s to %s");
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp38_ = date_span;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp39_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp40_ = _tmp39_;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp41_ = date_flags;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp42_ = california_calendar_date_to_pretty_string (_tmp40_, _tmp41_);
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp43_ = _tmp42_;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp44_ = date_span;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp45_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp46_ = _tmp45_;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp47_ = date_flags;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp48_ = california_calendar_date_to_pretty_string (_tmp46_, _tmp47_);
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp49_ = _tmp48_;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_tmp50_ = g_strdup_printf (_tmp37_, _tmp43_, _tmp49_);
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (span);
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			span = _tmp50_;
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp49_);
#line 374 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp43_);
#line 1759 "component-event.c"
		}
	} else {
		CaliforniaCalendarExactTimeSpan* exact_time_span = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp51_ = NULL;
		CaliforniaCalendarTimezone* _tmp52_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp53_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp54_ = NULL;
		gboolean _tmp55_ = FALSE;
		gboolean _tmp56_ = FALSE;
#line 378 "/home/jim/git/california/src/component/component-event.vala"
		_tmp51_ = self->priv->_exact_time_span;
#line 378 "/home/jim/git/california/src/component/component-event.vala"
		_tmp52_ = timezone;
#line 378 "/home/jim/git/california/src/component/component-event.vala"
		_tmp53_ = california_calendar_exact_time_span_to_timezone (_tmp51_, _tmp52_);
#line 378 "/home/jim/git/california/src/component/component-event.vala"
		exact_time_span = _tmp53_;
#line 379 "/home/jim/git/california/src/component/component-event.vala"
		_tmp54_ = exact_time_span;
#line 379 "/home/jim/git/california/src/component/component-event.vala"
		_tmp55_ = california_calendar_exact_time_span_get_is_same_day (_tmp54_);
#line 379 "/home/jim/git/california/src/component/component-event.vala"
		_tmp56_ = _tmp55_;
#line 379 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp56_) {
#line 1785 "component-event.c"
			gchar* timespan = NULL;
			const gchar* _tmp57_ = NULL;
			CaliforniaCalendarExactTimeSpan* _tmp58_ = NULL;
			CaliforniaCalendarExactTime* _tmp59_ = NULL;
			CaliforniaCalendarExactTime* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			CaliforniaCalendarExactTimeSpan* _tmp63_ = NULL;
			CaliforniaCalendarExactTime* _tmp64_ = NULL;
			CaliforniaCalendarExactTime* _tmp65_ = NULL;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			CaliforniaCalendarExactTimeSpan* _tmp70_ = NULL;
			CaliforniaCalendarDate* _tmp71_ = NULL;
			CaliforniaCalendarDate* _tmp72_ = NULL;
			CaliforniaCalendarDatePrettyFlag _tmp73_ = 0;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp57_ = _ ("%s to %s");
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp58_ = exact_time_span;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp59_ = california_calendar_exact_time_span_get_start_exact_time (_tmp58_);
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp60_ = _tmp59_;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp61_ = california_calendar_exact_time_to_pretty_time_string (_tmp60_, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE);
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp62_ = _tmp61_;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp63_ = exact_time_span;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp64_ = california_calendar_exact_time_span_get_end_exact_time (_tmp63_);
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp65_ = _tmp64_;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp66_ = california_calendar_exact_time_to_pretty_time_string (_tmp65_, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE);
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp67_ = _tmp66_;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp68_ = g_strdup_printf (_tmp57_, _tmp62_, _tmp67_);
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_tmp69_ = _tmp68_;
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp67_);
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp62_);
#line 381 "/home/jim/git/california/src/component/component-event.vala"
			timespan = _tmp69_;
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp70_ = exact_time_span;
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp71_ = california_calendar_exact_time_span_get_start_date (_tmp70_);
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp72_ = _tmp71_;
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp73_ = date_flags;
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp74_ = california_calendar_date_to_pretty_string (_tmp72_, _tmp73_);
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp75_ = _tmp74_;
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp76_ = timespan;
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_tmp77_ = g_strdup_printf ("%s, %s", _tmp75_, _tmp76_);
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (span);
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			span = _tmp77_;
#line 387 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp75_);
#line 379 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (timespan);
#line 1864 "component-event.c"
		} else {
			const gchar* _tmp78_ = NULL;
			CaliforniaCalendarExactTimeSpan* _tmp79_ = NULL;
			CaliforniaCalendarExactTime* _tmp80_ = NULL;
			CaliforniaCalendarExactTime* _tmp81_ = NULL;
			CaliforniaCalendarDatePrettyFlag _tmp82_ = 0;
			gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			CaliforniaCalendarExactTimeSpan* _tmp85_ = NULL;
			CaliforniaCalendarExactTime* _tmp86_ = NULL;
			CaliforniaCalendarExactTime* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			CaliforniaCalendarExactTimeSpan* _tmp90_ = NULL;
			CaliforniaCalendarExactTime* _tmp91_ = NULL;
			CaliforniaCalendarExactTime* _tmp92_ = NULL;
			CaliforniaCalendarDatePrettyFlag _tmp93_ = 0;
			gchar* _tmp94_ = NULL;
			gchar* _tmp95_ = NULL;
			CaliforniaCalendarExactTimeSpan* _tmp96_ = NULL;
			CaliforniaCalendarExactTime* _tmp97_ = NULL;
			CaliforniaCalendarExactTime* _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			gchar* _tmp101_ = NULL;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp78_ = _ ("%s, %s\n%s, %s");
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp79_ = exact_time_span;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp80_ = california_calendar_exact_time_span_get_start_exact_time (_tmp79_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp81_ = _tmp80_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp82_ = date_flags;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp83_ = california_calendar_exact_time_to_pretty_date_string (_tmp81_, _tmp82_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp84_ = _tmp83_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp85_ = exact_time_span;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp86_ = california_calendar_exact_time_span_get_start_exact_time (_tmp85_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp87_ = _tmp86_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp88_ = california_calendar_exact_time_to_pretty_time_string (_tmp87_, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp89_ = _tmp88_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp90_ = exact_time_span;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp91_ = california_calendar_exact_time_span_get_end_exact_time (_tmp90_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp92_ = _tmp91_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp93_ = date_flags;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp94_ = california_calendar_exact_time_to_pretty_date_string (_tmp92_, _tmp93_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp95_ = _tmp94_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp96_ = exact_time_span;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp97_ = california_calendar_exact_time_span_get_end_exact_time (_tmp96_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp98_ = _tmp97_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp99_ = california_calendar_exact_time_to_pretty_time_string (_tmp98_, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp100_ = _tmp99_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_tmp101_ = g_strdup_printf (_tmp78_, _tmp84_, _tmp89_, _tmp95_, _tmp100_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (span);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			span = _tmp101_;
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp100_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp95_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp89_);
#line 395 "/home/jim/git/california/src/component/component-event.vala"
			_g_free0 (_tmp84_);
#line 1950 "component-event.c"
		}
#line 367 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (exact_time_span);
#line 1954 "component-event.c"
	}
#line 403 "/home/jim/git/california/src/component/component-event.vala"
	result = span;
#line 403 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 403 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1962 "component-event.c"
}


/**
     * @inheritDoc
     */
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base, gboolean and_useful) {
	CaliforniaComponentEvent * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 409 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 410 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = and_useful;
#line 410 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 1983 "component-event.c"
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 410 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_summary;
#line 410 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_string_is_empty (_tmp2_);
#line 410 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp3_;
#line 1992 "component-event.c"
	} else {
#line 410 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 1996 "component-event.c"
	}
#line 410 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_) {
#line 411 "/home/jim/git/california/src/component/component-event.vala"
		result = FALSE;
#line 411 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2004 "component-event.c"
	}
#line 413 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = and_useful;
#line 413 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->is_valid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp5_);
#line 413 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_) {
#line 2012 "component-event.c"
		gboolean _tmp7_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp8_ = NULL;
#line 413 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = self->priv->_date_span;
#line 413 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp8_ != NULL) {
#line 413 "/home/jim/git/california/src/component/component-event.vala"
			_tmp7_ = TRUE;
#line 2021 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
#line 413 "/home/jim/git/california/src/component/component-event.vala"
			_tmp9_ = self->priv->_exact_time_span;
#line 413 "/home/jim/git/california/src/component/component-event.vala"
			_tmp7_ = _tmp9_ != NULL;
#line 2028 "component-event.c"
		}
#line 413 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp7_;
#line 2032 "component-event.c"
	} else {
#line 413 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = FALSE;
#line 2036 "component-event.c"
	}
#line 413 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp4_;
#line 413 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2042 "component-event.c"
}


/**
     * Compares an {@link Event} to another and returns which is chronologically first.
     *
     * The method attempts to compare DATE-TIMEs first, then DATEs, coercing a DATE-TIME into a DATE
     * if necessary.
     *
     * If both events have the same chronological time, they're sorted by summary in lexographical
     * order.
     *
     * {@link dtstamp} is the third comparison attempted.  In general, dtstamp is the time the
     * {@link Component} was created.
     *
     * Finally, UIDs are used to stabilize the sort.
     *
     * @inheritDoc
     */
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other) {
	CaliforniaComponentEvent * self;
	gint result = 0;
	CaliforniaComponentEvent* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint compare = 0;
	gboolean _tmp13_ = FALSE;
	CaliforniaCalendarExactTimeSpan* _tmp14_ = NULL;
	gint _tmp42_ = 0;
	gboolean _tmp43_ = FALSE;
	CaliforniaComponentDateTime* _tmp44_ = NULL;
	CaliforniaComponentDateTime* _tmp45_ = NULL;
	GCompareFunc _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	CaliforniaComponentEvent* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	CaliforniaCalendarExactTime* _tmp62_ = NULL;
	CaliforniaCalendarExactTime* _tmp63_ = NULL;
	CaliforniaComponentEvent* _tmp64_ = NULL;
	CaliforniaCalendarExactTime* _tmp65_ = NULL;
	CaliforniaCalendarExactTime* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	CaliforniaComponentEvent* _tmp71_ = NULL;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	CaliforniaComponentUID* _tmp75_ = NULL;
	CaliforniaComponentUID* _tmp76_ = NULL;
	CaliforniaComponentEvent* _tmp77_ = NULL;
	CaliforniaComponentUID* _tmp78_ = NULL;
	CaliforniaComponentUID* _tmp79_ = NULL;
	gint _tmp80_ = 0;
#line 432 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 432 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (other), 0);
#line 433 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = other;
#line 433 "/home/jim/git/california/src/component/component-event.vala"
	if (self == _tmp0_) {
#line 434 "/home/jim/git/california/src/component/component-event.vala"
		result = 0;
#line 434 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2116 "component-event.c"
	}
#line 437 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = california_component_event_get_is_all_day (self);
#line 437 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_;
#line 437 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp3_) {
#line 2124 "component-event.c"
		CaliforniaComponentEvent* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 437 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = other;
#line 437 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_component_event_get_is_all_day (_tmp4_);
#line 437 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = _tmp5_;
#line 437 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = !_tmp6_;
#line 2136 "component-event.c"
	} else {
#line 437 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = FALSE;
#line 2140 "component-event.c"
	}
#line 437 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 438 "/home/jim/git/california/src/component/component-event.vala"
		result = -1;
#line 438 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2148 "component-event.c"
	}
#line 440 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = california_component_event_get_is_all_day (self);
#line 440 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = _tmp8_;
#line 440 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp9_) {
#line 2156 "component-event.c"
		CaliforniaComponentEvent* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 440 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = other;
#line 440 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = california_component_event_get_is_all_day (_tmp10_);
#line 440 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = _tmp11_;
#line 440 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp12_;
#line 2168 "component-event.c"
	} else {
#line 440 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = FALSE;
#line 2172 "component-event.c"
	}
#line 440 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp7_) {
#line 441 "/home/jim/git/california/src/component/component-event.vala"
		result = 1;
#line 441 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2180 "component-event.c"
	}
#line 445 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = self->priv->_exact_time_span;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp14_ != NULL) {
#line 2186 "component-event.c"
		CaliforniaComponentEvent* _tmp15_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = other;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = _tmp15_->priv->_exact_time_span;
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = _tmp16_ != NULL;
#line 2195 "component-event.c"
	} else {
#line 445 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = FALSE;
#line 2199 "component-event.c"
	}
#line 445 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp13_) {
#line 2203 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp17_ = NULL;
		CaliforniaComponentEvent* _tmp18_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp19_ = NULL;
		gint _tmp20_ = 0;
#line 446 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = self->priv->_exact_time_span;
#line 446 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = other;
#line 446 "/home/jim/git/california/src/component/component-event.vala"
		_tmp19_ = _tmp18_->priv->_exact_time_span;
#line 446 "/home/jim/git/california/src/component/component-event.vala"
		_tmp20_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp19_);
#line 446 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp20_;
#line 2218 "component-event.c"
	} else {
		gboolean _tmp21_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp22_ = NULL;
#line 447 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = self->priv->_date_span;
#line 447 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp22_ != NULL) {
#line 2226 "component-event.c"
			CaliforniaComponentEvent* _tmp23_ = NULL;
			CaliforniaCalendarDateSpan* _tmp24_ = NULL;
#line 447 "/home/jim/git/california/src/component/component-event.vala"
			_tmp23_ = other;
#line 447 "/home/jim/git/california/src/component/component-event.vala"
			_tmp24_ = _tmp23_->priv->_date_span;
#line 447 "/home/jim/git/california/src/component/component-event.vala"
			_tmp21_ = _tmp24_ != NULL;
#line 2235 "component-event.c"
		} else {
#line 447 "/home/jim/git/california/src/component/component-event.vala"
			_tmp21_ = FALSE;
#line 2239 "component-event.c"
		}
#line 447 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp21_) {
#line 2243 "component-event.c"
			CaliforniaCalendarDateSpan* _tmp25_ = NULL;
			CaliforniaComponentEvent* _tmp26_ = NULL;
			CaliforniaCalendarDateSpan* _tmp27_ = NULL;
			gint _tmp28_ = 0;
#line 448 "/home/jim/git/california/src/component/component-event.vala"
			_tmp25_ = self->priv->_date_span;
#line 448 "/home/jim/git/california/src/component/component-event.vala"
			_tmp26_ = other;
#line 448 "/home/jim/git/california/src/component/component-event.vala"
			_tmp27_ = _tmp26_->priv->_date_span;
#line 448 "/home/jim/git/california/src/component/component-event.vala"
			_tmp28_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 448 "/home/jim/git/california/src/component/component-event.vala"
			compare = _tmp28_;
#line 2258 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp29_ = NULL;
#line 449 "/home/jim/git/california/src/component/component-event.vala"
			_tmp29_ = self->priv->_exact_time_span;
#line 449 "/home/jim/git/california/src/component/component-event.vala"
			if (_tmp29_ != NULL) {
#line 2265 "component-event.c"
				CaliforniaCalendarExactTimeSpan* _tmp30_ = NULL;
				CaliforniaCalendarDateSpan* _tmp31_ = NULL;
				CaliforniaCalendarDateSpan* _tmp32_ = NULL;
				CaliforniaComponentEvent* _tmp33_ = NULL;
				CaliforniaCalendarDateSpan* _tmp34_ = NULL;
				gint _tmp35_ = 0;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = self->priv->_exact_time_span;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = california_calendar_date_span_new_from_exact_time_span (_tmp30_);
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = _tmp31_;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = other;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = _tmp33_->priv->_date_span;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				_tmp35_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp35_;
#line 450 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp32_);
#line 2288 "component-event.c"
			} else {
				CaliforniaCalendarDateSpan* _tmp36_ = NULL;
				CaliforniaComponentEvent* _tmp37_ = NULL;
				CaliforniaCalendarExactTimeSpan* _tmp38_ = NULL;
				CaliforniaCalendarDateSpan* _tmp39_ = NULL;
				CaliforniaCalendarDateSpan* _tmp40_ = NULL;
				gint _tmp41_ = 0;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				_tmp36_ = self->priv->_date_span;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				_tmp37_ = other;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				_tmp38_ = _tmp37_->priv->_exact_time_span;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				_tmp39_ = california_calendar_date_span_new_from_exact_time_span (_tmp38_);
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				_tmp40_ = _tmp39_;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				_tmp41_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp41_;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp40_);
#line 2312 "component-event.c"
			}
		}
	}
#line 454 "/home/jim/git/california/src/component/component-event.vala"
	_tmp42_ = compare;
#line 454 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp42_ != 0) {
#line 455 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2324 "component-event.c"
	}
#line 458 "/home/jim/git/california/src/component/component-event.vala"
	_tmp44_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 458 "/home/jim/git/california/src/component/component-event.vala"
	_tmp45_ = _tmp44_;
#line 458 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp45_ != NULL) {
#line 2332 "component-event.c"
		CaliforniaComponentEvent* _tmp46_ = NULL;
		CaliforniaComponentDateTime* _tmp47_ = NULL;
		CaliforniaComponentDateTime* _tmp48_ = NULL;
#line 458 "/home/jim/git/california/src/component/component-event.vala"
		_tmp46_ = other;
#line 458 "/home/jim/git/california/src/component/component-event.vala"
		_tmp47_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 458 "/home/jim/git/california/src/component/component-event.vala"
		_tmp48_ = _tmp47_;
#line 458 "/home/jim/git/california/src/component/component-event.vala"
		_tmp43_ = _tmp48_ != NULL;
#line 2344 "component-event.c"
	} else {
#line 458 "/home/jim/git/california/src/component/component-event.vala"
		_tmp43_ = FALSE;
#line 2348 "component-event.c"
	}
#line 458 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp43_) {
#line 2352 "component-event.c"
		CaliforniaComponentDateTime* _tmp49_ = NULL;
		CaliforniaComponentDateTime* _tmp50_ = NULL;
		CaliforniaComponentEvent* _tmp51_ = NULL;
		CaliforniaComponentDateTime* _tmp52_ = NULL;
		CaliforniaComponentDateTime* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp49_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp50_ = _tmp49_;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp51_ = other;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp52_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp53_ = _tmp52_;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp54_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp53_);
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp54_;
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		_tmp55_ = compare;
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp55_ != 0) {
#line 461 "/home/jim/git/california/src/component/component-event.vala"
			result = compare;
#line 461 "/home/jim/git/california/src/component/component-event.vala"
			return result;
#line 2382 "component-event.c"
		}
	}
#line 465 "/home/jim/git/california/src/component/component-event.vala"
	_tmp56_ = g_strcmp0;
#line 465 "/home/jim/git/california/src/component/component-event.vala"
	_tmp57_ = self->priv->_summary;
#line 465 "/home/jim/git/california/src/component/component-event.vala"
	_tmp58_ = other;
#line 465 "/home/jim/git/california/src/component/component-event.vala"
	_tmp59_ = _tmp58_->priv->_summary;
#line 465 "/home/jim/git/california/src/component/component-event.vala"
	_tmp60_ = _tmp56_ (_tmp57_, _tmp59_);
#line 465 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp60_;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
	_tmp61_ = compare;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp61_ != 0) {
#line 467 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 467 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2405 "component-event.c"
	}
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp62_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp63_ = _tmp62_;
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp64_ = other;
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp65_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp66_ = _tmp65_;
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	_tmp67_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp66_);
#line 470 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp67_;
#line 471 "/home/jim/git/california/src/component/component-event.vala"
	_tmp68_ = compare;
#line 471 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp68_ != 0) {
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2429 "component-event.c"
	}
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp69_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp70_ = _tmp69_;
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp71_ = other;
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp72_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	_tmp73_ = _tmp72_;
#line 475 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp70_ - _tmp73_;
#line 476 "/home/jim/git/california/src/component/component-event.vala"
	_tmp74_ = compare;
#line 476 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp74_ != 0) {
#line 477 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 477 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2451 "component-event.c"
	}
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp75_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp76_ = _tmp75_;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp77_ = other;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp78_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp79_ = _tmp78_;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp80_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp79_);
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp80_;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2469 "component-event.c"
}


static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaComponentEvent * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CaliforniaComponentDateTime* _tmp1_ = NULL;
	CaliforniaComponentDateTime* _tmp2_ = NULL;
	gchar* _tmp7_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
	CaliforniaComponentUID* _tmp13_ = NULL;
	CaliforniaComponentUID* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
#line 483 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 486 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 486 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_ != NULL) {
#line 2498 "component-event.c"
		CaliforniaComponentDateTime* _tmp3_ = NULL;
		CaliforniaComponentDateTime* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp3_;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp5_;
#line 2512 "component-event.c"
	} else {
		gchar* _tmp6_ = NULL;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = g_strdup ("(no-recurring)");
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp6_;
#line 2521 "component-event.c"
	}
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = self->priv->_exact_time_span;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp8_ != NULL) {
#line 2527 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = self->priv->_exact_time_span;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp10_;
#line 2538 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = self->priv->_date_span;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 489 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp12_;
#line 2550 "component-event.c"
	}
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = _tmp13_;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = _tmp15_;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = _tmp17_;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = self->priv->_summary;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = g_strdup_printf ("Event %s/rid=%s/%d \"%s\" (%s)", _tmp16_, _tmp0_, _tmp18_, _tmp19_, _tmp7_);
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = _tmp20_;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp16_);
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp21_;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp7_);
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp0_);
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2580 "component-event.c"
}


const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_summary;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2595 "component-event.c"
}


void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = _tmp1_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "summary");
#line 2614 "component-event.c"
}


const gchar* california_component_event_get_description (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_description;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2629 "component-event.c"
}


void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = _tmp1_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "description");
#line 2648 "component-event.c"
}


CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarExactTimeSpan* result;
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_exact_time_span;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2663 "component-event.c"
}


static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp1_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = _tmp1_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "exact-time-span");
#line 2682 "component-event.c"
}


CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarDateSpan* result;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2697 "component-event.c"
}


static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = _tmp1_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "date-span");
#line 2716 "component-event.c"
}


gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
#line 64 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = self->priv->_date_span;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_ != NULL) {
#line 2730 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp2_ = NULL;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_exact_time_span;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 2736 "component-event.c"
	} else {
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 2740 "component-event.c"
	}
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2746 "component-event.c"
}


gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 73 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_event_get_is_all_day (self);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_) {
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = TRUE;
#line 2765 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
		CaliforniaCalendarDuration* _tmp4_ = NULL;
		CaliforniaCalendarDuration* _tmp5_ = NULL;
		CaliforniaCalendarDuration* _tmp6_ = NULL;
		guint64 _tmp7_ = 0ULL;
		guint64 _tmp8_ = 0ULL;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = self->priv->_exact_time_span;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = california_calendar_exact_time_span_get_duration (_tmp3_);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = _tmp4_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = _tmp5_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = california_calendar_duration_get_days (_tmp6_);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = _tmp7_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp8_ >= ((guint64) 1);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp6_);
#line 2789 "component-event.c"
	}
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2795 "component-event.c"
}


const gchar* california_component_event_get_location (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_location;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2810 "component-event.c"
}


void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = _tmp1_;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "location");
#line 2829 "component-event.c"
}


CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self) {
	CaliforniaComponentEventStatus result;
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), 0);
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_status;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2844 "component-event.c"
}


void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value) {
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = _tmp0_;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "status");
#line 2858 "component-event.c"
}


static void california_component_event_class_init (CaliforniaComponentEventClass * klass) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaComponentEventPrivate));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (klass)->update_from_component = california_component_event_real_update_from_component;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (klass)->clone = california_component_event_real_clone;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (klass)->is_valid = california_component_event_real_is_valid;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_component_event_real_to_string;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_component_event_get_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_component_event_set_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->finalize = california_component_event_finalize;
#line 2881 "component-event.c"
	/**
	     * Summary (title) of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_SUMMARY, g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2887 "component-event.c"
	/**
	     * Description of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2893 "component-event.c"
	/**
	     * {@link Calendar.ExactTimeSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT specifies a DATE-TIME for both properties, otherwise
	     * {@link date_span} will be specified.
	     *
	     * @see set_exact_time_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN, g_param_spec_object ("exact-time-span", "exact-time-span", "exact-time-span", CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2904 "component-event.c"
	/**
	     * {@link Calendar.DateSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT defines a DATE for one or both properties.  Generally
	     * this indicates an "all day" or multi-day event.
	     *
	     * @see set_date_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DATE_SPAN, g_param_spec_object ("date-span", "date-span", "date-span", CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2915 "component-event.c"
	/**
	     * Convenience property for determining if an all-day event or not.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY, g_param_spec_boolean ("is-all-day", "is-all-day", "is-all-day", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2921 "component-event.c"
	/**
	     * Convenience property for determining if {@link Event} spans one or more full days.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING, g_param_spec_boolean ("is-day-spanning", "is-day-spanning", "is-day-spanning", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2927 "component-event.c"
	/**
	     * Location of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_LOCATION, g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2933 "component-event.c"
	/**
	     * Status (confirmation) of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_STATUS, g_param_spec_enum ("status", "status", "status", CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2939 "component-event.c"
}


static void california_component_event_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_component_event_real_compare_to;
#line 2948 "component-event.c"
}


static void california_component_event_instance_init (CaliforniaComponentEvent * self) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self->priv = CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE (self);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = NULL;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED;
#line 2967 "component-event.c"
}


static void california_component_event_finalize (GObject* obj) {
	CaliforniaComponentEvent * self;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (california_component_event_parent_class)->finalize (obj);
#line 2987 "component-event.c"
}


/**
 * A mutable representation of an iCalendar Event.
 *
 * See [[https://tools.ietf.org/html/rfc5545#section-3.6.1]]
 */
GType california_component_event_get_type (void) {
	static volatile gsize california_component_event_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaComponentEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_component_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaComponentEvent), 0, (GInstanceInitFunc) california_component_event_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_component_event_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_component_event_type_id;
		california_component_event_type_id = g_type_register_static (CALIFORNIA_COMPONENT_TYPE_INSTANCE, "CaliforniaComponentEvent", &g_define_type_info, 0);
		g_type_add_interface_static (california_component_event_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_once_init_leave (&california_component_event_type_id__volatile, california_component_event_type_id);
	}
	return california_component_event_type_id__volatile;
}


static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_summary (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_description (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_exact_time_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_date_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_all_day (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_day_spanning (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_location (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_enum (value, california_component_event_get_status (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3063 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3069 "component-event.c"
	}
}


static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_summary (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_description (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_exact_time_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_date_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_location (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_status (self, g_value_get_enum (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3115 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3121 "component-event.c"
	}
}



