/* calendar-wall-time.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-wall-time.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;
typedef struct _CaliforniaCalendarWallTimePrivate CaliforniaCalendarWallTimePrivate;

#define CALIFORNIA_CALENDAR_WALL_TIME_TYPE_PRETTY_FLAG (california_calendar_wall_time_pretty_flag_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIME_UNIT (california_calendar_time_unit_get_type ())

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarWallTime {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarWallTimePrivate * priv;
};

struct _CaliforniaCalendarWallTimeClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaCalendarWallTimePrivate {
	gint _hour;
	gint _12hour;
	gint _minute;
	gint _second;
};

typedef enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS = 1 << 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES = 1 << 1,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY = 1 << 2,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM = 1 << 3
} CaliforniaCalendarWallTimePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_TIME_UNIT_SECOND,
	CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE,
	CALIFORNIA_CALENDAR_TIME_UNIT_HOUR
} CaliforniaCalendarTimeUnit;


static gpointer california_calendar_wall_time_parent_class = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest = NULL;
extern const gchar* california_calendar_MIDNIGHT;
extern const gchar* california_calendar_NOON;
extern const gchar* california_calendar_FMT_AM;
extern const gchar* california_calendar_FMT_BRIEF_AM;
extern const gchar* california_calendar_FMT_PM;
extern const gchar* california_calendar_FMT_BRIEF_PM;
extern const gchar* california_calendar_FMT_24HOUR_MIN;
extern const gchar* california_calendar_FMT_12HOUR_MIN_MERIDIEM;
extern const gchar* california_calendar_FMT_24HOUR_MIN_SEC;
extern const gchar* california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
static GeeComparableIface* california_calendar_wall_time_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_wall_time_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimePrivate))
enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_WALL_TIME_HOUR,
	CALIFORNIA_CALENDAR_WALL_TIME_MINUTE,
	CALIFORNIA_CALENDAR_WALL_TIME_SECOND,
	CALIFORNIA_CALENDAR_WALL_TIME_IS_PM
};
GType california_calendar_wall_time_pretty_flag_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY 24
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR (CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE (CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND (CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - 1)
CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second);
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value);
void california_calendar_wall_time_init (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void);
static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void);
static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value);
void california_calendar_wall_time_terminate (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed);
gboolean california_string_is_empty (const gchar* str);
gboolean california_string_is_numeric (const gchar* str);
GType california_calendar_time_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover);
gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self);
static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover);
CaliforniaCalendarWallTime* california_calendar_wall_time_round_down (CaliforniaCalendarWallTime* self, gint multiple, CaliforniaCalendarTimeUnit time_unit);
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags);
gboolean california_calendar_system_get_is_24hr (void);
gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self);
gchar* california_string_reduce_whitespace (const gchar* str);
static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other);
static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other);
static guint california_calendar_wall_time_real_hash (GeeHashable* base);
static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base);
static void california_calendar_wall_time_finalize (GObject* obj);
static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Options for {@link to_pretty_string}.
     */
GType california_calendar_wall_time_pretty_flag_get_type (void) {
	static volatile gsize california_calendar_wall_time_pretty_flag_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_pretty_flag_type_id__volatile)) {
		static const GFlagsValue values[] = {{CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE", "none"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS", "include-seconds"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES", "optional-minutes"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY", "meridiem-post-only"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM", "brief-meridiem"}, {0, NULL, NULL}};
		GType california_calendar_wall_time_pretty_flag_type_id;
		california_calendar_wall_time_pretty_flag_type_id = g_flags_register_static ("CaliforniaCalendarWallTimePrettyFlag", values);
		g_once_init_leave (&california_calendar_wall_time_pretty_flag_type_id__volatile, california_calendar_wall_time_pretty_flag_type_id);
	}
	return california_calendar_wall_time_pretty_flag_type_id__volatile;
}


/**
     * Generate a new {@link WallTime} object with the specified values.
     *
     * Note that hour must be in 24-hour time.
     *
     * Values will be clamped to create a valid time.
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second) {
	CaliforniaCalendarWallTime * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = (CaliforniaCalendarWallTime*) california_base_object_construct (object_type);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = hour;
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = CLAMP (_tmp0_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_hour (self, _tmp1_);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = minute;
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = CLAMP (_tmp2_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_minute (self, _tmp3_);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = second;
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = CLAMP (_tmp4_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_second (self, _tmp5_);
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = hour;
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_ == 0) {
#line 105 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_12hour (self, 12);
#line 223 "calendar-wall-time.c"
	} else {
		gint _tmp7_ = 0;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp7_ = hour;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp7_ > 12) {
#line 230 "calendar-wall-time.c"
			gint _tmp8_ = 0;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = hour;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp8_ - 12);
#line 236 "calendar-wall-time.c"
		} else {
			gint _tmp9_ = 0;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp9_ = hour;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp9_);
#line 243 "calendar-wall-time.c"
		}
	}
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self;
#line 248 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second) {
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return california_calendar_wall_time_construct (CALIFORNIA_CALENDAR_TYPE_WALL_TIME, hour, minute, second);
#line 255 "calendar-wall-time.c"
}


/**
     * Called from Calendar.init().
     */
void california_calendar_wall_time_init (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	CaliforniaCalendarWallTime* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarWallTime* _tmp7_ = NULL;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND);
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (_tmp3_);
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp3_);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_wall_time_get_latest ();
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_;
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (_tmp7_);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp7_);
#line 295 "calendar-wall-time.c"
}


/**
     * Called from Calendar.terminate().
     */
void california_calendar_wall_time_terminate (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (NULL);
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_get_latest ();
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (NULL);
#line 319 "calendar-wall-time.c"
}


/**
     * Attempt to convert a string into {@link WallTime}.
     *
     * 24-hour and 12-hour time is recognized, as are localized versions of AM and PM.  If the time
     * was "liberally" parsed (in other words, "8" is converted to 8am), the returned flag is
     * cleared.
     */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 349 "calendar-wall-time.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1226 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1227 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1227 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1227 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1228 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1228 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 382 "calendar-wall-time.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1229 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1229 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1229 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 391 "calendar-wall-time.c"
	}
#line 1231 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1231 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 397 "calendar-wall-time.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1232 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1232 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1232 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 406 "calendar-wall-time.c"
	}
#line 1234 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1234 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 412 "calendar-wall-time.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1234 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1234 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1234 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 421 "calendar-wall-time.c"
	} else {
#line 1234 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 425 "calendar-wall-time.c"
	}
#line 1234 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1235 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1235 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 433 "calendar-wall-time.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1235 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1235 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1235 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 442 "calendar-wall-time.c"
	} else {
#line 1235 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 446 "calendar-wall-time.c"
	}
#line 1235 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1236 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1236 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1236 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1237 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1237 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1237 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1237 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1237 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1237 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 468 "calendar-wall-time.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1278 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1278 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1278 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 481 "calendar-wall-time.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 512 "calendar-wall-time.c"
				goto __catch28_g_regex_error;
			}
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1280 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 521 "calendar-wall-time.c"
		}
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 537 "calendar-wall-time.c"
				goto __catch28_g_regex_error;
			}
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 548 "calendar-wall-time.c"
		}
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1281 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 562 "calendar-wall-time.c"
	}
	goto __finally28;
	__catch28_g_regex_error:
	{
		GError* e = NULL;
#line 1279 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1279 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1283 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1279 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 576 "calendar-wall-time.c"
	}
	__finally28:
#line 1279 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1279 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1279 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1279 "/usr/local/share/vala-0.24/vapi/glib-2.0.vapi"
		return NULL;
#line 587 "calendar-wall-time.c"
	}
}


CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed) {
	gboolean _vala_strictly_parsed = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gchar* token = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean pm = FALSE;
	gboolean meridiem_unknown = FALSE;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gint length = 0;
	const gchar* _tmp85_ = NULL;
	gint _tmp86_ = 0;
	gint _tmp87_ = 0;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp89_ = FALSE;
	const gchar* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp94_ = FALSE;
	gint _tmp95_ = 0;
	gint h = 0;
	const gchar* _tmp133_ = NULL;
	gint _tmp134_ = 0;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp136_ = FALSE;
	gboolean _tmp137_ = FALSE;
	gint _tmp141_ = 0;
	gboolean _tmp142_ = FALSE;
	gint _tmp143_ = 0;
	gboolean _tmp145_ = FALSE;
	gint _tmp146_ = 0;
	CaliforniaCalendarWallTime* _tmp147_ = NULL;
#line 135 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 136 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = FALSE;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = str;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = string_strip (_tmp0_);
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = _tmp1_;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) (-1));
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = _tmp3_;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp2_);
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp4_;
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = token;
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_string_is_empty (_tmp5_);
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_) {
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 672 "calendar-wall-time.c"
		}
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 676 "calendar-wall-time.c"
	}
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = token;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = california_calendar_MIDNIGHT;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) (-1));
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = _tmp9_;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp10_);
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 692 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp12_ = NULL;
#line 144 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_wall_time_new (0, 0, 0);
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp12_;
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 706 "calendar-wall-time.c"
		}
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 710 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = token;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp14_ = california_calendar_NOON;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = g_utf8_casefold (_tmp14_, (gssize) (-1));
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = _tmp15_;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp16_);
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp17_) {
#line 731 "calendar-wall-time.c"
			CaliforniaCalendarWallTime* _tmp18_ = NULL;
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_strictly_parsed = TRUE;
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = california_calendar_wall_time_new (12, 0, 0);
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp18_;
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (strictly_parsed) {
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				*strictly_parsed = _vala_strictly_parsed;
#line 745 "calendar-wall-time.c"
			}
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 749 "calendar-wall-time.c"
		}
	}
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = FALSE;
#line 155 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_unknown = FALSE;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp19_ = token;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp20_ = california_calendar_FMT_AM;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) (-1));
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp22_ = _tmp21_;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp23_ = g_str_has_suffix (_tmp19_, _tmp22_);
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp24_ = _tmp23_;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp22_);
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp24_) {
#line 772 "calendar-wall-time.c"
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gchar* _tmp34_ = NULL;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = token;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = token;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp27_ = strlen (_tmp26_);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp28_ = _tmp27_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp29_ = california_calendar_FMT_AM;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp30_ = g_utf8_casefold (_tmp29_, (gssize) (-1));
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = _tmp30_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp32_ = strlen (_tmp31_);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp33_ = _tmp32_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp34_ = string_slice (_tmp25_, (glong) 0, (glong) (_tmp28_ - _tmp33_));
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		token = _tmp34_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp31_);
#line 809 "calendar-wall-time.c"
	} else {
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = token;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp36_ = california_calendar_FMT_BRIEF_AM;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp37_ = g_utf8_casefold (_tmp36_, (gssize) (-1));
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp38_ = _tmp37_;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp39_ = g_str_has_suffix (_tmp35_, _tmp38_);
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp40_ = _tmp39_;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp38_);
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp40_) {
#line 833 "calendar-wall-time.c"
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			const gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gchar* _tmp50_ = NULL;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = token;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = token;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp43_ = strlen (_tmp42_);
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp44_ = _tmp43_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp45_ = california_calendar_FMT_BRIEF_AM;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp46_ = g_utf8_casefold (_tmp45_, (gssize) (-1));
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp47_ = _tmp46_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp48_ = strlen (_tmp47_);
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp49_ = _tmp48_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp50_ = string_slice (_tmp41_, (glong) 0, (glong) (_tmp44_ - _tmp49_));
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			token = _tmp50_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp47_);
#line 870 "calendar-wall-time.c"
		} else {
			const gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_ = FALSE;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp51_ = token;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp52_ = california_calendar_FMT_PM;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp53_ = g_utf8_casefold (_tmp52_, (gssize) (-1));
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp54_ = _tmp53_;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp55_ = g_str_has_suffix (_tmp51_, _tmp54_);
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp56_ = _tmp55_;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp54_);
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp56_) {
#line 894 "calendar-wall-time.c"
				const gchar* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				const gchar* _tmp61_ = NULL;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				gchar* _tmp66_ = NULL;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp57_ = token;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp58_ = token;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp59_ = strlen (_tmp58_);
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp60_ = _tmp59_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp61_ = california_calendar_FMT_PM;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp62_ = g_utf8_casefold (_tmp61_, (gssize) (-1));
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp63_ = _tmp62_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp64_ = strlen (_tmp63_);
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp65_ = _tmp64_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp66_ = string_slice (_tmp57_, (glong) 0, (glong) (_tmp60_ - _tmp65_));
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (token);
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				token = _tmp66_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (_tmp63_);
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				pm = TRUE;
#line 933 "calendar-wall-time.c"
			} else {
				const gchar* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_ = NULL;
				gboolean _tmp71_ = FALSE;
				gboolean _tmp72_ = FALSE;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp67_ = token;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp68_ = california_calendar_FMT_BRIEF_PM;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp69_ = g_utf8_casefold (_tmp68_, (gssize) (-1));
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp70_ = _tmp69_;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp71_ = g_str_has_suffix (_tmp67_, _tmp70_);
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp72_ = _tmp71_;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (_tmp70_);
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				if (_tmp72_) {
#line 957 "calendar-wall-time.c"
					const gchar* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					gint _tmp75_ = 0;
					gint _tmp76_ = 0;
					const gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
					gchar* _tmp79_ = NULL;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gchar* _tmp82_ = NULL;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp73_ = token;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp74_ = token;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp75_ = strlen (_tmp74_);
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp76_ = _tmp75_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp77_ = california_calendar_FMT_BRIEF_PM;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp78_ = g_utf8_casefold (_tmp77_, (gssize) (-1));
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp79_ = _tmp78_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp80_ = strlen (_tmp79_);
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp81_ = _tmp80_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp82_ = string_slice (_tmp73_, (glong) 0, (glong) (_tmp76_ - _tmp81_));
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_g_free0 (token);
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					token = _tmp82_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_g_free0 (_tmp79_);
#line 165 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					pm = TRUE;
#line 996 "calendar-wall-time.c"
				} else {
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					meridiem_unknown = TRUE;
#line 1000 "calendar-wall-time.c"
				}
			}
		}
	}
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp83_ = token;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp84_ = string_replace (_tmp83_, ":", "");
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp84_;
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp85_ = token;
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp86_ = strlen (_tmp85_);
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp87_ = _tmp86_;
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	length = _tmp87_;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp90_ = token;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp91_ = california_string_is_numeric (_tmp90_);
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp91_) {
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp89_ = TRUE;
#line 1029 "calendar-wall-time.c"
	} else {
		gint _tmp92_ = 0;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp92_ = length;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp89_ = _tmp92_ == 0;
#line 1036 "calendar-wall-time.c"
	}
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp89_) {
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp88_ = TRUE;
#line 1042 "calendar-wall-time.c"
	} else {
		gint _tmp93_ = 0;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp93_ = length;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp88_ = _tmp93_ > 4;
#line 1049 "calendar-wall-time.c"
	}
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp88_) {
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1061 "calendar-wall-time.c"
		}
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1065 "calendar-wall-time.c"
	}
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp95_ = length;
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp95_ == 3) {
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp94_ = TRUE;
#line 1073 "calendar-wall-time.c"
	} else {
		gint _tmp96_ = 0;
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp96_ = length;
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp94_ = _tmp96_ == 4;
#line 1080 "calendar-wall-time.c"
	}
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp94_) {
#line 1084 "calendar-wall-time.c"
		gint h = 0;
		gint m = 0;
		gint _tmp97_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		gboolean _tmp120_ = FALSE;
		gint _tmp121_ = 0;
		gboolean _tmp123_ = FALSE;
		gboolean _tmp124_ = FALSE;
		gboolean _tmp125_ = FALSE;
		gint _tmp126_ = 0;
		gint _tmp130_ = 0;
		gint _tmp131_ = 0;
		CaliforniaCalendarWallTime* _tmp132_ = NULL;
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp97_ = length;
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp97_ == 3) {
#line 1104 "calendar-wall-time.c"
			const gchar* _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			gint _tmp101_ = 0;
			const gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gint _tmp105_ = 0;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp98_ = token;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp99_ = string_slice (_tmp98_, (glong) 0, (glong) 1);
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp100_ = _tmp99_;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp101_ = atoi (_tmp100_);
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp101_;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp100_);
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp102_ = token;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp103_ = string_slice (_tmp102_, (glong) 1, (glong) 3);
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp104_ = _tmp103_;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp105_ = atoi (_tmp104_);
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp105_;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp104_);
#line 1137 "calendar-wall-time.c"
		} else {
			const gchar* _tmp106_ = NULL;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gint _tmp109_ = 0;
			const gchar* _tmp110_ = NULL;
			gchar* _tmp111_ = NULL;
			gchar* _tmp112_ = NULL;
			gint _tmp113_ = 0;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp106_ = token;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp107_ = string_slice (_tmp106_, (glong) 0, (glong) 2);
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp108_ = _tmp107_;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp109_ = atoi (_tmp108_);
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp109_;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp108_);
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp110_ = token;
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp111_ = string_slice (_tmp110_, (glong) 2, (glong) 4);
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp112_ = _tmp111_;
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp113_ = atoi (_tmp112_);
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp113_;
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp112_);
#line 1171 "calendar-wall-time.c"
		}
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp116_ = meridiem_unknown;
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (!_tmp116_) {
#line 1177 "calendar-wall-time.c"
			gboolean _tmp117_ = FALSE;
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp117_ = pm;
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp115_ = _tmp117_;
#line 1183 "calendar-wall-time.c"
		} else {
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp115_ = FALSE;
#line 1187 "calendar-wall-time.c"
		}
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp115_) {
#line 1191 "calendar-wall-time.c"
			gint _tmp118_ = 0;
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp118_ = h;
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp114_ = _tmp118_ != 12;
#line 1197 "calendar-wall-time.c"
		} else {
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp114_ = FALSE;
#line 1201 "calendar-wall-time.c"
		}
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp114_) {
#line 1205 "calendar-wall-time.c"
			gint _tmp119_ = 0;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp119_ = h;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp119_ + 12;
#line 1211 "calendar-wall-time.c"
		}
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp121_ = h;
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp121_ == 24) {
#line 1217 "calendar-wall-time.c"
			gint _tmp122_ = 0;
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp122_ = m;
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp120_ = _tmp122_ == 0;
#line 1223 "calendar-wall-time.c"
		} else {
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp120_ = FALSE;
#line 1227 "calendar-wall-time.c"
		}
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp120_) {
#line 196 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = 0;
#line 1233 "calendar-wall-time.c"
		}
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp126_ = h;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp126_ < CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR) {
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp125_ = TRUE;
#line 1241 "calendar-wall-time.c"
		} else {
			gint _tmp127_ = 0;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp127_ = h;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp125_ = _tmp127_ > CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR;
#line 1248 "calendar-wall-time.c"
		}
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp125_) {
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp124_ = TRUE;
#line 1254 "calendar-wall-time.c"
		} else {
			gint _tmp128_ = 0;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp128_ = m;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp124_ = _tmp128_ < CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE;
#line 1261 "calendar-wall-time.c"
		}
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp124_) {
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp123_ = TRUE;
#line 1267 "calendar-wall-time.c"
		} else {
			gint _tmp129_ = 0;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp129_ = m;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp123_ = _tmp129_ > CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE;
#line 1274 "calendar-wall-time.c"
		}
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp123_) {
#line 201 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = NULL;
#line 201 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 201 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (strictly_parsed) {
#line 201 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				*strictly_parsed = _vala_strictly_parsed;
#line 1286 "calendar-wall-time.c"
			}
#line 201 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 1290 "calendar-wall-time.c"
		}
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp130_ = h;
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp131_ = m;
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp132_ = california_calendar_wall_time_new (_tmp130_, _tmp131_, 0);
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp132_;
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1308 "calendar-wall-time.c"
		}
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1312 "calendar-wall-time.c"
	}
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp133_ = token;
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp134_ = atoi (_tmp133_);
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	h = _tmp134_;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp137_ = meridiem_unknown;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp137_) {
#line 1324 "calendar-wall-time.c"
		gboolean _tmp138_ = FALSE;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp138_ = pm;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp136_ = _tmp138_;
#line 1330 "calendar-wall-time.c"
	} else {
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp136_ = FALSE;
#line 1334 "calendar-wall-time.c"
	}
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp136_) {
#line 1338 "calendar-wall-time.c"
		gint _tmp139_ = 0;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp139_ = h;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp135_ = _tmp139_ != 12;
#line 1344 "calendar-wall-time.c"
	} else {
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp135_ = FALSE;
#line 1348 "calendar-wall-time.c"
	}
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp135_) {
#line 1352 "calendar-wall-time.c"
		gint _tmp140_ = 0;
#line 212 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp140_ = h;
#line 212 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		h = _tmp140_ + 12;
#line 1358 "calendar-wall-time.c"
	}
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp141_ = h;
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp141_ == 24) {
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		h = 0;
#line 1366 "calendar-wall-time.c"
	}
#line 219 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp143_ = h;
#line 219 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp143_ < CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR) {
#line 219 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp142_ = TRUE;
#line 1374 "calendar-wall-time.c"
	} else {
		gint _tmp144_ = 0;
#line 219 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp144_ = h;
#line 219 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp142_ = _tmp144_ > CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR;
#line 1381 "calendar-wall-time.c"
	}
#line 219 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp142_) {
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1393 "calendar-wall-time.c"
		}
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1397 "calendar-wall-time.c"
	}
#line 222 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp145_ = meridiem_unknown;
#line 222 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = !_tmp145_;
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp146_ = h;
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp147_ = california_calendar_wall_time_new (_tmp146_, 0, 0);
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp147_;
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (strictly_parsed) {
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*strictly_parsed = _vala_strictly_parsed;
#line 1415 "calendar-wall-time.c"
	}
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1419 "calendar-wall-time.c"
}


/**
     * Returns {@link WallTime} adjusted before or after this one.
     *
     * To subtract time, use a negative value.
     *
     * Like a wall clock, this will rollover to the next or previous day if enough time is
     * specified.  When this occurs, it's indicated in the rollover bool as an out result.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self ? g_object_ref (self) : NULL;
#line 1434 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	gint new_hour = 0;
	gint _tmp2_ = 0;
	gint new_minute = 0;
	gint _tmp3_ = 0;
	gint new_second = 0;
	gint _tmp4_ = 0;
	CaliforniaCalendarTimeUnit _tmp5_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	CaliforniaCalendarWallTime* _tmp15_ = NULL;
#line 235 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 236 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 236 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 1459 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1471 "calendar-wall-time.c"
		}
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1475 "calendar-wall-time.c"
	}
#line 242 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_hour;
#line 242 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_hour = _tmp2_;
#line 243 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = self->priv->_minute;
#line 243 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_minute = _tmp3_;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = self->priv->_second;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_second = _tmp4_;
#line 246 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = unit;
#line 246 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp5_) {
#line 246 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 1495 "calendar-wall-time.c"
		{
			gint _tmp6_ = 0;
			gboolean _tmp7_ = FALSE;
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp6_ = value;
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, &new_hour, _tmp6_, &_tmp7_);
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp7_;
#line 249 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1507 "calendar-wall-time.c"
		}
#line 246 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 1511 "calendar-wall-time.c"
		{
			gint _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
#line 252 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = value;
#line 252 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, &new_hour, &new_minute, _tmp8_, &_tmp9_);
#line 252 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp9_;
#line 253 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1523 "calendar-wall-time.c"
		}
#line 246 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 1527 "calendar-wall-time.c"
		{
			gint _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
#line 256 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp10_ = value;
#line 256 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_second (self, &new_hour, &new_minute, &new_second, _tmp10_, &_tmp11_);
#line 256 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp11_;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1539 "calendar-wall-time.c"
		}
		default:
		{
#line 260 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 1545 "calendar-wall-time.c"
		}
	}
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp12_ = new_hour;
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp13_ = new_minute;
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = new_second;
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = california_calendar_wall_time_new (_tmp12_, _tmp13_, _tmp14_);
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp15_;
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1562 "calendar-wall-time.c"
	}
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1566 "calendar-wall-time.c"
}


static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint rem = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 270 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 270 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1592 "calendar-wall-time.c"
		}
#line 270 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1596 "calendar-wall-time.c"
	}
#line 275 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 275 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 275 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp2_ % CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1608 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = rem;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1614 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = rem;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1621 "calendar-wall-time.c"
	}
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = *current_hour;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_hour = _tmp7_ + _tmp3_;
#line 279 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = *current_hour;
#line 279 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ < 0) {
#line 1631 "calendar-wall-time.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 280 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = *current_hour;
#line 280 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = abs (_tmp9_);
#line 280 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_hour = CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - _tmp10_;
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = TRUE;
#line 1642 "calendar-wall-time.c"
	} else {
		gint _tmp11_ = 0;
#line 282 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp11_ = *current_hour;
#line 282 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp11_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 1649 "calendar-wall-time.c"
			gint _tmp12_ = 0;
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp12_ = *current_hour;
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_hour = _tmp12_ - CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = TRUE;
#line 1657 "calendar-wall-time.c"
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 285 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp13_ = value;
#line 285 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp14_ = abs (_tmp13_);
#line 285 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp14_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 286 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = TRUE;
#line 1669 "calendar-wall-time.c"
			} else {
#line 288 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = FALSE;
#line 1673 "calendar-wall-time.c"
			}
		}
	}
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1681 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint hours = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 293 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 293 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1714 "calendar-wall-time.c"
		}
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1718 "calendar-wall-time.c"
	}
#line 299 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 299 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 299 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	hours = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1730 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = hours;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1736 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = hours;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1743 "calendar-wall-time.c"
	}
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_hour (self, current_hour, _tmp3_, &_tmp7_);
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1759 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1765 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1772 "calendar-wall-time.c"
	}
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_minute;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_minute = _tmp14_ + _tmp10_;
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_minute;
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1782 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_minute;
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_minute = CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - _tmp17_;
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_hour (self, current_hour, -1, &_tmp18_);
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1805 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1812 "calendar-wall-time.c"
		}
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1816 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 311 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_minute;
#line 311 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR) {
#line 1823 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 312 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_minute;
#line 312 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_minute = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 314 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, current_hour, 1, &_tmp24_);
#line 314 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 1843 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 1850 "calendar-wall-time.c"
			}
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 1854 "calendar-wall-time.c"
		}
	}
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1861 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint minutes = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 321 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 321 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 322 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1894 "calendar-wall-time.c"
		}
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1898 "calendar-wall-time.c"
	}
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	minutes = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1910 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = minutes;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1916 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = minutes;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1923 "calendar-wall-time.c"
	}
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, _tmp3_, &_tmp7_);
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1939 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1945 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1952 "calendar-wall-time.c"
	}
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_second;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_second = _tmp14_ + _tmp10_;
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_second;
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1962 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_second;
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_second = CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - _tmp17_;
#line 338 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, -1, &_tmp18_);
#line 338 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 339 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 339 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 339 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1985 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 339 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 339 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1992 "calendar-wall-time.c"
		}
#line 339 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1996 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 340 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_second;
#line 340 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE) {
#line 2003 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 341 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_second;
#line 341 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_second = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 343 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, 1, &_tmp24_);
#line 343 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 2023 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 2030 "calendar-wall-time.c"
			}
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 2034 "calendar-wall-time.c"
		}
	}
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 2041 "calendar-wall-time.c"
	}
}


/**
     * Round a unit of the {@link WallTime} to a multiple of a supplied value.
     *
     * By rounding wall-clock time, not only is the unit in question rounded down to a multiple of
     * the supplied value, but the lesser units are truncated to zero.  Thus, 17:23:54 rounded down
     * to a multiple of 10 minutes returns 17:20:00.
     *
     * If the {@link TimeUnit} is already a multiple of the value, no change is made (although
     * there's no guarantee that the same WallTime instance will be returned, especially if the
     * lesser units are truncated).
     *
     * A multiple of zero or a negative value is always rounded to the current WallTime.
     *
     * TODO: An interface to round up (which will need to deal with overflow).
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_round_down (CaliforniaCalendarWallTime* self, gint multiple, CaliforniaCalendarTimeUnit time_unit) {
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	gint current = 0;
	CaliforniaCalendarTimeUnit _tmp2_ = 0;
	gint rounded = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	CaliforniaCalendarTimeUnit _tmp11_ = 0;
#line 363 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 364 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = multiple;
#line 364 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ <= 0) {
#line 2079 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2087 "calendar-wall-time.c"
	}
#line 369 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = time_unit;
#line 369 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp2_) {
#line 369 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 2095 "calendar-wall-time.c"
		{
			gint _tmp3_ = 0;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp3_ = self->priv->_hour;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp3_;
#line 372 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 2104 "calendar-wall-time.c"
		}
#line 369 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 2108 "calendar-wall-time.c"
		{
			gint _tmp4_ = 0;
#line 375 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp4_ = self->priv->_minute;
#line 375 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp4_;
#line 376 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 2117 "calendar-wall-time.c"
		}
#line 369 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 2121 "calendar-wall-time.c"
		{
			gint _tmp5_ = 0;
#line 379 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp5_ = self->priv->_second;
#line 379 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp5_;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 2130 "calendar-wall-time.c"
		}
		default:
		{
#line 383 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 2136 "calendar-wall-time.c"
		}
	}
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = current;
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = current;
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = multiple;
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rounded = _tmp6_ - (_tmp7_ % _tmp9_);
#line 388 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = rounded;
#line 388 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp10_ < 0) {
#line 389 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		rounded = 0;
#line 2155 "calendar-wall-time.c"
	}
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = time_unit;
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp11_) {
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 2163 "calendar-wall-time.c"
		{
			gint _tmp12_ = 0;
			CaliforniaCalendarWallTime* _tmp13_ = NULL;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp12_ = rounded;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp13_ = california_calendar_wall_time_new (_tmp12_, 0, 0);
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp13_;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2175 "calendar-wall-time.c"
		}
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 2179 "calendar-wall-time.c"
		{
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			CaliforniaCalendarWallTime* _tmp16_ = NULL;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp14_ = self->priv->_hour;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp15_ = rounded;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp16_ = california_calendar_wall_time_new (_tmp14_, _tmp15_, 0);
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp16_;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2194 "calendar-wall-time.c"
		}
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 2198 "calendar-wall-time.c"
		{
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			CaliforniaCalendarWallTime* _tmp20_ = NULL;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = self->priv->_hour;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = self->priv->_minute;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = rounded;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp20_ = california_calendar_wall_time_new (_tmp17_, _tmp18_, _tmp19_);
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp20_;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2216 "calendar-wall-time.c"
		}
		default:
		{
#line 403 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 2222 "calendar-wall-time.c"
		}
	}
}


/**
     * Returns a prettified, localized user-visible string.
     *
     * The string respects {@link System.is_24hr}.
     */
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags) {
	gchar* result = NULL;
	gboolean include_sec = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp0_ = 0;
	gboolean optional_min = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp1_ = 0;
	gboolean meridiem_post_only = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp2_ = 0;
	gboolean brief_meridiem = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp3_ = 0;
	gboolean is_24hr = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* pm = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* am = NULL;
	const gchar* meridiem = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp53_ = FALSE;
	const gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	const gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
#line 412 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 413 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = flags;
#line 413 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	include_sec = (_tmp0_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS) != 0;
#line 414 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = flags;
#line 414 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	optional_min = (_tmp1_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES) != 0;
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = flags;
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_post_only = (_tmp2_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY) != 0;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = flags;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	brief_meridiem = (_tmp3_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM) != 0;
#line 417 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_system_get_is_24hr ();
#line 417 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 417 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	is_24hr = _tmp5_;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = brief_meridiem;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp7_) {
#line 2296 "calendar-wall-time.c"
		const gchar* _tmp8_ = NULL;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp8_ = california_calendar_FMT_BRIEF_PM;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp8_;
#line 2302 "calendar-wall-time.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = california_calendar_FMT_PM;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp9_;
#line 2309 "calendar-wall-time.c"
	}
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = _tmp6_;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = brief_meridiem;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 2317 "calendar-wall-time.c"
		const gchar* _tmp12_ = NULL;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_FMT_BRIEF_AM;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 2323 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = california_calendar_FMT_AM;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp13_;
#line 2330 "calendar-wall-time.c"
	}
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	am = _tmp10_;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = is_24hr;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp14_) {
#line 424 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		meridiem = "";
#line 2340 "calendar-wall-time.c"
	} else {
		gboolean _tmp15_ = FALSE;
#line 425 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = meridiem_post_only;
#line 425 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp15_) {
#line 2347 "calendar-wall-time.c"
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = california_calendar_wall_time_get_is_pm (self);
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = _tmp17_;
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp18_) {
#line 2357 "calendar-wall-time.c"
				const gchar* _tmp19_ = NULL;
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp19_ = pm;
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = _tmp19_;
#line 2363 "calendar-wall-time.c"
			} else {
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = "";
#line 2367 "calendar-wall-time.c"
			}
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp16_;
#line 2371 "calendar-wall-time.c"
		} else {
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = california_calendar_wall_time_get_is_pm (self);
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp22_ = _tmp21_;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp22_) {
#line 2382 "calendar-wall-time.c"
				const gchar* _tmp23_ = NULL;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp23_ = pm;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp23_;
#line 2388 "calendar-wall-time.c"
			} else {
				const gchar* _tmp24_ = NULL;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp24_ = am;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp24_;
#line 2395 "calendar-wall-time.c"
			}
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp20_;
#line 2399 "calendar-wall-time.c"
		}
	}
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp27_ = optional_min;
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp27_) {
#line 2406 "calendar-wall-time.c"
		gint _tmp28_ = 0;
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp28_ = self->priv->_minute;
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = _tmp28_ == 0;
#line 2412 "calendar-wall-time.c"
	} else {
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = FALSE;
#line 2416 "calendar-wall-time.c"
	}
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp26_) {
#line 2420 "calendar-wall-time.c"
		gboolean _tmp29_ = FALSE;
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp29_ = is_24hr;
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = !_tmp29_;
#line 2426 "calendar-wall-time.c"
	} else {
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = FALSE;
#line 2430 "calendar-wall-time.c"
	}
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp25_) {
#line 2434 "calendar-wall-time.c"
		gint _tmp30_ = 0;
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = is_24hr;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp31_) {
#line 2443 "calendar-wall-time.c"
			gint _tmp32_ = 0;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp32_ = self->priv->_hour;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp30_ = _tmp32_;
#line 2449 "calendar-wall-time.c"
		} else {
			gint _tmp33_ = 0;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp33_ = self->priv->_12hour;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp30_ = _tmp33_;
#line 2456 "calendar-wall-time.c"
		}
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp34_ = meridiem;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = g_strdup_printf ("%d%s", _tmp30_, _tmp34_);
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp35_;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2466 "calendar-wall-time.c"
	}
#line 437 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp36_ = include_sec;
#line 437 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp36_) {
#line 2472 "calendar-wall-time.c"
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp37_ = is_24hr;
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp37_) {
#line 2486 "calendar-wall-time.c"
			const gchar* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp38_ = california_calendar_FMT_24HOUR_MIN;
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp39_ = self->priv->_hour;
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp40_ = self->priv->_minute;
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = g_strdup_printf (_tmp38_, _tmp39_, _tmp40_);
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = _tmp41_;
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp43_ = california_string_reduce_whitespace (_tmp42_);
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp44_ = _tmp43_;
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp42_);
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp44_;
#line 440 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2514 "calendar-wall-time.c"
		}
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp45_ = california_calendar_FMT_12HOUR_MIN_MERIDIEM;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp46_ = self->priv->_12hour;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp47_ = self->priv->_minute;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp48_ = meridiem;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp49_ = g_strdup_printf (_tmp45_, _tmp46_, _tmp47_, _tmp48_);
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp50_ = _tmp49_;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp51_ = california_string_reduce_whitespace (_tmp50_);
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp52_ = _tmp51_;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp50_);
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp52_;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2538 "calendar-wall-time.c"
	}
#line 446 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp53_ = is_24hr;
#line 446 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp53_) {
#line 2544 "calendar-wall-time.c"
		const gchar* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp54_ = california_calendar_FMT_24HOUR_MIN_SEC;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp55_ = self->priv->_hour;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp56_ = self->priv->_minute;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp57_ = self->priv->_second;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp58_ = g_strdup_printf (_tmp54_, _tmp55_, _tmp56_, _tmp57_);
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp59_ = _tmp58_;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp60_ = california_string_reduce_whitespace (_tmp59_);
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp61_ = _tmp60_;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp59_);
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp61_;
#line 447 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2575 "calendar-wall-time.c"
	}
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp62_ = california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp63_ = self->priv->_12hour;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp64_ = self->priv->_minute;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp65_ = self->priv->_second;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp66_ = meridiem;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp67_ = g_strdup_printf (_tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_);
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp68_ = _tmp67_;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp69_ = california_string_reduce_whitespace (_tmp68_);
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp70_ = _tmp69_;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp68_);
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp70_;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2601 "calendar-wall-time.c"
}


static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gint result = 0;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint diff = 0;
	gint _tmp1_ = 0;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	CaliforniaCalendarWallTime* _tmp10_ = NULL;
	gint _tmp11_ = 0;
#line 452 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 452 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), 0);
#line 453 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 453 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (self == _tmp0_) {
#line 454 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = 0;
#line 454 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2633 "calendar-wall-time.c"
	}
#line 456 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_hour;
#line 456 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = other;
#line 456 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_->priv->_hour;
#line 456 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp1_ - _tmp3_;
#line 457 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = diff;
#line 457 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ != 0) {
#line 458 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 458 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2651 "calendar-wall-time.c"
	}
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = self->priv->_minute;
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = other;
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_->priv->_minute;
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp5_ - _tmp7_;
#line 461 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = diff;
#line 461 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ != 0) {
#line 462 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 462 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2669 "calendar-wall-time.c"
	}
#line 464 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = self->priv->_second;
#line 464 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = other;
#line 464 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = _tmp10_->priv->_second;
#line 464 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp9_ - _tmp11_;
#line 464 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2681 "calendar-wall-time.c"
}


static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gboolean result = FALSE;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 467 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 467 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), FALSE);
#line 468 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 468 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 468 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp1_ == 0;
#line 468 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2702 "calendar-wall-time.c"
}


static guint california_calendar_wall_time_real_hash (GeeHashable* base) {
	CaliforniaCalendarWallTime * self;
	guint result = 0U;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 471 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 473 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 473 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_minute;
#line 473 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_second;
#line 473 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = ((((guint) _tmp0_) << 12) | (((guint) _tmp1_) << 6)) | ((guint) _tmp2_);
#line 473 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2724 "calendar-wall-time.c"
}


static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarWallTime * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 476 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 477 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_to_pretty_string (self, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS);
#line 477 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 477 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2740 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__earliest;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2753 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__earliest);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__earliest = _tmp1_;
#line 2768 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__latest;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2781 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__latest);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__latest = _tmp1_;
#line 2796 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2811 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_hour = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "hour");
#line 2825 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_12hour;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2840 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_12hour = _tmp0_;
#line 2852 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_minute;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2867 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_minute = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "minute");
#line 2881 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_second;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2896 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_second = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "second");
#line 2910 "calendar-wall-time.c"
}


gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), FALSE);
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_ >= 12;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2925 "calendar-wall-time.c"
}


static void california_calendar_wall_time_class_init (CaliforniaCalendarWallTimeClass * klass) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarWallTimePrivate));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_wall_time_real_to_string;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_wall_time_get_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_wall_time_set_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_wall_time_finalize;
#line 2942 "calendar-wall-time.c"
	/**
	     * Zero-based hour of the day in 24-hour (or "military") time.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_HOUR, g_param_spec_int ("hour", "hour", "hour", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2948 "calendar-wall-time.c"
	/**
	     * Zero-based minute of the {@link hour}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_MINUTE, g_param_spec_int ("minute", "minute", "minute", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2954 "calendar-wall-time.c"
	/**
	     * Zero-based second of the {@link minute}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_SECOND, g_param_spec_int ("second", "second", "second", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2960 "calendar-wall-time.c"
	/**
	     * Indicates if post-meridiem.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_IS_PM, g_param_spec_boolean ("is-pm", "is-pm", "is-pm", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2966 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_wall_time_real_compare_to;
#line 2975 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_wall_time_real_equal_to;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_wall_time_real_hash;
#line 2986 "calendar-wall-time.c"
}


static void california_calendar_wall_time_instance_init (CaliforniaCalendarWallTime * self) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv = CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE (self);
#line 2993 "calendar-wall-time.c"
}


static void california_calendar_wall_time_finalize (GObject* obj) {
	CaliforniaCalendarWallTime * self;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (california_calendar_wall_time_parent_class)->finalize (obj);
#line 3003 "calendar-wall-time.c"
}


/**
 * An immutable represenation of "wall clock time", that is, an hour, minute, and seconds with no
 * correspondence to a day of a year.
 */
GType california_calendar_wall_time_get_type (void) {
	static volatile gsize california_calendar_wall_time_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarWallTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_wall_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarWallTime), 0, (GInstanceInitFunc) california_calendar_wall_time_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_wall_time_type_id;
		california_calendar_wall_time_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarWallTime", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_wall_time_type_id__volatile, california_calendar_wall_time_type_id);
	}
	return california_calendar_wall_time_type_id__volatile;
}


static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_hour (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_minute (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_second (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_IS_PM:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_boolean (value, california_calendar_wall_time_get_is_pm (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3056 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3062 "calendar-wall-time.c"
	}
}


static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_hour (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_minute (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_second (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3090 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3096 "calendar-wall-time.c"
	}
}



