/* week-pane.c generated by valac 0.24.0, the Vala compiler
 * generated from week-pane.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define CALIFORNIA_VIEW_WEEK_TYPE_PANE (california_view_week_pane_get_type ())
#define CALIFORNIA_VIEW_WEEK_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane))
#define CALIFORNIA_VIEW_WEEK_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPaneClass))
#define CALIFORNIA_VIEW_WEEK_IS_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_VIEW_WEEK_TYPE_PANE))
#define CALIFORNIA_VIEW_WEEK_IS_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_VIEW_WEEK_TYPE_PANE))
#define CALIFORNIA_VIEW_WEEK_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPaneClass))

typedef struct _CaliforniaViewWeekPane CaliforniaViewWeekPane;
typedef struct _CaliforniaViewWeekPaneClass CaliforniaViewWeekPaneClass;
typedef struct _CaliforniaViewWeekPanePrivate CaliforniaViewWeekPanePrivate;

#define CALIFORNIA_VIEW_WEEK_TYPE_GRID (california_view_week_grid_get_type ())
#define CALIFORNIA_VIEW_WEEK_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_VIEW_WEEK_TYPE_GRID, CaliforniaViewWeekGrid))
#define CALIFORNIA_VIEW_WEEK_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_VIEW_WEEK_TYPE_GRID, CaliforniaViewWeekGridClass))
#define CALIFORNIA_VIEW_WEEK_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_VIEW_WEEK_TYPE_GRID))
#define CALIFORNIA_VIEW_WEEK_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_VIEW_WEEK_TYPE_GRID))
#define CALIFORNIA_VIEW_WEEK_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_VIEW_WEEK_TYPE_GRID, CaliforniaViewWeekGridClass))

typedef struct _CaliforniaViewWeekGrid CaliforniaViewWeekGrid;
typedef struct _CaliforniaViewWeekGridClass CaliforniaViewWeekGridClass;

#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;

#define CALIFORNIA_VIEW_TYPE_PALETTE (california_view_palette_get_type ())
#define CALIFORNIA_VIEW_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_VIEW_TYPE_PALETTE, CaliforniaViewPalette))
#define CALIFORNIA_VIEW_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_VIEW_TYPE_PALETTE, CaliforniaViewPaletteClass))
#define CALIFORNIA_VIEW_IS_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_VIEW_TYPE_PALETTE))
#define CALIFORNIA_VIEW_IS_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_VIEW_TYPE_PALETTE))
#define CALIFORNIA_VIEW_PALETTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_VIEW_TYPE_PALETTE, CaliforniaViewPaletteClass))

typedef struct _CaliforniaViewPalette CaliforniaViewPalette;
typedef struct _CaliforniaViewPaletteClass CaliforniaViewPaletteClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIME_UNIT (california_calendar_time_unit_get_type ())

struct _CaliforniaViewWeekPane {
	GtkEventBox parent_instance;
	CaliforniaViewWeekPanePrivate * priv;
};

struct _CaliforniaViewWeekPaneClass {
	GtkEventBoxClass parent_class;
	gboolean (*on_draw) (CaliforniaViewWeekPane* self, cairo_t* ctx);
};

struct _CaliforniaViewWeekPanePrivate {
	CaliforniaViewWeekGrid* _owner;
	gint _line_height_px;
	gint requested_width;
	GtkDrawingArea* canvas;
};

typedef enum  {
	CALIFORNIA_CALENDAR_TIME_UNIT_SECOND,
	CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE,
	CALIFORNIA_CALENDAR_TIME_UNIT_HOUR
} CaliforniaCalendarTimeUnit;


static gpointer california_view_week_pane_parent_class = NULL;

GType california_view_week_pane_get_type (void) G_GNUC_CONST;
GType california_view_week_grid_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_VIEW_WEEK_PANE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPanePrivate))
enum  {
	CALIFORNIA_VIEW_WEEK_PANE_DUMMY_PROPERTY,
	CALIFORNIA_VIEW_WEEK_PANE_OWNER,
	CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX
};
GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_view_palette_get_type (void) G_GNUC_CONST;
CaliforniaViewPalette* california_view_palette_get_instance (void);
static void california_view_week_pane_on_palette_changed (CaliforniaViewWeekPane* self);
static void _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed (CaliforniaViewPalette* _sender, gpointer self);
CaliforniaViewWeekPane* california_view_week_pane_construct (GType object_type, CaliforniaViewWeekGrid* owner, gint requested_width);
static void california_view_week_pane_set_owner (CaliforniaViewWeekPane* self, CaliforniaViewWeekGrid* value);
static void california_view_week_pane_update_palette_metrics (CaliforniaViewWeekPane* self);
gboolean california_view_week_pane_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx);
static gboolean _california_view_week_pane_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
gint california_view_palette_get_normal_font_height_px (CaliforniaViewPalette* self);
#define CALIFORNIA_VIEW_PALETTE_LINE_PADDING_PX 4
static void california_view_week_pane_set_line_height_px (CaliforniaViewWeekPane* self, gint value);
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
gint california_view_week_pane_get_line_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void);
static gboolean california_view_week_pane_real_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx);
cairo_t* california_view_palette_prepare_hairline (cairo_t* ctx, GdkRGBA* rgba);
void california_view_palette_get_border (CaliforniaViewPalette* self, GdkRGBA* result);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void);
GType california_calendar_time_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover);
gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self);
cairo_t* california_view_palette_prepare_hairline_dashed (cairo_t* ctx, GdkRGBA* rgba);
gint california_view_week_pane_get_line_height_px (CaliforniaViewWeekPane* self);
gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self);
#define CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR 60
gint california_view_week_pane_get_text_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time);
CaliforniaCalendarWallTime* california_view_week_pane_get_wall_time (CaliforniaViewWeekPane* self, gint y);
CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second);
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second);
CaliforniaViewWeekGrid* california_view_week_pane_get_owner (CaliforniaViewWeekPane* self);
static void california_view_week_pane_finalize (GObject* obj);
static void _vala_california_view_week_pane_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_view_week_pane_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed (CaliforniaViewPalette* _sender, gpointer self) {
#line 33 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_on_palette_changed ((CaliforniaViewWeekPane*) self);
#line 149 "week-pane.c"
}


static gboolean _california_view_week_pane_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = california_view_week_pane_on_draw ((CaliforniaViewWeekPane*) self, cr);
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 158 "week-pane.c"
}


CaliforniaViewWeekPane* california_view_week_pane_construct (GType object_type, CaliforniaViewWeekGrid* owner, gint requested_width) {
	CaliforniaViewWeekPane * self = NULL;
	CaliforniaViewWeekGrid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkDrawingArea* _tmp2_ = NULL;
	CaliforniaViewPalette* _tmp3_ = NULL;
	CaliforniaViewPalette* _tmp4_ = NULL;
	GtkDrawingArea* _tmp5_ = NULL;
#line 18 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_GRID (owner), NULL);
#line 18 "/home/jim/git/california/src/view/week/week-pane.vala"
	self = (CaliforniaViewWeekPane*) g_object_new (object_type, NULL);
#line 19 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = owner;
#line 19 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_set_owner (self, _tmp0_);
#line 20 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = requested_width;
#line 20 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->requested_width = _tmp1_;
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WIDGET, GtkWidget), "margin", 0, NULL);
#line 24 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = self->priv->canvas;
#line 24 "/home/jim/git/california/src/view/week/week-pane.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_WIDGET, GtkWidget));
#line 26 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_update_palette_metrics (self);
#line 27 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = california_view_palette_get_instance ();
#line 27 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = _tmp3_;
#line 27 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_connect_object (_tmp4_, "palette-changed", (GCallback) _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed, self, 0);
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp5_ = self->priv->canvas;
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_WIDGET, GtkWidget), "draw", (GCallback) _california_view_week_pane_on_draw_gtk_widget_draw, self, 0);
#line 18 "/home/jim/git/california/src/view/week/week-pane.vala"
	return self;
#line 202 "week-pane.c"
}


static void california_view_week_pane_update_palette_metrics (CaliforniaViewWeekPane* self) {
	CaliforniaViewPalette* _tmp0_ = NULL;
	CaliforniaViewPalette* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkDrawingArea* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarWallTime* _tmp7_ = NULL;
	gint _tmp8_ = 0;
#line 36 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = california_view_palette_get_instance ();
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = _tmp0_;
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = california_view_palette_get_normal_font_height_px (_tmp1_);
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = _tmp2_;
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_set_line_height_px (self, _tmp3_ + (CALIFORNIA_VIEW_PALETTE_LINE_PADDING_PX * 2));
#line 42 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = self->priv->canvas;
#line 42 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp5_ = self->priv->requested_width;
#line 42 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp6_ = california_calendar_wall_time_get_latest ();
#line 42 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp7_ = _tmp6_;
#line 42 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp8_ = california_view_week_pane_get_line_y (self, _tmp7_);
#line 42 "/home/jim/git/california/src/view/week/week-pane.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_WIDGET, GtkWidget), _tmp5_, _tmp8_);
#line 240 "week-pane.c"
}


static void california_view_week_pane_on_palette_changed (CaliforniaViewWeekPane* self) {
#line 45 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 46 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_update_palette_metrics (self);
#line 47 "/home/jim/git/california/src/view/week/week-pane.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WIDGET, GtkWidget));
#line 251 "week-pane.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 65 "/home/jim/git/california/src/view/week/week-pane.vala"
	return self ? g_object_ref (self) : NULL;
#line 258 "week-pane.c"
}


static gboolean california_view_week_pane_real_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx) {
	gboolean result = FALSE;
	gint width = 0;
	gint _tmp0_ = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	CaliforniaViewPalette* _tmp4_ = NULL;
	CaliforniaViewPalette* _tmp5_ = NULL;
	GdkRGBA _tmp6_ = {0};
	GdkRGBA _tmp7_ = {0};
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	cairo_t* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	cairo_t* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	cairo_t* _tmp17_ = NULL;
	CaliforniaCalendarWallTime* wall_time = NULL;
	CaliforniaCalendarWallTime* _tmp18_ = NULL;
	CaliforniaCalendarWallTime* _tmp19_ = NULL;
	CaliforniaCalendarWallTime* _tmp20_ = NULL;
	cairo_t* _tmp51_ = NULL;
#line 50 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 51 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WIDGET, GtkWidget));
#line 51 "/home/jim/git/california/src/view/week/week-pane.vala"
	width = _tmp0_;
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WIDGET, GtkWidget));
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	height = _tmp1_;
#line 55 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = ctx;
#line 55 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_save (_tmp2_);
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = ctx;
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = california_view_palette_get_instance ();
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp5_ = _tmp4_;
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_palette_get_border (_tmp5_, &_tmp6_);
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp7_ = _tmp6_;
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp8_ = california_view_palette_prepare_hairline (_tmp3_, &_tmp7_);
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp9_ = _tmp8_;
#line 58 "/home/jim/git/california/src/view/week/week-pane.vala"
	_cairo_destroy0 (_tmp9_);
#line 59 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp10_ = ctx;
#line 59 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp11_ = width;
#line 59 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_move_to (_tmp10_, (gdouble) _tmp11_, (gdouble) 0);
#line 60 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp12_ = ctx;
#line 60 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp13_ = width;
#line 60 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp14_ = height;
#line 60 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_line_to (_tmp12_, (gdouble) _tmp13_, (gdouble) _tmp14_);
#line 61 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp15_ = ctx;
#line 61 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp16_ = height;
#line 61 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_line_to (_tmp15_, (gdouble) 0, (gdouble) _tmp16_);
#line 62 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp17_ = ctx;
#line 62 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_stroke (_tmp17_);
#line 65 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp18_ = california_calendar_wall_time_get_earliest ();
#line 65 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp19_ = _tmp18_;
#line 65 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp20_ = _g_object_ref0 (_tmp19_);
#line 65 "/home/jim/git/california/src/view/week/week-pane.vala"
	wall_time = _tmp20_;
#line 351 "week-pane.c"
	{
		gboolean _tmp21_ = FALSE;
#line 66 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp21_ = TRUE;
#line 66 "/home/jim/git/california/src/view/week/week-pane.vala"
		while (TRUE) {
#line 358 "week-pane.c"
			gboolean rollover = FALSE;
			CaliforniaCalendarWallTime* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			CaliforniaCalendarWallTime* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			gint line_y = 0;
			CaliforniaCalendarWallTime* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			CaliforniaCalendarWallTime* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			cairo_t* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			cairo_t* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			cairo_t* _tmp50_ = NULL;
#line 66 "/home/jim/git/california/src/view/week/week-pane.vala"
			if (!_tmp21_) {
#line 378 "week-pane.c"
			}
#line 66 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp21_ = FALSE;
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp22_ = wall_time;
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp24_ = california_calendar_wall_time_adjust (_tmp22_, 30, CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE, &_tmp23_);
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
			rollover = _tmp23_;
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
			_g_object_unref0 (wall_time);
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
			wall_time = _tmp24_;
#line 69 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp25_ = rollover;
#line 69 "/home/jim/git/california/src/view/week/week-pane.vala"
			if (_tmp25_) {
#line 70 "/home/jim/git/california/src/view/week/week-pane.vala"
				break;
#line 398 "week-pane.c"
			}
#line 72 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp26_ = wall_time;
#line 72 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp27_ = california_view_week_pane_get_line_y (self, _tmp26_);
#line 72 "/home/jim/git/california/src/view/week/week-pane.vala"
			line_y = _tmp27_;
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp28_ = wall_time;
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp29_ = california_calendar_wall_time_get_minute (_tmp28_);
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp30_ = _tmp29_;
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
			if (_tmp30_ == 0) {
#line 414 "week-pane.c"
				cairo_t* _tmp31_ = NULL;
				CaliforniaViewPalette* _tmp32_ = NULL;
				CaliforniaViewPalette* _tmp33_ = NULL;
				GdkRGBA _tmp34_ = {0};
				GdkRGBA _tmp35_ = {0};
				cairo_t* _tmp36_ = NULL;
				cairo_t* _tmp37_ = NULL;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp31_ = ctx;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp32_ = california_view_palette_get_instance ();
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp33_ = _tmp32_;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				california_view_palette_get_border (_tmp33_, &_tmp34_);
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp35_ = _tmp34_;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp36_ = california_view_palette_prepare_hairline (_tmp31_, &_tmp35_);
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp37_ = _tmp36_;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
				_cairo_destroy0 (_tmp37_);
#line 438 "week-pane.c"
			} else {
				cairo_t* _tmp38_ = NULL;
				CaliforniaViewPalette* _tmp39_ = NULL;
				CaliforniaViewPalette* _tmp40_ = NULL;
				GdkRGBA _tmp41_ = {0};
				GdkRGBA _tmp42_ = {0};
				cairo_t* _tmp43_ = NULL;
				cairo_t* _tmp44_ = NULL;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp38_ = ctx;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp39_ = california_view_palette_get_instance ();
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp40_ = _tmp39_;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				california_view_palette_get_border (_tmp40_, &_tmp41_);
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp42_ = _tmp41_;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp43_ = california_view_palette_prepare_hairline_dashed (_tmp38_, &_tmp42_);
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp44_ = _tmp43_;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
				_cairo_destroy0 (_tmp44_);
#line 463 "week-pane.c"
			}
#line 80 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp45_ = ctx;
#line 80 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp46_ = line_y;
#line 80 "/home/jim/git/california/src/view/week/week-pane.vala"
			cairo_move_to (_tmp45_, (gdouble) 0, (gdouble) _tmp46_);
#line 81 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp47_ = ctx;
#line 81 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp48_ = width;
#line 81 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp49_ = line_y;
#line 81 "/home/jim/git/california/src/view/week/week-pane.vala"
			cairo_line_to (_tmp47_, (gdouble) _tmp48_, (gdouble) _tmp49_);
#line 82 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp50_ = ctx;
#line 82 "/home/jim/git/california/src/view/week/week-pane.vala"
			cairo_stroke (_tmp50_);
#line 483 "week-pane.c"
		}
	}
#line 85 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp51_ = ctx;
#line 85 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_restore (_tmp51_);
#line 87 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = TRUE;
#line 87 "/home/jim/git/california/src/view/week/week-pane.vala"
	_g_object_unref0 (wall_time);
#line 87 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 496 "week-pane.c"
}


gboolean california_view_week_pane_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx) {
#line 50 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), FALSE);
#line 50 "/home/jim/git/california/src/view/week/week-pane.vala"
	return CALIFORNIA_VIEW_WEEK_PANE_GET_CLASS (self)->on_draw (self, ctx);
#line 505 "week-pane.c"
}


/**
     * Returns the y (in pixels) for a particular line of text for the {@link Calendar.WallTime}.
     *
     * If displaying text, use {@link get_text_y}, as that will deduct padding.
     */
gint california_view_week_pane_get_line_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time) {
	gint result = 0;
	gint line_y = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 95 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), 0);
#line 95 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (wall_time), 0);
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_line_height_px;
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = wall_time;
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = california_calendar_wall_time_get_hour (_tmp1_);
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = _tmp2_;
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	line_y = (_tmp0_ * 2) * _tmp3_;
#line 100 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = wall_time;
#line 100 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp5_ = california_calendar_wall_time_get_minute (_tmp4_);
#line 100 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp6_ = _tmp5_;
#line 100 "/home/jim/git/california/src/view/week/week-pane.vala"
	if (_tmp6_ != 0) {
#line 546 "week-pane.c"
		gdouble fraction = 0.0;
		CaliforniaCalendarWallTime* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gdouble amt = 0.0;
		gint _tmp10_ = 0;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
#line 101 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp7_ = wall_time;
#line 101 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp8_ = california_calendar_wall_time_get_minute (_tmp7_);
#line 101 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp9_ = _tmp8_;
#line 101 "/home/jim/git/california/src/view/week/week-pane.vala"
		fraction = ((gdouble) _tmp9_) / ((gdouble) CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR);
#line 102 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp10_ = self->priv->_line_height_px;
#line 102 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp11_ = fraction;
#line 102 "/home/jim/git/california/src/view/week/week-pane.vala"
		amt = (((gdouble) _tmp10_) * 2.0) * _tmp11_;
#line 104 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp12_ = line_y;
#line 104 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp13_ = amt;
#line 104 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp14_ = round (_tmp13_);
#line 104 "/home/jim/git/california/src/view/week/week-pane.vala"
		line_y = _tmp12_ + ((gint) _tmp14_);
#line 579 "week-pane.c"
	}
#line 107 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = line_y;
#line 107 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 585 "week-pane.c"
}


/**
     * Returns the y (in pixels) for the top of a line of text at {@link Calendar.WallTime}.
     *
     * Use this when displaying text.  Drawing lines, borders, etc. should use {@link get_line_y}.
     */
gint california_view_week_pane_get_text_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time) {
	gint result = 0;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 115 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), 0);
#line 115 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (wall_time), 0);
#line 116 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = wall_time;
#line 116 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = california_view_week_pane_get_line_y (self, _tmp0_);
#line 116 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp1_ + CALIFORNIA_VIEW_PALETTE_LINE_PADDING_PX;
#line 116 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 610 "week-pane.c"
}


/**
     * Returns the {@link Calendar.WallTime} for a y-coordinate down to the minute;
     */
CaliforniaCalendarWallTime* california_view_week_pane_get_wall_time (CaliforniaViewWeekPane* self, gint y) {
	CaliforniaCalendarWallTime* result = NULL;
	gint one_hour = 0;
	gint _tmp0_ = 0;
	gint hour = 0;
	gint _tmp1_ = 0;
	gint rem = 0;
	gint _tmp2_ = 0;
	gdouble min = 0.0;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
#line 122 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), NULL);
#line 124 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_line_height_px;
#line 124 "/home/jim/git/california/src/view/week/week-pane.vala"
	one_hour = _tmp0_ * 2;
#line 126 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = y;
#line 126 "/home/jim/git/california/src/view/week/week-pane.vala"
	hour = _tmp1_ / one_hour;
#line 127 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = y;
#line 127 "/home/jim/git/california/src/view/week/week-pane.vala"
	rem = _tmp2_ % one_hour;
#line 128 "/home/jim/git/california/src/view/week/week-pane.vala"
	min = (((gdouble) rem) / ((gdouble) one_hour)) * 60.0;
#line 130 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = california_calendar_wall_time_new (hour, (gint) min, 0);
#line 130 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp3_;
#line 130 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 649 "week-pane.c"
}


CaliforniaViewWeekGrid* california_view_week_pane_get_owner (CaliforniaViewWeekPane* self) {
	CaliforniaViewWeekGrid* result;
	CaliforniaViewWeekGrid* _tmp0_ = NULL;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), NULL);
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_owner;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp0_;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 664 "week-pane.c"
}


static void california_view_week_pane_set_owner (CaliforniaViewWeekPane* self, CaliforniaViewWeekGrid* value) {
	CaliforniaViewWeekGrid* _tmp0_ = NULL;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = value;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->_owner = _tmp0_;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_notify ((GObject *) self, "owner");
#line 678 "week-pane.c"
}


gint california_view_week_pane_get_line_height_px (CaliforniaViewWeekPane* self) {
	gint result;
	gint _tmp0_ = 0;
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), 0);
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_line_height_px;
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp0_;
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 693 "week-pane.c"
}


static void california_view_week_pane_set_line_height_px (CaliforniaViewWeekPane* self, gint value) {
	gint _tmp0_ = 0;
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = value;
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->_line_height_px = _tmp0_;
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_notify ((GObject *) self, "line-height-px");
#line 707 "week-pane.c"
}


static void california_view_week_pane_class_init (CaliforniaViewWeekPaneClass * klass) {
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_parent_class = g_type_class_peek_parent (klass);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaViewWeekPanePrivate));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	CALIFORNIA_VIEW_WEEK_PANE_CLASS (klass)->on_draw = california_view_week_pane_real_on_draw;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_view_week_pane_get_property;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_view_week_pane_set_property;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (klass)->finalize = california_view_week_pane_finalize;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_VIEW_WEEK_PANE_OWNER, g_param_spec_object ("owner", "owner", "owner", CALIFORNIA_VIEW_WEEK_TYPE_GRID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX, g_param_spec_int ("line-height-px", "line-height-px", "line-height-px", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 728 "week-pane.c"
}


static void california_view_week_pane_instance_init (CaliforniaViewWeekPane * self) {
	GtkDrawingArea* _tmp0_ = NULL;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv = CALIFORNIA_VIEW_WEEK_PANE_GET_PRIVATE (self);
#line 13 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->_line_height_px = 0;
#line 16 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 16 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_ref_sink (_tmp0_);
#line 16 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->canvas = _tmp0_;
#line 744 "week-pane.c"
}


static void california_view_week_pane_finalize (GObject* obj) {
	CaliforniaViewWeekPane * self;
	CaliforniaViewPalette* _tmp0_ = NULL;
	CaliforniaViewPalette* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane);
#line 33 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = california_view_palette_get_instance ();
#line 33 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = _tmp0_;
#line 33 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_parse_name ("palette-changed", CALIFORNIA_VIEW_TYPE_PALETTE, &_tmp2_, NULL, FALSE);
#line 33 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed, self);
#line 16 "/home/jim/git/california/src/view/week/week-pane.vala"
	_g_object_unref0 (self->priv->canvas);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (california_view_week_pane_parent_class)->finalize (obj);
#line 767 "week-pane.c"
}


GType california_view_week_pane_get_type (void) {
	static volatile gsize california_view_week_pane_type_id__volatile = 0;
	if (g_once_init_enter (&california_view_week_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaViewWeekPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_view_week_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaViewWeekPane), 0, (GInstanceInitFunc) california_view_week_pane_instance_init, NULL };
		GType california_view_week_pane_type_id;
		california_view_week_pane_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "CaliforniaViewWeekPane", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&california_view_week_pane_type_id__volatile, california_view_week_pane_type_id);
	}
	return california_view_week_pane_type_id__volatile;
}


static void _vala_california_view_week_pane_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaViewWeekPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	switch (property_id) {
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_OWNER:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		g_value_set_object (value, california_view_week_pane_get_owner (self));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		g_value_set_int (value, california_view_week_pane_get_line_height_px (self));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 800 "week-pane.c"
		default:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 806 "week-pane.c"
	}
}


static void _vala_california_view_week_pane_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaViewWeekPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	switch (property_id) {
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_OWNER:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		california_view_week_pane_set_owner (self, g_value_get_object (value));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		california_view_week_pane_set_line_height_px (self, g_value_get_int (value));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 828 "week-pane.c"
		default:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 834 "week-pane.c"
	}
}



