/* util-gfx.c generated by valac 0.24.0, the Vala compiler
 * generated from util-gfx.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>




void california_gfx_rgb_string_to_rgb (const gchar* rgb_string, GdkColor* default_rgb, gboolean* used_default, GdkColor* result);
gboolean california_string_is_empty (const gchar* str);
void california_gfx_rgb_string_to_rgba (const gchar* rgb_string, GdkRGBA* default_rgba, gboolean* used_default, GdkRGBA* result);
gdouble california_gfx_uint16_to_fp (guint16 value);
guint32 california_gfx_rgba_to_pixel (GdkRGBA* rgba);
guint8 california_gfx_fp_to_uint8 (gdouble value);
void california_gfx_rgba_to_rgb (GdkRGBA* rgba, GdkColor* result);
guint16 california_gfx_fp_to_uint16 (gdouble value);
gchar* california_gfx_rgb_to_uint8_rgb_string (GdkColor* rgb);
guint8 california_gfx_uint16_to_uint8 (guint16 value);
gchar* california_gfx_rgb_to_string (GdkColor* rgb);
gchar* california_gfx_rgba_to_string (GdkRGBA* rgba);

const GdkColor CALIFORNIA_GFX_RGB_BLACK = {(guint32) 0, (guint16) 0, (guint16) 0};
const GdkColor CALIFORNIA_GFX_RGB_WHITE = {(guint32) 255, (guint16) 255, (guint16) 255};
const GdkRGBA CALIFORNIA_GFX_RGBA_BLACK = {0.0, 0.0, 0.0, 1.0};
const GdkRGBA CALIFORNIA_GFX_RGBA_WHITE = {1.0, 1.0, 1.0, 1.0};

/**
 * Convert an RGB string into an RGB structure.
 *
 * The string can be in any of the forms that Gdk.Color.parse accepts.  If unable to parse the
 * string, the {@link default_rgb} is returned and {@link used_default} is set to true.
 */
void california_gfx_rgb_string_to_rgb (const gchar* rgb_string, GdkColor* default_rgb, gboolean* used_default, GdkColor* result) {
	gboolean _vala_used_default = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkColor rgb = {0};
	const gchar* _tmp3_ = NULL;
	GdkColor _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
#line 21 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_if_fail (default_rgb != NULL);
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = rgb_string;
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 22 "/home/jim/git/california/src/util/util-gfx.vala"
	if (_tmp1_) {
#line 62 "util-gfx.c"
		GdkColor _tmp2_ = {0};
#line 23 "/home/jim/git/california/src/util/util-gfx.vala"
		_vala_used_default = TRUE;
#line 25 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp2_ = *default_rgb;
#line 25 "/home/jim/git/california/src/util/util-gfx.vala"
		*result = _tmp2_;
#line 25 "/home/jim/git/california/src/util/util-gfx.vala"
		if (used_default) {
#line 25 "/home/jim/git/california/src/util/util-gfx.vala"
			*used_default = _vala_used_default;
#line 74 "util-gfx.c"
		}
#line 25 "/home/jim/git/california/src/util/util-gfx.vala"
		return;
#line 78 "util-gfx.c"
	}
#line 29 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = rgb_string;
#line 29 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = gdk_color_parse (_tmp3_, &_tmp4_);
#line 29 "/home/jim/git/california/src/util/util-gfx.vala"
	rgb = _tmp4_;
#line 29 "/home/jim/git/california/src/util/util-gfx.vala"
	if (!_tmp5_) {
#line 88 "util-gfx.c"
		const gchar* _tmp6_ = NULL;
		GdkColor _tmp7_ = {0};
#line 30 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp6_ = rgb_string;
#line 30 "/home/jim/git/california/src/util/util-gfx.vala"
		g_debug ("util-gfx.vala:30: Unable to parse RGB color \"%s\"", _tmp6_);
#line 32 "/home/jim/git/california/src/util/util-gfx.vala"
		_vala_used_default = TRUE;
#line 34 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp7_ = *default_rgb;
#line 34 "/home/jim/git/california/src/util/util-gfx.vala"
		*result = _tmp7_;
#line 34 "/home/jim/git/california/src/util/util-gfx.vala"
		if (used_default) {
#line 34 "/home/jim/git/california/src/util/util-gfx.vala"
			*used_default = _vala_used_default;
#line 105 "util-gfx.c"
		}
#line 34 "/home/jim/git/california/src/util/util-gfx.vala"
		return;
#line 109 "util-gfx.c"
	}
#line 37 "/home/jim/git/california/src/util/util-gfx.vala"
	_vala_used_default = FALSE;
#line 39 "/home/jim/git/california/src/util/util-gfx.vala"
	*result = rgb;
#line 39 "/home/jim/git/california/src/util/util-gfx.vala"
	if (used_default) {
#line 39 "/home/jim/git/california/src/util/util-gfx.vala"
		*used_default = _vala_used_default;
#line 119 "util-gfx.c"
	}
#line 39 "/home/jim/git/california/src/util/util-gfx.vala"
	return;
#line 123 "util-gfx.c"
}


/**
 * Convert an RGB string into an RGBA structure.
 *
 * The string can be in any of the forms that Gdk.Color.parse accepts.  If unable to parse the
 * string, the {@link default_rgba} is returned and {@link used_default} is set to true.
 */
void california_gfx_rgb_string_to_rgba (const gchar* rgb_string, GdkRGBA* default_rgba, gboolean* used_default, GdkRGBA* result) {
	gboolean _vala_used_default = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkColor rgb = {0};
	const gchar* _tmp3_ = NULL;
	GdkColor _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GdkRGBA rgba = {0};
	GdkColor _tmp8_ = {0};
	guint16 _tmp9_ = 0U;
	gdouble _tmp10_ = 0.0;
	GdkColor _tmp11_ = {0};
	guint16 _tmp12_ = 0U;
	gdouble _tmp13_ = 0.0;
	GdkColor _tmp14_ = {0};
	guint16 _tmp15_ = 0U;
	gdouble _tmp16_ = 0.0;
#line 48 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_if_fail (default_rgba != NULL);
#line 49 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = rgb_string;
#line 49 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 49 "/home/jim/git/california/src/util/util-gfx.vala"
	if (_tmp1_) {
#line 159 "util-gfx.c"
		GdkRGBA _tmp2_ = {0};
#line 50 "/home/jim/git/california/src/util/util-gfx.vala"
		_vala_used_default = TRUE;
#line 52 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp2_ = *default_rgba;
#line 52 "/home/jim/git/california/src/util/util-gfx.vala"
		*result = _tmp2_;
#line 52 "/home/jim/git/california/src/util/util-gfx.vala"
		if (used_default) {
#line 52 "/home/jim/git/california/src/util/util-gfx.vala"
			*used_default = _vala_used_default;
#line 171 "util-gfx.c"
		}
#line 52 "/home/jim/git/california/src/util/util-gfx.vala"
		return;
#line 175 "util-gfx.c"
	}
#line 56 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = rgb_string;
#line 56 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = gdk_color_parse (_tmp3_, &_tmp4_);
#line 56 "/home/jim/git/california/src/util/util-gfx.vala"
	rgb = _tmp4_;
#line 56 "/home/jim/git/california/src/util/util-gfx.vala"
	if (!_tmp5_) {
#line 185 "util-gfx.c"
		const gchar* _tmp6_ = NULL;
		GdkRGBA _tmp7_ = {0};
#line 57 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp6_ = rgb_string;
#line 57 "/home/jim/git/california/src/util/util-gfx.vala"
		g_debug ("util-gfx.vala:57: Unable to parse RGB color \"%s\"", _tmp6_);
#line 59 "/home/jim/git/california/src/util/util-gfx.vala"
		_vala_used_default = TRUE;
#line 61 "/home/jim/git/california/src/util/util-gfx.vala"
		_tmp7_ = *default_rgba;
#line 61 "/home/jim/git/california/src/util/util-gfx.vala"
		*result = _tmp7_;
#line 61 "/home/jim/git/california/src/util/util-gfx.vala"
		if (used_default) {
#line 61 "/home/jim/git/california/src/util/util-gfx.vala"
			*used_default = _vala_used_default;
#line 202 "util-gfx.c"
		}
#line 61 "/home/jim/git/california/src/util/util-gfx.vala"
		return;
#line 206 "util-gfx.c"
	}
#line 64 "/home/jim/git/california/src/util/util-gfx.vala"
	memset (&rgba, 0, sizeof (GdkRGBA));
#line 65 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp8_ = rgb;
#line 65 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp9_ = _tmp8_.red;
#line 65 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp10_ = california_gfx_uint16_to_fp (_tmp9_);
#line 65 "/home/jim/git/california/src/util/util-gfx.vala"
	rgba.red = _tmp10_;
#line 66 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp11_ = rgb;
#line 66 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp12_ = _tmp11_.green;
#line 66 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp13_ = california_gfx_uint16_to_fp (_tmp12_);
#line 66 "/home/jim/git/california/src/util/util-gfx.vala"
	rgba.green = _tmp13_;
#line 67 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp14_ = rgb;
#line 67 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp15_ = _tmp14_.blue;
#line 67 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp16_ = california_gfx_uint16_to_fp (_tmp15_);
#line 67 "/home/jim/git/california/src/util/util-gfx.vala"
	rgba.blue = _tmp16_;
#line 68 "/home/jim/git/california/src/util/util-gfx.vala"
	rgba.alpha = 1.0;
#line 70 "/home/jim/git/california/src/util/util-gfx.vala"
	_vala_used_default = FALSE;
#line 72 "/home/jim/git/california/src/util/util-gfx.vala"
	*result = rgba;
#line 72 "/home/jim/git/california/src/util/util-gfx.vala"
	if (used_default) {
#line 72 "/home/jim/git/california/src/util/util-gfx.vala"
		*used_default = _vala_used_default;
#line 244 "util-gfx.c"
	}
#line 72 "/home/jim/git/california/src/util/util-gfx.vala"
	return;
#line 248 "util-gfx.c"
}


inline gdouble california_gfx_uint16_to_fp (guint16 value) {
	gdouble result = 0.0;
	guint16 _tmp0_ = 0U;
	guint16 _tmp1_ = 0U;
#line 77 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = value;
#line 77 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = G_MAXUINT16;
#line 77 "/home/jim/git/california/src/util/util-gfx.vala"
	result = ((gdouble) _tmp0_) / ((gdouble) _tmp1_);
#line 77 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 264 "util-gfx.c"
}


/**
 * Converts the Gdk.RGBA into a 32-bit pixel representation.
 */
guint32 california_gfx_rgba_to_pixel (GdkRGBA* rgba) {
	guint32 result = 0U;
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	guint8 _tmp2_ = 0U;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	guint8 _tmp5_ = 0U;
	GdkRGBA _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	guint8 _tmp8_ = 0U;
	GdkRGBA _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	guint8 _tmp11_ = 0U;
#line 83 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_val_if_fail (rgba != NULL, 0U);
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = *rgba;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = _tmp0_.red;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = california_gfx_fp_to_uint8 (_tmp1_);
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = *rgba;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = _tmp3_.green;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = california_gfx_fp_to_uint8 (_tmp4_);
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp6_ = *rgba;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp7_ = _tmp6_.blue;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp8_ = california_gfx_fp_to_uint8 (_tmp7_);
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp9_ = *rgba;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp10_ = _tmp9_.alpha;
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp11_ = california_gfx_fp_to_uint8 (_tmp10_);
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	result = (((((guint32) _tmp2_) << 24) | (((guint32) _tmp5_) << 16)) | (((guint32) _tmp8_) << 8)) | ((guint32) _tmp11_);
#line 84 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 315 "util-gfx.c"
}


inline guint8 california_gfx_fp_to_uint8 (gdouble value) {
	guint8 result = 0U;
	gdouble _tmp0_ = 0.0;
	guint8 _tmp1_ = 0U;
	gdouble _tmp2_ = 0.0;
#line 91 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = value;
#line 91 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = G_MAXUINT8;
#line 91 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = round (_tmp0_ * ((gdouble) _tmp1_));
#line 91 "/home/jim/git/california/src/util/util-gfx.vala"
	result = (guint8) _tmp2_;
#line 91 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 334 "util-gfx.c"
}


/**
 * Converts a Gdk.RGBA structure into an RGB (Gdk.Color) structure.
 *
 * The alpha channel is necessarily stripped in this conversion.
 */
void california_gfx_rgba_to_rgb (GdkRGBA* rgba, GdkColor* result) {
	GdkColor rgb = {0};
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	guint16 _tmp2_ = 0U;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	guint16 _tmp5_ = 0U;
	GdkRGBA _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	guint16 _tmp8_ = 0U;
#line 99 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_if_fail (rgba != NULL);
#line 100 "/home/jim/git/california/src/util/util-gfx.vala"
	memset (&rgb, 0, sizeof (GdkColor));
#line 101 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = *rgba;
#line 101 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = _tmp0_.red;
#line 101 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = california_gfx_fp_to_uint16 (_tmp1_);
#line 101 "/home/jim/git/california/src/util/util-gfx.vala"
	rgb.red = _tmp2_;
#line 102 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = *rgba;
#line 102 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = _tmp3_.green;
#line 102 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = california_gfx_fp_to_uint16 (_tmp4_);
#line 102 "/home/jim/git/california/src/util/util-gfx.vala"
	rgb.green = _tmp5_;
#line 103 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp6_ = *rgba;
#line 103 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp7_ = _tmp6_.blue;
#line 103 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp8_ = california_gfx_fp_to_uint16 (_tmp7_);
#line 103 "/home/jim/git/california/src/util/util-gfx.vala"
	rgb.blue = _tmp8_;
#line 105 "/home/jim/git/california/src/util/util-gfx.vala"
	*result = rgb;
#line 105 "/home/jim/git/california/src/util/util-gfx.vala"
	return;
#line 386 "util-gfx.c"
}


inline guint16 california_gfx_fp_to_uint16 (gdouble value) {
	guint16 result = 0U;
	gdouble _tmp0_ = 0.0;
	guint16 _tmp1_ = 0U;
	gdouble _tmp2_ = 0.0;
#line 109 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = value;
#line 109 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = G_MAXUINT16;
#line 109 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = round (_tmp0_ * ((gdouble) _tmp1_));
#line 109 "/home/jim/git/california/src/util/util-gfx.vala"
	result = (guint16) _tmp2_;
#line 109 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 405 "util-gfx.c"
}


gchar* california_gfx_rgb_to_uint8_rgb_string (GdkColor* rgb) {
	gchar* result = NULL;
	GdkColor _tmp0_ = {0};
	guint16 _tmp1_ = 0U;
	guint8 _tmp2_ = 0U;
	GdkColor _tmp3_ = {0};
	guint16 _tmp4_ = 0U;
	guint8 _tmp5_ = 0U;
	GdkColor _tmp6_ = {0};
	guint16 _tmp7_ = 0U;
	guint8 _tmp8_ = 0U;
	gchar* _tmp9_ = NULL;
#line 112 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_val_if_fail (rgb != NULL, NULL);
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = *rgb;
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = _tmp0_.red;
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = california_gfx_uint16_to_uint8 (_tmp1_);
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = *rgb;
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = _tmp3_.green;
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = california_gfx_uint16_to_uint8 (_tmp4_);
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp6_ = *rgb;
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp7_ = _tmp6_.blue;
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp8_ = california_gfx_uint16_to_uint8 (_tmp7_);
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp9_ = g_strdup_printf ("#%02x%02x%02x", (guint) _tmp2_, (guint) _tmp5_, (guint) _tmp8_);
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	result = _tmp9_;
#line 113 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 447 "util-gfx.c"
}


inline guint8 california_gfx_uint16_to_uint8 (guint16 value) {
	guint8 result = 0U;
	guint16 _tmp0_ = 0U;
	guint8 _tmp1_ = 0U;
#line 121 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = value;
#line 121 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = G_MAXUINT8;
#line 121 "/home/jim/git/california/src/util/util-gfx.vala"
	result = (guint8) (_tmp0_ / (_tmp1_ + 1));
#line 121 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 463 "util-gfx.c"
}


gchar* california_gfx_rgb_to_string (GdkColor* rgb) {
	gchar* result = NULL;
	GdkColor _tmp0_ = {0};
	guint16 _tmp1_ = 0U;
	GdkColor _tmp2_ = {0};
	guint16 _tmp3_ = 0U;
	GdkColor _tmp4_ = {0};
	guint16 _tmp5_ = 0U;
	gchar* _tmp6_ = NULL;
#line 124 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_val_if_fail (rgb != NULL, NULL);
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = *rgb;
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = _tmp0_.red;
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = *rgb;
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = _tmp2_.green;
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = *rgb;
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = _tmp4_.blue;
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp6_ = g_strdup_printf ("(%d,%d,%d)", (gint) _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	result = _tmp6_;
#line 125 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 496 "util-gfx.c"
}


gchar* california_gfx_rgba_to_string (GdkRGBA* rgba) {
	gchar* result = NULL;
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	GdkRGBA _tmp2_ = {0};
	gdouble _tmp3_ = 0.0;
	GdkRGBA _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	GdkRGBA _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	gchar* _tmp8_ = NULL;
#line 128 "/home/jim/git/california/src/util/util-gfx.vala"
	g_return_val_if_fail (rgba != NULL, NULL);
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp0_ = *rgba;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp1_ = _tmp0_.red;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp2_ = *rgba;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp3_ = _tmp2_.green;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp4_ = *rgba;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp5_ = _tmp4_.blue;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp6_ = *rgba;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp7_ = _tmp6_.alpha;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	_tmp8_ = g_strdup_printf ("(%lf,%lf,%lf,%lf)", _tmp1_, _tmp3_, _tmp5_, _tmp7_);
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	result = _tmp8_;
#line 129 "/home/jim/git/california/src/util/util-gfx.vala"
	return result;
#line 535 "util-gfx.c"
}



